/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.realm;

import java.io.Serializable;
import java.security.Principal;
import java.util.Arrays;
import java.util.List;
import javax.security.auth.login.LoginContext;
import org.apache.catalina.TomcatPrincipal;
import org.ietf.jgss.GSSCredential;

public class GenericPrincipal
implements TomcatPrincipal,
Serializable {
    private static final long serialVersionUID = 1L;
    protected final String name;
    protected final String[] roles;
    protected final Principal userPrincipal;
    protected final transient LoginContext loginContext;
    protected transient GSSCredential gssCredential = null;

    public GenericPrincipal(String name) {
        this(name, null);
    }

    public GenericPrincipal(String name, List<String> roles) {
        this(name, roles, null);
    }

    @Deprecated
    public GenericPrincipal(String name, String password, List<String> roles) {
        this(name, roles, null);
    }

    public GenericPrincipal(String name, List<String> roles, Principal userPrincipal) {
        this(name, roles, userPrincipal, null);
    }

    @Deprecated
    public GenericPrincipal(String name, String password, List<String> roles, Principal userPrincipal) {
        this(name, roles, userPrincipal, null);
    }

    public GenericPrincipal(String name, List<String> roles, Principal userPrincipal, LoginContext loginContext) {
        this(name, roles, userPrincipal, loginContext, null);
    }

    @Deprecated
    public GenericPrincipal(String name, String password, List<String> roles, Principal userPrincipal, LoginContext loginContext) {
        this(name, roles, userPrincipal, loginContext, null);
    }

    public GenericPrincipal(String name, List<String> roles, Principal userPrincipal, LoginContext loginContext, GSSCredential gssCredential) {
        this.name = name;
        this.userPrincipal = userPrincipal;
        if (roles == null) {
            this.roles = new String[0];
        } else {
            this.roles = roles.toArray(new String[0]);
            if (this.roles.length > 1) {
                Arrays.sort(this.roles);
            }
        }
        this.loginContext = loginContext;
        this.gssCredential = gssCredential;
    }

    @Deprecated
    public GenericPrincipal(String name, String password, List<String> roles, Principal userPrincipal, LoginContext loginContext, GSSCredential gssCredential) {
        this(name, roles, userPrincipal, loginContext, gssCredential);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String[] getRoles() {
        return (String[])this.roles.clone();
    }

    @Override
    public Principal getUserPrincipal() {
        if (this.userPrincipal != null) {
            return this.userPrincipal;
        }
        return this;
    }

    @Override
    public GSSCredential getGssCredential() {
        return this.gssCredential;
    }

    protected void setGssCredential(GSSCredential gssCredential) {
        this.gssCredential = gssCredential;
    }

    public boolean hasRole(String role) {
        if ("*".equals(role)) {
            return true;
        }
        if (role == null) {
            return false;
        }
        return Arrays.binarySearch(this.roles, role) >= 0;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("GenericPrincipal[");
        sb.append(this.name);
        sb.append('(');
        for (String role : this.roles) {
            sb.append(role).append(',');
        }
        sb.append(")]");
        return sb.toString();
    }

    @Override
    public void logout() throws Exception {
        if (this.loginContext != null) {
            this.loginContext.logout();
        }
        if (this.gssCredential != null) {
            this.gssCredential.dispose();
        }
    }

    private Object writeReplace() {
        return new SerializablePrincipal(this.name, this.roles, this.userPrincipal);
    }

    private static class SerializablePrincipal
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final String name;
        private final String[] roles;
        private final Principal principal;

        public SerializablePrincipal(String name, String[] roles, Principal principal) {
            this.name = name;
            this.roles = roles;
            this.principal = principal instanceof Serializable ? principal : null;
        }

        private Object readResolve() {
            return new GenericPrincipal(this.name, Arrays.asList(this.roles), this.principal);
        }
    }
}

