/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.valves;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import javax.servlet.http.HttpSession;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.valves.ValveBase;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;

public class CrawlerSessionManagerValve
extends ValveBase {
    private static final Log log = LogFactory.getLog(CrawlerSessionManagerValve.class);
    private Map<String, SessionInfo> uaIpSessionInfo = new ConcurrentHashMap<String, SessionInfo>();
    private String crawlerUserAgents = ".*GoogleBot.*|.*bingbot.*|.*Yahoo! Slurp.*";
    private Pattern uaPattern = null;
    private int sessionInactiveInterval = 60;

    public void setCrawlerUserAgents(String crawlerUserAgents) {
        this.crawlerUserAgents = crawlerUserAgents;
        this.uaPattern = crawlerUserAgents == null || crawlerUserAgents.length() == 0 ? null : Pattern.compile(crawlerUserAgents);
    }

    public String getCrawlerUserAgents() {
        return this.crawlerUserAgents;
    }

    public void setSessionInactiveInterval(int sessionInactiveInterval) {
        this.sessionInactiveInterval = sessionInactiveInterval;
    }

    public int getSessionInactiveInterval() {
        return this.sessionInactiveInterval;
    }

    @Override
    protected void initInternal() throws LifecycleException {
        super.initInternal();
        this.uaPattern = Pattern.compile(this.crawlerUserAgents);
    }

    @Override
    public void invoke(Request request, Response response) throws IOException, ServletException {
        boolean isBot = false;
        SessionInfo sessionInfo = null;
        String clientIp = null;
        if (log.isDebugEnabled()) {
            log.debug((Object)(request.hashCode() + ": ClientIp=" + request.getRemoteAddr() + ", RequestedSessionId=" + request.getRequestedSessionId()));
        }
        if (request.getRequestedSessionId() == null) {
            Enumeration<String> uaHeaders = request.getHeaders("user-agent");
            String uaHeader = null;
            if (uaHeaders.hasMoreElements()) {
                uaHeader = uaHeaders.nextElement();
            }
            if (uaHeader != null && !uaHeaders.hasMoreElements()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)(request.hashCode() + ": UserAgent=" + uaHeader));
                }
                if (this.uaPattern.matcher(uaHeader).matches()) {
                    isBot = true;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)(request.hashCode() + ": Bot found. UserAgent=" + uaHeader));
                    }
                }
            }
            if (isBot && (sessionInfo = this.uaIpSessionInfo.get(clientIp = request.getRemoteAddr())) != null) {
                request.setRequestedSessionId(sessionInfo.getSessionId());
                if (log.isDebugEnabled()) {
                    log.debug((Object)(request.hashCode() + ": SessionID=" + sessionInfo.getSessionId()));
                }
            }
        }
        this.getNext().invoke(request, response);
        if (isBot) {
            if (sessionInfo == null) {
                HttpSession s = request.getSession(false);
                if (s != null) {
                    this.uaIpSessionInfo.put(clientIp, new SessionInfo(s.getId()));
                    s.setMaxInactiveInterval(this.sessionInactiveInterval);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)(request.hashCode() + ": New bot session. SessionID=" + s.getId()));
                    }
                }
            } else {
                sessionInfo.access();
                if (log.isDebugEnabled()) {
                    log.debug((Object)(request.hashCode() + ": Bot session accessed. SessionID=" + sessionInfo.getSessionId()));
                }
            }
        }
    }

    @Override
    public void backgroundProcess() {
        super.backgroundProcess();
        long expireTime = System.currentTimeMillis() - (long)((this.sessionInactiveInterval + 60) * 1000);
        Iterator<Map.Entry<String, SessionInfo>> iter = this.uaIpSessionInfo.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<String, SessionInfo> entry = iter.next();
            if (entry.getValue().getLastAccessed() >= expireTime) continue;
            iter.remove();
        }
    }

    private static final class SessionInfo {
        private final String sessionId;
        private volatile long lastAccessed;

        public SessionInfo(String sessionId) {
            this.sessionId = sessionId;
            this.lastAccessed = System.currentTimeMillis();
        }

        public String getSessionId() {
            return this.sessionId;
        }

        public long getLastAccessed() {
            return this.lastAccessed;
        }

        public void access() {
            this.lastAccessed = System.currentTimeMillis();
        }
    }
}

