/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.connector;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.EnumSet;
import javax.servlet.ServletRequest;
import javax.servlet.SessionTrackingMode;
import org.apache.catalina.Context;
import org.apache.catalina.Wrapper;
import org.apache.catalina.comet.CometEvent;
import org.apache.catalina.connector.Connector;
import org.apache.catalina.connector.CoyotePrincipal;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.core.ApplicationSessionCookieConfig;
import org.apache.catalina.core.AsyncContextImpl;
import org.apache.catalina.util.ServerInfo;
import org.apache.catalina.util.URLEncoder;
import org.apache.coyote.ActionCode;
import org.apache.coyote.Adapter;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.ExceptionUtils;
import org.apache.tomcat.util.buf.B2CConverter;
import org.apache.tomcat.util.buf.ByteChunk;
import org.apache.tomcat.util.buf.CharChunk;
import org.apache.tomcat.util.buf.MessageBytes;
import org.apache.tomcat.util.http.Cookies;
import org.apache.tomcat.util.http.ServerCookie;
import org.apache.tomcat.util.net.SocketStatus;
import org.apache.tomcat.util.res.StringManager;

public class CoyoteAdapter
implements Adapter {
    private static final Log log = LogFactory.getLog(CoyoteAdapter.class);
    private static final String POWERED_BY = "Servlet/3.0 JSP/2.2 (" + ServerInfo.getServerInfo() + " Java/" + System.getProperty("java.vm.vendor") + "/" + System.getProperty("java.runtime.version") + ")";
    private static final EnumSet<SessionTrackingMode> SSL_ONLY = EnumSet.of(SessionTrackingMode.SSL);
    public static final int ADAPTER_NOTES = 1;
    protected static final boolean ALLOW_BACKSLASH = Boolean.valueOf(System.getProperty("org.apache.catalina.connector.CoyoteAdapter.ALLOW_BACKSLASH", "false"));
    private Connector connector = null;
    protected static final StringManager sm = StringManager.getManager((String)"org.apache.catalina.connector");
    protected static URLEncoder urlEncoder = new URLEncoder();

    public CoyoteAdapter(Connector connector) {
        this.connector = connector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean event(org.apache.coyote.Request req, org.apache.coyote.Response res, SocketStatus status) {
        Request request = (Request)req.getNote(1);
        Response response = (Response)res.getNote(1);
        if (request.getWrapper() == null) {
            return false;
        }
        boolean error = false;
        boolean read = false;
        try {
            if (status == SocketStatus.OPEN) {
                if (response.isClosed()) {
                    request.getEvent().setEventType(CometEvent.EventType.END);
                    request.getEvent().setEventSubType(null);
                } else {
                    try {
                        if (request.read()) {
                            read = true;
                        }
                    }
                    catch (IOException e) {
                        error = true;
                    }
                    if (read) {
                        request.getEvent().setEventType(CometEvent.EventType.READ);
                        request.getEvent().setEventSubType(null);
                    } else if (error) {
                        request.getEvent().setEventType(CometEvent.EventType.ERROR);
                        request.getEvent().setEventSubType(CometEvent.EventSubType.CLIENT_DISCONNECT);
                    } else {
                        request.getEvent().setEventType(CometEvent.EventType.END);
                        request.getEvent().setEventSubType(null);
                    }
                }
            } else if (status == SocketStatus.DISCONNECT) {
                request.getEvent().setEventType(CometEvent.EventType.ERROR);
                request.getEvent().setEventSubType(CometEvent.EventSubType.CLIENT_DISCONNECT);
                error = true;
            } else if (status == SocketStatus.ERROR) {
                request.getEvent().setEventType(CometEvent.EventType.ERROR);
                request.getEvent().setEventSubType(CometEvent.EventSubType.IOEXCEPTION);
                error = true;
            } else if (status == SocketStatus.STOP) {
                request.getEvent().setEventType(CometEvent.EventType.END);
                request.getEvent().setEventSubType(CometEvent.EventSubType.SERVER_SHUTDOWN);
            } else if (status == SocketStatus.TIMEOUT) {
                if (response.isClosed()) {
                    request.getEvent().setEventType(CometEvent.EventType.END);
                    request.getEvent().setEventSubType(null);
                } else {
                    request.getEvent().setEventType(CometEvent.EventType.ERROR);
                    request.getEvent().setEventSubType(CometEvent.EventSubType.TIMEOUT);
                }
            }
            req.getRequestProcessor().setWorkerThreadName(Thread.currentThread().getName());
            this.connector.getService().getContainer().getPipeline().getFirst().event(request, response, request.getEvent());
            if (!error && !response.isClosed() && request.getAttribute("javax.servlet.error.exception") != null) {
                request.getEvent().setEventType(CometEvent.EventType.ERROR);
                request.getEvent().setEventSubType(null);
                error = true;
                this.connector.getService().getContainer().getPipeline().getFirst().event(request, response, request.getEvent());
            }
            if (response.isClosed() || !request.isComet()) {
                if (status == SocketStatus.OPEN && request.getEvent().getEventType() != CometEvent.EventType.END) {
                    request.getEvent().setEventType(CometEvent.EventType.END);
                    request.getEvent().setEventSubType(null);
                    error = true;
                    this.connector.getService().getContainer().getPipeline().getFirst().event(request, response, request.getEvent());
                }
                res.action(ActionCode.COMET_END, null);
            } else if (!error && read && request.getAvailable()) {
                request.getEvent().setEventType(CometEvent.EventType.ERROR);
                request.getEvent().setEventSubType(CometEvent.EventSubType.IOEXCEPTION);
                error = true;
                this.connector.getService().getContainer().getPipeline().getFirst().event(request, response, request.getEvent());
            }
            boolean e = !error;
            return e;
        }
        catch (Throwable t) {
            ExceptionUtils.handleThrowable((Throwable)t);
            if (!(t instanceof IOException)) {
                log.error((Object)sm.getString("coyoteAdapter.service"), t);
            }
            error = true;
            boolean bl = false;
            return bl;
        }
        finally {
            req.getRequestProcessor().setWorkerThreadName(null);
            if (error || response.isClosed() || !request.isComet()) {
                request.recycle();
                request.setFilterChain(null);
                response.recycle();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean asyncDispatch(org.apache.coyote.Request req, org.apache.coyote.Response res, SocketStatus status) throws Exception {
        Request request = (Request)req.getNote(1);
        Response response = (Response)res.getNote(1);
        if (request == null) {
            throw new IllegalStateException("Dispatch may only happen on an existing request.");
        }
        boolean comet = false;
        boolean success = true;
        AsyncContextImpl asyncConImpl = (AsyncContextImpl)request.getAsyncContext();
        try {
            Context ctxt;
            if (!request.isAsync() && !comet && (ctxt = (Context)request.getMappingData().context) != null) {
                ctxt.fireRequestDestroyEvent((ServletRequest)request);
            }
            if (status == SocketStatus.TIMEOUT) {
                success = true;
                if (!asyncConImpl.timeout()) {
                    asyncConImpl.setErrorState(null);
                }
            }
            if (request.isAsyncDispatching()) {
                success = true;
                this.connector.getService().getContainer().getPipeline().getFirst().invoke(request, response);
                Throwable t = (Throwable)request.getAttribute("javax.servlet.error.exception");
                if (t != null) {
                    asyncConImpl.setErrorState(t);
                }
            }
            if (request.isComet()) {
                if (!response.isClosed() && !response.isError()) {
                    if (request.getAvailable() || request.getContentLength() > 0 && !request.isParametersParsed()) {
                        if (this.event(req, res, SocketStatus.OPEN)) {
                            comet = true;
                            res.action(ActionCode.COMET_BEGIN, null);
                        }
                    } else {
                        comet = true;
                        res.action(ActionCode.COMET_BEGIN, null);
                    }
                } else {
                    request.setFilterChain(null);
                }
            }
            if (!request.isAsync() && !comet) {
                request.finishRequest();
                response.finishResponse();
                req.action(ActionCode.POST_REQUEST, null);
                ((Context)request.getMappingData().context).logAccess(request, response, System.currentTimeMillis() - req.getStartTime(), false);
            }
        }
        catch (IOException e) {
            success = false;
        }
        catch (Throwable t) {
            ExceptionUtils.handleThrowable((Throwable)t);
            success = false;
            log.error((Object)sm.getString("coyoteAdapter.service"), t);
        }
        finally {
            req.getRequestProcessor().setWorkerThreadName(null);
            if (!success || !comet && !request.isAsync()) {
                request.recycle();
                response.recycle();
            } else {
                request.clearEncoders();
                response.clearEncoders();
            }
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(org.apache.coyote.Request req, org.apache.coyote.Response res) throws Exception {
        Request request = (Request)req.getNote(1);
        Response response = (Response)res.getNote(1);
        if (request == null) {
            request = this.connector.createRequest();
            request.setCoyoteRequest(req);
            response = this.connector.createResponse();
            response.setCoyoteResponse(res);
            request.setResponse(response);
            response.setRequest(request);
            req.setNote(1, (Object)request);
            res.setNote(1, (Object)response);
            req.getParameters().setQueryStringEncoding(this.connector.getURIEncoding());
        }
        if (this.connector.getXpoweredBy()) {
            response.addHeader("X-Powered-By", POWERED_BY);
        }
        boolean comet = false;
        boolean async = false;
        try {
            AsyncContextImpl asyncConImpl;
            req.getRequestProcessor().setWorkerThreadName(Thread.currentThread().getName());
            boolean postParseSuccess = this.postParseRequest(req, request, res, response);
            if (postParseSuccess) {
                request.setAsyncSupported(this.connector.getService().getContainer().getPipeline().isAsyncSupported());
                this.connector.getService().getContainer().getPipeline().getFirst().invoke(request, response);
                if (request.isComet()) {
                    if (!response.isClosed() && !response.isError()) {
                        if (request.getAvailable() || request.getContentLength() > 0 && !request.isParametersParsed()) {
                            if (this.event(req, res, SocketStatus.OPEN)) {
                                comet = true;
                                res.action(ActionCode.COMET_BEGIN, null);
                            }
                        } else {
                            comet = true;
                            res.action(ActionCode.COMET_BEGIN, null);
                        }
                    } else {
                        request.setFilterChain(null);
                    }
                }
            }
            if ((asyncConImpl = (AsyncContextImpl)request.getAsyncContext()) != null) {
                async = true;
            } else if (!comet) {
                request.finishRequest();
                response.finishResponse();
                if (postParseSuccess) {
                    ((Context)request.getMappingData().context).logAccess(request, response, System.currentTimeMillis() - req.getStartTime(), false);
                }
                req.action(ActionCode.POST_REQUEST, null);
            }
        }
        catch (IOException e) {
        }
        catch (Throwable t) {
            ExceptionUtils.handleThrowable((Throwable)t);
            log.error((Object)sm.getString("coyoteAdapter.service"), t);
        }
        finally {
            req.getRequestProcessor().setWorkerThreadName(null);
            if (!comet && !async) {
                request.recycle();
                response.recycle();
            } else {
                request.clearEncoders();
                response.clearEncoders();
            }
        }
    }

    public void log(org.apache.coyote.Request req, org.apache.coyote.Response res, long time) {
        Request request = (Request)req.getNote(1);
        Response response = (Response)res.getNote(1);
        boolean create = false;
        if (request == null) {
            create = true;
            request = this.connector.createRequest();
            request.setCoyoteRequest(req);
            response = this.connector.createResponse();
            response.setCoyoteResponse(res);
            request.setResponse(response);
            response.setRequest(request);
            req.setNote(1, (Object)request);
            res.setNote(1, (Object)response);
            req.getParameters().setQueryStringEncoding(this.connector.getURIEncoding());
        }
        try {
            this.connector.getService().getContainer().logAccess(request, response, time, true);
        }
        catch (Throwable t) {
            ExceptionUtils.handleThrowable((Throwable)t);
            log.warn((Object)sm.getString("coyoteAdapter.accesslogFail"), t);
        }
        if (create) {
            request.recycle();
            response.recycle();
        }
    }

    public String getDomain() {
        return this.connector.getDomain();
    }

    protected boolean postParseRequest(org.apache.coyote.Request req, Request request, org.apache.coyote.Response res, Response response) throws Exception {
        MessageBytes serverName;
        String authtype;
        if (!req.scheme().isNull()) {
            request.setSecure(req.scheme().equals("https"));
        } else {
            req.scheme().setString(this.connector.getScheme());
            request.setSecure(this.connector.getSecure());
        }
        String proxyName = this.connector.getProxyName();
        int proxyPort = this.connector.getProxyPort();
        if (proxyPort != 0) {
            req.setServerPort(proxyPort);
        }
        if (proxyName != null) {
            req.serverName().setString(proxyName);
        }
        MessageBytes decodedURI = req.decodedURI();
        decodedURI.duplicate(req.requestURI());
        this.parsePathParameters(req, request);
        try {
            req.getURLDecoder().convert(decodedURI, false);
        }
        catch (IOException ioe) {
            res.setStatus(400);
            res.setMessage("Invalid URI: " + ioe.getMessage());
            this.connector.getService().getContainer().logAccess(request, response, 0L, true);
            return false;
        }
        if (!CoyoteAdapter.normalize(req.decodedURI())) {
            res.setStatus(400);
            res.setMessage("Invalid URI");
            this.connector.getService().getContainer().logAccess(request, response, 0L, true);
            return false;
        }
        this.convertURI(decodedURI, request);
        if (!CoyoteAdapter.checkNormalize(req.decodedURI())) {
            res.setStatus(400);
            res.setMessage("Invalid URI character encoding");
            this.connector.getService().getContainer().logAccess(request, response, 0L, true);
            return false;
        }
        String principal = req.getRemoteUser().toString();
        if (principal != null) {
            request.setUserPrincipal(new CoyotePrincipal(principal));
        }
        if ((authtype = req.getAuthType().toString()) != null) {
            request.setAuthType(authtype);
        }
        if (this.connector.getUseIPVHosts()) {
            serverName = req.localName();
            if (serverName.isNull()) {
                res.action(ActionCode.REQ_LOCAL_NAME_ATTRIBUTE, null);
            }
        } else {
            serverName = req.serverName();
        }
        if (request.isAsyncStarted()) {
            request.getMappingData().recycle();
        }
        boolean mapRequired = true;
        String version = null;
        while (mapRequired) {
            if (version != null) {
                mapRequired = false;
            }
            this.connector.getMapper().map(serverName, decodedURI, version, request.getMappingData());
            request.setContext((Context)request.getMappingData().context);
            request.setWrapper((Wrapper)request.getMappingData().wrapper);
            if (request.getMappingData().contexts == null) {
                mapRequired = false;
            }
            if (request.getContext() == null) {
                res.setStatus(404);
                res.setMessage("Not found");
                request.getHost().logAccess(request, response, 0L, true);
                return false;
            }
            String sessionID = null;
            if (request.getServletContext().getEffectiveSessionTrackingModes().contains(SessionTrackingMode.URL) && (sessionID = request.getPathParameter(ApplicationSessionCookieConfig.getSessionUriParamName(request.getContext()))) != null) {
                request.setRequestedSessionId(sessionID);
                request.setRequestedSessionURL(true);
            }
            this.parseSessionCookiesId(req, request);
            this.parseSessionSslId(request);
            sessionID = request.getRequestedSessionId();
            if (!mapRequired) continue;
            if (sessionID == null) {
                mapRequired = false;
                continue;
            }
            Object[] objs = request.getMappingData().contexts;
            for (int i = objs.length; i > 0; --i) {
                Context ctxt = (Context)objs[i - 1];
                if (ctxt.getManager().findSession(sessionID) == null) continue;
                if (ctxt.equals(request.getMappingData().context)) {
                    mapRequired = false;
                    continue;
                }
                version = ctxt.getWebappVersion();
                request.getMappingData().recycle();
                break;
            }
            if (version != null) continue;
            mapRequired = false;
        }
        MessageBytes redirectPathMB = request.getMappingData().redirectPath;
        if (!redirectPathMB.isNull()) {
            String redirectPath = urlEncoder.encode(redirectPathMB.toString());
            String query = request.getQueryString();
            if (request.isRequestedSessionIdFromURL()) {
                redirectPath = redirectPath + ";" + ApplicationSessionCookieConfig.getSessionUriParamName(request.getContext()) + "=" + request.getRequestedSessionId();
            }
            if (query != null) {
                redirectPath = redirectPath + "?" + query;
            }
            response.sendRedirect(redirectPath);
            request.getContext().logAccess(request, response, 0L, true);
            return false;
        }
        if (!this.connector.getAllowTrace() && req.method().equalsIgnoreCase("TRACE")) {
            String[] methods;
            Wrapper wrapper = request.getWrapper();
            String header = null;
            if (wrapper != null && (methods = wrapper.getServletMethods()) != null) {
                for (int i = 0; i < methods.length; ++i) {
                    if ("TRACE".equals(methods[i])) continue;
                    header = header == null ? methods[i] : header + ", " + methods[i];
                }
            }
            res.setStatus(405);
            res.addHeader("Allow", header);
            res.setMessage("TRACE method is not allowed");
            request.getContext().logAccess(request, response, 0L, true);
            return false;
        }
        return true;
    }

    protected void parsePathParameters(org.apache.coyote.Request req, Request request) {
        req.decodedURI().toBytes();
        ByteChunk uriBC = req.decodedURI().getByteChunk();
        int semicolon = uriBC.indexOf(';', 0);
        String enc = this.connector.getURIEncoding();
        if (enc == null) {
            enc = "ISO-8859-1";
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)sm.getString("coyoteAdapter.debug", new Object[]{"uriBC", uriBC.toString()}));
            log.debug((Object)sm.getString("coyoteAdapter.debug", new Object[]{"semicolon", String.valueOf(semicolon)}));
            log.debug((Object)sm.getString("coyoteAdapter.debug", new Object[]{"enc", enc}));
        }
        boolean warnedEncoding = false;
        while (semicolon > -1) {
            int equals;
            int start = uriBC.getStart();
            int end = uriBC.getEnd();
            int pathParamStart = semicolon + 1;
            int pathParamEnd = ByteChunk.findBytes((byte[])uriBC.getBuffer(), (int)(start + pathParamStart), (int)end, (byte[])new byte[]{59, 47});
            String pv = null;
            if (pathParamEnd >= 0) {
                block13: {
                    try {
                        pv = new String(uriBC.getBuffer(), start + pathParamStart, pathParamEnd - pathParamStart, enc);
                    }
                    catch (UnsupportedEncodingException e) {
                        if (warnedEncoding) break block13;
                        log.warn((Object)sm.getString("coyoteAdapter.parsePathParam", new Object[]{enc}));
                        warnedEncoding = true;
                    }
                }
                byte[] buf = uriBC.getBuffer();
                for (int i = 0; i < end - start - pathParamEnd; ++i) {
                    buf[start + semicolon + i] = buf[start + i + pathParamEnd];
                }
                uriBC.setBytes(buf, start, end - start - pathParamEnd + semicolon);
            } else {
                block14: {
                    try {
                        pv = new String(uriBC.getBuffer(), start + pathParamStart, end - start - pathParamStart, enc);
                    }
                    catch (UnsupportedEncodingException e) {
                        if (warnedEncoding) break block14;
                        log.warn((Object)sm.getString("coyoteAdapter.parsePathParam", new Object[]{enc}));
                        warnedEncoding = true;
                    }
                }
                uriBC.setEnd(start + semicolon);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)sm.getString("coyoteAdapter.debug", new Object[]{"pathParamStart", String.valueOf(pathParamStart)}));
                log.debug((Object)sm.getString("coyoteAdapter.debug", new Object[]{"pathParamEnd", String.valueOf(pathParamEnd)}));
                log.debug((Object)sm.getString("coyoteAdapter.debug", new Object[]{"pv", pv}));
            }
            if (pv != null && (equals = pv.indexOf(61)) > -1) {
                String name = pv.substring(0, equals);
                String value = pv.substring(equals + 1);
                request.addPathParameter(name, value);
                if (log.isDebugEnabled()) {
                    log.debug((Object)sm.getString("coyoteAdapter.debug", new Object[]{"equals", String.valueOf(equals)}));
                    log.debug((Object)sm.getString("coyoteAdapter.debug", new Object[]{"name", name}));
                    log.debug((Object)sm.getString("coyoteAdapter.debug", new Object[]{"value", value}));
                }
            }
            semicolon = uriBC.indexOf(';', semicolon);
        }
    }

    protected void parseSessionSslId(Request request) {
        if (request.getRequestedSessionId() == null && SSL_ONLY.equals(request.getServletContext().getEffectiveSessionTrackingModes()) && request.connector.secure) {
            request.setRequestedSessionId(request.getAttribute("javax.servlet.request.ssl_session").toString());
            request.setRequestedSessionSSL(true);
        }
    }

    protected void parseSessionCookiesId(org.apache.coyote.Request req, Request request) {
        Context context = (Context)request.getMappingData().context;
        if (context != null && !context.getServletContext().getEffectiveSessionTrackingModes().contains(SessionTrackingMode.COOKIE)) {
            return;
        }
        Cookies serverCookies = req.getCookies();
        int count = serverCookies.getCookieCount();
        if (count <= 0) {
            return;
        }
        String sessionCookieName = ApplicationSessionCookieConfig.getSessionCookieName(context);
        for (int i = 0; i < count; ++i) {
            ServerCookie scookie = serverCookies.getCookie(i);
            if (!scookie.getName().equals(sessionCookieName)) continue;
            if (!request.isRequestedSessionIdFromCookie()) {
                this.convertMB(scookie.getValue());
                request.setRequestedSessionId(scookie.getValue().toString());
                request.setRequestedSessionCookie(true);
                request.setRequestedSessionURL(false);
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)(" Requested cookie session id is " + request.getRequestedSessionId()));
                continue;
            }
            if (request.isRequestedSessionIdValid()) continue;
            this.convertMB(scookie.getValue());
            request.setRequestedSessionId(scookie.getValue().toString());
        }
    }

    protected void convertURI(MessageBytes uri, Request request) throws Exception {
        ByteChunk bc = uri.getByteChunk();
        int length = bc.getLength();
        CharChunk cc = uri.getCharChunk();
        cc.allocate(length, -1);
        String enc = this.connector.getURIEncoding();
        if (enc != null) {
            B2CConverter conv = request.getURIConverter();
            try {
                if (conv == null) {
                    conv = new B2CConverter(enc);
                    request.setURIConverter(conv);
                }
            }
            catch (IOException e) {
                log.error((Object)"Invalid URI encoding; using HTTP default");
                this.connector.setURIEncoding(null);
            }
            if (conv != null) {
                try {
                    conv.convert(bc, cc, cc.getBuffer().length - cc.getEnd());
                    uri.setChars(cc.getBuffer(), cc.getStart(), cc.getLength());
                    return;
                }
                catch (IOException e) {
                    log.error((Object)"Invalid URI character encoding; trying ascii");
                    cc.recycle();
                }
            }
        }
        byte[] bbuf = bc.getBuffer();
        char[] cbuf = cc.getBuffer();
        int start = bc.getStart();
        for (int i = 0; i < length; ++i) {
            cbuf[i] = (char)(bbuf[i + start] & 0xFF);
        }
        uri.setChars(cbuf, 0, length);
    }

    protected void convertMB(MessageBytes mb) {
        if (mb.getType() != 2) {
            return;
        }
        ByteChunk bc = mb.getByteChunk();
        CharChunk cc = mb.getCharChunk();
        int length = bc.getLength();
        cc.allocate(length, -1);
        byte[] bbuf = bc.getBuffer();
        char[] cbuf = cc.getBuffer();
        int start = bc.getStart();
        for (int i = 0; i < length; ++i) {
            cbuf[i] = (char)(bbuf[i + start] & 0xFF);
        }
        mb.setChars(cbuf, 0, length);
    }

    public static boolean normalize(MessageBytes uriMB) {
        int end;
        ByteChunk uriBC = uriMB.getByteChunk();
        byte[] b = uriBC.getBytes();
        int start = uriBC.getStart();
        if (start == (end = uriBC.getEnd())) {
            return false;
        }
        if (end - start == 1 && b[start] == 42) {
            return true;
        }
        int pos = 0;
        int index = 0;
        for (pos = start; pos < end; ++pos) {
            if (b[pos] == 92) {
                if (ALLOW_BACKSLASH) {
                    b[pos] = 47;
                } else {
                    return false;
                }
            }
            if (b[pos] != 0) continue;
            return false;
        }
        if (b[start] != 47) {
            return false;
        }
        for (pos = start; pos < end - 1; ++pos) {
            if (b[pos] != 47) continue;
            while (pos + 1 < end && b[pos + 1] == 47) {
                CoyoteAdapter.copyBytes(b, pos, pos + 1, end - pos - 1);
                --end;
            }
        }
        if (end - start >= 2 && b[end - 1] == 46 && (b[end - 2] == 47 || b[end - 2] == 46 && b[end - 3] == 47)) {
            b[end] = 47;
            ++end;
        }
        uriBC.setEnd(end);
        index = 0;
        while ((index = uriBC.indexOf("/./", 0, 3, index)) >= 0) {
            CoyoteAdapter.copyBytes(b, start + index, start + index + 2, end - start - index - 2);
            uriBC.setEnd(end -= 2);
        }
        index = 0;
        while ((index = uriBC.indexOf("/../", 0, 4, index)) >= 0) {
            if (index == 0) {
                return false;
            }
            int index2 = -1;
            for (pos = start + index - 1; pos >= 0 && index2 < 0; --pos) {
                if (b[pos] != 47) continue;
                index2 = pos;
            }
            CoyoteAdapter.copyBytes(b, start + index2, start + index + 3, end - start - index - 3);
            end = end + index2 - index - 3;
            uriBC.setEnd(end);
            index = index2;
        }
        return true;
    }

    public static boolean checkNormalize(MessageBytes uriMB) {
        CharChunk uriCC = uriMB.getCharChunk();
        char[] c = uriCC.getChars();
        int start = uriCC.getStart();
        int end = uriCC.getEnd();
        int pos = 0;
        for (pos = start; pos < end; ++pos) {
            if (c[pos] == '\\') {
                return false;
            }
            if (c[pos] != '\u0000') continue;
            return false;
        }
        for (pos = start; pos < end - 1; ++pos) {
            if (c[pos] != '/' || c[pos + 1] != '/') continue;
            return false;
        }
        if (end - start >= 2 && c[end - 1] == '.' && (c[end - 2] == '/' || c[end - 2] == '.' && c[end - 3] == '/')) {
            return false;
        }
        if (uriCC.indexOf("/./", 0, 3, 0) >= 0) {
            return false;
        }
        return uriCC.indexOf("/../", 0, 4, 0) < 0;
    }

    protected static void copyBytes(byte[] b, int dest, int src, int len) {
        for (int pos = 0; pos < len; ++pos) {
            b[pos + dest] = b[pos + src];
        }
    }

    static {
        urlEncoder.addSafeCharacter('-');
        urlEncoder.addSafeCharacter('_');
        urlEncoder.addSafeCharacter('.');
        urlEncoder.addSafeCharacter('*');
        urlEncoder.addSafeCharacter('/');
    }
}

