/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.connector;

import java.util.HashMap;
import javax.management.ObjectName;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleState;
import org.apache.catalina.Service;
import org.apache.catalina.connector.CoyoteAdapter;
import org.apache.catalina.connector.MapperListener;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.core.AprLifecycleListener;
import org.apache.catalina.mbeans.MBeanUtils;
import org.apache.catalina.util.LifecycleMBeanBase;
import org.apache.coyote.Adapter;
import org.apache.coyote.ProtocolHandler;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.IntrospectionUtils;
import org.apache.tomcat.util.http.mapper.Mapper;
import org.apache.tomcat.util.res.StringManager;

public class Connector
extends LifecycleMBeanBase {
    private static final Log log = LogFactory.getLog(Connector.class);
    public static final boolean RECYCLE_FACADES = Boolean.valueOf(System.getProperty("org.apache.catalina.connector.RECYCLE_FACADES", "false"));
    protected Service service = null;
    protected boolean allowTrace = false;
    protected long asyncTimeout = 10000L;
    protected boolean enableLookups = false;
    protected boolean xpoweredBy = false;
    protected static final String info = "org.apache.catalina.connector.Connector/2.1";
    protected int port = 0;
    protected String proxyName = null;
    protected int proxyPort = 0;
    protected int redirectPort = 443;
    protected String scheme = "http";
    protected boolean secure = false;
    protected static final StringManager sm = StringManager.getManager((String)"org.apache.catalina.connector");
    protected int maxPostSize = 0x200000;
    protected int maxSavePostSize = 4096;
    protected boolean stopped = false;
    protected boolean useIPVHosts = false;
    protected Thread thread = null;
    protected String protocolHandlerClassName = "org.apache.coyote.http11.Http11Protocol";
    protected ProtocolHandler protocolHandler = null;
    protected Adapter adapter = null;
    protected Mapper mapper = new Mapper();
    protected MapperListener mapperListener = new MapperListener(this.mapper, this);
    protected String URIEncoding = null;
    protected boolean useBodyEncodingForURI = false;
    protected static HashMap<String, String> replacements = new HashMap();
    private ObjectName onameProtocolHandler;
    private ObjectName onameMapper;

    public Connector() {
        this(null);
    }

    public Connector(String protocol) {
        this.setProtocol(protocol);
        try {
            Class<?> clazz = Class.forName(this.protocolHandlerClassName);
            this.protocolHandler = (ProtocolHandler)clazz.newInstance();
        }
        catch (Exception e) {
            log.error((Object)sm.getString("coyoteConnector.protocolHandlerInstantiationFailed", new Object[]{e}));
        }
    }

    public Object getProperty(String name) {
        String repl = name;
        if (replacements.get(name) != null) {
            repl = replacements.get(name);
        }
        return IntrospectionUtils.getProperty((Object)this.protocolHandler, (String)repl);
    }

    public boolean setProperty(String name, String value) {
        String repl = name;
        if (replacements.get(name) != null) {
            repl = replacements.get(name);
        }
        return IntrospectionUtils.setProperty((Object)this.protocolHandler, (String)repl, (String)value);
    }

    public Object getAttribute(String name) {
        return this.getProperty(name);
    }

    public void setAttribute(String name, Object value) {
        this.setProperty(name, String.valueOf(value));
    }

    public Service getService() {
        return this.service;
    }

    public void setService(Service service) {
        this.service = service;
    }

    public boolean getAllowTrace() {
        return this.allowTrace;
    }

    public void setAllowTrace(boolean allowTrace) {
        this.allowTrace = allowTrace;
        this.setProperty("allowTrace", String.valueOf(allowTrace));
    }

    public long getAsyncTimeout() {
        return this.asyncTimeout;
    }

    public void setAsyncTimeout(long asyncTimeout) {
        this.asyncTimeout = asyncTimeout;
        this.setProperty("asyncTimeout", String.valueOf(asyncTimeout));
    }

    public boolean getEnableLookups() {
        return this.enableLookups;
    }

    public void setEnableLookups(boolean enableLookups) {
        this.enableLookups = enableLookups;
        this.setProperty("enableLookups", String.valueOf(enableLookups));
    }

    public String getInfo() {
        return info;
    }

    public Mapper getMapper() {
        return this.mapper;
    }

    public int getMaxPostSize() {
        return this.maxPostSize;
    }

    public void setMaxPostSize(int maxPostSize) {
        this.maxPostSize = maxPostSize;
    }

    public int getMaxSavePostSize() {
        return this.maxSavePostSize;
    }

    public void setMaxSavePostSize(int maxSavePostSize) {
        this.maxSavePostSize = maxSavePostSize;
        this.setProperty("maxSavePostSize", String.valueOf(maxSavePostSize));
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
        this.setProperty("port", String.valueOf(port));
    }

    public String getProtocol() {
        if ("org.apache.coyote.http11.Http11Protocol".equals(this.getProtocolHandlerClassName()) || "org.apache.coyote.http11.Http11AprProtocol".equals(this.getProtocolHandlerClassName())) {
            return "HTTP/1.1";
        }
        if ("org.apache.coyote.ajp.AjpProtocol".equals(this.getProtocolHandlerClassName()) || "org.apache.coyote.ajp.AjpAprProtocol".equals(this.getProtocolHandlerClassName())) {
            return "AJP/1.3";
        }
        return this.getProtocolHandlerClassName();
    }

    public void setProtocol(String protocol) {
        if (AprLifecycleListener.isAprAvailable()) {
            if ("HTTP/1.1".equals(protocol)) {
                this.setProtocolHandlerClassName("org.apache.coyote.http11.Http11AprProtocol");
            } else if ("AJP/1.3".equals(protocol)) {
                this.setProtocolHandlerClassName("org.apache.coyote.ajp.AjpAprProtocol");
            } else if (protocol != null) {
                this.setProtocolHandlerClassName(protocol);
            } else {
                this.setProtocolHandlerClassName("org.apache.coyote.http11.Http11AprProtocol");
            }
        } else if ("HTTP/1.1".equals(protocol)) {
            this.setProtocolHandlerClassName("org.apache.coyote.http11.Http11Protocol");
        } else if ("AJP/1.3".equals(protocol)) {
            this.setProtocolHandlerClassName("org.apache.coyote.ajp.AjpProtocol");
        } else if (protocol != null) {
            this.setProtocolHandlerClassName(protocol);
        }
    }

    public String getProtocolHandlerClassName() {
        return this.protocolHandlerClassName;
    }

    public void setProtocolHandlerClassName(String protocolHandlerClassName) {
        this.protocolHandlerClassName = protocolHandlerClassName;
    }

    public ProtocolHandler getProtocolHandler() {
        return this.protocolHandler;
    }

    public String getProxyName() {
        return this.proxyName;
    }

    public void setProxyName(String proxyName) {
        if (proxyName != null && proxyName.length() > 0) {
            this.proxyName = proxyName;
            this.setProperty("proxyName", proxyName);
        } else {
            this.proxyName = null;
        }
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public void setProxyPort(int proxyPort) {
        this.proxyPort = proxyPort;
        this.setProperty("proxyPort", String.valueOf(proxyPort));
    }

    public int getRedirectPort() {
        return this.redirectPort;
    }

    public void setRedirectPort(int redirectPort) {
        this.redirectPort = redirectPort;
        this.setProperty("redirectPort", String.valueOf(redirectPort));
    }

    public String getScheme() {
        return this.scheme;
    }

    public void setScheme(String scheme) {
        this.scheme = scheme;
    }

    public boolean getSecure() {
        return this.secure;
    }

    public void setSecure(boolean secure) {
        this.secure = secure;
        this.setProperty("secure", Boolean.toString(secure));
    }

    public String getURIEncoding() {
        return this.URIEncoding;
    }

    public void setURIEncoding(String URIEncoding) {
        this.URIEncoding = URIEncoding;
        this.setProperty("uRIEncoding", URIEncoding);
    }

    public boolean getUseBodyEncodingForURI() {
        return this.useBodyEncodingForURI;
    }

    public void setUseBodyEncodingForURI(boolean useBodyEncodingForURI) {
        this.useBodyEncodingForURI = useBodyEncodingForURI;
        this.setProperty("useBodyEncodingForURI", String.valueOf(useBodyEncodingForURI));
    }

    public boolean getXpoweredBy() {
        return this.xpoweredBy;
    }

    public void setXpoweredBy(boolean xpoweredBy) {
        this.xpoweredBy = xpoweredBy;
        this.setProperty("xpoweredBy", String.valueOf(xpoweredBy));
    }

    public void setUseIPVHosts(boolean useIPVHosts) {
        this.useIPVHosts = useIPVHosts;
        this.setProperty("useIPVHosts", String.valueOf(useIPVHosts));
    }

    public boolean getUseIPVHosts() {
        return this.useIPVHosts;
    }

    public Request createRequest() {
        Request request = new Request();
        request.setConnector(this);
        return request;
    }

    public Response createResponse() {
        Response response = new Response();
        response.setConnector(this);
        return response;
    }

    protected String createObjectNameKeyProperties(String type) {
        String address;
        Object addressObj = this.getProperty("address");
        StringBuilder sb = new StringBuilder("type=");
        sb.append(type);
        sb.append(",port=");
        sb.append(this.getPort());
        if (addressObj != null && (address = addressObj.toString()).length() > 0) {
            sb.append(",address=");
            sb.append(ObjectName.quote(address));
        }
        return sb.toString();
    }

    public void pause() {
        try {
            this.protocolHandler.pause();
        }
        catch (Exception e) {
            log.error((Object)sm.getString("coyoteConnector.protocolHandlerPauseFailed"), (Throwable)e);
        }
    }

    public void resume() {
        try {
            this.protocolHandler.resume();
        }
        catch (Exception e) {
            log.error((Object)sm.getString("coyoteConnector.protocolHandlerResumeFailed"), (Throwable)e);
        }
    }

    @Override
    protected void initInternal() throws LifecycleException {
        super.initInternal();
        this.adapter = new CoyoteAdapter(this);
        this.protocolHandler.setAdapter(this.adapter);
        IntrospectionUtils.setProperty((Object)this.protocolHandler, (String)"jkHome", (String)System.getProperty("catalina.base"));
        try {
            this.protocolHandler.init();
        }
        catch (Exception e) {
            throw new LifecycleException(sm.getString("coyoteConnector.protocolHandlerInitializationFailed", new Object[]{e}));
        }
        this.onameProtocolHandler = this.register(this.protocolHandler, this.createObjectNameKeyProperties("ProtocolHandler"));
        this.mapperListener.setDomain(this.getDomain());
        this.onameMapper = this.register(this.mapperListener, this.createObjectNameKeyProperties("Mapper"));
    }

    @Override
    protected void startInternal() throws LifecycleException {
        this.setState(LifecycleState.STARTING);
        try {
            this.protocolHandler.start();
        }
        catch (Exception e) {
            String errPrefix = "";
            if (this.service != null) {
                errPrefix = errPrefix + "service.getName(): \"" + this.service.getName() + "\"; ";
            }
            throw new LifecycleException(errPrefix + " " + sm.getString("coyoteConnector.protocolHandlerStartFailed", new Object[]{e}));
        }
        this.mapperListener.init();
    }

    @Override
    protected void stopInternal() throws LifecycleException {
        this.setState(LifecycleState.STOPPING);
        this.mapperListener.destroy();
    }

    @Override
    protected void destroyInternal() throws LifecycleException {
        this.unregister(this.onameMapper);
        this.unregister(this.onameProtocolHandler);
        try {
            this.protocolHandler.destroy();
        }
        catch (Exception e) {
            throw new LifecycleException(sm.getString("coyoteConnector.protocolHandlerDestroyFailed", new Object[]{e}));
        }
        if (this.getService() != null) {
            this.getService().removeConnector(this);
        }
        super.destroyInternal();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Connector[");
        sb.append(this.getProtocol());
        sb.append('-');
        sb.append(this.getPort());
        sb.append(']');
        return sb.toString();
    }

    @Override
    protected String getDomainInternal() {
        return MBeanUtils.getDomain(this.getService());
    }

    @Override
    protected String getObjectNameKeyProperties() {
        return this.createObjectNameKeyProperties("Connector");
    }

    static {
        replacements.put("acceptCount", "backlog");
        replacements.put("connectionLinger", "soLinger");
        replacements.put("connectionTimeout", "soTimeout");
        replacements.put("connectionUploadTimeout", "timeout");
        replacements.put("randomFile", "randomfile");
        replacements.put("rootFile", "rootfile");
        replacements.put("sslProtocols", "protocols");
    }
}

