/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Locale;
import org.apache.catalina.AccessLog;
import org.apache.catalina.Container;
import org.apache.catalina.ContainerEvent;
import org.apache.catalina.ContainerListener;
import org.apache.catalina.Context;
import org.apache.catalina.Engine;
import org.apache.catalina.Host;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Realm;
import org.apache.catalina.Service;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.core.ContainerBase;
import org.apache.catalina.core.StandardEngineValve;
import org.apache.catalina.realm.JAASRealm;
import org.apache.catalina.util.ServerInfo;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;

public class StandardEngine
extends ContainerBase
implements Engine {
    private static final Log log = LogFactory.getLog(StandardEngine.class);
    private String defaultHost = null;
    private static final String info = "org.apache.catalina.core.StandardEngine/1.0";
    private Service service = null;
    private String baseDir = null;
    private String jvmRouteId;
    private volatile AccessLog defaultAccessLog;

    public StandardEngine() {
        this.pipeline.setBasic(new StandardEngineValve());
        try {
            this.setJvmRoute(System.getProperty("jvmRoute"));
        }
        catch (Exception ex) {
            log.warn((Object)sm.getString("standardEngine.jvmRouteFail"));
        }
        this.backgroundProcessorDelay = 10;
    }

    @Override
    public Realm getRealm() {
        Realm configured = super.getRealm();
        if (configured == null) {
            configured = new JAASRealm();
            this.setRealm(configured);
        }
        return configured;
    }

    @Override
    public String getDefaultHost() {
        return this.defaultHost;
    }

    @Override
    public void setDefaultHost(String host) {
        String oldDefaultHost = this.defaultHost;
        this.defaultHost = host == null ? null : host.toLowerCase(Locale.ENGLISH);
        this.support.firePropertyChange("defaultHost", oldDefaultHost, this.defaultHost);
    }

    @Override
    public void setJvmRoute(String routeId) {
        this.jvmRouteId = routeId;
    }

    @Override
    public String getJvmRoute() {
        return this.jvmRouteId;
    }

    @Override
    public Service getService() {
        return this.service;
    }

    @Override
    public void setService(Service service) {
        this.service = service;
    }

    public String getBaseDir() {
        if (this.baseDir == null) {
            this.baseDir = System.getProperty("catalina.base");
        }
        if (this.baseDir == null) {
            this.baseDir = System.getProperty("catalina.home");
        }
        return this.baseDir;
    }

    public void setBaseDir(String baseDir) {
        this.baseDir = baseDir;
    }

    @Override
    public void addChild(Container child) {
        if (!(child instanceof Host)) {
            throw new IllegalArgumentException(sm.getString("standardEngine.notHost"));
        }
        super.addChild(child);
    }

    @Override
    public String getInfo() {
        return info;
    }

    @Override
    public void setParent(Container container) {
        throw new IllegalArgumentException(sm.getString("standardEngine.notParent"));
    }

    @Override
    protected synchronized void startInternal() throws LifecycleException {
        if (log.isInfoEnabled()) {
            log.info((Object)("Starting Servlet Engine: " + ServerInfo.getServerInfo()));
        }
        super.startInternal();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("StandardEngine[");
        sb.append(this.getName());
        sb.append("]");
        return sb.toString();
    }

    @Override
    public void logAccess(Request request, Response response, long time, boolean useDefault) {
        boolean logged = false;
        if (this.getAccessLog() != null) {
            this.accessLog.log(request, response, time);
            logged = true;
        }
        if (!logged && useDefault) {
            if (this.defaultAccessLog == null) {
                Host host = (Host)this.findChild(this.getDefaultHost());
                if (host != null && host.getState().isAvailable()) {
                    this.defaultAccessLog = host.getAccessLog();
                    if (this.defaultAccessLog != null) {
                        AccessLogListener l = new AccessLogListener(this);
                        host.addPropertyChangeListener(l);
                        host.addContainerListener(l);
                        host.addLifecycleListener(l);
                    } else {
                        Context context = (Context)host.findChild("");
                        if (context != null && context.getState().isAvailable()) {
                            this.defaultAccessLog = context.getAccessLog();
                            if (this.defaultAccessLog != null) {
                                AccessLogListener l = new AccessLogListener(this);
                                context.addPropertyChangeListener(l);
                                context.addLifecycleListener(l);
                            }
                        }
                    }
                }
                if (this.defaultAccessLog == null) {
                    this.defaultAccessLog = new NoopAccessLog();
                }
            }
            this.defaultAccessLog.log(request, response, time);
        }
    }

    @Override
    public ClassLoader getParentClassLoader() {
        if (this.parentClassLoader != null) {
            return this.parentClassLoader;
        }
        if (this.service != null) {
            return this.service.getParentClassLoader();
        }
        return ClassLoader.getSystemClassLoader();
    }

    @Override
    protected String getObjectNameKeyProperties() {
        return "type=Engine";
    }

    protected static final class AccessLogListener
    implements PropertyChangeListener,
    LifecycleListener,
    ContainerListener {
        private StandardEngine engine;
        private volatile boolean disabled = false;

        public AccessLogListener(StandardEngine engine) {
            this.engine = engine;
        }

        @Override
        public void lifecycleEvent(LifecycleEvent event) {
            if (this.disabled) {
                return;
            }
            String type = event.getType();
            if ("after_start".equals(type) || "before_stop".equals(type)) {
                this.engine.defaultAccessLog = null;
            } else if ("before_destroy".endsWith(type)) {
                this.engine.defaultAccessLog = null;
                this.disabled = true;
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (this.disabled) {
                return;
            }
            if ("defaultHost".equals(evt.getPropertyName())) {
                this.engine.defaultAccessLog = null;
                this.disabled = true;
            }
        }

        @Override
        public void containerEvent(ContainerEvent event) {
            Context context;
            if (this.disabled) {
                return;
            }
            if ("addChild".equals(event.getType()) && "".equals((context = (Context)event.getData()).getPath())) {
                this.engine.defaultAccessLog = null;
            }
        }
    }

    protected static final class NoopAccessLog
    implements AccessLog {
        protected NoopAccessLog() {
        }

        @Override
        public void log(Request request, Response response, long time) {
        }
    }
}

