/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.session;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedAction;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Date;
import java.util.Deque;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Engine;
import org.apache.catalina.Globals;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.Manager;
import org.apache.catalina.Session;
import org.apache.catalina.mbeans.MBeanUtils;
import org.apache.catalina.session.StandardSession;
import org.apache.catalina.util.Base64;
import org.apache.catalina.util.LifecycleMBeanBase;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.ExceptionUtils;
import org.apache.tomcat.util.res.StringManager;

public abstract class ManagerBase
extends LifecycleMBeanBase
implements Manager,
PropertyChangeListener {
    private final Log log = LogFactory.getLog(ManagerBase.class);
    protected volatile Queue<InputStream> randomInputStreams = new ConcurrentLinkedQueue<InputStream>();
    protected String randomFile = "/dev/urandom";
    protected String randomFileCurrent = null;
    protected volatile boolean randomFileCurrentIsValid = true;
    protected static final String DEFAULT_ALGORITHM = "MD5";
    protected String algorithm = "MD5";
    protected Container container;
    protected Queue<MessageDigest> digests = new ConcurrentLinkedQueue<MessageDigest>();
    protected boolean distributable;
    protected String entropy = null;
    private static final String info = "ManagerBase/1.0";
    protected int maxInactiveInterval = 1800;
    protected int sessionIdLength = 16;
    protected static String name = "ManagerBase";
    protected Queue<Random> randoms = new ConcurrentLinkedQueue<Random>();
    protected SecureRandom randomSeed = null;
    protected String randomClass = "java.security.SecureRandom";
    protected volatile int sessionMaxAliveTime;
    private final Object sessionMaxAliveTimeUpdateLock = new Object();
    protected static final int TIMING_STATS_CACHE_SIZE = 100;
    protected Deque<SessionTiming> sessionCreationTiming = new LinkedList<SessionTiming>();
    protected Deque<SessionTiming> sessionExpirationTiming = new LinkedList<SessionTiming>();
    protected AtomicLong expiredSessions = new AtomicLong(0L);
    protected Map<String, Session> sessions = new ConcurrentHashMap<String, Session>();
    protected long sessionCounter = 0L;
    protected volatile int maxActive = 0;
    private final Object maxActiveUpdateLock = new Object();
    protected int maxActiveSessions = -1;
    protected int rejectedSessions = 0;
    protected volatile int duplicates = 0;
    protected long processingTime = 0L;
    private int count = 0;
    protected int processExpiresFrequency = 6;
    protected static final StringManager sm = StringManager.getManager((String)"org.apache.catalina.session");
    protected PropertyChangeSupport support = new PropertyChangeSupport(this);

    public String getAlgorithm() {
        return this.algorithm;
    }

    public void setAlgorithm(String algorithm) {
        String oldAlgorithm = this.algorithm;
        this.algorithm = algorithm;
        this.support.firePropertyChange("algorithm", oldAlgorithm, this.algorithm);
    }

    @Override
    public Container getContainer() {
        return this.container;
    }

    @Override
    public void setContainer(Container container) {
        if (this.container != null && this.container instanceof Context) {
            ((Context)this.container).removePropertyChangeListener(this);
        }
        Container oldContainer = this.container;
        this.container = container;
        this.support.firePropertyChange("container", oldContainer, this.container);
        if (this.container != null && this.container instanceof Context) {
            this.setMaxInactiveInterval(((Context)this.container).getSessionTimeout() * 60);
            ((Context)this.container).addPropertyChangeListener(this);
        }
    }

    public String getClassName() {
        return this.getClass().getName();
    }

    protected MessageDigest createDigest() {
        MessageDigest result;
        long t1 = System.currentTimeMillis();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)sm.getString("managerBase.getting", new Object[]{this.algorithm}));
        }
        try {
            result = MessageDigest.getInstance(this.algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            this.log.error((Object)sm.getString("managerBase.digest", new Object[]{this.algorithm}), (Throwable)e);
            try {
                result = MessageDigest.getInstance(DEFAULT_ALGORITHM);
            }
            catch (NoSuchAlgorithmException f) {
                this.log.error((Object)sm.getString("managerBase.digest", new Object[]{DEFAULT_ALGORITHM}), (Throwable)e);
                result = null;
            }
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)sm.getString("managerBase.gotten"));
        }
        long t2 = System.currentTimeMillis();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("getDigest() " + (t2 - t1)));
        }
        return result;
    }

    @Override
    public boolean getDistributable() {
        return this.distributable;
    }

    @Override
    public void setDistributable(boolean distributable) {
        boolean oldDistributable = this.distributable;
        this.distributable = distributable;
        this.support.firePropertyChange("distributable", (Object)oldDistributable, (Object)this.distributable);
    }

    public String getEntropy() {
        if (this.entropy == null) {
            byte[] result = new byte[32];
            boolean apr = false;
            try {
                String methodName = "random";
                Class[] paramTypes = new Class[]{result.getClass(), Integer.TYPE};
                Object[] paramValues = new Object[]{result, 32};
                Method method = Class.forName("org.apache.tomcat.jni.OS").getMethod(methodName, paramTypes);
                method.invoke(null, paramValues);
                apr = true;
            }
            catch (Throwable t) {
                ExceptionUtils.handleThrowable((Throwable)t);
            }
            if (apr) {
                this.setEntropy(Base64.encode(result));
            } else {
                this.setEntropy(this.toString());
            }
        }
        return this.entropy;
    }

    public void setEntropy(String entropy) {
        String oldEntropy = entropy;
        this.entropy = entropy;
        this.support.firePropertyChange("entropy", oldEntropy, this.entropy);
    }

    @Override
    public String getInfo() {
        return info;
    }

    @Override
    public int getMaxInactiveInterval() {
        return this.maxInactiveInterval;
    }

    @Override
    public void setMaxInactiveInterval(int interval) {
        int oldMaxInactiveInterval = this.maxInactiveInterval;
        this.maxInactiveInterval = interval;
        this.support.firePropertyChange("maxInactiveInterval", (Object)oldMaxInactiveInterval, (Object)this.maxInactiveInterval);
    }

    @Override
    public int getSessionIdLength() {
        return this.sessionIdLength;
    }

    @Override
    public void setSessionIdLength(int idLength) {
        int oldSessionIdLength = this.sessionIdLength;
        this.sessionIdLength = idLength;
        this.support.firePropertyChange("sessionIdLength", (Object)oldSessionIdLength, (Object)this.sessionIdLength);
    }

    public String getName() {
        return name;
    }

    public void setRandomFile(String s) {
        this.randomFile = s;
    }

    protected InputStream createRandomInputStream() {
        if (Globals.IS_SECURITY_ENABLED) {
            return AccessController.doPrivileged(new PrivilegedCreateRandomInputStream());
        }
        try {
            File f = new File(this.randomFileCurrent);
            if (!f.exists()) {
                this.randomFileCurrentIsValid = false;
                this.closeRandomInputStreams();
                return null;
            }
            FileInputStream is = new FileInputStream(f);
            ((InputStream)is).read();
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Opening " + this.randomFileCurrent));
            }
            this.randomFileCurrentIsValid = true;
            return is;
        }
        catch (IOException ex) {
            this.log.warn((Object)("Error reading " + this.randomFileCurrent), (Throwable)ex);
            this.randomFileCurrentIsValid = false;
            this.closeRandomInputStreams();
            return null;
        }
    }

    public String getRandomFile() {
        return this.randomFile;
    }

    public String getRandomFileCurrent() {
        return this.randomFileCurrent;
    }

    protected synchronized void closeRandomInputStreams() {
        InputStream is = this.randomInputStreams.poll();
        while (is != null) {
            try {
                is.close();
            }
            catch (Exception e) {
                this.log.warn((Object)"Failed to close randomInputStream.");
            }
            is = this.randomInputStreams.poll();
        }
    }

    protected Random createRandom() {
        long t2;
        if (this.randomSeed == null) {
            this.createRandomSeed();
        }
        Random result = null;
        long t1 = System.currentTimeMillis();
        try {
            Class<?> clazz = Class.forName(this.randomClass);
            result = (Random)clazz.newInstance();
        }
        catch (Exception e) {
            this.log.error((Object)sm.getString("managerBase.random", new Object[]{this.randomClass}), (Throwable)e);
            result = new Random();
        }
        byte[] seedBytes = this.randomSeed.generateSeed(64);
        ByteArrayInputStream bais = new ByteArrayInputStream(seedBytes);
        DataInputStream dis = new DataInputStream(bais);
        for (int i = 0; i < 8; ++i) {
            try {
                result.setSeed(dis.readLong());
                continue;
            }
            catch (IOException e) {
                this.log.error((Object)sm.getString("managerBase.seedFailed", new Object[]{result.getClass().getName()}), (Throwable)e);
            }
        }
        if (this.log.isDebugEnabled() && (t2 = System.currentTimeMillis()) - t1 > 100L) {
            this.log.debug((Object)sm.getString("managerBase.createRandom", new Object[]{t2 - t1}));
        }
        return result;
    }

    protected synchronized void createRandomSeed() {
        long t2;
        long seed;
        if (this.randomSeed != null) {
            return;
        }
        long t1 = seed = System.currentTimeMillis();
        char[] entropy = this.getEntropy().toCharArray();
        for (int i = 0; i < entropy.length; ++i) {
            long update = (byte)entropy[i] << i % 8 * 8;
            seed ^= update;
        }
        SecureRandom result = new SecureRandom();
        result.setSeed(seed);
        if (this.log.isDebugEnabled() && (t2 = System.currentTimeMillis()) - t1 > 100L) {
            this.log.debug((Object)sm.getString("managerBase.createRandomSeed", new Object[]{t2 - t1}));
        }
        this.randomSeed = result;
    }

    public String getRandomClass() {
        return this.randomClass;
    }

    public void setRandomClass(String randomClass) {
        String oldRandomClass = this.randomClass;
        this.randomClass = randomClass;
        this.support.firePropertyChange("randomClass", oldRandomClass, this.randomClass);
    }

    @Override
    public int getRejectedSessions() {
        return this.rejectedSessions;
    }

    @Override
    public long getExpiredSessions() {
        return this.expiredSessions.get();
    }

    @Override
    public void setExpiredSessions(long expiredSessions) {
        this.expiredSessions.set(expiredSessions);
    }

    public long getProcessingTime() {
        return this.processingTime;
    }

    public void setProcessingTime(long processingTime) {
        this.processingTime = processingTime;
    }

    public int getProcessExpiresFrequency() {
        return this.processExpiresFrequency;
    }

    public void setProcessExpiresFrequency(int processExpiresFrequency) {
        if (processExpiresFrequency <= 0) {
            return;
        }
        int oldProcessExpiresFrequency = this.processExpiresFrequency;
        this.processExpiresFrequency = processExpiresFrequency;
        this.support.firePropertyChange("processExpiresFrequency", (Object)oldProcessExpiresFrequency, (Object)this.processExpiresFrequency);
    }

    @Override
    public void backgroundProcess() {
        this.count = (this.count + 1) % this.processExpiresFrequency;
        if (this.count == 0) {
            this.processExpires();
        }
    }

    public void processExpires() {
        long timeNow = System.currentTimeMillis();
        Session[] sessions = this.findSessions();
        int expireHere = 0;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Start expire sessions " + this.getName() + " at " + timeNow + " sessioncount " + sessions.length));
        }
        for (int i = 0; i < sessions.length; ++i) {
            if (sessions[i] == null || sessions[i].isValid()) continue;
            ++expireHere;
        }
        long timeEnd = System.currentTimeMillis();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("End expire sessions " + this.getName() + " processingTime " + (timeEnd - timeNow) + " expired sessions: " + expireHere));
        }
        this.processingTime += timeEnd - timeNow;
    }

    @Override
    protected void initInternal() throws LifecycleException {
        super.initInternal();
        this.setDistributable(((Context)this.getContainer()).getDistributable());
    }

    @Override
    protected void startInternal() throws LifecycleException {
        this.randomFileCurrent = this.randomFile;
        InputStream is = this.createRandomInputStream();
        if (is != null) {
            this.randomInputStreams.add(is);
        }
        while (this.sessionCreationTiming.size() < 100) {
            this.sessionCreationTiming.add(null);
        }
        while (this.sessionExpirationTiming.size() < 100) {
            this.sessionExpirationTiming.add(null);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Force random number initialization starting");
        }
        this.generateSessionId();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Force random number initialization completed");
        }
    }

    @Override
    protected void stopInternal() throws LifecycleException {
        this.closeRandomInputStreams();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(Session session) {
        this.sessions.put(session.getIdInternal(), session);
        int size = this.getActiveSessions();
        if (size > this.maxActive) {
            Object object = this.maxActiveUpdateLock;
            synchronized (object) {
                if (size > this.maxActive) {
                    this.maxActive = size;
                }
            }
        }
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.support.addPropertyChangeListener(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Session createSession(String sessionId) {
        if (this.maxActiveSessions >= 0 && this.getActiveSessions() >= this.maxActiveSessions) {
            ++this.rejectedSessions;
            throw new IllegalStateException(sm.getString("managerBase.createSession.ise"));
        }
        Session session = this.createEmptySession();
        session.setNew(true);
        session.setValid(true);
        session.setCreationTime(System.currentTimeMillis());
        session.setMaxInactiveInterval(this.maxInactiveInterval);
        String id = sessionId;
        if (id == null) {
            id = this.generateSessionId();
        }
        session.setId(id);
        ++this.sessionCounter;
        SessionTiming timing = new SessionTiming(session.getCreationTime(), 0);
        Deque<SessionTiming> deque = this.sessionCreationTiming;
        synchronized (deque) {
            this.sessionCreationTiming.add(timing);
            this.sessionCreationTiming.poll();
        }
        return session;
    }

    @Override
    public Session createEmptySession() {
        return this.getNewSession();
    }

    @Override
    public Session findSession(String id) throws IOException {
        if (id == null) {
            return null;
        }
        return this.sessions.get(id);
    }

    @Override
    public Session[] findSessions() {
        return this.sessions.values().toArray(new Session[0]);
    }

    @Override
    public void remove(Session session) {
        this.remove(session, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(Session session, boolean update) {
        if (update) {
            long timeNow = System.currentTimeMillis();
            int timeAlive = (int)((timeNow - session.getCreationTime()) / 1000L);
            this.updateSessionMaxAliveTime(timeAlive);
            this.expiredSessions.incrementAndGet();
            SessionTiming timing = new SessionTiming(timeNow, timeAlive);
            Deque<SessionTiming> deque = this.sessionExpirationTiming;
            synchronized (deque) {
                this.sessionExpirationTiming.add(timing);
                this.sessionExpirationTiming.poll();
            }
        }
        if (session.getIdInternal() != null) {
            this.sessions.remove(session.getIdInternal());
        }
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.support.removePropertyChangeListener(listener);
    }

    @Override
    public void changeSessionId(Session session) {
        session.setId(this.generateSessionId());
    }

    protected StandardSession getNewSession() {
        return new StandardSession(this);
    }

    protected void getRandomBytes(byte[] bytes) {
        Random random;
        if (this.randomFileCurrentIsValid) {
            InputStream is = null;
            try {
                int len;
                is = this.randomInputStreams.poll();
                if (is == null) {
                    is = this.createRandomInputStream();
                }
                if ((len = is.read(bytes)) == bytes.length) {
                    this.randomInputStreams.add(is);
                    return;
                }
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Got " + len + " " + bytes.length));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.randomFileCurrentIsValid = false;
            if (is != null) {
                this.randomInputStreams.add(is);
            }
            this.closeRandomInputStreams();
        }
        if ((random = this.randoms.poll()) == null) {
            random = this.createRandom();
        }
        random.nextBytes(bytes);
        this.randoms.add(random);
    }

    protected String generateSessionId() {
        byte[] random = new byte[16];
        String jvmRoute = this.getJvmRoute();
        String result = null;
        StringBuilder buffer = new StringBuilder();
        do {
            int resultLenBytes = 0;
            if (result != null) {
                buffer = new StringBuilder();
                ++this.duplicates;
            }
            while (resultLenBytes < this.sessionIdLength) {
                this.getRandomBytes(random);
                MessageDigest md = this.digests.poll();
                if (md == null) {
                    md = this.createDigest();
                }
                random = md.digest(random);
                this.digests.add(md);
                for (int j = 0; j < random.length && resultLenBytes < this.sessionIdLength; ++resultLenBytes, ++j) {
                    byte b1 = (byte)((random[j] & 0xF0) >> 4);
                    byte b2 = (byte)(random[j] & 0xF);
                    if (b1 < 10) {
                        buffer.append((char)(48 + b1));
                    } else {
                        buffer.append((char)(65 + (b1 - 10)));
                    }
                    if (b2 < 10) {
                        buffer.append((char)(48 + b2));
                        continue;
                    }
                    buffer.append((char)(65 + (b2 - 10)));
                }
            }
            if (jvmRoute == null) continue;
            buffer.append('.').append(jvmRoute);
        } while (this.sessions.containsKey(result = buffer.toString()));
        return result;
    }

    public Engine getEngine() {
        Engine e = null;
        for (Container c = this.getContainer(); e == null && c != null; c = c.getParent()) {
            if (!(c instanceof Engine)) continue;
            e = (Engine)c;
        }
        return e;
    }

    public String getJvmRoute() {
        Engine e = this.getEngine();
        return e == null ? null : e.getJvmRoute();
    }

    @Override
    public void setSessionCounter(long sessionCounter) {
        this.sessionCounter = sessionCounter;
    }

    @Override
    public long getSessionCounter() {
        return this.sessionCounter;
    }

    public int getDuplicates() {
        return this.duplicates;
    }

    public void setDuplicates(int duplicates) {
        this.duplicates = duplicates;
    }

    @Override
    public int getActiveSessions() {
        return this.sessions.size();
    }

    @Override
    public int getMaxActive() {
        return this.maxActive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMaxActive(int maxActive) {
        Object object = this.maxActiveUpdateLock;
        synchronized (object) {
            this.maxActive = maxActive;
        }
    }

    public int getMaxActiveSessions() {
        return this.maxActiveSessions;
    }

    public void setMaxActiveSessions(int max) {
        int oldMaxActiveSessions = this.maxActiveSessions;
        this.maxActiveSessions = max;
        this.support.firePropertyChange("maxActiveSessions", new Integer(oldMaxActiveSessions), new Integer(this.maxActiveSessions));
    }

    @Override
    public int getSessionMaxAliveTime() {
        return this.sessionMaxAliveTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSessionMaxAliveTime(int sessionMaxAliveTime) {
        Object object = this.sessionMaxAliveTimeUpdateLock;
        synchronized (object) {
            this.sessionMaxAliveTime = sessionMaxAliveTime;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateSessionMaxAliveTime(int sessionAliveTime) {
        if (sessionAliveTime > this.sessionMaxAliveTime) {
            Object object = this.sessionMaxAliveTimeUpdateLock;
            synchronized (object) {
                if (sessionAliveTime > this.sessionMaxAliveTime) {
                    this.sessionMaxAliveTime = sessionAliveTime;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getSessionAverageAliveTime() {
        ArrayList<SessionTiming> copy = new ArrayList<SessionTiming>();
        Deque<SessionTiming> deque = this.sessionExpirationTiming;
        synchronized (deque) {
            copy.addAll(this.sessionExpirationTiming);
        }
        int counter = 0;
        int result = 0;
        for (SessionTiming timing : copy) {
            if (timing == null) continue;
            int timeAlive = timing.getDuration();
            result = result * ((++counter - 1) / counter) + timeAlive / counter;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getSessionCreateRate() {
        long now = System.currentTimeMillis();
        ArrayList<SessionTiming> copy = new ArrayList<SessionTiming>();
        Deque<SessionTiming> deque = this.sessionCreationTiming;
        synchronized (deque) {
            copy.addAll(this.sessionCreationTiming);
        }
        long oldest = now;
        int counter = 0;
        int result = 0;
        for (SessionTiming timing : copy) {
            if (timing == null) continue;
            ++counter;
            if (timing.getTimestamp() >= oldest) continue;
            oldest = timing.getTimestamp();
        }
        if (counter > 0) {
            result = oldest < now ? (int)((long)(60000 * counter) / (now - oldest)) : Integer.MAX_VALUE;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getSessionExpireRate() {
        long now = System.currentTimeMillis();
        ArrayList<SessionTiming> copy = new ArrayList<SessionTiming>();
        Deque<SessionTiming> deque = this.sessionExpirationTiming;
        synchronized (deque) {
            copy.addAll(this.sessionExpirationTiming);
        }
        long oldest = now;
        int counter = 0;
        int result = 0;
        for (SessionTiming timing : copy) {
            if (timing == null) continue;
            ++counter;
            if (timing.getTimestamp() >= oldest) continue;
            oldest = timing.getTimestamp();
        }
        if (counter > 0) {
            result = oldest < now ? (int)((long)(60000 * counter) / (now - oldest)) : Integer.MAX_VALUE;
        }
        return result;
    }

    public String listSessionIds() {
        StringBuilder sb = new StringBuilder();
        Iterator<String> keys = this.sessions.keySet().iterator();
        while (keys.hasNext()) {
            sb.append(keys.next()).append(" ");
        }
        return sb.toString();
    }

    public String getSessionAttribute(String sessionId, String key) {
        Session s = this.sessions.get(sessionId);
        if (s == null) {
            if (this.log.isInfoEnabled()) {
                this.log.info((Object)("Session not found " + sessionId));
            }
            return null;
        }
        Object o = s.getSession().getAttribute(key);
        if (o == null) {
            return null;
        }
        return o.toString();
    }

    public HashMap<String, String> getSession(String sessionId) {
        Session s = this.sessions.get(sessionId);
        if (s == null) {
            if (this.log.isInfoEnabled()) {
                this.log.info((Object)("Session not found " + sessionId));
            }
            return null;
        }
        Enumeration ee = s.getSession().getAttributeNames();
        if (ee == null || !ee.hasMoreElements()) {
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        while (ee.hasMoreElements()) {
            String attrName = (String)ee.nextElement();
            map.put(attrName, this.getSessionAttribute(sessionId, attrName));
        }
        return map;
    }

    public void expireSession(String sessionId) {
        Session s = this.sessions.get(sessionId);
        if (s == null) {
            if (this.log.isInfoEnabled()) {
                this.log.info((Object)("Session not found " + sessionId));
            }
            return;
        }
        s.expire();
    }

    public long getThisAccessedTimestamp(String sessionId) {
        Session s = this.sessions.get(sessionId);
        if (s == null) {
            return -1L;
        }
        return s.getThisAccessedTime();
    }

    public String getThisAccessedTime(String sessionId) {
        Session s = this.sessions.get(sessionId);
        if (s == null) {
            if (this.log.isInfoEnabled()) {
                this.log.info((Object)("Session not found " + sessionId));
            }
            return "";
        }
        return new Date(s.getThisAccessedTime()).toString();
    }

    public long getLastAccessedTimestamp(String sessionId) {
        Session s = this.sessions.get(sessionId);
        if (s == null) {
            return -1L;
        }
        return s.getLastAccessedTime();
    }

    public String getLastAccessedTime(String sessionId) {
        Session s = this.sessions.get(sessionId);
        if (s == null) {
            if (this.log.isInfoEnabled()) {
                this.log.info((Object)("Session not found " + sessionId));
            }
            return "";
        }
        return new Date(s.getLastAccessedTime()).toString();
    }

    public String getCreationTime(String sessionId) {
        Session s = this.sessions.get(sessionId);
        if (s == null) {
            if (this.log.isInfoEnabled()) {
                this.log.info((Object)("Session not found " + sessionId));
            }
            return "";
        }
        return new Date(s.getCreationTime()).toString();
    }

    public long getCreationTimestamp(String sessionId) {
        Session s = this.sessions.get(sessionId);
        if (s == null) {
            return -1L;
        }
        return s.getCreationTime();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getName());
        sb.append('[');
        if (this.container == null) {
            sb.append("Container is null");
        } else {
            sb.append(this.container.getName());
        }
        sb.append(']');
        return sb.toString();
    }

    @Override
    public String getObjectNameKeyProperties() {
        StringBuilder name = new StringBuilder("type=Manager");
        if (this.container instanceof Context) {
            name.append(",context=");
            String contextName = this.container.getName();
            if (!contextName.startsWith("/")) {
                name.append('/');
            }
            name.append(contextName);
            Context context = (Context)this.container;
            name.append(",host=");
            name.append(context.getParent().getName());
        } else {
            name.append(",container=");
            name.append(this.container.getName());
        }
        return name.toString();
    }

    @Override
    public String getDomainInternal() {
        return MBeanUtils.getDomain(this.container);
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        if (!(event.getSource() instanceof Context)) {
            return;
        }
        if (event.getPropertyName().equals("sessionTimeout")) {
            try {
                this.setMaxInactiveInterval((Integer)event.getNewValue() * 60);
            }
            catch (NumberFormatException e) {
                this.log.error((Object)sm.getString("managerBase.sessionTimeout", new Object[]{event.getNewValue()}));
            }
        }
    }

    protected static final class SessionTiming {
        private long timestamp;
        private int duration;

        public SessionTiming(long timestamp, int duration) {
            this.timestamp = timestamp;
            this.duration = duration;
        }

        public long getTimestamp() {
            return this.timestamp;
        }

        public int getDuration() {
            return this.duration;
        }
    }

    private class PrivilegedCreateRandomInputStream
    implements PrivilegedAction<InputStream> {
        private PrivilegedCreateRandomInputStream() {
        }

        @Override
        public InputStream run() {
            try {
                File f = new File(ManagerBase.this.randomFileCurrent);
                if (!f.exists()) {
                    ManagerBase.this.randomFileCurrentIsValid = false;
                    ManagerBase.this.closeRandomInputStreams();
                    return null;
                }
                FileInputStream is = new FileInputStream(f);
                ((InputStream)is).read();
                if (ManagerBase.this.log.isDebugEnabled()) {
                    ManagerBase.this.log.debug((Object)("Opening " + ManagerBase.this.randomFileCurrent));
                }
                ManagerBase.this.randomFileCurrentIsValid = true;
                return is;
            }
            catch (IOException ex) {
                ManagerBase.this.log.warn((Object)("Error reading " + ManagerBase.this.randomFileCurrent), (Throwable)ex);
                ManagerBase.this.randomFileCurrentIsValid = false;
                ManagerBase.this.closeRandomInputStreams();
                return null;
            }
        }
    }
}

