/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.util;

import java.util.Locale;

public final class ContextName {
    private final String ROOT_NAME = "ROOT";
    private final String VERSION_MARKER = "##";
    private final String FWD_SLASH_REPLACEMENT = "#";
    private final String baseName;
    private final String path;
    private final String version;
    private final String name;

    public ContextName(String name) {
        String tmp;
        this.baseName = name.toLowerCase(Locale.ENGLISH).endsWith(".war") || name.toLowerCase(Locale.ENGLISH).endsWith(".xml") ? name.substring(0, name.length() - 4) : name;
        int versionIndex = this.baseName.indexOf("##");
        if (versionIndex > -1) {
            this.version = this.baseName.substring(versionIndex + 2);
            tmp = this.baseName.substring(0, versionIndex);
        } else {
            this.version = "";
            tmp = this.baseName;
        }
        this.path = "ROOT".equals(tmp) ? "" : "/" + tmp.replaceAll("#", "/");
        this.name = versionIndex > -1 ? this.path + "##" + this.version : this.path;
    }

    public ContextName(String path, String version) {
        this.path = path == null || "/".equals(path) ? "" : path;
        this.version = version == null ? "" : version;
        this.name = "".equals(this.version) ? this.path : this.path + "##" + this.version;
        StringBuilder tmp = new StringBuilder();
        if ("".equals(this.path)) {
            tmp.append("ROOT");
        } else {
            tmp.append(this.path.substring(1).replaceAll("/", "#"));
        }
        if (this.version.length() > 0) {
            tmp.append("##");
            tmp.append(this.version);
        }
        this.baseName = tmp.toString();
    }

    public String getBaseName() {
        return this.baseName;
    }

    public String getPath() {
        return this.path;
    }

    public String getVersion() {
        return this.version;
    }

    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        StringBuilder tmp = new StringBuilder();
        if (this.path == "") {
            tmp.append('/');
        } else {
            tmp.append(this.path);
        }
        if (this.version != "") {
            tmp.append("##");
            tmp.append(this.version);
        }
        return tmp.toString();
    }

    public String toString() {
        return this.getDisplayName();
    }
}

