/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.connector;

import java.io.IOException;
import java.io.Writer;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import org.apache.catalina.Globals;
import org.apache.catalina.connector.ClientAbortException;
import org.apache.coyote.ActionCode;
import org.apache.coyote.Response;
import org.apache.tomcat.util.buf.ByteChunk;
import org.apache.tomcat.util.buf.C2BConverter;

public class OutputBuffer
extends Writer
implements ByteChunk.ByteOutputChannel {
    public static final String DEFAULT_ENCODING = "ISO-8859-1";
    public static final int DEFAULT_BUFFER_SIZE = 8192;
    private ByteChunk bb;
    private boolean initial = true;
    private long bytesWritten = 0L;
    private long charsWritten = 0L;
    private boolean closed = false;
    private boolean doFlush = false;
    private ByteChunk outputChunk = new ByteChunk();
    private String enc;
    private boolean gotEnc = false;
    protected HashMap<String, C2BConverter> encoders = new HashMap();
    protected C2BConverter conv;
    private Response coyoteResponse;
    private boolean suspended = false;

    public OutputBuffer() {
        this(8192);
    }

    public OutputBuffer(int size) {
        this.bb = new ByteChunk(size);
        this.bb.setLimit(size);
        this.bb.setByteOutputChannel((ByteChunk.ByteOutputChannel)this);
    }

    public void setResponse(Response coyoteResponse) {
        this.coyoteResponse = coyoteResponse;
    }

    public Response getResponse() {
        return this.coyoteResponse;
    }

    public boolean isSuspended() {
        return this.suspended;
    }

    public void setSuspended(boolean suspended) {
        this.suspended = suspended;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void recycle() {
        this.initial = true;
        this.bytesWritten = 0L;
        this.charsWritten = 0L;
        this.bb.recycle();
        this.closed = false;
        this.suspended = false;
        if (this.conv != null) {
            this.conv.recycle();
        }
        this.gotEnc = false;
        this.enc = null;
    }

    public void clearEncoders() {
        this.encoders.clear();
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        if (this.suspended) {
            return;
        }
        if (!this.coyoteResponse.isCommitted() && this.coyoteResponse.getContentLengthLong() == -1L && !this.coyoteResponse.isCommitted()) {
            this.coyoteResponse.setContentLength(this.bb.getLength());
        }
        this.doFlush(false);
        this.closed = true;
        this.coyoteResponse.finish();
    }

    @Override
    public void flush() throws IOException {
        this.doFlush(true);
    }

    protected void doFlush(boolean realFlush) throws IOException {
        if (this.suspended) {
            return;
        }
        this.doFlush = true;
        if (this.initial) {
            this.coyoteResponse.sendHeaders();
            this.initial = false;
        }
        if (this.bb.getLength() > 0) {
            this.bb.flushBuffer();
        }
        this.doFlush = false;
        if (realFlush) {
            this.coyoteResponse.action(ActionCode.CLIENT_FLUSH, (Object)this.coyoteResponse);
            if (this.coyoteResponse.isExceptionPresent()) {
                throw new ClientAbortException(this.coyoteResponse.getErrorException());
            }
        }
    }

    public void realWriteBytes(byte[] buf, int off, int cnt) throws IOException {
        if (this.closed) {
            return;
        }
        if (this.coyoteResponse == null) {
            return;
        }
        if (cnt > 0) {
            this.outputChunk.setBytes(buf, off, cnt);
            try {
                this.coyoteResponse.doWrite(this.outputChunk);
            }
            catch (IOException e) {
                throw new ClientAbortException(e);
            }
        }
    }

    public void write(byte[] b, int off, int len) throws IOException {
        if (this.suspended) {
            return;
        }
        this.writeBytes(b, off, len);
    }

    private void writeBytes(byte[] b, int off, int len) throws IOException {
        if (this.closed) {
            return;
        }
        this.bb.append(b, off, len);
        this.bytesWritten += (long)len;
        if (this.doFlush) {
            this.bb.flushBuffer();
        }
    }

    public void writeByte(int b) throws IOException {
        if (this.suspended) {
            return;
        }
        this.bb.append((byte)b);
        ++this.bytesWritten;
    }

    @Override
    public void write(int c) throws IOException {
        if (this.suspended) {
            return;
        }
        this.conv.convert((char)c);
        this.conv.flushBuffer();
        ++this.charsWritten;
    }

    @Override
    public void write(char[] c) throws IOException {
        if (this.suspended) {
            return;
        }
        this.write(c, 0, c.length);
    }

    @Override
    public void write(char[] c, int off, int len) throws IOException {
        if (this.suspended) {
            return;
        }
        this.conv.convert(c, off, len);
        this.conv.flushBuffer();
        this.charsWritten += (long)len;
    }

    @Override
    public void write(String s, int off, int len) throws IOException {
        if (this.suspended) {
            return;
        }
        this.charsWritten += (long)len;
        if (s == null) {
            s = "null";
        }
        this.conv.convert(s, off, len);
        this.conv.flushBuffer();
    }

    @Override
    public void write(String s) throws IOException {
        if (this.suspended) {
            return;
        }
        if (s == null) {
            s = "null";
        }
        this.conv.convert(s);
        this.conv.flushBuffer();
    }

    public void setEncoding(String s) {
        this.enc = s;
    }

    public void checkConverter() throws IOException {
        if (!this.gotEnc) {
            this.setConverter();
        }
    }

    /*
     * Unable to fully structure code
     */
    protected void setConverter() throws IOException {
        if (this.coyoteResponse != null) {
            this.enc = this.coyoteResponse.getCharacterEncoding();
        }
        this.gotEnc = true;
        if (this.enc == null) {
            this.enc = "ISO-8859-1";
        }
        this.conv = this.encoders.get(this.enc);
        if (this.conv == null) {
            if (Globals.IS_SECURITY_ENABLED) {
                try {
                    this.conv = AccessController.doPrivileged(new PrivilegedExceptionAction<C2BConverter>(){

                        @Override
                        public C2BConverter run() throws IOException {
                            return new C2BConverter(OutputBuffer.this.bb, OutputBuffer.this.enc);
                        }
                    });
                }
                catch (PrivilegedActionException ex) {
                    e = ex.getException();
                    if (!(e instanceof IOException)) ** GOTO lbl17
                    throw (IOException)e;
                }
            } else {
                this.conv = new C2BConverter(this.bb, this.enc);
            }
lbl17:
            // 3 sources

            this.encoders.put(this.enc, this.conv);
        }
    }

    public void flushBytes() throws IOException {
        this.bb.flushBuffer();
    }

    public long getContentWritten() {
        return this.bytesWritten + this.charsWritten;
    }

    public boolean isNew() {
        return this.bytesWritten == 0L && this.charsWritten == 0L;
    }

    public void setBufferSize(int size) {
        if (size > this.bb.getLimit()) {
            this.bb.setLimit(size);
        }
    }

    public void reset() {
        this.bb.recycle();
        this.bytesWritten = 0L;
        this.charsWritten = 0L;
        this.gotEnc = false;
        this.enc = null;
        this.initial = true;
    }

    public int getBufferSize() {
        return this.bb.getLimit();
    }
}

