/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.startup;

import java.io.File;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.LinkedHashSet;
import java.util.Locale;
import org.apache.catalina.loader.StandardClassLoader;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;

public final class ClassLoaderFactory {
    private static final Log log = LogFactory.getLog(ClassLoaderFactory.class);
    protected static final Integer IS_DIR = 0;
    protected static final Integer IS_JAR = 1;
    protected static final Integer IS_GLOB = 2;
    protected static final Integer IS_URL = 3;

    public static ClassLoader createClassLoader(File[] unpacked, File[] packed, final ClassLoader parent) throws Exception {
        int i;
        if (log.isDebugEnabled()) {
            log.debug((Object)"Creating new class loader");
        }
        LinkedHashSet<URL> set = new LinkedHashSet<URL>();
        if (unpacked != null) {
            for (i = 0; i < unpacked.length; ++i) {
                File file = unpacked[i];
                if (!file.exists() || !file.canRead()) continue;
                file = new File(file.getCanonicalPath() + File.separator);
                URL url = file.toURI().toURL();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("  Including directory " + url));
                }
                set.add(url);
            }
        }
        if (packed != null) {
            for (i = 0; i < packed.length; ++i) {
                File directory = packed[i];
                if (!directory.isDirectory() || !directory.exists() || !directory.canRead()) continue;
                String[] filenames = directory.list();
                for (int j = 0; j < filenames.length; ++j) {
                    String filename = filenames[j].toLowerCase(Locale.ENGLISH);
                    if (!filename.endsWith(".jar")) continue;
                    File file = new File(directory, filenames[j]);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("  Including jar file " + file.getAbsolutePath()));
                    }
                    URL url = file.toURI().toURL();
                    set.add(url);
                }
            }
        }
        final URL[] array = set.toArray(new URL[set.size()]);
        return AccessController.doPrivileged(new PrivilegedAction<StandardClassLoader>(){

            @Override
            public StandardClassLoader run() {
                if (parent == null) {
                    return new StandardClassLoader(array);
                }
                return new StandardClassLoader(array, parent);
            }
        });
    }

    public static ClassLoader createClassLoader(String[] locations, Integer[] types, final ClassLoader parent) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Creating new class loader");
        }
        LinkedHashSet<URL> set = new LinkedHashSet<URL>();
        if (locations != null && types != null && locations.length == types.length) {
            for (int i = 0; i < locations.length; ++i) {
                URL url;
                File directory;
                String location = locations[i];
                if (types[i] == IS_URL) {
                    URL url2 = new URL(location);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("  Including URL " + url2));
                    }
                    set.add(url2);
                    continue;
                }
                if (types[i] == IS_DIR) {
                    directory = new File(location);
                    if (!(directory = new File(directory.getCanonicalPath())).exists() || !directory.isDirectory() || !directory.canRead()) continue;
                    url = directory.toURI().toURL();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("  Including directory " + url));
                    }
                    set.add(url);
                    continue;
                }
                if (types[i] == IS_JAR) {
                    File file = new File(location);
                    if (!(file = new File(file.getCanonicalPath())).exists() || !file.canRead()) continue;
                    url = file.toURI().toURL();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("  Including jar file " + url));
                    }
                    set.add(url);
                    continue;
                }
                if (types[i] != IS_GLOB || !(directory = new File(location)).exists() || !directory.isDirectory() || !directory.canRead()) continue;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("  Including directory glob " + directory.getAbsolutePath()));
                }
                String[] filenames = directory.list();
                for (int j = 0; j < filenames.length; ++j) {
                    String filename = filenames[j].toLowerCase(Locale.ENGLISH);
                    if (!filename.endsWith(".jar")) continue;
                    File file = new File(directory, filenames[j]);
                    if (!(file = new File(file.getCanonicalPath())).exists() || !file.canRead()) continue;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("    Including glob jar file " + file.getAbsolutePath()));
                    }
                    URL url3 = file.toURI().toURL();
                    set.add(url3);
                }
            }
        }
        final URL[] array = set.toArray(new URL[set.size()]);
        if (log.isDebugEnabled()) {
            for (int i = 0; i < array.length; ++i) {
                log.debug((Object)("  location " + i + " is " + array[i]));
            }
        }
        return AccessController.doPrivileged(new PrivilegedAction<StandardClassLoader>(){

            @Override
            public StandardClassLoader run() {
                if (parent == null) {
                    return new StandardClassLoader(array);
                }
                return new StandardClassLoader(array, parent);
            }
        });
    }
}

