/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.loader;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilePermission;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.jar.JarFile;
import javax.management.ObjectName;
import javax.servlet.ServletContext;
import org.apache.catalina.Context;
import org.apache.catalina.Globals;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleState;
import org.apache.catalina.Loader;
import org.apache.catalina.WebResource;
import org.apache.catalina.WebResourceRoot;
import org.apache.catalina.loader.WebappClassLoader;
import org.apache.catalina.util.LifecycleMBeanBase;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.ExceptionUtils;
import org.apache.tomcat.util.modeler.Registry;
import org.apache.tomcat.util.res.StringManager;

public class WebappLoader
extends LifecycleMBeanBase
implements Loader,
PropertyChangeListener {
    private WebappClassLoader classLoader = null;
    private Context context = null;
    private boolean delegate = false;
    private String loaderClass = "org.apache.catalina.loader.WebappClassLoader";
    private ClassLoader parentClassLoader = null;
    private boolean reloadable = false;
    protected static final StringManager sm = StringManager.getManager((String)"org.apache.catalina.loader");
    protected final PropertyChangeSupport support = new PropertyChangeSupport(this);
    private String classpath = null;
    private ArrayList<String> loaderRepositories = null;
    private static final Log log = LogFactory.getLog(WebappLoader.class);

    public WebappLoader() {
        this(null);
    }

    public WebappLoader(ClassLoader parent) {
        this.parentClassLoader = parent;
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    @Override
    public Context getContext() {
        return this.context;
    }

    @Override
    public void setContext(Context context) {
        if (this.context == context) {
            return;
        }
        if (this.getState().isAvailable()) {
            throw new IllegalStateException(sm.getString("webappLoader.setContext.ise"));
        }
        if (this.context != null) {
            this.context.removePropertyChangeListener(this);
        }
        Context oldContext = this.context;
        this.context = context;
        this.support.firePropertyChange("context", oldContext, this.context);
        if (this.context != null) {
            this.setReloadable(this.context.getReloadable());
            this.context.addPropertyChangeListener(this);
        }
    }

    @Override
    public boolean getDelegate() {
        return this.delegate;
    }

    @Override
    public void setDelegate(boolean delegate) {
        boolean oldDelegate = this.delegate;
        this.delegate = delegate;
        this.support.firePropertyChange("delegate", (Object)oldDelegate, (Object)this.delegate);
    }

    public String getLoaderClass() {
        return this.loaderClass;
    }

    public void setLoaderClass(String loaderClass) {
        this.loaderClass = loaderClass;
    }

    @Override
    public boolean getReloadable() {
        return this.reloadable;
    }

    @Override
    public void setReloadable(boolean reloadable) {
        boolean oldReloadable = this.reloadable;
        this.reloadable = reloadable;
        this.support.firePropertyChange("reloadable", (Object)oldReloadable, (Object)this.reloadable);
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.support.addPropertyChangeListener(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void backgroundProcess() {
        if (this.reloadable && this.modified()) {
            try {
                Thread.currentThread().setContextClassLoader(WebappLoader.class.getClassLoader());
                if (this.context == null) return;
                this.context.reload();
                return;
            }
            finally {
                if (this.context != null && this.context.getLoader() != null) {
                    Thread.currentThread().setContextClassLoader(this.context.getLoader().getClassLoader());
                }
            }
        } else {
            this.closeJARs(false);
        }
    }

    public String[] getLoaderRepositories() {
        if (this.loaderRepositories == null) {
            return null;
        }
        String[] res = new String[this.loaderRepositories.size()];
        this.loaderRepositories.toArray(res);
        return res;
    }

    public String getLoaderRepositoriesString() {
        String[] repositories = this.getLoaderRepositories();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < repositories.length; ++i) {
            sb.append(repositories[i]).append(":");
        }
        return sb.toString();
    }

    public String getClasspath() {
        return this.classpath;
    }

    @Override
    public boolean modified() {
        return this.classLoader != null ? this.classLoader.modified() : false;
    }

    public void closeJARs(boolean force) {
        if (this.classLoader != null) {
            this.classLoader.closeJARs(force);
        }
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.support.removePropertyChangeListener(listener);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("WebappLoader[");
        if (this.context != null) {
            sb.append(this.context.getName());
        }
        sb.append("]");
        return sb.toString();
    }

    @Override
    protected void startInternal() throws LifecycleException {
        if (log.isDebugEnabled()) {
            log.debug((Object)sm.getString("webappLoader.starting"));
        }
        if (this.context.getResources() == null) {
            log.info((Object)("No resources for " + this.context));
            this.setState(LifecycleState.STARTING);
            return;
        }
        try {
            this.classLoader = this.createClassLoader();
            this.classLoader.setResources(this.context.getResources());
            this.classLoader.setDelegate(this.delegate);
            this.setRepositories();
            this.setClassPath();
            this.setPermissions();
            this.classLoader.start();
            String contextName = this.context.getName();
            if (!contextName.startsWith("/")) {
                contextName = "/" + contextName;
            }
            ObjectName cloname = new ObjectName(this.context.getDomain() + ":type=WebappClassLoader,context=" + contextName + ",host=" + this.context.getParent().getName());
            Registry.getRegistry(null, null).registerComponent((Object)this.classLoader, cloname, null);
        }
        catch (Throwable t) {
            t = ExceptionUtils.unwrapInvocationTargetException((Throwable)t);
            ExceptionUtils.handleThrowable((Throwable)t);
            log.error((Object)"LifecycleException ", t);
            throw new LifecycleException("start: ", t);
        }
        this.setState(LifecycleState.STARTING);
    }

    @Override
    protected void stopInternal() throws LifecycleException {
        if (log.isDebugEnabled()) {
            log.debug((Object)sm.getString("webappLoader.stopping"));
        }
        this.setState(LifecycleState.STOPPING);
        ServletContext servletContext = this.context.getServletContext();
        servletContext.removeAttribute("org.apache.catalina.jsp_classpath");
        if (this.classLoader != null) {
            this.classLoader.stop();
        }
        try {
            String contextName = this.context.getName();
            if (!contextName.startsWith("/")) {
                contextName = "/" + contextName;
            }
            ObjectName cloname = new ObjectName(this.context.getDomain() + ":type=WebappClassLoader,context=" + contextName + ",host=" + this.context.getParent().getName());
            Registry.getRegistry(null, null).unregisterComponent(cloname);
        }
        catch (Exception e) {
            log.error((Object)"LifecycleException ", (Throwable)e);
        }
        this.classLoader = null;
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        if (!(event.getSource() instanceof Context)) {
            return;
        }
        if (event.getPropertyName().equals("reloadable")) {
            try {
                this.setReloadable((Boolean)event.getNewValue());
            }
            catch (NumberFormatException e) {
                log.error((Object)sm.getString("webappLoader.reloadable", new Object[]{event.getNewValue().toString()}));
            }
        }
    }

    private WebappClassLoader createClassLoader() throws Exception {
        Class<?> clazz = Class.forName(this.loaderClass);
        WebappClassLoader classLoader = null;
        if (this.parentClassLoader == null) {
            this.parentClassLoader = this.context.getParentClassLoader();
        }
        Class[] argTypes = new Class[]{ClassLoader.class};
        Object[] args = new Object[]{this.parentClassLoader};
        Constructor<?> constr = clazz.getConstructor(argTypes);
        classLoader = (WebappClassLoader)constr.newInstance(args);
        return classLoader;
    }

    private void setPermissions() {
        block20: {
            if (!Globals.IS_SECURITY_ENABLED) {
                return;
            }
            if (this.context == null) {
                return;
            }
            ServletContext servletContext = this.context.getServletContext();
            File workDir = (File)servletContext.getAttribute("javax.servlet.context.tempdir");
            if (workDir != null) {
                try {
                    String workDirPath = workDir.getCanonicalPath();
                    this.classLoader.addPermission(new FilePermission(workDirPath, "read,write"));
                    this.classLoader.addPermission(new FilePermission(workDirPath + File.separator + "-", "read,write,delete"));
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            try {
                String path;
                URL rootURL = servletContext.getResource("/");
                this.classLoader.addPermission(rootURL);
                String contextRoot = servletContext.getRealPath("/");
                if (contextRoot != null) {
                    try {
                        contextRoot = new File(contextRoot).getCanonicalPath();
                        this.classLoader.addPermission(contextRoot);
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                }
                URL classesURL = servletContext.getResource("/WEB-INF/classes/");
                this.classLoader.addPermission(classesURL);
                URL libURL = servletContext.getResource("/WEB-INF/lib/");
                this.classLoader.addPermission(libURL);
                if (contextRoot != null) {
                    if (libURL != null) {
                        File rootDir = new File(contextRoot);
                        File libDir = new File(rootDir, "WEB-INF/lib/");
                        try {
                            String path2 = libDir.getCanonicalPath();
                            this.classLoader.addPermission(path2);
                        }
                        catch (IOException e) {}
                    }
                    break block20;
                }
                if (workDir == null) break block20;
                if (libURL != null) {
                    File libDir = new File(workDir, "WEB-INF/lib/");
                    try {
                        path = libDir.getCanonicalPath();
                        this.classLoader.addPermission(path);
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                }
                if (classesURL != null) {
                    File classesDir = new File(workDir, "WEB-INF/classes/");
                    try {
                        path = classesDir.getCanonicalPath();
                        this.classLoader.addPermission(path);
                    }
                    catch (IOException e) {}
                }
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
    }

    private void setRepositories() throws IOException {
        if (this.context == null) {
            return;
        }
        ServletContext servletContext = this.context.getServletContext();
        if (servletContext == null) {
            return;
        }
        this.loaderRepositories = new ArrayList();
        File workDir = (File)servletContext.getAttribute("javax.servlet.context.tempdir");
        if (workDir == null) {
            log.info((Object)("No work dir for " + servletContext));
        }
        if (log.isDebugEnabled() && workDir != null) {
            log.debug((Object)sm.getString("webappLoader.deploy", new Object[]{workDir.getAbsolutePath()}));
        }
        this.classLoader.setWorkDir(workDir);
        WebResourceRoot resources = this.context.getResources();
        String classesPath = "/WEB-INF/classes";
        WebResource classes = resources.getResource(classesPath);
        if (classes.isDirectory()) {
            File classRepository = null;
            String absoluteClassesPath = classes.getCanonicalPath();
            if (absoluteClassesPath != null) {
                classRepository = new File(absoluteClassesPath);
            } else {
                classRepository = new File(workDir, classesPath);
                if (!classRepository.mkdirs() && !classRepository.isDirectory()) {
                    throw new IOException(sm.getString("webappLoader.mkdirFailure"));
                }
                if (!this.copyDir(classes, classRepository)) {
                    throw new IOException(sm.getString("webappLoader.copyFailure"));
                }
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)sm.getString("webappLoader.classDeploy", new Object[]{classesPath, classRepository.getAbsolutePath()}));
            }
            this.classLoader.setRepository(classesPath + "/", classRepository);
            this.loaderRepositories.add(classesPath + "/");
        }
        String libPath = "/WEB-INF/lib";
        this.classLoader.setJarPath(libPath);
        WebResource libDir = resources.getResource(libPath);
        if (libDir.isDirectory()) {
            WebResource[] jars;
            boolean copyJars = false;
            String absoluteLibPath = libDir.getCanonicalPath();
            File destDir = null;
            if (absoluteLibPath != null) {
                destDir = new File(absoluteLibPath);
            } else {
                copyJars = true;
                destDir = new File(workDir, libPath);
                if (!destDir.mkdirs() && !destDir.isDirectory()) {
                    throw new IOException(sm.getString("webappLoader.mkdirFailure"));
                }
            }
            for (WebResource jar : jars = resources.listResources(libPath)) {
                String jarName = jar.getName();
                if (!jarName.endsWith(".jar")) continue;
                String filename = libPath + "/" + jarName;
                File destFile = new File(destDir, jarName);
                if (log.isDebugEnabled()) {
                    log.debug((Object)sm.getString("webappLoader.jarDeploy", new Object[]{filename, destFile.getAbsolutePath()}));
                }
                if (!jar.canRead()) {
                    IOException ioe = new IOException(sm.getString("webappLoader.readFailure", new Object[]{filename}));
                    throw ioe;
                }
                if (copyJars && !this.copy(jar.getInputStream(), destFile)) {
                    throw new IOException(sm.getString("webappLoader.copyFailure"));
                }
                try {
                    JarFile jarFile = new JarFile(destFile);
                    this.classLoader.addJar(filename, jarFile, destFile);
                }
                catch (Exception ex) {
                    // empty catch block
                }
                this.loaderRepositories.add(filename);
            }
        }
    }

    private void setClassPath() {
        if (this.context == null) {
            return;
        }
        ServletContext servletContext = this.context.getServletContext();
        if (servletContext == null) {
            return;
        }
        StringBuilder classpath = new StringBuilder();
        ClassLoader loader = this.getClassLoader();
        if (this.delegate && loader != null) {
            loader = loader.getParent();
        }
        while (loader != null && this.buildClassPath(servletContext, classpath, loader)) {
            loader = loader.getParent();
        }
        if (this.delegate && (loader = this.getClassLoader()) != null) {
            this.buildClassPath(servletContext, classpath, loader);
        }
        this.classpath = classpath.toString();
        servletContext.setAttribute("org.apache.catalina.jsp_classpath", (Object)classpath.toString());
    }

    private boolean buildClassPath(ServletContext servletContext, StringBuilder classpath, ClassLoader loader) {
        if (loader instanceof URLClassLoader) {
            URL[] repositories = ((URLClassLoader)loader).getURLs();
            for (int i = 0; i < repositories.length; ++i) {
                String repository = repositories[i].toString();
                if (repository.startsWith("file://")) {
                    repository = this.utf8Decode(repository.substring(7));
                } else if (repository.startsWith("file:")) {
                    repository = this.utf8Decode(repository.substring(5));
                } else {
                    if (!repository.startsWith("jndi:")) continue;
                    repository = servletContext.getRealPath(repository.substring(5));
                }
                if (repository == null) continue;
                if (classpath.length() > 0) {
                    classpath.append(File.pathSeparator);
                }
                classpath.append(repository);
            }
        } else {
            String cp = this.getClasspath(loader);
            if (cp == null) {
                log.info((Object)("Unknown loader " + loader + " " + loader.getClass()));
            } else {
                if (classpath.length() > 0) {
                    classpath.append(File.pathSeparator);
                }
                classpath.append(cp);
            }
            return false;
        }
        return true;
    }

    private String utf8Decode(String input) {
        String result = null;
        try {
            result = URLDecoder.decode(input, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return result;
    }

    private String getClasspath(ClassLoader loader) {
        try {
            Method m = loader.getClass().getMethod("getClasspath", new Class[0]);
            if (log.isTraceEnabled()) {
                log.trace((Object)("getClasspath " + m));
            }
            if (m == null) {
                return null;
            }
            Object o = m.invoke((Object)loader, new Object[0]);
            if (log.isDebugEnabled()) {
                log.debug((Object)("gotClasspath " + o));
            }
            if (o instanceof String) {
                return (String)o;
            }
            return null;
        }
        catch (Exception ex) {
            Throwable t = ExceptionUtils.unwrapInvocationTargetException((Throwable)ex);
            ExceptionUtils.handleThrowable((Throwable)t);
            if (log.isDebugEnabled()) {
                log.debug((Object)"getClasspath ", (Throwable)ex);
            }
            return null;
        }
    }

    private boolean copyDir(WebResource src, File destDir) {
        WebResource[] resources;
        for (WebResource resource : resources = src.getWebResourceRoot().listResources(src.getWebappPath())) {
            File currentFile = new File(destDir, resource.getName());
            if (resource.isFile()) {
                InputStream is = resource.getInputStream();
                if (this.copy(is, currentFile)) continue;
                return false;
            }
            if (!resource.isDirectory()) continue;
            if (!currentFile.isDirectory() && !currentFile.mkdir()) {
                return false;
            }
            if (this.copyDir(resource, currentFile)) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean copy(InputStream is, File file) {
        try (FileOutputStream os = new FileOutputStream(file);){
            int len;
            byte[] buf = new byte[4096];
            while ((len = is.read(buf)) >= 0) {
                os.write(buf, 0, len);
            }
        }
        catch (IOException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e) {}
        }
        return true;
    }

    @Override
    protected String getDomainInternal() {
        return this.context.getDomain();
    }

    @Override
    protected String getObjectNameKeyProperties() {
        StringBuilder name = new StringBuilder("type=Loader");
        name.append(",context=");
        String contextName = this.context.getName();
        if (!contextName.startsWith("/")) {
            name.append("/");
        }
        name.append(contextName);
        name.append(",host=");
        name.append(this.context.getParent().getName());
        return name.toString();
    }
}

