/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.startup;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.servlet.ServletContext;

public class WebappServiceLoader<T> {
    private static final String LIB = "/WEB-INF/lib/";
    private static final String SERVICES = "META-INF/services/";
    private final ServletContext context;

    public WebappServiceLoader(ServletContext context) {
        this.context = context;
    }

    public Collection<T> load(Class<T> serviceType) throws IOException {
        String configFile = SERVICES + serviceType.getName();
        HashSet<String> servicesFound = new HashSet<String>();
        ClassLoader loader = this.context.getClassLoader();
        List orderedLibs = (List)this.context.getAttribute("javax.servlet.context.orderedLibs");
        if (orderedLibs != null) {
            for (String lib : orderedLibs) {
                URL jarUrl = this.context.getResource(LIB + lib);
                if (jarUrl == null) continue;
                String base = jarUrl.toExternalForm();
                URL url = base.endsWith("/") ? new URL(base + configFile) : new URL("jar:" + base + "!/" + configFile);
                try {
                    this.parseConfigFile(servicesFound, url);
                }
                catch (FileNotFoundException e) {}
            }
            loader = loader.getParent();
        }
        Enumeration<URL> resources = loader == null ? ClassLoader.getSystemResources(configFile) : loader.getResources(configFile);
        while (resources.hasMoreElements()) {
            this.parseConfigFile(servicesFound, resources.nextElement());
        }
        if (servicesFound.isEmpty()) {
            return Collections.emptyList();
        }
        return this.loadServices(serviceType, servicesFound);
    }

    private void parseConfigFile(Set<String> servicesFound, URL url) throws IOException {
        try (InputStream is = url.openStream();){
            String line;
            InputStreamReader in = new InputStreamReader(is, StandardCharsets.UTF_8);
            BufferedReader reader = new BufferedReader(in);
            while ((line = reader.readLine()) != null) {
                int i = line.indexOf(35);
                if (i >= 0) {
                    line = line.substring(0, i);
                }
                if ((line = line.trim()).length() == 0 || servicesFound.contains(line)) continue;
                servicesFound.add(line);
            }
        }
    }

    private Collection<T> loadServices(Class<T> serviceType, Set<String> servicesFound) throws IOException {
        ClassLoader loader = this.context.getClassLoader();
        ArrayList<T> services = new ArrayList<T>(servicesFound.size());
        for (String serviceClass : servicesFound) {
            try {
                Class<?> clazz = Class.forName(serviceClass, true, loader);
                services.add(serviceType.cast(clazz.newInstance()));
            }
            catch (ClassCastException | ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                throw new IOException(e);
            }
        }
        return Collections.unmodifiableCollection(services);
    }
}

