/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.webresources;

import java.io.File;
import java.io.IOException;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.webresources.AbstractResourceSet;
import org.apache.tomcat.util.http.RequestUtil;

public abstract class AbstractFileResourceSet
extends AbstractResourceSet {
    protected static final String[] EMPTY_STRING_ARRAY = new String[0];
    protected final String internalPath;
    protected File fileBase;
    protected String absoluteBase;
    protected String canonicalBase;

    protected AbstractFileResourceSet(String internalPath) {
        this.internalPath = this.checkInternalPath(internalPath);
    }

    protected File file(String name, boolean mustExist) {
        File file;
        if (name.equals("/")) {
            name = "";
        }
        if ((file = new File(this.fileBase, name)).exists() && file.canRead() || !mustExist) {
            if (this.getRoot().getAllowLinking()) {
                return file;
            }
            String canPath = null;
            try {
                canPath = file.getCanonicalPath();
            }
            catch (IOException e) {
                // empty catch block
            }
            if (canPath == null) {
                return null;
            }
            if (!canPath.startsWith(this.canonicalBase)) {
                return null;
            }
            String fileAbsPath = file.getAbsolutePath();
            if (fileAbsPath.endsWith(".")) {
                fileAbsPath = fileAbsPath + '/';
            }
            String absPath = this.normalize(fileAbsPath);
            if (this.absoluteBase.length() < absPath.length() && this.canonicalBase.length() < canPath.length()) {
                if ((absPath = absPath.substring(this.absoluteBase.length() + 1)).equals("")) {
                    absPath = "/";
                }
                if ((canPath = canPath.substring(this.canonicalBase.length() + 1)).equals("")) {
                    canPath = "/";
                }
                if (!canPath.equals(absPath)) {
                    return null;
                }
            }
        } else {
            return null;
        }
        return file;
    }

    protected String normalize(String path) {
        return RequestUtil.normalize((String)path, (File.separatorChar == '/' ? 1 : 0) != 0);
    }

    @Override
    protected void initInternal() throws LifecycleException {
        this.fileBase = new File(this.getBase(), this.internalPath);
        this.checkType(this.fileBase);
        String absolutePath = this.fileBase.getAbsolutePath();
        if (absolutePath.endsWith(".")) {
            absolutePath = absolutePath + '/';
        }
        this.absoluteBase = this.normalize(absolutePath);
        try {
            this.canonicalBase = this.fileBase.getCanonicalPath();
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    protected abstract void checkType(File var1);
}

