/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.webresources;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.WebResource;
import org.apache.catalina.WebResourceRoot;
import org.apache.catalina.util.ResourceSet;
import org.apache.catalina.webresources.AbstractResourceSet;
import org.apache.catalina.webresources.EmptyResource;
import org.apache.catalina.webresources.JarResource;
import org.apache.catalina.webresources.JarResourceRoot;

public class JarResourceSet
extends AbstractResourceSet {
    private HashMap<String, JarEntry> jarFileEntries = new HashMap();
    private String baseUrl;
    private final String internalPath;

    public JarResourceSet(WebResourceRoot root, String base, String webAppMount, String internalPath) throws IllegalArgumentException {
        this.setRoot(root);
        this.setBase(base);
        this.setWebAppMount(webAppMount);
        this.internalPath = this.checkInternalPath(internalPath);
        if (this.getRoot().getState().isAvailable()) {
            try {
                this.start();
            }
            catch (LifecycleException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    @Override
    public WebResource getResource(String path) {
        this.checkPath(path);
        String webAppMount = this.getWebAppMount();
        WebResourceRoot root = this.getRoot();
        if (path.startsWith(webAppMount)) {
            String pathInJar = this.internalPath + path.substring(webAppMount.length(), path.length());
            if (pathInJar.charAt(0) == '/') {
                pathInJar = pathInJar.substring(1);
            }
            if (pathInJar.equals("")) {
                return new JarResourceRoot(root, new File(this.getBase()), pathInJar, path);
            }
            JarEntry jarEntry = null;
            if (pathInJar.charAt(pathInJar.length() - 1) != '/' && (jarEntry = this.jarFileEntries.get(pathInJar + '/')) != null) {
                path = path + '/';
            }
            if (jarEntry == null) {
                jarEntry = this.jarFileEntries.get(pathInJar);
            }
            if (jarEntry == null) {
                return new EmptyResource(root, path);
            }
            return new JarResource(root, this.getBase(), this.baseUrl, jarEntry, this.internalPath, path);
        }
        return new EmptyResource(root, path);
    }

    @Override
    public String[] list(String path) {
        this.checkPath(path);
        String webAppMount = this.getWebAppMount();
        ArrayList<String> result = new ArrayList<String>();
        if (path.startsWith(webAppMount)) {
            String pathInJar = this.internalPath + path.substring(webAppMount.length());
            if (pathInJar.charAt(0) == '/') {
                pathInJar = pathInJar.substring(1);
            }
            for (String name : this.jarFileEntries.keySet()) {
                if (name.length() <= pathInJar.length() || !name.startsWith(pathInJar) || (name = name.charAt(name.length() - 1) == '/' ? name.substring(pathInJar.length(), name.length() - 1) : name.substring(pathInJar.length())).length() == 0) continue;
                if (name.charAt(0) == '/') {
                    name = name.substring(1);
                }
                if (name.length() <= 0 || name.lastIndexOf(47) != -1) continue;
                result.add(name);
            }
        } else {
            if (!path.endsWith("/")) {
                path = path + "/";
            }
            if (webAppMount.startsWith(path)) {
                int i = webAppMount.indexOf(47, path.length());
                if (i == -1) {
                    return new String[]{webAppMount.substring(path.length())};
                }
                return new String[]{webAppMount.substring(path.length(), i)};
            }
        }
        return result.toArray(new String[result.size()]);
    }

    @Override
    public Set<String> listWebAppPaths(String path) {
        this.checkPath(path);
        String webAppMount = this.getWebAppMount();
        ResourceSet<String> result = new ResourceSet<String>();
        if (path.startsWith(webAppMount)) {
            String pathInJar = this.internalPath + path.substring(webAppMount.length());
            if (pathInJar.charAt(pathInJar.length() - 1) != '/') {
                pathInJar = pathInJar.substring(1) + '/';
            }
            if (pathInJar.charAt(0) == '/') {
                pathInJar = pathInJar.substring(1);
            }
            for (String name : this.jarFileEntries.keySet()) {
                int nextSlash;
                if (name.length() <= pathInJar.length() || !name.startsWith(pathInJar) || (nextSlash = name.indexOf(47, pathInJar.length())) != -1 && nextSlash != name.length() - 1 || !name.startsWith(pathInJar)) continue;
                result.add(webAppMount + '/' + name.substring(this.internalPath.length()));
            }
        } else {
            if (!path.endsWith("/")) {
                path = path + "/";
            }
            if (webAppMount.startsWith(path)) {
                int i = webAppMount.indexOf(47, path.length());
                if (i == -1) {
                    result.add(webAppMount + "/");
                } else {
                    result.add(webAppMount.substring(0, i + 1));
                }
            }
        }
        result.setLocked(true);
        return result;
    }

    @Override
    public boolean mkdir(String path) {
        this.checkPath(path);
        return false;
    }

    @Override
    public boolean write(String path, InputStream is, boolean overwrite) {
        this.checkPath(path);
        if (is == null) {
            throw new NullPointerException(sm.getString("dirResourceSet.writeNpe"));
        }
        return false;
    }

    @Override
    protected void initInternal() throws LifecycleException {
        try (JarFile jarFile = new JarFile(this.getBase());){
            Enumeration<JarEntry> entries = jarFile.entries();
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                this.jarFileEntries.put(entry.getName(), entry);
            }
        }
        catch (IOException ioe) {
            throw new IllegalArgumentException(ioe);
        }
        try {
            this.baseUrl = new File(this.getBase()).toURI().toURL().toString();
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

