/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.webresources;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.webresources.AbstractResourceSet;
import org.apache.tomcat.util.http.RequestUtil;

public abstract class AbstractFileResourceSet
extends AbstractResourceSet {
    protected static final String[] EMPTY_STRING_ARRAY = new String[0];
    private File fileBase;
    private String absoluteBase;
    private String canonicalBase;

    protected AbstractFileResourceSet(String internalPath) {
        this.setInternalPath(internalPath);
    }

    protected final File getFileBase() {
        return this.fileBase;
    }

    protected final File file(String name, boolean mustExist) {
        if (name.equals("/")) {
            name = "";
        }
        File file = new File(this.fileBase, name);
        if (!mustExist || file.canRead()) {
            if (this.getRoot().getAllowLinking()) {
                return file;
            }
            String canPath = null;
            try {
                canPath = file.getCanonicalPath();
            }
            catch (IOException e) {
                // empty catch block
            }
            if (canPath == null) {
                return null;
            }
            if (!canPath.startsWith(this.canonicalBase)) {
                return null;
            }
            String fileAbsPath = file.getAbsolutePath();
            if (fileAbsPath.endsWith(".")) {
                fileAbsPath = fileAbsPath + '/';
            }
            String absPath = this.normalize(fileAbsPath);
            if (this.absoluteBase.length() < absPath.length() && this.canonicalBase.length() < canPath.length()) {
                if ((absPath = absPath.substring(this.absoluteBase.length() + 1)).equals("")) {
                    absPath = "/";
                }
                if ((canPath = canPath.substring(this.canonicalBase.length() + 1)).equals("")) {
                    canPath = "/";
                }
                if (!canPath.equals(absPath)) {
                    return null;
                }
            }
        } else {
            return null;
        }
        return file;
    }

    private String normalize(String path) {
        return RequestUtil.normalize((String)path, (File.separatorChar == '/' ? 1 : 0) != 0);
    }

    @Override
    public URL getBaseUrl() {
        try {
            return this.getFileBase().toURI().toURL();
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    @Override
    protected void initInternal() throws LifecycleException {
        this.fileBase = new File(this.getBase(), this.getInternalPath());
        this.checkType(this.fileBase);
        String absolutePath = this.fileBase.getAbsolutePath();
        if (absolutePath.endsWith(".")) {
            absolutePath = absolutePath + '/';
        }
        this.absoluteBase = this.normalize(absolutePath);
        try {
            this.canonicalBase = this.fileBase.getCanonicalPath();
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    protected abstract void checkType(File var1);
}

