/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.webresources;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.WebResource;
import org.apache.catalina.WebResourceRoot;
import org.apache.catalina.webresources.AbstractArchiveResourceSet;
import org.apache.catalina.webresources.JarWarResource;

public class JarWarResourceSet
extends AbstractArchiveResourceSet {
    private final String archivePath;

    public JarWarResourceSet(WebResourceRoot root, String webAppMount, String base, String archivePath, String internalPath) throws IllegalArgumentException {
        this.setRoot(root);
        this.setWebAppMount(webAppMount);
        this.setBase(base);
        this.archivePath = archivePath;
        this.setInternalPath(internalPath);
        if (this.getRoot().getState().isAvailable()) {
            try {
                this.start();
            }
            catch (LifecycleException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    @Override
    protected WebResource createArchiveResource(JarEntry jarEntry, String webAppPath) {
        return new JarWarResource(this.getRoot(), webAppPath, this.getBase(), this.getBaseUrl(), jarEntry, this.archivePath, this.getInternalPath());
    }

    @Override
    protected void initInternal() throws LifecycleException {
        try (JarFile warFile = new JarFile(this.getBase());){
            JarEntry jarFileInWar = warFile.getJarEntry(this.archivePath);
            InputStream jarFileIs = warFile.getInputStream(jarFileInWar);
            try (JarInputStream jarIs = new JarInputStream(jarFileIs);){
                JarEntry entry = jarIs.getNextJarEntry();
                while (entry != null) {
                    this.getJarFileEntries().put(entry.getName(), entry);
                    entry = jarIs.getNextJarEntry();
                }
            }
        }
        catch (IOException ioe) {
            throw new IllegalArgumentException(ioe);
        }
        try {
            this.setBaseUrl(new File(this.getBase()).toURI().toURL().toString());
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

