/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.webresources;

import java.net.URL;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.catalina.webresources.WarURLStreamHandler;

public class TomcatURLStreamHandlerFactory
implements URLStreamHandlerFactory {
    private static final String WAR_PROTOCOL = "war";
    private static TomcatURLStreamHandlerFactory instance = new TomcatURLStreamHandlerFactory();
    private List<URLStreamHandlerFactory> userFactories = new CopyOnWriteArrayList<URLStreamHandlerFactory>();

    public static TomcatURLStreamHandlerFactory getInstance() {
        return instance;
    }

    public static void register() {
    }

    public static void addUserFactory(URLStreamHandlerFactory factory) {
        TomcatURLStreamHandlerFactory.instance.userFactories.add(factory);
    }

    public static void release(ClassLoader classLoader) {
        Iterator<URLStreamHandlerFactory> iter = TomcatURLStreamHandlerFactory.instance.userFactories.iterator();
        block0: while (iter.hasNext()) {
            for (ClassLoader factoryLoader = iter.next().getClass().getClassLoader(); factoryLoader != null; factoryLoader = factoryLoader.getParent()) {
                if (!classLoader.equals(factoryLoader)) continue;
                iter.remove();
                continue block0;
            }
        }
    }

    private TomcatURLStreamHandlerFactory() {
        URL.setURLStreamHandlerFactory(this);
    }

    @Override
    public URLStreamHandler createURLStreamHandler(String protocol) {
        if (WAR_PROTOCOL.equals(protocol)) {
            return new WarURLStreamHandler();
        }
        for (URLStreamHandlerFactory factory : this.userFactories) {
            URLStreamHandler handler = factory.createURLStreamHandler(protocol);
            if (handler == null) continue;
            return handler;
        }
        return null;
    }
}

