/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.webresources;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.catalina.WebResourceRoot;
import org.apache.catalina.webresources.AbstractResource;

public abstract class AbstractArchiveResource
extends AbstractResource {
    private final String base;
    private final String baseUrl;
    private final JarEntry resource;
    private final String name;

    protected AbstractArchiveResource(WebResourceRoot root, String webAppPath, String base, String baseUrl, JarEntry jarEntry, String internalPath) {
        super(root, webAppPath);
        int index;
        this.base = base;
        this.baseUrl = baseUrl;
        this.resource = jarEntry;
        String resourceName = this.resource.getName();
        if (resourceName.charAt(resourceName.length() - 1) == '/') {
            resourceName = resourceName.substring(0, resourceName.length() - 1);
        }
        this.name = internalPath.length() > 0 && resourceName.equals(internalPath.subSequence(1, internalPath.length())) ? "" : ((index = resourceName.lastIndexOf(47)) == -1 ? resourceName : resourceName.substring(index + 1));
    }

    public String getBase() {
        return this.base;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public JarEntry getResource() {
        return this.resource;
    }

    @Override
    public long getLastModified() {
        return this.resource.getTime();
    }

    @Override
    public boolean exists() {
        return true;
    }

    @Override
    public boolean isVirtual() {
        return false;
    }

    @Override
    public boolean isDirectory() {
        return this.resource.isDirectory();
    }

    @Override
    public boolean isFile() {
        return !this.resource.isDirectory();
    }

    @Override
    public boolean delete() {
        return false;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public long getContentLength() {
        return this.resource.getSize();
    }

    @Override
    public String getCanonicalPath() {
        return null;
    }

    @Override
    public boolean canRead() {
        return true;
    }

    @Override
    public long getCreation() {
        return this.resource.getTime();
    }

    @Override
    public URL getURL() {
        try {
            return new URL(this.baseUrl + "!/" + this.resource.getName());
        }
        catch (MalformedURLException e) {
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((Object)sm.getString("fileResource.getUrlFail", new Object[]{this.resource.getName(), this.baseUrl}), (Throwable)e);
            }
            return null;
        }
    }

    protected static class JarInputStreamWrapper
    extends InputStream {
        private final JarFile jarFile;
        private final InputStream is;

        public JarInputStreamWrapper(JarFile jarFile, InputStream is) {
            this.jarFile = jarFile;
            this.is = is;
        }

        @Override
        public int read() throws IOException {
            return this.is.read();
        }

        @Override
        public int read(byte[] b) throws IOException {
            return this.is.read(b);
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            return this.is.read(b, off, len);
        }

        @Override
        public long skip(long n) throws IOException {
            return this.is.skip(n);
        }

        @Override
        public int available() throws IOException {
            return this.is.available();
        }

        @Override
        public void close() throws IOException {
            this.jarFile.close();
        }

        @Override
        public synchronized void mark(int readlimit) {
            this.is.mark(readlimit);
        }

        @Override
        public synchronized void reset() throws IOException {
            this.is.reset();
        }

        @Override
        public boolean markSupported() {
            return this.is.markSupported();
        }
    }
}

