/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.webresources;

import java.io.File;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.catalina.WebResourceRoot;
import org.apache.catalina.webresources.AbstractResource;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;

public class JarResourceRoot
extends AbstractResource {
    private static final Log log = LogFactory.getLog(JarResourceRoot.class);
    private final File base;
    private final String baseUrl;
    private final String name;

    public JarResourceRoot(WebResourceRoot root, File base, String baseUrl, String webAppPath) {
        super(root, webAppPath);
        this.base = base;
        this.baseUrl = "jar:" + baseUrl;
        String resourceName = webAppPath.endsWith("/") ? webAppPath.substring(0, webAppPath.length() - 1) : webAppPath;
        int i = resourceName.lastIndexOf(47);
        if (i > -1) {
            resourceName = resourceName.substring(i + 1);
        }
        this.name = resourceName;
    }

    @Override
    public long getLastModified() {
        return this.base.lastModified();
    }

    @Override
    public boolean exists() {
        return true;
    }

    @Override
    public boolean isVirtual() {
        return false;
    }

    @Override
    public boolean isDirectory() {
        return true;
    }

    @Override
    public boolean isFile() {
        return false;
    }

    @Override
    public boolean delete() {
        return false;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public long getContentLength() {
        return -1L;
    }

    @Override
    public String getCanonicalPath() {
        return null;
    }

    @Override
    public boolean canRead() {
        return true;
    }

    @Override
    public InputStream getInputStream() {
        return null;
    }

    @Override
    public long getCreation() {
        return this.base.lastModified();
    }

    @Override
    public URL getURL() {
        try {
            return new URL(this.baseUrl + "!/");
        }
        catch (MalformedURLException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)sm.getString("fileResource.getUrlFail", new Object[]{"", this.baseUrl}), (Throwable)e);
            }
            return null;
        }
    }

    @Override
    protected Log getLog() {
        return log;
    }
}

