/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.webresources;

import java.io.File;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.apache.catalina.Context;
import org.apache.catalina.Host;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleState;
import org.apache.catalina.WebResource;
import org.apache.catalina.WebResourceRoot;
import org.apache.catalina.WebResourceSet;
import org.apache.catalina.util.LifecycleMBeanBase;
import org.apache.catalina.webresources.AbstractResourceSet;
import org.apache.catalina.webresources.Cache;
import org.apache.catalina.webresources.DirResourceSet;
import org.apache.catalina.webresources.EmptyResource;
import org.apache.catalina.webresources.FileResourceSet;
import org.apache.catalina.webresources.JarResourceSet;
import org.apache.catalina.webresources.JarWarResourceSet;
import org.apache.catalina.webresources.TomcatURLStreamHandlerFactory;
import org.apache.tomcat.util.res.StringManager;

public class StandardRoot
extends LifecycleMBeanBase
implements WebResourceRoot {
    protected static final StringManager sm = StringManager.getManager((String)"org.apache.catalina.webresources");
    private Context context;
    private boolean allowLinking = false;
    private ArrayList<WebResourceSet> preResources = new ArrayList();
    private WebResourceSet main;
    private ArrayList<WebResourceSet> jarResources = new ArrayList();
    private ArrayList<WebResourceSet> postResources = new ArrayList();
    private Cache cache = new Cache(this);
    private boolean cachingAllowed = true;
    private ArrayList<WebResourceSet> mainResources = new ArrayList();
    private ArrayList<ArrayList<WebResourceSet>> allResources = new ArrayList();

    public StandardRoot() {
        this.allResources.add(this.preResources);
        this.allResources.add(this.mainResources);
        this.allResources.add(this.jarResources);
        this.allResources.add(this.postResources);
    }

    public StandardRoot(Context context) {
        this.allResources.add(this.preResources);
        this.allResources.add(this.mainResources);
        this.allResources.add(this.jarResources);
        this.allResources.add(this.postResources);
        this.context = context;
    }

    @Override
    public String[] list(String path) {
        this.checkState();
        HashSet<String> result = new HashSet<String>();
        for (ArrayList<WebResourceSet> list : this.allResources) {
            for (WebResourceSet webResourceSet : list) {
                String[] entries;
                for (String entry : entries = webResourceSet.list(path)) {
                    result.add(entry);
                }
            }
        }
        return result.toArray(new String[result.size()]);
    }

    @Override
    public Set<String> listWebAppPaths(String path) {
        this.checkState();
        HashSet<String> result = new HashSet<String>();
        for (ArrayList<WebResourceSet> list : this.allResources) {
            for (WebResourceSet webResourceSet : list) {
                result.addAll(webResourceSet.listWebAppPaths(path));
            }
        }
        if (result.size() == 0) {
            return null;
        }
        return result;
    }

    @Override
    public boolean mkdir(String path) {
        this.checkState();
        if (this.preResourceExists(path)) {
            return false;
        }
        return this.main.mkdir(path);
    }

    @Override
    public boolean write(String path, InputStream is, boolean overwrite) {
        this.checkState();
        if (!overwrite && this.preResourceExists(path)) {
            return false;
        }
        return this.main.write(path, is, overwrite);
    }

    private boolean preResourceExists(String path) {
        for (WebResourceSet webResourceSet : this.preResources) {
            WebResource webResource = webResourceSet.getResource(path);
            if (!webResource.exists()) continue;
            return true;
        }
        return false;
    }

    @Override
    public WebResource getResource(String path) {
        if (this.isCachingAllowed()) {
            return this.cache.getResource(path);
        }
        return this.getResourceInternal(path);
    }

    protected WebResource getResourceInternal(String path) {
        this.checkState();
        WebResource result = null;
        WebResource virtual = null;
        for (ArrayList<WebResourceSet> list : this.allResources) {
            for (WebResourceSet webResourceSet : list) {
                result = webResourceSet.getResource(path);
                if (result.exists()) {
                    return result;
                }
                if (virtual != null || !result.isVirtual()) continue;
                virtual = result;
            }
        }
        if (virtual != null) {
            return virtual;
        }
        return new EmptyResource(this, path);
    }

    @Override
    public WebResource[] getResources(String path) {
        this.checkState();
        ArrayList<WebResource> result = new ArrayList<WebResource>();
        for (ArrayList<WebResourceSet> list : this.allResources) {
            for (WebResourceSet webResourceSet : list) {
                WebResource webResource = webResourceSet.getResource(path);
                if (!webResource.exists()) continue;
                result.add(webResource);
            }
        }
        if (result.size() == 0) {
            result.add(this.main.getResource(path));
        }
        return result.toArray(new WebResource[result.size()]);
    }

    @Override
    public WebResource[] listResources(String path) {
        this.checkState();
        String[] resources = this.list(path);
        WebResource[] result = new WebResource[resources.length];
        for (int i = 0; i < resources.length; ++i) {
            result[i] = path.charAt(path.length() - 1) == '/' ? this.getResource(path + resources[i]) : this.getResource(path + '/' + resources[i]);
        }
        return result;
    }

    @Override
    public void createWebResourceSet(WebResourceRoot.ResourceSetType type, String webAppMount, URL url, String internalPath) {
        BaseLocation baseLocation = new BaseLocation(url);
        this.createWebResourceSet(type, webAppMount, baseLocation.getBasePath(), baseLocation.getArchivePath(), internalPath);
    }

    @Override
    public void createWebResourceSet(WebResourceRoot.ResourceSetType type, String webAppMount, String base, String archivePath, String internalPath) {
        AbstractResourceSet resourceSet;
        ArrayList<WebResourceSet> resourceList;
        switch (type) {
            case PRE: {
                resourceList = this.preResources;
                break;
            }
            case RESOURCE_JAR: {
                resourceList = this.jarResources;
                break;
            }
            case POST: {
                resourceList = this.postResources;
                break;
            }
            default: {
                throw new IllegalArgumentException(sm.getString("standardRoot.createUnknownType", new Object[]{type}));
            }
        }
        File file = new File(base);
        if (file.isFile()) {
            resourceSet = archivePath != null ? new JarWarResourceSet(this, webAppMount, base, archivePath, internalPath) : (file.getName().toLowerCase(Locale.ENGLISH).endsWith(".jar") ? new JarResourceSet(this, webAppMount, base, internalPath) : new FileResourceSet(this, webAppMount, base, internalPath));
        } else if (file.isDirectory()) {
            resourceSet = new DirResourceSet(this, webAppMount, base, internalPath);
        } else {
            throw new IllegalArgumentException(sm.getString("standardRoot.createInvalidFile", new Object[]{file}));
        }
        resourceList.add(resourceSet);
    }

    @Override
    public void addPreResources(WebResourceSet webResourceSet) {
        webResourceSet.setRoot(this);
        this.preResources.add(webResourceSet);
    }

    @Override
    public WebResourceSet[] getPreResources() {
        return this.preResources.toArray(new WebResourceSet[0]);
    }

    @Override
    public void addJarResources(WebResourceSet webResourceSet) {
        webResourceSet.setRoot(this);
        this.jarResources.add(webResourceSet);
    }

    @Override
    public WebResourceSet[] getJarResources() {
        return this.jarResources.toArray(new WebResourceSet[0]);
    }

    @Override
    public void addPostResources(WebResourceSet webResourceSet) {
        webResourceSet.setRoot(this);
        this.postResources.add(webResourceSet);
    }

    @Override
    public WebResourceSet[] getPostResources() {
        return this.postResources.toArray(new WebResourceSet[0]);
    }

    @Override
    public void setAllowLinking(boolean allowLinking) {
        this.allowLinking = allowLinking;
    }

    @Override
    public boolean getAllowLinking() {
        return this.allowLinking;
    }

    @Override
    public void setCachingAllowed(boolean cachingAllowed) {
        this.cachingAllowed = cachingAllowed;
    }

    @Override
    public boolean isCachingAllowed() {
        return this.cachingAllowed;
    }

    @Override
    public long getCacheTtl() {
        return this.cache.getTtl();
    }

    @Override
    public void setCacheTtl(long cacheTtl) {
        this.cache.setTtl(cacheTtl);
    }

    @Override
    public long getCacheMaxSize() {
        return this.cache.getMaxSize();
    }

    @Override
    public void setCacheMaxSize(long cacheMaxSize) {
        this.cache.setMaxSize(cacheMaxSize);
    }

    @Override
    public void setCacheMaxObjectSize(long cacheMaxObjectSize) {
        this.cache.setMaxObjectSize(cacheMaxObjectSize);
    }

    @Override
    public long getCacheMaxObjectSize() {
        return this.cache.getMaxObjectSize();
    }

    @Override
    public Context getContext() {
        return this.context;
    }

    @Override
    public void setContext(Context context) {
        this.context = context;
    }

    private void checkState() {
        if (!this.getState().isAvailable()) {
            throw new IllegalStateException(sm.getString("standardRoot.checkStateNotStarted"));
        }
    }

    protected void setMainResources(WebResourceSet main) {
        this.main = main;
        this.mainResources.clear();
        this.mainResources.add(main);
    }

    @Override
    public void backgroundProcess() {
        this.cache.backgroundProcess();
    }

    @Override
    protected String getDomainInternal() {
        return this.context.getDomain();
    }

    @Override
    protected String getObjectNameKeyProperties() {
        StringBuilder keyProperties = new StringBuilder("type=WebResourceRoot");
        keyProperties.append(this.context.getMBeanKeyProperties());
        return keyProperties.toString();
    }

    @Override
    protected void initInternal() throws LifecycleException {
        super.initInternal();
        TomcatURLStreamHandlerFactory.register();
        if (this.context == null) {
            throw new IllegalStateException(sm.getString("standardRoot.noContext"));
        }
        for (ArrayList<WebResourceSet> list : this.allResources) {
            for (WebResourceSet webResourceSet : list) {
                webResourceSet.init();
            }
        }
    }

    @Override
    protected void startInternal() throws LifecycleException {
        String docBase = this.context.getDocBase();
        File f = new File(docBase);
        if (!f.isAbsolute()) {
            f = new File(((Host)this.context.getParent()).getAppBaseFile(), f.getName());
        }
        if (f.isDirectory()) {
            this.main = new DirResourceSet(this, "/", f.getAbsolutePath(), "/");
        } else if (f.isFile() && docBase.endsWith(".war")) {
            this.main = new JarResourceSet(this, "/", f.getAbsolutePath(), "/");
        } else {
            throw new IllegalArgumentException(sm.getString("standardRoot.startInvalidMain", new Object[]{f.getAbsolutePath()}));
        }
        this.mainResources.clear();
        this.mainResources.add(this.main);
        for (ArrayList<WebResourceSet> list : this.allResources) {
            for (WebResourceSet webResourceSet : list) {
                webResourceSet.start();
            }
        }
        this.setState(LifecycleState.STARTING);
    }

    @Override
    protected void stopInternal() throws LifecycleException {
        for (ArrayList<WebResourceSet> list : this.allResources) {
            for (WebResourceSet webResourceSet : list) {
                webResourceSet.stop();
            }
        }
        if (this.main != null) {
            this.main.destroy();
        }
        this.mainResources.clear();
        for (WebResourceSet webResourceSet : this.jarResources) {
            webResourceSet.destroy();
        }
        this.jarResources.clear();
        this.cache.clear();
        this.setState(LifecycleState.STOPPING);
    }

    @Override
    protected void destroyInternal() throws LifecycleException {
        for (ArrayList<WebResourceSet> list : this.allResources) {
            for (WebResourceSet webResourceSet : list) {
                webResourceSet.destroy();
            }
        }
        super.destroyInternal();
    }

    static class BaseLocation {
        private final String basePath;
        private final String archivePath;

        BaseLocation(URL url) {
            File f = null;
            if ("jar".equals(url.getProtocol())) {
                String jarUrl = url.toString();
                int endOfFileUrl = jarUrl.indexOf("!/");
                String fileUrl = jarUrl.substring(4, endOfFileUrl);
                try {
                    f = new File(new URL(fileUrl).toURI());
                }
                catch (MalformedURLException | URISyntaxException e) {
                    throw new IllegalArgumentException(e);
                }
                int startOfArchivePath = endOfFileUrl + 2;
                this.archivePath = jarUrl.length() > startOfArchivePath ? jarUrl.substring(startOfArchivePath) : null;
            } else if ("file".equals(url.getProtocol())) {
                try {
                    f = new File(url.toURI());
                }
                catch (URISyntaxException e) {
                    throw new IllegalArgumentException(e);
                }
                this.archivePath = null;
            } else {
                throw new IllegalArgumentException(sm.getString("standardRoot.unsupportedProtocol", new Object[]{url.getProtocol()}));
            }
            this.basePath = f.getAbsolutePath();
        }

        public String getBasePath() {
            return this.basePath;
        }

        public String getArchivePath() {
            return this.archivePath;
        }
    }
}

