/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.webresources;

import java.io.IOException;
import java.io.InputStream;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.apache.catalina.WebResourceRoot;
import org.apache.catalina.webresources.AbstractArchiveResource;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;

public class JarResource
extends AbstractArchiveResource {
    private static final Log log = LogFactory.getLog(JarResource.class);

    public JarResource(WebResourceRoot root, String webAppPath, String base, String baseUrl, JarEntry jarEntry, String internalPath, Manifest manifest) {
        super(root, webAppPath, base, "jar:" + baseUrl, jarEntry, internalPath, manifest, baseUrl);
    }

    @Override
    protected AbstractArchiveResource.JarInputStreamWrapper getJarInputStreamWrapper() {
        try {
            JarFile jarFile = new JarFile(this.getBase());
            JarEntry jarEntry = jarFile.getJarEntry(this.getResource().getName());
            InputStream is = jarFile.getInputStream(jarEntry);
            return new AbstractArchiveResource.JarInputStreamWrapper(jarFile, jarEntry, is);
        }
        catch (IOException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)sm.getString("fileResource.getInputStreamFail", new Object[]{this.getResource().getName(), this.getBaseUrl()}), (Throwable)e);
            }
            return null;
        }
    }

    @Override
    protected Log getLog() {
        return log;
    }
}

