/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.mapper;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.catalina.Context;
import org.apache.catalina.Host;
import org.apache.catalina.WebResource;
import org.apache.catalina.WebResourceRoot;
import org.apache.catalina.Wrapper;
import org.apache.catalina.mapper.MappingData;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.buf.Ascii;
import org.apache.tomcat.util.buf.CharChunk;
import org.apache.tomcat.util.buf.MessageBytes;
import org.apache.tomcat.util.res.StringManager;

public final class Mapper {
    private static final Log log = LogFactory.getLog(Mapper.class);
    protected static final StringManager sm = StringManager.getManager((String)Mapper.class.getPackage().getName());
    protected MappedHost[] hosts = new MappedHost[0];
    protected String defaultHostName = null;
    protected Map<Context, ContextVersion> contextObjectToContextVersionMap = new ConcurrentHashMap<Context, ContextVersion>();

    public void setDefaultHostName(String defaultHostName) {
        this.defaultHostName = defaultHostName;
    }

    public synchronized void addHost(String name, String[] aliases, Host host) {
        MappedHost[] newHosts = new MappedHost[this.hosts.length + 1];
        MappedHost newHost = new MappedHost();
        ContextList contextList = new ContextList();
        newHost.name = name;
        newHost.contextList = contextList;
        newHost.object = host;
        if (Mapper.insertMap(this.hosts, newHosts, newHost)) {
            this.hosts = newHosts;
        }
        for (int i = 0; i < aliases.length; ++i) {
            newHosts = new MappedHost[this.hosts.length + 1];
            newHost = new MappedHost();
            newHost.name = aliases[i];
            newHost.contextList = contextList;
            newHost.object = host;
            if (!Mapper.insertMap(this.hosts, newHosts, newHost)) continue;
            this.hosts = newHosts;
        }
    }

    public synchronized void removeHost(String name) {
        int pos = Mapper.find(this.hosts, name);
        if (pos < 0) {
            return;
        }
        Host host = (Host)this.hosts[pos].object;
        MappedHost[] newHosts = new MappedHost[this.hosts.length - 1];
        if (Mapper.removeMap(this.hosts, newHosts, name)) {
            this.hosts = newHosts;
        }
        for (int i = 0; i < newHosts.length; ++i) {
            MappedHost[] newHosts2;
            if (newHosts[i].object != host || !Mapper.removeMap(this.hosts, newHosts2 = new MappedHost[this.hosts.length - 1], newHosts[i].name)) continue;
            this.hosts = newHosts2;
        }
    }

    public synchronized void addHostAlias(String name, String alias) {
        int pos = Mapper.find(this.hosts, name);
        if (pos < 0) {
            return;
        }
        MappedHost realHost = this.hosts[pos];
        MappedHost[] newHosts = new MappedHost[this.hosts.length + 1];
        MappedHost newHost = new MappedHost();
        newHost.name = alias;
        newHost.contextList = realHost.contextList;
        newHost.object = realHost.object;
        if (Mapper.insertMap(this.hosts, newHosts, newHost)) {
            this.hosts = newHosts;
        }
    }

    public synchronized void removeHostAlias(String alias) {
        int pos = Mapper.find(this.hosts, alias);
        if (pos < 0) {
            return;
        }
        MappedHost[] newHosts = new MappedHost[this.hosts.length - 1];
        if (Mapper.removeMap(this.hosts, newHosts, alias)) {
            this.hosts = newHosts;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addContextVersion(String hostName, Host host, String path, String version, Context context, String[] welcomeResources, WebResourceRoot resources) {
        MappedHost[] hosts = this.hosts;
        int pos = Mapper.find(hosts, hostName);
        if (pos < 0) {
            this.addHost(hostName, new String[0], host);
            hosts = this.hosts;
            pos = Mapper.find(hosts, hostName);
        }
        if (pos < 0) {
            log.error((Object)("No host found: " + hostName));
        }
        MappedHost mappedHost = hosts[pos];
        if (mappedHost.name.equals(hostName)) {
            int slashCount = Mapper.slashCount(path);
            MappedHost mappedHost2 = mappedHost;
            synchronized (mappedHost2) {
                int pos2;
                MappedContext[] contexts = mappedHost.contextList.contexts;
                if (slashCount > mappedHost.contextList.nesting) {
                    mappedHost.contextList.nesting = slashCount;
                }
                if ((pos2 = Mapper.find(contexts, path)) < 0 || !path.equals(contexts[pos2].name)) {
                    MappedContext newContext = new MappedContext();
                    newContext.name = path;
                    MappedContext[] newContexts = new MappedContext[contexts.length + 1];
                    if (Mapper.insertMap(contexts, newContexts, newContext)) {
                        mappedHost.contextList.contexts = newContexts;
                    }
                    pos2 = Mapper.find(newContexts, path);
                }
                MappedContext mappedContext = mappedHost.contextList.contexts[pos2];
                ContextVersion[] contextVersions = mappedContext.versions;
                ContextVersion[] newContextVersions = new ContextVersion[contextVersions.length + 1];
                ContextVersion newContextVersion = new ContextVersion();
                newContextVersion.path = path;
                newContextVersion.slashCount = slashCount;
                newContextVersion.name = version;
                newContextVersion.object = context;
                newContextVersion.welcomeResources = welcomeResources;
                newContextVersion.resources = resources;
                if (Mapper.insertMap(contextVersions, newContextVersions, newContextVersion)) {
                    mappedContext.versions = newContextVersions;
                    this.contextObjectToContextVersionMap.put(context, newContextVersion);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeContextVersion(Context ctxt, String hostName, String path, String version) {
        this.contextObjectToContextVersionMap.remove(ctxt);
        MappedHost[] hosts = this.hosts;
        int pos = Mapper.find(hosts, hostName);
        if (pos < 0) {
            return;
        }
        MappedHost host = hosts[pos];
        if (host.name.equals(hostName)) {
            MappedHost mappedHost = host;
            synchronized (mappedHost) {
                MappedContext[] contexts = host.contextList.contexts;
                if (contexts.length == 0) {
                    return;
                }
                int pos2 = Mapper.find(contexts, path);
                if (pos2 < 0 || !path.equals(contexts[pos2].name)) {
                    return;
                }
                MappedContext context = contexts[pos2];
                ContextVersion[] contextVersions = context.versions;
                ContextVersion[] newContextVersions = new ContextVersion[contextVersions.length - 1];
                if (Mapper.removeMap(contextVersions, newContextVersions, version)) {
                    MappedContext[] newContexts;
                    context.versions = newContextVersions;
                    if (context.versions.length == 0 && Mapper.removeMap(contexts, newContexts = new MappedContext[contexts.length - 1], path)) {
                        host.contextList.contexts = newContexts;
                        host.contextList.nesting = 0;
                        for (int i = 0; i < newContexts.length; ++i) {
                            int slashCount = Mapper.slashCount(newContexts[i].name);
                            if (slashCount <= host.contextList.nesting) continue;
                            host.contextList.nesting = slashCount;
                        }
                    }
                }
            }
        }
    }

    public void addWrapper(String hostName, String contextPath, String version, String path, Wrapper wrapper, boolean jspWildCard, boolean resourceOnly) {
        MappedHost[] hosts = this.hosts;
        int pos = Mapper.find(hosts, hostName);
        if (pos < 0) {
            return;
        }
        MappedHost host = hosts[pos];
        if (host.name.equals(hostName)) {
            MappedContext[] contexts = host.contextList.contexts;
            int pos2 = Mapper.find(contexts, contextPath);
            if (pos2 < 0) {
                log.error((Object)("No context found: " + contextPath));
                return;
            }
            MappedContext context = contexts[pos2];
            if (context.name.equals(contextPath)) {
                ContextVersion[] contextVersions = context.versions;
                int pos3 = Mapper.find(contextVersions, version);
                if (pos3 < 0) {
                    log.error((Object)("No context version found: " + contextPath + " " + version));
                    return;
                }
                ContextVersion contextVersion = contextVersions[pos3];
                if (contextVersion.name.equals(version)) {
                    this.addWrapper(contextVersion, path, wrapper, jspWildCard, resourceOnly);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addWrapper(ContextVersion context, String path, Wrapper wrapper, boolean jspWildCard, boolean resourceOnly) {
        ContextVersion contextVersion = context;
        synchronized (contextVersion) {
            MappedWrapper newWrapper = new MappedWrapper();
            newWrapper.object = wrapper;
            newWrapper.jspWildCard = jspWildCard;
            newWrapper.resourceOnly = resourceOnly;
            if (path.endsWith("/*")) {
                newWrapper.name = path.substring(0, path.length() - 2);
                MappedWrapper[] oldWrappers = context.wildcardWrappers;
                MappedWrapper[] newWrappers = new MappedWrapper[oldWrappers.length + 1];
                if (Mapper.insertMap(oldWrappers, newWrappers, newWrapper)) {
                    context.wildcardWrappers = newWrappers;
                    int slashCount = Mapper.slashCount(newWrapper.name);
                    if (slashCount > context.nesting) {
                        context.nesting = slashCount;
                    }
                }
            } else if (path.startsWith("*.")) {
                newWrapper.name = path.substring(2);
                MappedWrapper[] oldWrappers = context.extensionWrappers;
                MappedWrapper[] newWrappers = new MappedWrapper[oldWrappers.length + 1];
                if (Mapper.insertMap(oldWrappers, newWrappers, newWrapper)) {
                    context.extensionWrappers = newWrappers;
                }
            } else if (path.equals("/")) {
                newWrapper.name = "";
                context.defaultWrapper = newWrapper;
            } else {
                newWrapper.name = path.length() == 0 ? "/" : path;
                MappedWrapper[] oldWrappers = context.exactWrappers;
                MappedWrapper[] newWrappers = new MappedWrapper[oldWrappers.length + 1];
                if (Mapper.insertMap(oldWrappers, newWrappers, newWrapper)) {
                    context.exactWrappers = newWrappers;
                }
            }
        }
    }

    public void removeWrapper(String hostName, String contextPath, String version, String path) {
        MappedHost[] hosts = this.hosts;
        int pos = Mapper.find(hosts, hostName);
        if (pos < 0) {
            return;
        }
        MappedHost host = hosts[pos];
        if (host.name.equals(hostName)) {
            MappedContext[] contexts = host.contextList.contexts;
            int pos2 = Mapper.find(contexts, contextPath);
            if (pos2 < 0) {
                return;
            }
            MappedContext context = contexts[pos2];
            if (context.name.equals(contextPath)) {
                ContextVersion[] contextVersions = context.versions;
                int pos3 = Mapper.find(contextVersions, version);
                if (pos3 < 0) {
                    return;
                }
                ContextVersion contextVersion = contextVersions[pos3];
                if (contextVersion.name.equals(version)) {
                    this.removeWrapper(contextVersion, path);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeWrapper(ContextVersion context, String path) {
        if (log.isDebugEnabled()) {
            log.debug((Object)sm.getString("mapper.removeWrapper", new Object[]{context.name, path}));
        }
        ContextVersion contextVersion = context;
        synchronized (contextVersion) {
            if (path.endsWith("/*")) {
                String name = path.substring(0, path.length() - 2);
                MappedWrapper[] oldWrappers = context.wildcardWrappers;
                if (oldWrappers.length == 0) {
                    return;
                }
                MappedWrapper[] newWrappers = new MappedWrapper[oldWrappers.length - 1];
                if (Mapper.removeMap(oldWrappers, newWrappers, name)) {
                    context.nesting = 0;
                    for (int i = 0; i < newWrappers.length; ++i) {
                        int slashCount = Mapper.slashCount(newWrappers[i].name);
                        if (slashCount <= context.nesting) continue;
                        context.nesting = slashCount;
                    }
                    context.wildcardWrappers = newWrappers;
                }
            } else if (path.startsWith("*.")) {
                String name = path.substring(2);
                MappedWrapper[] oldWrappers = context.extensionWrappers;
                if (oldWrappers.length == 0) {
                    return;
                }
                MappedWrapper[] newWrappers = new MappedWrapper[oldWrappers.length - 1];
                if (Mapper.removeMap(oldWrappers, newWrappers, name)) {
                    context.extensionWrappers = newWrappers;
                }
            } else if (path.equals("/")) {
                context.defaultWrapper = null;
            } else {
                String name = path.length() == 0 ? "/" : path;
                MappedWrapper[] oldWrappers = context.exactWrappers;
                if (oldWrappers.length == 0) {
                    return;
                }
                MappedWrapper[] newWrappers = new MappedWrapper[oldWrappers.length - 1];
                if (Mapper.removeMap(oldWrappers, newWrappers, name)) {
                    context.exactWrappers = newWrappers;
                }
            }
        }
    }

    public void addWelcomeFile(String hostName, String contextPath, String version, String welcomeFile) {
        MappedHost[] hosts = this.hosts;
        int pos = Mapper.find(hosts, hostName);
        if (pos < 0) {
            return;
        }
        MappedHost host = hosts[pos];
        if (host.name.equals(hostName)) {
            MappedContext[] contexts = host.contextList.contexts;
            int pos2 = Mapper.find(contexts, contextPath);
            if (pos2 < 0) {
                log.error((Object)("No context found: " + contextPath));
                return;
            }
            MappedContext context = contexts[pos2];
            if (context.name.equals(contextPath)) {
                ContextVersion[] contextVersions = context.versions;
                int pos3 = Mapper.find(contextVersions, version);
                if (pos3 < 0) {
                    log.error((Object)("No context version found: " + contextPath + " " + version));
                    return;
                }
                ContextVersion contextVersion = contextVersions[pos3];
                if (contextVersion.name.equals(version)) {
                    int len = contextVersion.welcomeResources.length + 1;
                    String[] newWelcomeResources = new String[len];
                    System.arraycopy(contextVersion.welcomeResources, 0, newWelcomeResources, 0, len - 1);
                    newWelcomeResources[len - 1] = welcomeFile;
                    contextVersion.welcomeResources = newWelcomeResources;
                }
            }
        }
    }

    public void removeWelcomeFile(String hostName, String contextPath, String version, String welcomeFile) {
        MappedHost[] hosts = this.hosts;
        int pos = Mapper.find(hosts, hostName);
        if (pos < 0) {
            return;
        }
        MappedHost host = hosts[pos];
        if (host.name.equals(hostName)) {
            MappedContext[] contexts = host.contextList.contexts;
            int pos2 = Mapper.find(contexts, contextPath);
            if (pos2 < 0) {
                log.error((Object)("No context found: " + contextPath));
                return;
            }
            MappedContext context = contexts[pos2];
            if (context.name.equals(contextPath)) {
                ContextVersion[] contextVersions = context.versions;
                int pos3 = Mapper.find(contextVersions, version);
                if (pos3 < 0) {
                    log.error((Object)("No context version found: " + contextPath + " " + version));
                    return;
                }
                ContextVersion contextVersion = contextVersions[pos3];
                if (contextVersion.name.equals(version)) {
                    int match = -1;
                    for (int i = 0; i < contextVersion.welcomeResources.length; ++i) {
                        if (!welcomeFile.equals(contextVersion.welcomeResources[i])) continue;
                        match = i;
                        break;
                    }
                    if (match > -1) {
                        int len = contextVersion.welcomeResources.length - 1;
                        String[] newWelcomeResources = new String[len];
                        System.arraycopy(contextVersion.welcomeResources, 0, newWelcomeResources, 0, match);
                        if (match < len) {
                            System.arraycopy(contextVersion.welcomeResources, match + 1, newWelcomeResources, match, len - match);
                        }
                        contextVersion.welcomeResources = newWelcomeResources;
                    }
                }
            }
        }
    }

    public void clearWelcomeFiles(String hostName, String contextPath, String version) {
        MappedHost[] hosts = this.hosts;
        int pos = Mapper.find(hosts, hostName);
        if (pos < 0) {
            return;
        }
        MappedHost host = hosts[pos];
        if (host.name.equals(hostName)) {
            MappedContext[] contexts = host.contextList.contexts;
            int pos2 = Mapper.find(contexts, contextPath);
            if (pos2 < 0) {
                log.error((Object)("No context found: " + contextPath));
                return;
            }
            MappedContext context = contexts[pos2];
            if (context.name.equals(contextPath)) {
                ContextVersion[] contextVersions = context.versions;
                int pos3 = Mapper.find(contextVersions, version);
                if (pos3 < 0) {
                    log.error((Object)("No context version found: " + contextPath + " " + version));
                    return;
                }
                ContextVersion contextVersion = contextVersions[pos3];
                if (contextVersion.name.equals(version)) {
                    contextVersion.welcomeResources = new String[0];
                }
            }
        }
    }

    public void map(MessageBytes host, MessageBytes uri, String version, MappingData mappingData) throws Exception {
        if (host.isNull()) {
            host.getCharChunk().append(this.defaultHostName);
        }
        host.toChars();
        uri.toChars();
        this.internalMap(host.getCharChunk(), uri.getCharChunk(), version, mappingData);
    }

    public void map(Context context, MessageBytes uri, MappingData mappingData) throws Exception {
        ContextVersion contextVersion = this.contextObjectToContextVersionMap.get(context);
        uri.toChars();
        CharChunk uricc = uri.getCharChunk();
        uricc.setLimit(-1);
        this.internalMapWrapper(contextVersion, uricc, mappingData);
    }

    private final void internalMap(CharChunk host, CharChunk uri, String version, MappingData mappingData) throws Exception {
        uri.setLimit(-1);
        MappedContext[] contexts = null;
        MappedContext context = null;
        ContextVersion contextVersion = null;
        int nesting = 0;
        if (mappingData.host == null) {
            MappedHost[] hosts = this.hosts;
            int pos = Mapper.findIgnoreCase(hosts, host);
            if (pos != -1 && host.equalsIgnoreCase(hosts[pos].name)) {
                mappingData.host = (Host)hosts[pos].object;
                contexts = hosts[pos].contextList.contexts;
                nesting = hosts[pos].contextList.nesting;
            } else {
                if (this.defaultHostName == null) {
                    return;
                }
                pos = Mapper.find(hosts, this.defaultHostName);
                if (pos != -1 && this.defaultHostName.equals(hosts[pos].name)) {
                    mappingData.host = (Host)hosts[pos].object;
                    contexts = hosts[pos].contextList.contexts;
                    nesting = hosts[pos].contextList.nesting;
                } else {
                    return;
                }
            }
        }
        if (mappingData.context == null && contexts != null) {
            int pos = Mapper.find(contexts, uri);
            if (pos == -1) {
                return;
            }
            int lastSlash = -1;
            int uriEnd = uri.getEnd();
            int length = -1;
            boolean found = false;
            while (pos >= 0) {
                if (uri.startsWith(contexts[pos].name)) {
                    length = contexts[pos].name.length();
                    if (uri.getLength() == length) {
                        found = true;
                        break;
                    }
                    if (uri.startsWithIgnoreCase("/", length)) {
                        found = true;
                        break;
                    }
                }
                lastSlash = lastSlash == -1 ? Mapper.nthSlash(uri, nesting + 1) : Mapper.lastSlash(uri);
                uri.setEnd(lastSlash);
                pos = Mapper.find(contexts, uri);
            }
            uri.setEnd(uriEnd);
            if (!found) {
                if (contexts[0].name.equals("")) {
                    context = contexts[0];
                }
            } else {
                context = contexts[pos];
            }
            if (context != null) {
                mappingData.contextPath.setString(context.name);
            }
        }
        if (context != null) {
            int pos;
            ContextVersion[] contextVersions = context.versions;
            int versionCount = contextVersions.length;
            if (versionCount > 1) {
                Context[] contextObjects = new Context[contextVersions.length];
                for (int i = 0; i < contextObjects.length; ++i) {
                    contextObjects[i] = (Context)contextVersions[i].object;
                }
                mappingData.contexts = contextObjects;
            }
            contextVersion = version == null ? contextVersions[versionCount - 1] : ((pos = Mapper.find(contextVersions, version)) < 0 || !contextVersions[pos].name.equals(version) ? contextVersions[versionCount - 1] : contextVersions[pos]);
            mappingData.context = (Context)contextVersion.object;
            mappingData.contextSlashCount = contextVersion.slashCount;
        }
        if (contextVersion != null && mappingData.wrapper == null) {
            this.internalMapWrapper(contextVersion, uri, mappingData);
        }
    }

    private final void internalMapWrapper(ContextVersion contextVersion, CharChunk path, MappingData mappingData) throws Exception {
        char[] buf;
        boolean checkWelcomeFiles;
        int pathOffset = path.getOffset();
        int pathEnd = path.getEnd();
        int servletPath = pathOffset;
        boolean noServletPath = false;
        int length = contextVersion.path.length();
        if (length != pathEnd - pathOffset) {
            servletPath = pathOffset + length;
        } else {
            noServletPath = true;
            path.append('/');
            pathOffset = path.getOffset();
            pathEnd = path.getEnd();
            servletPath = pathOffset + length;
        }
        path.setOffset(servletPath);
        MappedWrapper[] exactWrappers = contextVersion.exactWrappers;
        this.internalMapExactWrapper(exactWrappers, path, mappingData);
        boolean checkJspWelcomeFiles = false;
        MappedWrapper[] wildcardWrappers = contextVersion.wildcardWrappers;
        if (mappingData.wrapper == null) {
            this.internalMapWildcardWrapper(wildcardWrappers, contextVersion.nesting, path, mappingData);
            if (mappingData.wrapper != null && mappingData.jspWildCard) {
                char[] buf2 = path.getBuffer();
                if (buf2[pathEnd - 1] == '/') {
                    mappingData.wrapper = null;
                    checkJspWelcomeFiles = true;
                } else {
                    mappingData.wrapperPath.setChars(buf2, path.getStart(), path.getLength());
                    mappingData.pathInfo.recycle();
                }
            }
        }
        if (mappingData.wrapper == null && noServletPath) {
            mappingData.redirectPath.setChars(path.getBuffer(), pathOffset, pathEnd - pathOffset);
            path.setEnd(pathEnd - 1);
            return;
        }
        MappedWrapper[] extensionWrappers = contextVersion.extensionWrappers;
        if (mappingData.wrapper == null && !checkJspWelcomeFiles) {
            this.internalMapExtensionWrapper(extensionWrappers, path, mappingData, true);
        }
        if (mappingData.wrapper == null) {
            checkWelcomeFiles = checkJspWelcomeFiles;
            if (!checkWelcomeFiles) {
                buf = path.getBuffer();
                boolean bl = checkWelcomeFiles = buf[pathEnd - 1] == '/';
            }
            if (checkWelcomeFiles) {
                for (int i = 0; i < contextVersion.welcomeResources.length && mappingData.wrapper == null; ++i) {
                    String pathStr;
                    WebResource file;
                    path.setOffset(pathOffset);
                    path.setEnd(pathEnd);
                    path.append(contextVersion.welcomeResources[i], 0, contextVersion.welcomeResources[i].length());
                    path.setOffset(servletPath);
                    this.internalMapExactWrapper(exactWrappers, path, mappingData);
                    if (mappingData.wrapper == null) {
                        this.internalMapWildcardWrapper(wildcardWrappers, contextVersion.nesting, path, mappingData);
                    }
                    if (mappingData.wrapper != null || contextVersion.resources == null || (file = contextVersion.resources.getResource(pathStr = path.toString())) == null || !file.isFile()) continue;
                    this.internalMapExtensionWrapper(extensionWrappers, path, mappingData, true);
                    if (mappingData.wrapper != null || contextVersion.defaultWrapper == null) continue;
                    mappingData.wrapper = (Wrapper)contextVersion.defaultWrapper.object;
                    mappingData.requestPath.setChars(path.getBuffer(), path.getStart(), path.getLength());
                    mappingData.wrapperPath.setChars(path.getBuffer(), path.getStart(), path.getLength());
                    mappingData.requestPath.setString(pathStr);
                    mappingData.wrapperPath.setString(pathStr);
                }
                path.setOffset(servletPath);
                path.setEnd(pathEnd);
            }
        }
        if (mappingData.wrapper == null) {
            checkWelcomeFiles = checkJspWelcomeFiles;
            if (!checkWelcomeFiles) {
                buf = path.getBuffer();
                boolean bl = checkWelcomeFiles = buf[pathEnd - 1] == '/';
            }
            if (checkWelcomeFiles) {
                for (int i = 0; i < contextVersion.welcomeResources.length && mappingData.wrapper == null; ++i) {
                    path.setOffset(pathOffset);
                    path.setEnd(pathEnd);
                    path.append(contextVersion.welcomeResources[i], 0, contextVersion.welcomeResources[i].length());
                    path.setOffset(servletPath);
                    this.internalMapExtensionWrapper(extensionWrappers, path, mappingData, false);
                }
                path.setOffset(servletPath);
                path.setEnd(pathEnd);
            }
        }
        if (mappingData.wrapper == null && !checkJspWelcomeFiles) {
            if (contextVersion.defaultWrapper != null) {
                mappingData.wrapper = (Wrapper)contextVersion.defaultWrapper.object;
                mappingData.requestPath.setChars(path.getBuffer(), path.getStart(), path.getLength());
                mappingData.wrapperPath.setChars(path.getBuffer(), path.getStart(), path.getLength());
            }
            char[] buf3 = path.getBuffer();
            if (contextVersion.resources != null && buf3[pathEnd - 1] != '/') {
                String pathStr = path.toString();
                WebResource file = contextVersion.resources.getResource(pathStr);
                if (file != null && file.isDirectory()) {
                    path.setOffset(pathOffset);
                    path.append('/');
                    mappingData.redirectPath.setChars(path.getBuffer(), path.getStart(), path.getLength());
                } else {
                    mappingData.requestPath.setString(pathStr);
                    mappingData.wrapperPath.setString(pathStr);
                }
            }
        }
        path.setOffset(pathOffset);
        path.setEnd(pathEnd);
    }

    private final void internalMapExactWrapper(MappedWrapper[] wrappers, CharChunk path, MappingData mappingData) {
        int pos = Mapper.find(wrappers, path);
        if (pos != -1 && path.equals(wrappers[pos].name)) {
            mappingData.requestPath.setString(wrappers[pos].name);
            mappingData.wrapper = (Wrapper)wrappers[pos].object;
            if (path.equals("/")) {
                mappingData.pathInfo.setString("/");
                mappingData.wrapperPath.setString("");
                mappingData.contextPath.setString("");
            } else {
                mappingData.wrapperPath.setString(wrappers[pos].name);
            }
        }
    }

    private final void internalMapWildcardWrapper(MappedWrapper[] wrappers, int nesting, CharChunk path, MappingData mappingData) {
        int pathEnd = path.getEnd();
        int lastSlash = -1;
        int length = -1;
        int pos = Mapper.find(wrappers, path);
        if (pos != -1) {
            boolean found = false;
            while (pos >= 0) {
                if (path.startsWith(wrappers[pos].name)) {
                    length = wrappers[pos].name.length();
                    if (path.getLength() == length) {
                        found = true;
                        break;
                    }
                    if (path.startsWithIgnoreCase("/", length)) {
                        found = true;
                        break;
                    }
                }
                lastSlash = lastSlash == -1 ? Mapper.nthSlash(path, nesting + 1) : Mapper.lastSlash(path);
                path.setEnd(lastSlash);
                pos = Mapper.find(wrappers, path);
            }
            path.setEnd(pathEnd);
            if (found) {
                mappingData.wrapperPath.setString(wrappers[pos].name);
                if (path.getLength() > length) {
                    mappingData.pathInfo.setChars(path.getBuffer(), path.getOffset() + length, path.getLength() - length);
                }
                mappingData.requestPath.setChars(path.getBuffer(), path.getOffset(), path.getLength());
                mappingData.wrapper = (Wrapper)wrappers[pos].object;
                mappingData.jspWildCard = wrappers[pos].jspWildCard;
            }
        }
    }

    private final void internalMapExtensionWrapper(MappedWrapper[] wrappers, CharChunk path, MappingData mappingData, boolean resourceExpected) {
        char[] buf = path.getBuffer();
        int pathEnd = path.getEnd();
        int servletPath = path.getOffset();
        int slash = -1;
        for (int i = pathEnd - 1; i >= servletPath; --i) {
            if (buf[i] != '/') continue;
            slash = i;
            break;
        }
        if (slash >= 0) {
            int period = -1;
            for (int i = pathEnd - 1; i > slash; --i) {
                if (buf[i] != '.') continue;
                period = i;
                break;
            }
            if (period >= 0) {
                path.setOffset(period + 1);
                path.setEnd(pathEnd);
                int pos = Mapper.find(wrappers, path);
                if (pos != -1 && path.equals(wrappers[pos].name) && (resourceExpected || !wrappers[pos].resourceOnly)) {
                    mappingData.wrapperPath.setChars(buf, servletPath, pathEnd - servletPath);
                    mappingData.requestPath.setChars(buf, servletPath, pathEnd - servletPath);
                    mappingData.wrapper = (Wrapper)wrappers[pos].object;
                }
                path.setOffset(servletPath);
                path.setEnd(pathEnd);
            }
        }
    }

    private static final <T> int find(MapElement<T>[] map, CharChunk name) {
        return Mapper.find(map, name, name.getStart(), name.getEnd());
    }

    private static final <T> int find(MapElement<T>[] map, CharChunk name, int start, int end) {
        int a = 0;
        int b = map.length - 1;
        if (b == -1) {
            return -1;
        }
        if (Mapper.compare(name, start, end, map[0].name) < 0) {
            return -1;
        }
        if (b == 0) {
            return 0;
        }
        int i = 0;
        do {
            i = (b + a) / 2;
            int result = Mapper.compare(name, start, end, map[i].name);
            if (result == 1) {
                a = i;
                continue;
            }
            if (result == 0) {
                return i;
            }
            b = i;
        } while (b - a != 1);
        int result2 = Mapper.compare(name, start, end, map[b].name);
        if (result2 < 0) {
            return a;
        }
        return b;
    }

    private static final <T> int findIgnoreCase(MapElement<T>[] map, CharChunk name) {
        return Mapper.findIgnoreCase(map, name, name.getStart(), name.getEnd());
    }

    private static final <T> int findIgnoreCase(MapElement<T>[] map, CharChunk name, int start, int end) {
        int a = 0;
        int b = map.length - 1;
        if (b == -1) {
            return -1;
        }
        if (Mapper.compareIgnoreCase(name, start, end, map[0].name) < 0) {
            return -1;
        }
        if (b == 0) {
            return 0;
        }
        int i = 0;
        do {
            i = (b + a) / 2;
            int result = Mapper.compareIgnoreCase(name, start, end, map[i].name);
            if (result == 1) {
                a = i;
                continue;
            }
            if (result == 0) {
                return i;
            }
            b = i;
        } while (b - a != 1);
        int result2 = Mapper.compareIgnoreCase(name, start, end, map[b].name);
        if (result2 < 0) {
            return a;
        }
        return b;
    }

    private static final <T> int find(MapElement<T>[] map, String name) {
        int a = 0;
        int b = map.length - 1;
        if (b == -1) {
            return -1;
        }
        if (name.compareTo(map[0].name) < 0) {
            return -1;
        }
        if (b == 0) {
            return 0;
        }
        int i = 0;
        do {
            i = (b + a) / 2;
            int result = name.compareTo(map[i].name);
            if (result > 0) {
                a = i;
                continue;
            }
            if (result == 0) {
                return i;
            }
            b = i;
        } while (b - a != 1);
        int result2 = name.compareTo(map[b].name);
        if (result2 < 0) {
            return a;
        }
        return b;
    }

    private static final int compare(CharChunk name, int start, int end, String compareTo) {
        int result = 0;
        char[] c = name.getBuffer();
        int len = compareTo.length();
        if (end - start < len) {
            len = end - start;
        }
        for (int i = 0; i < len && result == 0; ++i) {
            if (c[i + start] > compareTo.charAt(i)) {
                result = 1;
                continue;
            }
            if (c[i + start] >= compareTo.charAt(i)) continue;
            result = -1;
        }
        if (result == 0) {
            if (compareTo.length() > end - start) {
                result = -1;
            } else if (compareTo.length() < end - start) {
                result = 1;
            }
        }
        return result;
    }

    private static final int compareIgnoreCase(CharChunk name, int start, int end, String compareTo) {
        int result = 0;
        char[] c = name.getBuffer();
        int len = compareTo.length();
        if (end - start < len) {
            len = end - start;
        }
        for (int i = 0; i < len && result == 0; ++i) {
            if (Ascii.toLower((int)c[i + start]) > Ascii.toLower((int)compareTo.charAt(i))) {
                result = 1;
                continue;
            }
            if (Ascii.toLower((int)c[i + start]) >= Ascii.toLower((int)compareTo.charAt(i))) continue;
            result = -1;
        }
        if (result == 0) {
            if (compareTo.length() > end - start) {
                result = -1;
            } else if (compareTo.length() < end - start) {
                result = 1;
            }
        }
        return result;
    }

    private static final int lastSlash(CharChunk name) {
        char[] c = name.getBuffer();
        int end = name.getEnd();
        int start = name.getStart();
        int pos = end;
        while (pos > start && c[--pos] != '/') {
        }
        return pos;
    }

    private static final int nthSlash(CharChunk name, int n) {
        int start;
        char[] c = name.getBuffer();
        int end = name.getEnd();
        int pos = start = name.getStart();
        int count = 0;
        while (pos < end) {
            if (c[pos++] != '/' || ++count != n) continue;
            --pos;
            break;
        }
        return pos;
    }

    private static final int slashCount(String name) {
        int pos = -1;
        int count = 0;
        while ((pos = name.indexOf(47, pos + 1)) != -1) {
            ++count;
        }
        return count;
    }

    private static final <T> boolean insertMap(MapElement<T>[] oldMap, MapElement<T>[] newMap, MapElement<T> newElement) {
        int pos = Mapper.find(oldMap, newElement.name);
        if (pos != -1 && newElement.name.equals(oldMap[pos].name)) {
            return false;
        }
        System.arraycopy(oldMap, 0, newMap, 0, pos + 1);
        newMap[pos + 1] = newElement;
        System.arraycopy(oldMap, pos + 1, newMap, pos + 2, oldMap.length - pos - 1);
        return true;
    }

    private static final <T> boolean removeMap(MapElement<T>[] oldMap, MapElement<T>[] newMap, String name) {
        int pos = Mapper.find(oldMap, name);
        if (pos != -1 && name.equals(oldMap[pos].name)) {
            System.arraycopy(oldMap, 0, newMap, 0, pos);
            System.arraycopy(oldMap, pos + 1, newMap, pos, oldMap.length - pos - 1);
            return true;
        }
        return false;
    }

    protected static class MappedWrapper
    extends MapElement<Wrapper> {
        public boolean jspWildCard = false;
        public boolean resourceOnly = false;

        protected MappedWrapper() {
        }
    }

    protected static final class ContextVersion
    extends MapElement<Context> {
        public String path = null;
        public int slashCount;
        public String[] welcomeResources = new String[0];
        public WebResourceRoot resources = null;
        public MappedWrapper defaultWrapper = null;
        public MappedWrapper[] exactWrappers = new MappedWrapper[0];
        public MappedWrapper[] wildcardWrappers = new MappedWrapper[0];
        public MappedWrapper[] extensionWrappers = new MappedWrapper[0];
        public int nesting = 0;

        protected ContextVersion() {
        }
    }

    protected static final class MappedContext
    extends MapElement<Context> {
        public ContextVersion[] versions = new ContextVersion[0];

        protected MappedContext() {
        }
    }

    protected static final class ContextList {
        public MappedContext[] contexts = new MappedContext[0];
        public int nesting = 0;

        protected ContextList() {
        }
    }

    protected static final class MappedHost
    extends MapElement<Host> {
        public ContextList contextList = null;

        protected MappedHost() {
        }
    }

    protected static abstract class MapElement<T> {
        public String name = null;
        public T object = null;

        protected MapElement() {
        }
    }
}

