/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.webresources;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URL;
import java.security.cert.Certificate;
import java.util.jar.Manifest;
import org.apache.catalina.WebResource;
import org.apache.catalina.WebResourceRoot;
import org.apache.catalina.webresources.EmptyResource;
import org.apache.catalina.webresources.StandardRoot;

public class CachedResource
implements WebResource {
    private static final long CACHE_ENTRY_SIZE = 500L;
    private final StandardRoot root;
    private final String webAppPath;
    private final long ttl;
    private final int objectMaxSizeBytes;
    private volatile WebResource webResource;
    private volatile long nextCheck;
    private volatile Long cachedLastModified = null;
    private volatile String cachedLastModifiedHttp = null;
    private volatile byte[] cachedContent = null;
    private volatile Boolean cachedIsFile = null;
    private volatile Boolean cachedIsDirectory = null;
    private volatile Boolean cachedExists = null;
    private volatile Boolean cachedIsVirtual = null;
    private volatile Long cachedContentLength = null;

    public CachedResource(StandardRoot root, String path, long ttl, int objectMaxSizeBytes) {
        this.root = root;
        this.webAppPath = path;
        this.ttl = ttl;
        this.objectMaxSizeBytes = objectMaxSizeBytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean validate(boolean useClassLoaderResources) {
        long now = System.currentTimeMillis();
        if (this.webResource == null) {
            CachedResource cachedResource = this;
            synchronized (cachedResource) {
                if (this.webResource == null) {
                    this.webResource = this.root.getResourceInternal(this.webAppPath, useClassLoaderResources);
                    this.getLastModified();
                    this.getContentLength();
                    this.nextCheck = this.ttl + now;
                    this.cachedExists = this.webResource instanceof EmptyResource ? Boolean.FALSE : Boolean.TRUE;
                    return true;
                }
            }
        }
        if (now < this.nextCheck) {
            return true;
        }
        WebResource webResourceInternal = this.root.getResourceInternal(this.webAppPath, useClassLoaderResources);
        if (!this.webResource.exists() && webResourceInternal.exists()) {
            return false;
        }
        if (this.webResource.getLastModified() != this.getLastModified() || this.webResource.getContentLength() != this.getContentLength()) {
            return false;
        }
        if (this.webResource.getLastModified() != webResourceInternal.getLastModified() || this.webResource.getContentLength() != webResourceInternal.getContentLength()) {
            return false;
        }
        this.nextCheck = this.ttl + now;
        return true;
    }

    protected long getNextCheck() {
        return this.nextCheck;
    }

    @Override
    public long getLastModified() {
        Long cachedLastModified = this.cachedLastModified;
        if (cachedLastModified == null) {
            this.cachedLastModified = cachedLastModified = Long.valueOf(this.webResource.getLastModified());
        }
        return cachedLastModified;
    }

    @Override
    public String getLastModifiedHttp() {
        String cachedLastModifiedHttp = this.cachedLastModifiedHttp;
        if (cachedLastModifiedHttp == null) {
            this.cachedLastModifiedHttp = cachedLastModifiedHttp = this.webResource.getLastModifiedHttp();
        }
        return cachedLastModifiedHttp;
    }

    @Override
    public boolean exists() {
        Boolean cachedExists = this.cachedExists;
        if (cachedExists == null) {
            this.cachedExists = cachedExists = Boolean.valueOf(this.webResource.exists());
        }
        return cachedExists;
    }

    @Override
    public boolean isVirtual() {
        Boolean cachedIsVirtual = this.cachedIsVirtual;
        if (cachedIsVirtual == null) {
            this.cachedIsVirtual = cachedIsVirtual = Boolean.valueOf(this.webResource.isVirtual());
        }
        return cachedIsVirtual;
    }

    @Override
    public boolean isDirectory() {
        Boolean cachedIsDirectory = this.cachedIsDirectory;
        if (cachedIsDirectory == null) {
            this.cachedIsDirectory = cachedIsDirectory = Boolean.valueOf(this.webResource.isDirectory());
        }
        return cachedIsDirectory;
    }

    @Override
    public boolean isFile() {
        Boolean cachedIsFile = this.cachedIsFile;
        if (cachedIsFile == null) {
            this.cachedIsFile = cachedIsFile = Boolean.valueOf(this.webResource.isFile());
        }
        return cachedIsFile;
    }

    @Override
    public boolean delete() {
        return this.webResource.delete();
    }

    @Override
    public String getName() {
        return this.webResource.getName();
    }

    @Override
    public long getContentLength() {
        Long cachedContentLength = this.cachedContentLength;
        if (cachedContentLength == null) {
            long result = 0L;
            if (this.webResource != null) {
                result = this.webResource.getContentLength();
                this.cachedContentLength = cachedContentLength = Long.valueOf(result);
            }
            return result;
        }
        return cachedContentLength;
    }

    @Override
    public String getCanonicalPath() {
        return this.webResource.getCanonicalPath();
    }

    @Override
    public boolean canRead() {
        return this.webResource.canRead();
    }

    @Override
    public String getWebappPath() {
        return this.webAppPath;
    }

    @Override
    public String getETag() {
        return this.webResource.getETag();
    }

    @Override
    public void setMimeType(String mimeType) {
        this.webResource.setMimeType(mimeType);
    }

    @Override
    public String getMimeType() {
        return this.webResource.getMimeType();
    }

    @Override
    public InputStream getInputStream() {
        byte[] content = this.cachedContent;
        if (content == null) {
            return this.webResource.getInputStream();
        }
        return new ByteArrayInputStream(content);
    }

    @Override
    public byte[] getContent() {
        byte[] cachedContent = this.cachedContent;
        if (cachedContent == null) {
            if (this.getContentLength() > (long)this.objectMaxSizeBytes) {
                return null;
            }
            this.cachedContent = cachedContent = this.webResource.getContent();
        }
        return cachedContent;
    }

    @Override
    public long getCreation() {
        return this.webResource.getCreation();
    }

    @Override
    public URL getURL() {
        return this.webResource.getURL();
    }

    @Override
    public Certificate[] getCertificates() {
        return this.webResource.getCertificates();
    }

    @Override
    public Manifest getManifest() {
        return this.webResource.getManifest();
    }

    @Override
    public WebResourceRoot getWebResourceRoot() {
        return this.webResource.getWebResourceRoot();
    }

    WebResource getWebResource() {
        return this.webResource;
    }

    long getSize() {
        long result = 500L;
        if (this.getContentLength() <= (long)this.objectMaxSizeBytes) {
            result += this.getContentLength();
        }
        return result;
    }
}

