/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.authenticator.jaspic;

import java.io.IOException;
import java.security.Principal;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.message.callback.CallerPrincipalCallback;
import javax.security.auth.message.callback.GroupPrincipalCallback;
import org.apache.catalina.realm.GenericPrincipal;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.res.StringManager;

public class CallbackHandlerImpl
implements CallbackHandler {
    private static final Log log = LogFactory.getLog(CallbackHandlerImpl.class);
    private static final StringManager sm = StringManager.getManager(CallbackHandlerImpl.class);
    private String name;
    private Principal principal;
    private Subject subject;
    private String[] groups;

    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        if (callbacks != null) {
            for (Callback callback : callbacks) {
                if (callback instanceof CallerPrincipalCallback) {
                    CallerPrincipalCallback cpc = (CallerPrincipalCallback)callback;
                    this.name = cpc.getName();
                    this.principal = cpc.getPrincipal();
                    this.subject = cpc.getSubject();
                    continue;
                }
                if (callback instanceof GroupPrincipalCallback) {
                    GroupPrincipalCallback gpc = (GroupPrincipalCallback)callback;
                    this.groups = gpc.getGroups();
                    continue;
                }
                log.error((Object)sm.getString("callbackHandlerImpl.jaspicCallbackMissing", new Object[]{callback.getClass().getName()}));
            }
            Principal gp = this.getPrincipal();
            if (this.subject != null && gp != null) {
                this.subject.getPrivateCredentials().add(gp);
            }
        }
    }

    private Principal getPrincipal() {
        if (this.principal instanceof GenericPrincipal) {
            return this.principal;
        }
        String name = this.name;
        if (name == null && this.principal != null) {
            name = this.principal.getName();
        }
        if (name == null) {
            return null;
        }
        List<Object> roles = this.groups == null || this.groups.length == 0 ? Collections.emptyList() : Arrays.asList(this.groups);
        return new GenericPrincipal(name, null, roles, this.principal);
    }
}

