/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.authenticator.jaspic;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.security.auth.message.config.AuthConfigFactory;
import javax.security.auth.message.config.AuthConfigProvider;
import javax.security.auth.message.config.RegistrationListener;

public class AuthConfigFactoryImpl
extends AuthConfigFactory {
    private Map<String, ConfigProviderInfo> configProviders = new HashMap<String, ConfigProviderInfo>();

    public AuthConfigProvider getConfigProvider(String layer, String appContext, RegistrationListener listener) {
        String registrationKey = this.getRegistrationKey(layer, appContext);
        ConfigProviderInfo provider = this.configProviders.get(registrationKey);
        if (provider == null) {
            provider = this.configProviders.get(this.getRegistrationKey(null, appContext));
        }
        if (provider == null) {
            provider = this.configProviders.get(this.getRegistrationKey(layer, null));
        }
        if (provider == null) {
            provider = this.configProviders.get(this.getRegistrationKey(null, null));
        }
        if (provider == null) {
            return null;
        }
        if (listener != null) {
            provider.addListener(listener);
        }
        return provider.getAuthConfigProvider();
    }

    public String registerConfigProvider(String className, Map properties, String layer, String appContext, String description) {
        throw new IllegalStateException("Not implemented yet!");
    }

    public String registerConfigProvider(AuthConfigProvider provider, String layer, String appContext, String description) {
        String registrationId = this.getRegistrationKey(layer, appContext);
        ConfigProviderInfo providerInfo = new ConfigProviderInfo(provider, true, layer, appContext, description);
        this.configProviders.put(registrationId, providerInfo);
        return registrationId;
    }

    public boolean removeRegistration(String registrationID) {
        return this.configProviders.remove(registrationID) != null;
    }

    public String[] detachListener(RegistrationListener listener, String layer, String appContext) {
        return null;
    }

    public String[] getRegistrationIDs(AuthConfigProvider provider) {
        return null;
    }

    public AuthConfigFactory.RegistrationContext getRegistrationContext(String registrationID) {
        return this.configProviders.get(registrationID);
    }

    public void refresh() {
    }

    private String getRegistrationKey(String layer, String appContext) {
        return layer + "/" + appContext;
    }

    private static class ConfigProviderInfo
    implements AuthConfigFactory.RegistrationContext {
        private final AuthConfigProvider authConfigProvider;
        private String appContext;
        private String description;
        private String messageLayer;
        private final boolean persistent;
        private final List<RegistrationListener> listeners = new ArrayList<RegistrationListener>();

        private ConfigProviderInfo(AuthConfigProvider authConfigProvider, boolean persistent, String layer, String appContext, String description) {
            this.authConfigProvider = authConfigProvider;
            this.persistent = persistent;
            this.messageLayer = layer;
            this.appContext = appContext;
            this.description = description;
        }

        private ConfigProviderInfo(AuthConfigProvider authConfigProvider, List<RegistrationListener> listeners, boolean persistent) {
            this.authConfigProvider = authConfigProvider;
            this.persistent = persistent;
        }

        public AuthConfigProvider getAuthConfigProvider() {
            return this.authConfigProvider;
        }

        public List<RegistrationListener> getListeners() {
            return this.listeners;
        }

        public void addListener(RegistrationListener listener) {
            this.listeners.add(listener);
        }

        public String getAppContext() {
            return this.appContext;
        }

        public String getDescription() {
            return this.description;
        }

        public String getMessageLayer() {
            return this.messageLayer;
        }

        public boolean isPersistent() {
            return this.persistent;
        }
    }
}

