/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.authenticator.jaspic;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.message.AuthException;
import javax.security.auth.message.AuthStatus;
import javax.security.auth.message.MessageInfo;
import javax.security.auth.message.config.AuthConfigFactory;
import javax.security.auth.message.config.AuthConfigProvider;
import javax.security.auth.message.config.ServerAuthConfig;
import javax.security.auth.message.config.ServerAuthContext;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.authenticator.AuthenticatorBase;
import org.apache.catalina.authenticator.jaspic.JaspicCallbackHandler;
import org.apache.catalina.authenticator.jaspic.MessageInfoImpl;
import org.apache.catalina.connector.Request;
import org.apache.catalina.realm.GenericPrincipal;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.res.StringManager;

public class JaspicAuthenticator
extends AuthenticatorBase {
    private static final Log log = LogFactory.getLog(JaspicAuthenticator.class);
    protected static final StringManager sm = StringManager.getManager(JaspicAuthenticator.class);
    private static final String AUTH_TYPE = "JASPIC";
    public static final String MESSAGE_LAYER = "HttpServlet";
    private Subject serviceSubject;
    private Map<String, String> authProperties = new HashMap<String, String>();
    private JaspicCallbackHandler callbackHandler;

    @Override
    protected synchronized void startInternal() throws LifecycleException {
        super.startInternal();
        this.serviceSubject = new Subject();
        this.callbackHandler = this.getJaspicCallbackHandler();
    }

    @Override
    public boolean authenticate(Request request, HttpServletResponse response) throws IOException {
        AuthStatus authStatus;
        String appContext;
        if (this.checkForCachedAuthentication(request, response, true)) {
            return true;
        }
        MessageInfoImpl messageInfo = new MessageInfoImpl(request, response, true);
        AuthConfigFactory factory = AuthConfigFactory.getFactory();
        AuthConfigProvider configProvider = factory.getConfigProvider(MESSAGE_LAYER, appContext = this.getAppContextId(request), null);
        if (configProvider == null) {
            this.handleUnauthorizedRequest(response, null);
            return false;
        }
        Subject subject = new Subject();
        try {
            ServerAuthConfig authConfig = configProvider.getServerAuthConfig(MESSAGE_LAYER, appContext, (CallbackHandler)this.callbackHandler);
            String messageAuthContextId = authConfig.getAuthContextID((MessageInfo)messageInfo);
            ServerAuthContext authContext = authConfig.getAuthContext(messageAuthContextId, this.serviceSubject, this.authProperties);
            authStatus = authContext.validateRequest((MessageInfo)messageInfo, subject, this.serviceSubject);
        }
        catch (AuthException e) {
            this.handleUnauthorizedRequest(response, e);
            return false;
        }
        if (authStatus == AuthStatus.SUCCESS) {
            GenericPrincipal principal = this.getPrincipal(subject);
            if (principal != null) {
                this.register(request, response, principal, AUTH_TYPE, null, null);
            }
            return true;
        }
        return false;
    }

    private GenericPrincipal getPrincipal(Subject subject) {
        if (subject == null) {
            return null;
        }
        Set<GenericPrincipal> principals = subject.getPrivateCredentials(GenericPrincipal.class);
        if (principals.isEmpty()) {
            return null;
        }
        return principals.iterator().next();
    }

    private void handleUnauthorizedRequest(HttpServletResponse response, AuthException e) throws IOException {
        response.sendError(401);
        if (log.isDebugEnabled()) {
            log.debug((Object)sm.getString("authenticator.jaspic.unauthorized"), (Throwable)e);
        }
    }

    private String getAppContextId(Request request) {
        return request.getServletContext().getVirtualServerName() + " " + request.getContextPath();
    }

    private JaspicCallbackHandler getJaspicCallbackHandler() {
        return new JaspicCallbackHandler(this.container.getRealm());
    }

    @Override
    protected String getAuthMethod() {
        return this.context.getLoginConfig().getAuthMethod();
    }

    public void setProperty(String key, String value) {
        this.authProperties.put(key, value);
    }

    public Map<String, String> getAuthProperties() {
        return Collections.unmodifiableMap(this.authProperties);
    }
}

