/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.authenticator.jaspic;

import java.io.IOException;
import java.security.Principal;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.message.callback.CallerPrincipalCallback;
import javax.security.auth.message.callback.GroupPrincipalCallback;
import javax.security.auth.message.callback.PasswordValidationCallback;
import org.apache.catalina.Realm;
import org.apache.catalina.authenticator.jaspic.PrincipalGroupCallback;
import org.apache.tomcat.util.res.StringManager;

public class JaspicCallbackHandler
implements CallbackHandler {
    protected static final StringManager sm = StringManager.getManager(JaspicCallbackHandler.class);
    private Realm realm;

    public JaspicCallbackHandler(Realm realm) {
        this.realm = realm;
    }

    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        if (callbacks == null) {
            return;
        }
        PrincipalGroupCallback principalGroupCallback = new PrincipalGroupCallback();
        for (Callback callback : callbacks) {
            this.handleCallback(callback, principalGroupCallback);
        }
        principalGroupCallback.configureSubject();
    }

    private void handleCallback(Callback callback, PrincipalGroupCallback principalGroupCallback) {
        if (callback instanceof CallerPrincipalCallback) {
            principalGroupCallback.setCallerPrincipalCallback((CallerPrincipalCallback)callback);
        } else if (callback instanceof GroupPrincipalCallback) {
            principalGroupCallback.setGroupPrincipalCallback((GroupPrincipalCallback)callback);
        } else if (callback instanceof PasswordValidationCallback) {
            this.handlePasswordValidationCallback((PasswordValidationCallback)callback);
        } else {
            throw new IllegalStateException(sm.getString("authenticator.jaspic.unknownCallback", new Object[]{callback.getClass()}));
        }
    }

    private void handlePasswordValidationCallback(PasswordValidationCallback passwordValidationCallback) {
        String password;
        Subject subject = passwordValidationCallback.getSubject();
        String username = passwordValidationCallback.getUsername();
        Principal principal = this.realm.authenticate(username, password = new String(passwordValidationCallback.getPassword()));
        passwordValidationCallback.setResult(principal != null);
        if (principal != null) {
            subject.getPrivateCredentials().add(principal);
        }
    }
}

