/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.authenticator.jaspic;

import java.security.Principal;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.security.auth.Subject;
import javax.security.auth.message.callback.CallerPrincipalCallback;
import javax.security.auth.message.callback.GroupPrincipalCallback;
import org.apache.catalina.realm.GenericPrincipal;

public class PrincipalGroupCallback {
    private CallerPrincipalCallback callerPrincipalCallback;
    private GroupPrincipalCallback groupPrincipalCallback;

    public void setCallerPrincipalCallback(CallerPrincipalCallback callerPrincipalCallback) {
        this.callerPrincipalCallback = callerPrincipalCallback;
    }

    public void setGroupPrincipalCallback(GroupPrincipalCallback groupPrincipalCallback) {
        this.groupPrincipalCallback = groupPrincipalCallback;
    }

    public void configureSubject() {
        GenericPrincipal principal = this.getPrincipal();
        if (principal == null) {
            return;
        }
        Subject subject = this.getSubject();
        if (subject != null) {
            subject.getPrivateCredentials().add(principal);
        }
    }

    private Subject getSubject() {
        if (this.callerPrincipalCallback != null) {
            return this.callerPrincipalCallback.getSubject();
        }
        if (this.groupPrincipalCallback != null) {
            return this.groupPrincipalCallback.getSubject();
        }
        return null;
    }

    public GenericPrincipal getPrincipal() {
        if (this.callerPrincipalCallback == null) {
            return null;
        }
        Principal userPrincipal = this.getUserPrincipal();
        return new GenericPrincipal(this.getUserName(), null, this.getRoles(), userPrincipal);
    }

    private Principal getUserPrincipal() {
        if (this.callerPrincipalCallback == null) {
            return null;
        }
        return this.callerPrincipalCallback.getPrincipal();
    }

    private List<String> getRoles() {
        if (this.groupPrincipalCallback == null) {
            return Collections.emptyList();
        }
        return Arrays.asList(this.groupPrincipalCallback.getGroups());
    }

    private String getUserName() {
        String name = null;
        if (this.callerPrincipalCallback != null) {
            name = this.callerPrincipalCallback.getName();
        }
        if (name != null) {
            return name;
        }
        return this.getUserPrincipalName();
    }

    private String getUserPrincipalName() {
        Principal principal = this.getUserPrincipal();
        if (principal == null) {
            return null;
        }
        return principal.getName();
    }
}

