/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.authenticator.jaspic.provider;

import java.util.HashMap;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.message.AuthException;
import javax.security.auth.message.MessageInfo;
import javax.security.auth.message.config.ServerAuthConfig;
import javax.security.auth.message.config.ServerAuthContext;
import org.apache.catalina.Context;
import org.apache.catalina.Realm;
import org.apache.catalina.authenticator.jaspic.provider.TomcatServerAuthContext;
import org.apache.catalina.authenticator.jaspic.provider.modules.BasicAuthModule;
import org.apache.catalina.authenticator.jaspic.provider.modules.DigestAuthModule;
import org.apache.catalina.authenticator.jaspic.provider.modules.FormAuthModule;
import org.apache.catalina.authenticator.jaspic.provider.modules.NonLoginAuthModule;
import org.apache.catalina.authenticator.jaspic.provider.modules.SSLAuthModule;
import org.apache.catalina.authenticator.jaspic.provider.modules.SpnegoAuthModule;
import org.apache.catalina.authenticator.jaspic.provider.modules.TomcatAuthModule;
import org.apache.tomcat.util.descriptor.web.LoginConfig;
import org.apache.tomcat.util.res.StringManager;

public class TomcatAuthConfig
implements ServerAuthConfig {
    protected static final StringManager sm = StringManager.getManager(TomcatAuthConfig.class);
    private String messageLayer;
    private String appContext;
    private CallbackHandler handler;
    private TomcatServerAuthContext tomcatServerAuthContext;
    private Context context;
    private LoginConfig loginConfig;
    private Realm realm;
    private Map<String, String> properties;

    public TomcatAuthConfig(String layer, String appContext, CallbackHandler callbackHandler, Context context, Map<String, String> properties) throws AuthException {
        this.messageLayer = layer;
        this.appContext = appContext;
        this.handler = callbackHandler;
        this.context = context;
        this.properties = properties;
        this.realm = context.getRealm();
        this.loginConfig = context.getLoginConfig();
        this.initializeAuthContext(properties);
    }

    public String getMessageLayer() {
        return this.messageLayer;
    }

    public String getAppContext() {
        return this.appContext;
    }

    public String getAuthContextID(MessageInfo messageInfo) {
        return messageInfo.toString();
    }

    public synchronized void refresh() {
        this.tomcatServerAuthContext = null;
    }

    public boolean isProtected() {
        return false;
    }

    public synchronized ServerAuthContext getAuthContext(String authContextID, Subject serviceSubject, Map properties) throws AuthException {
        if (this.tomcatServerAuthContext == null) {
            this.initializeAuthContext(properties);
        }
        return this.tomcatServerAuthContext;
    }

    private void initializeAuthContext(Map<String, String> properties) throws AuthException {
        TomcatAuthModule module = this.getModule();
        module.initialize(null, null, this.handler, this.getMergedProperties(properties));
        this.tomcatServerAuthContext = new TomcatServerAuthContext(module);
    }

    private Map<String, String> getMergedProperties(Map properties) {
        HashMap<String, String> mergedProperties = new HashMap<String, String>(this.properties);
        mergedProperties.put("javax.servlet.http.realmName", this.getRealmName());
        if (properties != null) {
            mergedProperties.putAll(properties);
        }
        return mergedProperties;
    }

    private TomcatAuthModule getModule() throws AuthException {
        String authMethod;
        switch (authMethod = this.getAuthMethod()) {
            case "BASIC": {
                return new BasicAuthModule(this.context);
            }
            case "DIGEST": {
                return new DigestAuthModule(this.context);
            }
            case "FORM": {
                return new FormAuthModule(this.context);
            }
            case "NONE": {
                return new NonLoginAuthModule(this.context);
            }
            case "SPNEGO": {
                return new SpnegoAuthModule(this.context);
            }
            case "CLIENT-CERT": {
                return new SSLAuthModule(this.context);
            }
        }
        throw new AuthException(sm.getString("authenticator.jaspic.unknownAuthType", new Object[]{authMethod}));
    }

    private String getRealmName() {
        return this.loginConfig.getRealmName();
    }

    private String getAuthMethod() {
        return this.loginConfig.getAuthMethod().replace("JASPIC-", "");
    }
}

