/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.authenticator.jaspic.provider.modules;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.message.AuthException;
import javax.security.auth.message.AuthStatus;
import javax.security.auth.message.MessageInfo;
import javax.security.auth.message.MessagePolicy;
import javax.security.auth.message.callback.PasswordValidationCallback;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.Context;
import org.apache.catalina.authenticator.BasicAuthenticator;
import org.apache.catalina.authenticator.jaspic.provider.modules.TomcatAuthModule;
import org.apache.catalina.connector.Request;
import org.apache.tomcat.util.buf.ByteChunk;
import org.apache.tomcat.util.buf.MessageBytes;

public class BasicAuthModule
extends TomcatAuthModule {
    public BasicAuthModule(Context context) {
        super(context);
    }

    @Override
    public void initializeModule(MessagePolicy requestPolicy, MessagePolicy responsePolicy, CallbackHandler handler, Map<String, String> options) throws AuthException {
    }

    public AuthStatus validateRequest(MessageInfo messageInfo, Subject clientSubject, Subject serviceSubject) throws AuthException {
        if (!this.isMandatory(messageInfo)) {
            return AuthStatus.SUCCESS;
        }
        Request request = (Request)messageInfo.getRequestMessage();
        HttpServletResponse response = (HttpServletResponse)messageInfo.getResponseMessage();
        MessageBytes authorization = request.getCoyoteRequest().getMimeHeaders().getValue("authorization");
        String realmName = this.getRealmName();
        if (authorization == null) {
            return this.sendUnauthorizedError(response, realmName);
        }
        authorization.toBytes();
        ByteChunk authorizationBC = authorization.getByteChunk();
        BasicAuthenticator.BasicCredentials credentials = null;
        try {
            credentials = new BasicAuthenticator.BasicCredentials(authorizationBC);
            String username = credentials.getUsername();
            char[] password = credentials.getPassword().toCharArray();
            PasswordValidationCallback passwordCallback = new PasswordValidationCallback(clientSubject, username, password);
            this.handler.handle(new Callback[]{passwordCallback});
            if (!passwordCallback.getResult()) {
                return this.sendUnauthorizedError(response, realmName);
            }
            this.handlePrincipalCallbacks(clientSubject, this.getPrincipal(passwordCallback));
            return AuthStatus.SUCCESS;
        }
        catch (Exception e) {
            throw new AuthException(e.getMessage());
        }
    }

    private AuthStatus sendUnauthorizedError(HttpServletResponse response, String realmName) throws AuthException {
        String authHeader = MessageFormat.format("Basic realm=\"{0}\"", realmName);
        response.setHeader("WWW-Authenticate", authHeader);
        try {
            response.sendError(401);
        }
        catch (IOException e) {
            throw new AuthException(e.getMessage());
        }
        return AuthStatus.SEND_CONTINUE;
    }
}

