/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.authenticator.jaspic.provider.modules;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.Principal;
import java.text.MessageFormat;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.message.AuthException;
import javax.security.auth.message.AuthStatus;
import javax.security.auth.message.MessageInfo;
import javax.security.auth.message.MessagePolicy;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.Context;
import org.apache.catalina.Realm;
import org.apache.catalina.authenticator.DigestAuthenticator;
import org.apache.catalina.authenticator.jaspic.provider.modules.TomcatAuthModule;
import org.apache.catalina.connector.Request;
import org.apache.catalina.util.StandardSessionIdGenerator;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.security.ConcurrentMessageDigest;
import org.apache.tomcat.util.security.MD5Encoder;

public class DigestAuthModule
extends TomcatAuthModule {
    private static final Log log = LogFactory.getLog(DigestAuthModule.class);
    protected static final String QOP = "auth";
    private CallbackHandler handler;
    private Realm realm;
    protected Map<String, DigestAuthenticator.NonceInfo> nonces;
    protected long lastTimestamp = 0L;
    protected final Object lastTimestampLock = new Object();
    protected int nonceCacheSize = 1000;
    protected int nonceCountWindowSize = 100;
    protected String key = null;
    protected long nonceValidity = 300000L;
    protected String opaque;
    protected boolean validateUri = true;
    private StandardSessionIdGenerator sessionIdGenerator;

    public DigestAuthModule(Context context) {
        super(context);
        this.realm = context.getRealm();
    }

    public int getNonceCountWindowSize() {
        return this.nonceCountWindowSize;
    }

    public void setNonceCountWindowSize(int nonceCountWindowSize) {
        this.nonceCountWindowSize = nonceCountWindowSize;
    }

    public int getNonceCacheSize() {
        return this.nonceCacheSize;
    }

    public void setNonceCacheSize(int nonceCacheSize) {
        this.nonceCacheSize = nonceCacheSize;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public long getNonceValidity() {
        return this.nonceValidity;
    }

    public void setNonceValidity(long nonceValidity) {
        this.nonceValidity = nonceValidity;
    }

    public String getOpaque() {
        return this.opaque;
    }

    public void setOpaque(String opaque) {
        this.opaque = opaque;
    }

    public boolean isValidateUri() {
        return this.validateUri;
    }

    public void setValidateUri(boolean validateUri) {
        this.validateUri = validateUri;
    }

    public void setRealm(Realm realm) {
        this.realm = realm;
    }

    @Override
    public synchronized void initializeModule(MessagePolicy requestPolicy, MessagePolicy responsePolicy, CallbackHandler handler, Map<String, String> options) throws AuthException {
        String nonceValidityValue;
        String nonceCountWindowSizeValue;
        this.handler = handler;
        this.sessionIdGenerator = new StandardSessionIdGenerator();
        this.key = options.get("key");
        String nonceCacheSizeValue = options.get("nonceCacheSize");
        if (nonceCacheSizeValue != null) {
            this.nonceCacheSize = Integer.parseInt(nonceCacheSizeValue);
        }
        if ((nonceCountWindowSizeValue = options.get("nonceCountWindowSize")) != null) {
            this.nonceCountWindowSize = Integer.parseInt(nonceCountWindowSizeValue);
        }
        if ((nonceValidityValue = options.get("nonceValidity")) != null) {
            this.nonceValidity = Long.parseLong(nonceValidityValue);
        }
        this.opaque = options.get("opaque");
        String validateUriValue = options.get("validateUri");
        if (validateUriValue != null) {
            this.validateUri = Boolean.parseBoolean(validateUriValue);
        }
        if (this.getKey() == null) {
            this.setKey(this.sessionIdGenerator.generateSessionId());
        }
        if (this.getOpaque() == null) {
            this.setOpaque(this.sessionIdGenerator.generateSessionId());
        }
        this.nonces = new LinkedHashMap<String, DigestAuthenticator.NonceInfo>(){
            private static final long serialVersionUID = 1L;
            private static final long LOG_SUPPRESS_TIME = 300000L;
            private long lastLog = 0L;

            @Override
            protected boolean removeEldestEntry(Map.Entry<String, DigestAuthenticator.NonceInfo> eldest) {
                long currentTime = System.currentTimeMillis();
                if (this.size() > DigestAuthModule.this.getNonceCacheSize()) {
                    if (this.lastLog < currentTime && currentTime - eldest.getValue().getTimestamp() < DigestAuthModule.this.getNonceValidity()) {
                        log.warn((Object)TomcatAuthModule.sm.getString("digestAuthenticator.cacheRemove"));
                        this.lastLog = currentTime + 300000L;
                    }
                    return true;
                }
                return false;
            }
        };
    }

    public AuthStatus validateRequest(MessageInfo messageInfo, Subject clientSubject, Subject serviceSubject) throws AuthException {
        Principal principal = null;
        Request request = (Request)messageInfo.getRequestMessage();
        HttpServletResponse response = (HttpServletResponse)messageInfo.getResponseMessage();
        String authorization = request.getHeader("authorization");
        DigestAuthenticator.DigestInfo digestInfo = new DigestAuthenticator.DigestInfo(this.getOpaque(), this.getNonceValidity(), this.getKey(), this.nonces, this.isValidateUri());
        if (authorization == null || !digestInfo.parse(request, authorization)) {
            String nonce = this.generateNonce(request);
            String authenticateHeader = this.getAuthenticateHeader(nonce, false);
            return this.sendUnauthorizedError(response, authenticateHeader);
        }
        if (digestInfo.validate(request)) {
            principal = digestInfo.authenticate(this.realm);
        }
        if (principal == null || digestInfo.isNonceStale()) {
            String nonce = this.generateNonce(request);
            boolean isNoncaneStale = principal != null && digestInfo.isNonceStale();
            String authenticateHeader = this.getAuthenticateHeader(nonce, isNoncaneStale);
            return this.sendUnauthorizedError(response, authenticateHeader);
        }
        try {
            this.handlePrincipalCallbacks(clientSubject, principal);
        }
        catch (IOException | UnsupportedCallbackException e) {
            throw new AuthException(e.getMessage());
        }
        return AuthStatus.SUCCESS;
    }

    private AuthStatus sendUnauthorizedError(HttpServletResponse response, String authenticateHeader) throws AuthException {
        response.setHeader("WWW-Authenticate", authenticateHeader);
        try {
            response.sendError(401);
        }
        catch (IOException e) {
            throw new AuthException(e.getMessage());
        }
        return AuthStatus.SEND_CONTINUE;
    }

    protected static String removeQuotes(String quotedString, boolean quotesRequired) {
        if (quotedString.length() > 0 && quotedString.charAt(0) != '\"' && !quotesRequired) {
            return quotedString;
        }
        if (quotedString.length() > 2) {
            return quotedString.substring(1, quotedString.length() - 1);
        }
        return "";
    }

    protected static String removeQuotes(String quotedString) {
        return DigestAuthModule.removeQuotes(quotedString, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String generateNonce(HttpServletRequest request) {
        long currentTime = System.currentTimeMillis();
        Object object = this.lastTimestampLock;
        synchronized (object) {
            if (currentTime > this.lastTimestamp) {
                this.lastTimestamp = currentTime;
            } else {
                currentTime = ++this.lastTimestamp;
            }
        }
        String ipTimeKey = request.getRemoteAddr() + ":" + currentTime + ":" + this.getKey();
        byte[] buffer = ConcurrentMessageDigest.digestMD5((byte[][])new byte[][]{ipTimeKey.getBytes(StandardCharsets.ISO_8859_1)});
        String nonce = currentTime + ":" + MD5Encoder.encode((byte[])buffer);
        DigestAuthenticator.NonceInfo info = new DigestAuthenticator.NonceInfo(currentTime, this.getNonceCountWindowSize());
        Map<String, DigestAuthenticator.NonceInfo> map = this.nonces;
        synchronized (map) {
            this.nonces.put(nonce, info);
        }
        return nonce;
    }

    protected String getAuthenticateHeader(String nonce, boolean isNonceStale) {
        String realmName = this.getRealmName();
        String template = "Digest realm=\"{0}\", qop=\"{1}\", nonce=\"{2}\", opaque=\"{3}\"";
        String authenticateHeader = MessageFormat.format(template, realmName, QOP, nonce, this.getOpaque());
        if (!isNonceStale) {
            return authenticateHeader;
        }
        return authenticateHeader + ", stale=true";
    }
}

