/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.authenticator.jaspic.provider.modules;

import java.io.IOException;
import java.security.Principal;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.message.AuthException;
import javax.security.auth.message.AuthStatus;
import javax.security.auth.message.MessageInfo;
import javax.security.auth.message.MessagePolicy;
import javax.security.auth.message.callback.PasswordValidationCallback;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.Context;
import org.apache.catalina.Manager;
import org.apache.catalina.Realm;
import org.apache.catalina.Session;
import org.apache.catalina.authenticator.SavedRequest;
import org.apache.catalina.authenticator.jaspic.provider.modules.TomcatAuthModule;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.realm.GenericPrincipal;
import org.apache.coyote.ActionCode;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.ExceptionUtils;
import org.apache.tomcat.util.buf.ByteChunk;
import org.apache.tomcat.util.buf.MessageBytes;
import org.apache.tomcat.util.descriptor.web.LoginConfig;
import org.apache.tomcat.util.http.MimeHeaders;

public class FormAuthModule
extends TomcatAuthModule {
    private static final Log log = LogFactory.getLog(FormAuthModule.class);
    private String landingPage;
    private String characterEncoding;
    private Realm realm;
    private LoginConfig loginConfig;

    public FormAuthModule(Context context) {
        super(context);
        this.realm = context.getRealm();
        this.loginConfig = context.getLoginConfig();
    }

    @Override
    public void initializeModule(MessagePolicy requestPolicy, MessagePolicy responsePolicy, CallbackHandler handler, Map<String, String> options) throws AuthException {
        this.characterEncoding = options.get("characterEncoding");
        this.landingPage = options.get("landingPage");
    }

    public AuthStatus validateRequest(MessageInfo messageInfo, Subject clientSubject, Subject serviceSubject) throws AuthException {
        if (!this.isMandatory(messageInfo)) {
            return AuthStatus.SUCCESS;
        }
        try {
            return this.validate(messageInfo, clientSubject);
        }
        catch (Exception e) {
            throw new AuthException(e.getMessage());
        }
    }

    private AuthStatus validate(MessageInfo messageInfo, Subject clientSubject) throws IOException, UnsupportedCallbackException {
        Request request = (Request)messageInfo.getRequestMessage();
        HttpServletResponse response = (HttpServletResponse)messageInfo.getResponseMessage();
        if (!this.cache && this.isUserAuthenticatedBefore(request)) {
            return this.handleSavedCredentials(clientSubject, request, response);
        }
        if (this.isMatchingSavedRequest(request)) {
            return this.submitSavedRequest(clientSubject, request, response);
        }
        if (!this.isLoginActionRequest(request)) {
            return this.handleRedirectToLoginPage(request, response);
        }
        return this.handleLoginFormAction(request, response);
    }

    private AuthStatus handleSavedCredentials(Subject clientSubject, Request request, HttpServletResponse response) throws IOException, UnsupportedCallbackException {
        char[] password;
        Session session = request.getSessionInternal(true);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Checking for reauthenticate in session " + session));
        }
        String username = (String)session.getNote("org.apache.catalina.session.USERNAME");
        String passwordString = (String)session.getNote("org.apache.catalina.session.PASSWORD");
        char[] cArray = password = passwordString != null ? passwordString.toCharArray() : null;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Reauthenticating username '" + username + "'"));
        }
        PasswordValidationCallback passwordCallback = new PasswordValidationCallback(clientSubject, username, password);
        this.handler.handle(new Callback[]{passwordCallback});
        if (!passwordCallback.getResult()) {
            this.forwardToErrorPage(request, response);
            return AuthStatus.FAILURE;
        }
        GenericPrincipal principal = this.getPrincipal(passwordCallback);
        session.setNote("org.apache.catalina.authenticator.PRINCIPAL", principal);
        if (this.isMatchingSavedRequest(request)) {
            return this.submitSavedRequest(clientSubject, request, response);
        }
        this.handlePrincipalCallbacks(clientSubject, principal);
        return AuthStatus.SUCCESS;
    }

    private boolean isUserAuthenticatedBefore(Request request) {
        Session session = request.getSessionInternal(true);
        String username = (String)session.getNote("org.apache.catalina.session.USERNAME");
        String password = (String)session.getNote("org.apache.catalina.session.PASSWORD");
        return username != null && password != null;
    }

    private AuthStatus submitSavedRequest(Subject clientSubject, Request request, HttpServletResponse response) throws IOException, UnsupportedCallbackException {
        Session session = request.getSessionInternal(true);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Restore request from session '" + session.getIdInternal() + "'"));
        }
        Principal principal = (Principal)session.getNote("org.apache.catalina.authenticator.PRINCIPAL");
        this.handlePrincipalCallbacks(clientSubject, principal);
        if (this.cache) {
            session.removeNote("org.apache.catalina.session.USERNAME");
            session.removeNote("org.apache.catalina.session.PASSWORD");
        }
        if (this.restoreRequest(request, session)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Proceed to restored request");
            }
            return AuthStatus.SUCCESS;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Restore of original request failed");
        }
        response.sendError(400);
        return AuthStatus.FAILURE;
    }

    private AuthStatus handleRedirectToLoginPage(Request request, HttpServletResponse response) throws IOException {
        Session session = request.getSessionInternal(true);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Save request in session '" + session.getIdInternal() + "'"));
        }
        try {
            this.saveRequest(request, session);
        }
        catch (IOException ioe) {
            log.debug((Object)"Request body too big to save during authentication");
            response.sendError(403, sm.getString("authenticator.requestBodyTooBig"));
            return AuthStatus.FAILURE;
        }
        this.forwardToLoginPage(request, response);
        return AuthStatus.SEND_CONTINUE;
    }

    private AuthStatus handleLoginFormAction(Request request, HttpServletResponse response) throws IOException {
        Session session;
        Principal principal;
        request.getResponse().sendAcknowledgement();
        if (this.characterEncoding != null) {
            request.setCharacterEncoding(this.characterEncoding);
        }
        String username = request.getParameter("j_username");
        String password = request.getParameter("j_password");
        if (log.isDebugEnabled()) {
            log.debug((Object)("Authenticating username '" + username + "'"));
        }
        if ((principal = this.realm.authenticate(username, password)) == null) {
            this.forwardToErrorPage(request, response);
            return AuthStatus.FAILURE;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Authentication of '" + username + "' was successful"));
        }
        if ((session = request.getSessionInternal(false)) == null) {
            this.handleSessionExpired(request, response);
            return AuthStatus.FAILURE;
        }
        session.setNote("org.apache.catalina.authenticator.PRINCIPAL", principal);
        session.setNote("org.apache.catalina.session.USERNAME", username);
        session.setNote("org.apache.catalina.session.PASSWORD", password);
        String savedRequestUrl = this.savedRequestURL(session);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Redirecting to original '" + savedRequestUrl + "'"));
        }
        if (savedRequestUrl == null) {
            if (this.landingPage == null) {
                response.sendError(400, sm.getString("authenticator.formlogin"));
            } else {
                String uri = request.getContextPath() + this.landingPage;
                SavedRequest saved = new SavedRequest();
                saved.setMethod("GET");
                saved.setRequestURI(uri);
                saved.setDecodedRequestURI(uri);
                session.setNote("org.apache.catalina.authenticator.REQUEST", saved);
                response.sendRedirect(response.encodeRedirectURL(uri));
            }
        } else {
            Response internalResponse = request.getResponse();
            String location = response.encodeRedirectURL(savedRequestUrl);
            if ("HTTP/1.1".equals(request.getProtocol())) {
                internalResponse.sendRedirect(location, 303);
            } else {
                internalResponse.sendRedirect(location, 302);
            }
        }
        return AuthStatus.FAILURE;
    }

    private void handleSessionExpired(Request request, HttpServletResponse response) throws IOException {
        if (this.landingPage == null) {
            response.sendError(408, sm.getString("authenticator.sessionExpired"));
            return;
        }
        String uri = request.getContextPath() + this.landingPage;
        SavedRequest saved = new SavedRequest();
        saved.setMethod("GET");
        saved.setRequestURI(uri);
        saved.setDecodedRequestURI(uri);
        request.getSessionInternal(true).setNote("org.apache.catalina.authenticator.REQUEST", saved);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void forwardToLoginPage(Request request, HttpServletResponse response) throws IOException {
        Session session;
        String loginPage;
        if (log.isDebugEnabled()) {
            log.debug((Object)sm.getString("formAuthenticator.forwardLogin", new Object[]{request.getRequestURI(), request.getMethod(), this.loginConfig.getLoginPage(), this.context.getName()}));
        }
        if ((loginPage = this.loginConfig.getLoginPage()) == null || loginPage.length() == 0) {
            String msg = sm.getString("formAuthenticator.noLoginPage", new Object[]{this.context.getName()});
            log.warn((Object)msg);
            response.sendError(500, msg);
            return;
        }
        if (this.changeSessionIdOnAuthentication && (session = request.getSessionInternal(false)) != null) {
            Manager manager = request.getContext().getManager();
            manager.changeSessionId(session);
            request.changeSessionId(session.getId());
        }
        String oldMethod = request.getMethod();
        request.getCoyoteRequest().method().setString("GET");
        RequestDispatcher disp = this.context.getServletContext().getRequestDispatcher(loginPage);
        try {
            if (this.context.fireRequestInitEvent((ServletRequest)request)) {
                disp.forward((ServletRequest)request.getRequest(), (ServletResponse)response);
                this.context.fireRequestDestroyEvent((ServletRequest)request);
            }
        }
        catch (Throwable t) {
            ExceptionUtils.handleThrowable((Throwable)t);
            String msg = sm.getString("formAuthenticator.forwardLoginFail");
            log.warn((Object)msg, t);
            request.setAttribute("javax.servlet.error.exception", t);
            response.sendError(500, msg);
        }
        finally {
            request.getCoyoteRequest().method().setString(oldMethod);
        }
    }

    protected void forwardToErrorPage(Request request, HttpServletResponse response) throws IOException {
        String errorPage = this.loginConfig.getErrorPage();
        if (errorPage == null || errorPage.length() == 0) {
            String msg = sm.getString("formAuthenticator.noErrorPage", new Object[]{this.context.getName()});
            log.warn((Object)msg);
            response.sendError(500, msg);
            return;
        }
        RequestDispatcher disp = this.context.getServletContext().getRequestDispatcher(this.loginConfig.getErrorPage());
        try {
            if (this.context.fireRequestInitEvent((ServletRequest)request)) {
                disp.forward((ServletRequest)request.getRequest(), (ServletResponse)response);
                this.context.fireRequestDestroyEvent((ServletRequest)request);
            }
        }
        catch (Throwable t) {
            ExceptionUtils.handleThrowable((Throwable)t);
            String msg = sm.getString("formAuthenticator.forwardErrorFail");
            log.warn((Object)msg, t);
            request.setAttribute("javax.servlet.error.exception", t);
            response.sendError(500, msg);
        }
    }

    protected boolean isMatchingSavedRequest(Request request) {
        Session session = request.getSessionInternal(false);
        if (session == null) {
            return false;
        }
        SavedRequest sreq = (SavedRequest)session.getNote("org.apache.catalina.authenticator.REQUEST");
        if (sreq == null) {
            return false;
        }
        if (session.getNote("org.apache.catalina.authenticator.PRINCIPAL") == null) {
            return false;
        }
        String decodedRequestURI = request.getDecodedRequestURI();
        if (decodedRequestURI == null) {
            return false;
        }
        return decodedRequestURI.equals(sreq.getDecodedRequestURI());
    }

    protected boolean restoreRequest(Request request, Session session) throws IOException {
        SavedRequest saved = (SavedRequest)session.getNote("org.apache.catalina.authenticator.REQUEST");
        session.removeNote("org.apache.catalina.authenticator.REQUEST");
        session.removeNote("org.apache.catalina.authenticator.PRINCIPAL");
        if (saved == null) {
            return false;
        }
        byte[] buffer = new byte[4096];
        ServletInputStream is = request.createInputStream();
        while (is.read(buffer) >= 0) {
        }
        request.clearCookies();
        Iterator<Cookie> cookies = saved.getCookies();
        while (cookies.hasNext()) {
            request.addCookie(cookies.next());
        }
        String method = saved.getMethod();
        MimeHeaders rmh = request.getCoyoteRequest().getMimeHeaders();
        rmh.recycle();
        boolean cachable = "GET".equalsIgnoreCase(method) || "HEAD".equalsIgnoreCase(method);
        Iterator<String> names = saved.getHeaderNames();
        while (names.hasNext()) {
            String name = names.next();
            if ("If-Modified-Since".equalsIgnoreCase(name) || cachable && "If-None-Match".equalsIgnoreCase(name)) continue;
            Iterator<String> values = saved.getHeaderValues(name);
            while (values.hasNext()) {
                rmh.addValue(name).setString(values.next());
            }
        }
        request.clearLocales();
        Iterator<Locale> locales = saved.getLocales();
        while (locales.hasNext()) {
            request.addLocale(locales.next());
        }
        request.getCoyoteRequest().getParameters().recycle();
        request.getCoyoteRequest().getParameters().setQueryStringEncoding(request.getConnector().getURIEncoding());
        ByteChunk body = saved.getBody();
        if (body != null) {
            request.getCoyoteRequest().action(ActionCode.REQ_SET_BODY_REPLAY, (Object)body);
            MessageBytes contentType = MessageBytes.newInstance();
            String savedContentType = saved.getContentType();
            if (savedContentType == null && "POST".equalsIgnoreCase(method)) {
                savedContentType = "application/x-www-form-urlencoded";
            }
            contentType.setString(savedContentType);
            request.getCoyoteRequest().setContentType(contentType);
        }
        request.getCoyoteRequest().method().setString(method);
        return true;
    }

    protected void saveRequest(Request request, Session session) throws IOException {
        int bytesRead;
        SavedRequest saved = new SavedRequest();
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                saved.addCookie(cookie);
            }
        }
        Enumeration<String> names = request.getHeaderNames();
        while (names.hasMoreElements()) {
            String name = names.nextElement();
            Enumeration<String> values = request.getHeaders(name);
            while (values.hasMoreElements()) {
                String value = values.nextElement();
                saved.addHeader(name, value);
            }
        }
        Enumeration<Locale> locales = request.getLocales();
        while (locales.hasMoreElements()) {
            Locale locale = locales.nextElement();
            saved.addLocale(locale);
        }
        request.getResponse().sendAcknowledgement();
        ByteChunk body = new ByteChunk();
        body.setLimit(request.getConnector().getMaxSavePostSize());
        byte[] buffer = new byte[4096];
        ServletInputStream is = request.getInputStream();
        while ((bytesRead = is.read(buffer)) >= 0) {
            body.append(buffer, 0, bytesRead);
        }
        if (body.getLength() > 0) {
            saved.setContentType(request.getContentType());
            saved.setBody(body);
        }
        saved.setMethod(request.getMethod());
        saved.setQueryString(request.getQueryString());
        saved.setRequestURI(request.getRequestURI());
        saved.setDecodedRequestURI(request.getDecodedRequestURI());
        session.setNote("org.apache.catalina.authenticator.REQUEST", saved);
    }

    protected String savedRequestURL(Session session) {
        SavedRequest saved = (SavedRequest)session.getNote("org.apache.catalina.authenticator.REQUEST");
        if (saved == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder(saved.getRequestURI());
        if (saved.getQueryString() != null) {
            sb.append('?');
            sb.append(saved.getQueryString());
        }
        return sb.toString();
    }

    private boolean isLoginActionRequest(Request request) {
        String contextPath = request.getContextPath();
        String requestURI = request.getDecodedRequestURI();
        return requestURI.startsWith(contextPath) && requestURI.endsWith("/j_security_check");
    }
}

