/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.authenticator.jaspic.provider.modules;

import java.security.Principal;
import java.security.cert.X509Certificate;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.message.AuthException;
import javax.security.auth.message.AuthStatus;
import javax.security.auth.message.MessageInfo;
import javax.security.auth.message.MessagePolicy;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.Context;
import org.apache.catalina.authenticator.jaspic.provider.modules.TomcatAuthModule;
import org.apache.catalina.connector.Request;
import org.apache.coyote.ActionCode;

public class SSLAuthModule
extends TomcatAuthModule {
    public SSLAuthModule(Context context) {
        super(context);
    }

    @Override
    public void initializeModule(MessagePolicy requestPolicy, MessagePolicy responsePolicy, CallbackHandler handler, Map<String, String> options) throws AuthException {
    }

    public AuthStatus validateRequest(MessageInfo messageInfo, Subject clientSubject, Subject serviceSubject) throws AuthException {
        if (!this.isMandatory(messageInfo)) {
            return AuthStatus.SUCCESS;
        }
        Request request = (Request)messageInfo.getRequestMessage();
        HttpServletResponse response = (HttpServletResponse)messageInfo.getResponseMessage();
        try {
            X509Certificate[] certs = this.getRequestCertificates(request);
            if (certs == null || certs.length < 1) {
                response.sendError(401, sm.getString("authenticator.certificates"));
                return AuthStatus.FAILURE;
            }
            Principal principal = this.context.getRealm().authenticate(certs);
            if (principal == null) {
                response.sendError(401, sm.getString("authenticator.unauthorized"));
                return AuthStatus.FAILURE;
            }
            this.handlePrincipalCallbacks(clientSubject, principal);
            return AuthStatus.SUCCESS;
        }
        catch (Exception e) {
            throw new AuthException(e.getMessage());
        }
    }

    protected X509Certificate[] getRequestCertificates(Request request) throws IllegalStateException {
        X509Certificate[] certs = (X509Certificate[])request.getAttribute("javax.servlet.request.X509Certificate");
        if (certs == null || certs.length < 1) {
            try {
                request.getCoyoteRequest().action(ActionCode.REQ_SSL_CERTIFICATE, null);
                certs = (X509Certificate[])request.getAttribute("javax.servlet.request.X509Certificate");
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
        return certs;
    }
}

