/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.authenticator.jaspic.provider.modules;

import java.io.File;
import java.io.IOException;
import java.security.Principal;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Map;
import java.util.regex.Pattern;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import javax.security.auth.message.AuthException;
import javax.security.auth.message.AuthStatus;
import javax.security.auth.message.MessageInfo;
import javax.security.auth.message.MessagePolicy;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.Context;
import org.apache.catalina.authenticator.SpnegoAuthenticator;
import org.apache.catalina.authenticator.jaspic.provider.modules.TomcatAuthModule;
import org.apache.catalina.connector.Request;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.buf.ByteChunk;
import org.apache.tomcat.util.buf.MessageBytes;
import org.apache.tomcat.util.codec.binary.Base64;
import org.apache.tomcat.util.compat.JreVendor;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.Oid;

public class SpnegoAuthModule
extends TomcatAuthModule {
    private static final Log log = LogFactory.getLog(SpnegoAuthModule.class);
    private String loginConfigName = "com.sun.security.jgss.krb5.accept";
    private boolean storeDelegatedCredential = true;
    private Pattern noKeepAliveUserAgents = null;
    private boolean applyJava8u40Fix = true;

    @Override
    public void initializeModule(MessagePolicy requestPolicy, MessagePolicy responsePolicy, CallbackHandler handler, Map<String, String> options) throws AuthException {
        this.loginConfigName = options.getOrDefault("loginConfigName", "com.sun.security.jgss.krb5.accept");
        this.storeDelegatedCredential = Boolean.parseBoolean(options.getOrDefault("storeDelegatedCredential", Boolean.TRUE.toString()));
        this.noKeepAliveUserAgents = this.compilePattern(options.get("noKeepAliveUserAgents"));
        this.applyJava8u40Fix = Boolean.parseBoolean(options.getOrDefault("applyJava8u40Fix", Boolean.TRUE.toString()));
        this.configureKerberosFileLocation();
        this.configureJaasFileLocation();
    }

    private Pattern compilePattern(String noKeepAliveUserAgents) {
        if (noKeepAliveUserAgents == null || noKeepAliveUserAgents.length() == 0) {
            return null;
        }
        return Pattern.compile(noKeepAliveUserAgents);
    }

    private void configureKerberosFileLocation() {
        String krb5Conf = System.getProperty("java.security.krb5.conf");
        if (krb5Conf == null) {
            File configFile = new File(this.context.getCatalinaBase(), "conf/krb5.ini");
            System.setProperty("java.security.krb5.conf", configFile.getAbsolutePath());
        }
    }

    private void configureJaasFileLocation() {
        String jaasConf = System.getProperty("java.security.auth.login.config");
        if (jaasConf == null) {
            File configFile = new File(this.context.getCatalinaBase(), "conf/jaas.conf");
            System.setProperty("java.security.auth.login.config", configFile.getAbsolutePath());
        }
    }

    public SpnegoAuthModule(Context context) {
        super(context);
    }

    public AuthStatus validateRequest(MessageInfo messageInfo, Subject clientSubject, Subject serviceSubject) throws AuthException {
        try {
            return this.validate(messageInfo, clientSubject);
        }
        catch (IOException e) {
            throw new AuthException(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AuthStatus validate(MessageInfo messageInfo, Subject clientSubject) throws IOException {
        Object manager;
        Request request = (Request)messageInfo.getRequestMessage();
        HttpServletResponse response = (HttpServletResponse)messageInfo.getResponseMessage();
        MessageBytes authorization = request.getCoyoteRequest().getMimeHeaders().getValue("authorization");
        if (authorization == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)sm.getString("authenticator.noAuthHeader"));
            }
            response.setHeader("WWW-Authenticate", "Negotiate");
            response.sendError(401);
            return AuthStatus.SEND_FAILURE;
        }
        authorization.toBytes();
        ByteChunk authorizationBC = authorization.getByteChunk();
        if (!authorizationBC.startsWithIgnoreCase("negotiate ", 0)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)sm.getString("spnegoAuthenticator.authHeaderNotNego"));
            }
            response.setHeader("WWW-Authenticate", "Negotiate");
            response.sendError(401);
            return AuthStatus.SEND_FAILURE;
        }
        authorizationBC.setOffset(authorizationBC.getOffset() + 10);
        byte[] decoded = Base64.decodeBase64((byte[])authorizationBC.getBuffer(), (int)authorizationBC.getOffset(), (int)authorizationBC.getLength());
        if (this.applyJava8u40Fix) {
            SpnegoAuthenticator.SpnegoTokenFixer.fix(decoded);
        }
        if (decoded.length == 0) {
            if (log.isDebugEnabled()) {
                log.debug((Object)sm.getString("spnegoAuthenticator.authHeaderNoToken"));
            }
            response.setHeader("WWW-Authenticate", "Negotiate");
            response.sendError(401);
            return AuthStatus.SEND_FAILURE;
        }
        LoginContext lc = null;
        GSSContext gssContext = null;
        byte[] outToken = null;
        Principal principal = null;
        try {
            try {
                lc = new LoginContext(this.loginConfigName);
                lc.login();
            }
            catch (LoginException e) {
                log.error((Object)sm.getString("spnegoAuthenticator.serviceLoginFail"), (Throwable)e);
                response.sendError(500);
                AuthStatus authStatus = AuthStatus.FAILURE;
                if (gssContext != null) {
                    try {
                        gssContext.dispose();
                    }
                    catch (GSSException gSSException) {
                        // empty catch block
                    }
                }
                if (lc != null) {
                    try {
                        lc.logout();
                    }
                    catch (LoginException loginException) {
                        // empty catch block
                    }
                }
                return authStatus;
            }
            Subject subject = lc.getSubject();
            manager = GSSManager.getInstance();
            int credentialLifetime = JreVendor.IS_IBM_JVM ? Integer.MAX_VALUE : 0;
            PrivilegedExceptionAction<GSSCredential> action = new PrivilegedExceptionAction<GSSCredential>((GSSManager)manager, credentialLifetime){
                final /* synthetic */ GSSManager val$manager;
                final /* synthetic */ int val$credentialLifetime;
                {
                    this.val$manager = gSSManager;
                    this.val$credentialLifetime = n;
                }

                @Override
                public GSSCredential run() throws GSSException {
                    return this.val$manager.createCredential(null, this.val$credentialLifetime, new Oid("1.3.6.1.5.5.2"), 2);
                }
            };
            gssContext = ((GSSManager)manager).createContext(Subject.doAs(subject, action));
            outToken = Subject.doAs(lc.getSubject(), new SpnegoAuthenticator.AcceptAction(gssContext, decoded));
            if (outToken == null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)sm.getString("spnegoAuthenticator.ticketValidateFail"));
                }
                response.setHeader("WWW-Authenticate", "Negotiate");
                response.sendError(401);
                AuthStatus authStatus = AuthStatus.SEND_FAILURE;
                return authStatus;
            }
            principal = Subject.doAs(subject, new SpnegoAuthenticator.AuthenticateAction(this.context.getRealm(), gssContext, this.storeDelegatedCredential));
        }
        catch (GSSException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)sm.getString("spnegoAuthenticator.ticketValidateFail"), (Throwable)e);
            }
            response.setHeader("WWW-Authenticate", "Negotiate");
            response.sendError(401);
            manager = AuthStatus.FAILURE;
            return manager;
        }
        catch (PrivilegedActionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof GSSException) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)sm.getString("spnegoAuthenticator.serviceLoginFail"), (Throwable)e);
                }
            } else {
                log.error((Object)sm.getString("spnegoAuthenticator.serviceLoginFail"), (Throwable)e);
            }
            response.setHeader("WWW-Authenticate", "Negotiate");
            response.sendError(401);
            AuthStatus authStatus = AuthStatus.FAILURE;
            return authStatus;
        }
        finally {
            if (gssContext != null) {
                try {
                    gssContext.dispose();
                }
                catch (GSSException gSSException) {}
            }
            if (lc != null) {
                try {
                    lc.logout();
                }
                catch (LoginException loginException) {}
            }
        }
        response.setHeader("WWW-Authenticate", "Negotiate " + Base64.encodeBase64String((byte[])outToken));
        if (principal != null) {
            MessageBytes ua;
            try {
                this.handlePrincipalCallbacks(clientSubject, principal);
            }
            catch (IOException | UnsupportedCallbackException e) {
                e.printStackTrace();
            }
            Pattern p = this.noKeepAliveUserAgents;
            if (p != null && (ua = request.getCoyoteRequest().getMimeHeaders().getValue("user-agent")) != null && p.matcher(ua.toString()).matches()) {
                response.setHeader("Connection", "close");
            }
            return AuthStatus.SUCCESS;
        }
        response.sendError(401);
        return AuthStatus.FAILURE;
    }

    @Override
    public AuthStatus secureResponse(MessageInfo messageInfo, Subject serviceSubject) throws AuthException {
        return null;
    }

    @Override
    public void cleanSubject(MessageInfo messageInfo, Subject subject) throws AuthException {
    }
}

