/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.authenticator.jaspic.provider.modules;

import java.io.IOException;
import java.security.Principal;
import java.util.Iterator;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.message.AuthException;
import javax.security.auth.message.AuthStatus;
import javax.security.auth.message.MessageInfo;
import javax.security.auth.message.MessagePolicy;
import javax.security.auth.message.callback.CallerPrincipalCallback;
import javax.security.auth.message.callback.GroupPrincipalCallback;
import javax.security.auth.message.callback.PasswordValidationCallback;
import javax.security.auth.message.module.ServerAuthModule;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.Context;
import org.apache.catalina.connector.Request;
import org.apache.catalina.realm.GenericPrincipal;
import org.apache.tomcat.util.res.StringManager;

public abstract class TomcatAuthModule
implements ServerAuthModule {
    public static final String REALM_NAME = "javax.servlet.http.realmName";
    public static final String DEFAULT_REALM_NAME = "Authentication required";
    protected static final String AUTH_HEADER_NAME = "WWW-Authenticate";
    protected static final String AUTHORIZATION_HEADER = "authorization";
    protected static final StringManager sm = StringManager.getManager(TomcatAuthModule.class);
    private Class<?>[] supportedMessageTypes = new Class[]{Request.class, HttpServletResponse.class};
    protected String realmName = "Authentication required";
    protected CallbackHandler handler;
    protected Context context;
    protected boolean cache = true;
    protected boolean changeSessionIdOnAuthentication = true;

    public TomcatAuthModule(Context context) {
        this.context = context;
    }

    protected boolean isMandatory(MessageInfo messageInfo) {
        String mandatory = (String)messageInfo.getMap().get("javax.security.auth.message.MessagePolicy.isMandatory");
        return Boolean.parseBoolean(mandatory);
    }

    public final void initialize(MessagePolicy requestPolicy, MessagePolicy responsePolicy, CallbackHandler handler, Map options) throws AuthException {
        this.handler = handler;
        this.cache = Boolean.parseBoolean((String)options.get("cache"));
        this.changeSessionIdOnAuthentication = Boolean.parseBoolean((String)options.get("changeSessionIdOnAuthentication"));
        String name = (String)options.get(REALM_NAME);
        if (name != null) {
            this.realmName = name;
        }
        this.initializeModule(requestPolicy, responsePolicy, handler, options);
    }

    public String getRealmName() {
        return this.realmName;
    }

    public abstract void initializeModule(MessagePolicy var1, MessagePolicy var2, CallbackHandler var3, Map<String, String> var4) throws AuthException;

    protected void handlePrincipalCallbacks(Subject clientSubject, Principal principal) throws IOException, UnsupportedCallbackException {
        CallerPrincipalCallback principalCallback = new CallerPrincipalCallback(clientSubject, principal);
        String[] roles = this.context.getRealm().getRoles(principal);
        GroupPrincipalCallback groupCallback = new GroupPrincipalCallback(clientSubject, roles);
        this.handler.handle(new Callback[]{principalCallback, groupCallback});
    }

    protected GenericPrincipal getPrincipal(PasswordValidationCallback passwordCallback) {
        Iterator<Object> credentials = passwordCallback.getSubject().getPrivateCredentials().iterator();
        return (GenericPrincipal)credentials.next();
    }

    public Class<?>[] getSupportedMessageTypes() {
        return this.supportedMessageTypes;
    }

    public AuthStatus secureResponse(MessageInfo messageInfo, Subject serviceSubject) throws AuthException {
        return null;
    }

    public void cleanSubject(MessageInfo messageInfo, Subject subject) throws AuthException {
    }
}

