/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.connector;

import java.io.IOException;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.ReadListener;
import org.apache.catalina.security.SecurityUtil;
import org.apache.coyote.ActionCode;
import org.apache.coyote.ContainerThreadMarker;
import org.apache.coyote.Request;
import org.apache.tomcat.util.buf.B2CConverter;
import org.apache.tomcat.util.buf.ByteChunk;
import org.apache.tomcat.util.buf.CharChunk;
import org.apache.tomcat.util.collections.SynchronizedStack;
import org.apache.tomcat.util.net.ApplicationBufferHandler;
import org.apache.tomcat.util.res.StringManager;

public class InputBuffer
extends Reader
implements ByteChunk.ByteInputChannel,
CharChunk.CharInputChannel,
CharChunk.CharOutputChannel,
ApplicationBufferHandler {
    protected static final StringManager sm = StringManager.getManager(InputBuffer.class);
    public static final int DEFAULT_BUFFER_SIZE = 8192;
    public final int INITIAL_STATE = 0;
    public final int CHAR_STATE = 1;
    public final int BYTE_STATE = 2;
    private static final Map<Charset, SynchronizedStack<B2CConverter>> encoders = new ConcurrentHashMap<Charset, SynchronizedStack<B2CConverter>>();
    private final ByteChunk bb;
    private ByteBuffer tempRead;
    private CharChunk cb;
    private int state = 0;
    private boolean closed = false;
    private String enc;
    protected B2CConverter conv;
    private Request coyoteRequest;
    private int markPos = -1;
    private final int size;

    public InputBuffer() {
        this(8192);
    }

    public InputBuffer(int size) {
        this.size = size;
        this.tempRead = ByteBuffer.allocate(size);
        this.tempRead.flip();
        this.bb = new ByteChunk(size);
        this.bb.setLimit(size);
        this.bb.setByteInputChannel((ByteChunk.ByteInputChannel)this);
        this.cb = new CharChunk(size);
        this.cb.setLimit(size);
        this.cb.setOptimizedWrite(false);
        this.cb.setCharInputChannel((CharChunk.CharInputChannel)this);
        this.cb.setCharOutputChannel((CharChunk.CharOutputChannel)this);
    }

    public void setRequest(Request coyoteRequest) {
        this.coyoteRequest = coyoteRequest;
    }

    public void recycle() {
        this.state = 0;
        if (this.cb.getChars().length > this.size) {
            this.cb = new CharChunk(this.size);
            this.cb.setLimit(this.size);
            this.cb.setOptimizedWrite(false);
            this.cb.setCharInputChannel((CharChunk.CharInputChannel)this);
            this.cb.setCharOutputChannel((CharChunk.CharOutputChannel)this);
        } else {
            this.cb.recycle();
        }
        this.markPos = -1;
        this.bb.recycle();
        this.closed = false;
        if (this.conv != null) {
            this.conv.recycle();
            encoders.get(this.conv.getCharset()).push((Object)this.conv);
            this.conv = null;
        }
        this.enc = null;
    }

    @Override
    public void close() throws IOException {
        this.closed = true;
    }

    public int available() {
        int available = 0;
        if (this.state == 2) {
            available = this.bb.getLength();
        } else if (this.state == 1) {
            available = this.cb.getLength();
        }
        if (available == 0) {
            this.coyoteRequest.action(ActionCode.AVAILABLE, (Object)(this.coyoteRequest.getReadListener() != null ? 1 : 0));
            available = this.coyoteRequest.getAvailable() > 0 ? 1 : 0;
        }
        return available;
    }

    public void setReadListener(ReadListener listener) {
        this.coyoteRequest.setReadListener(listener);
        if (!this.coyoteRequest.isFinished() && this.isReady()) {
            this.coyoteRequest.action(ActionCode.DISPATCH_READ, null);
            if (!ContainerThreadMarker.isContainerThread()) {
                this.coyoteRequest.action(ActionCode.DISPATCH_EXECUTE, null);
            }
        }
    }

    public boolean isFinished() {
        int available = 0;
        if (this.state == 2) {
            available = this.bb.getLength();
        } else if (this.state == 1) {
            available = this.cb.getLength();
        }
        if (available > 0) {
            return false;
        }
        return this.coyoteRequest.isFinished();
    }

    public boolean isReady() {
        boolean result;
        if (this.coyoteRequest.getReadListener() == null) {
            throw new IllegalStateException(sm.getString("inputBuffer.requiresNonBlocking"));
        }
        if (this.isFinished()) {
            if (!ContainerThreadMarker.isContainerThread()) {
                this.coyoteRequest.action(ActionCode.DISPATCH_READ, null);
                this.coyoteRequest.action(ActionCode.DISPATCH_EXECUTE, null);
            }
            return false;
        }
        boolean bl = result = this.available() > 0;
        if (!result) {
            this.coyoteRequest.action(ActionCode.NB_READ_INTEREST, null);
        }
        return result;
    }

    boolean isBlocking() {
        return this.coyoteRequest.getReadListener() == null;
    }

    public int realReadBytes() throws IOException {
        if (this.closed) {
            return -1;
        }
        if (this.coyoteRequest == null) {
            return -1;
        }
        if (this.state == 0) {
            this.state = 2;
        }
        int result = this.coyoteRequest.doRead((ApplicationBufferHandler)this);
        this.bb.setBytes(this.tempRead.array(), this.tempRead.arrayOffset() + this.tempRead.position(), this.tempRead.remaining());
        this.tempRead.position(0).limit(0);
        return result;
    }

    public int readByte() throws IOException {
        if (this.closed) {
            throw new IOException(sm.getString("inputBuffer.streamClosed"));
        }
        return this.bb.substract();
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (this.closed) {
            throw new IOException(sm.getString("inputBuffer.streamClosed"));
        }
        return this.bb.substract(b, off, len);
    }

    public int read(ByteBuffer b) throws IOException {
        if (this.closed) {
            throw new IOException(sm.getString("inputBuffer.streamClosed"));
        }
        return this.bb.substract(b);
    }

    public void realWriteChars(char[] c, int off, int len) throws IOException {
        this.markPos = -1;
        this.cb.setOffset(0);
        this.cb.setEnd(0);
    }

    public void setEncoding(String s) {
        this.enc = s;
    }

    public int realReadChars() throws IOException {
        int nRead;
        this.checkConverter();
        boolean eof = false;
        if (this.bb.getLength() <= 0 && (nRead = this.realReadBytes()) < 0) {
            eof = true;
        }
        if (this.markPos == -1) {
            this.cb.setOffset(0);
            this.cb.setEnd(0);
        } else {
            this.cb.makeSpace(this.bb.getLength());
            if (this.cb.getBuffer().length - this.cb.getEnd() == 0 && this.bb.getLength() != 0) {
                this.cb.setOffset(0);
                this.cb.setEnd(0);
                this.markPos = -1;
            }
        }
        this.state = 1;
        this.conv.convert(this.bb, this.cb, eof);
        if (this.cb.getLength() == 0 && eof) {
            return -1;
        }
        return this.cb.getLength();
    }

    @Override
    public int read() throws IOException {
        if (this.closed) {
            throw new IOException(sm.getString("inputBuffer.streamClosed"));
        }
        return this.cb.substract();
    }

    @Override
    public int read(char[] cbuf) throws IOException {
        if (this.closed) {
            throw new IOException(sm.getString("inputBuffer.streamClosed"));
        }
        return this.read(cbuf, 0, cbuf.length);
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        if (this.closed) {
            throw new IOException(sm.getString("inputBuffer.streamClosed"));
        }
        return this.cb.substract(cbuf, off, len);
    }

    @Override
    public long skip(long n) throws IOException {
        if (this.closed) {
            throw new IOException(sm.getString("inputBuffer.streamClosed"));
        }
        if (n < 0L) {
            throw new IllegalArgumentException();
        }
        long nRead = 0L;
        while (nRead < n) {
            if ((long)this.cb.getLength() >= n) {
                this.cb.setOffset(this.cb.getStart() + (int)n);
                nRead = n;
                continue;
            }
            nRead += (long)this.cb.getLength();
            this.cb.setOffset(this.cb.getEnd());
            int nb = this.realReadChars();
            if (nb >= 0) continue;
            break;
        }
        return nRead;
    }

    @Override
    public boolean ready() throws IOException {
        if (this.closed) {
            throw new IOException(sm.getString("inputBuffer.streamClosed"));
        }
        if (this.state == 0) {
            this.state = 1;
        }
        return this.available() > 0;
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public void mark(int readAheadLimit) throws IOException {
        if (this.closed) {
            throw new IOException(sm.getString("inputBuffer.streamClosed"));
        }
        if (this.cb.getLength() <= 0) {
            this.cb.setOffset(0);
            this.cb.setEnd(0);
        } else if (this.cb.getBuffer().length > 2 * this.size && this.cb.getLength() < this.cb.getStart()) {
            System.arraycopy(this.cb.getBuffer(), this.cb.getStart(), this.cb.getBuffer(), 0, this.cb.getLength());
            this.cb.setEnd(this.cb.getLength());
            this.cb.setOffset(0);
        }
        this.cb.setLimit(this.cb.getStart() + readAheadLimit + this.size);
        this.markPos = this.cb.getStart();
    }

    @Override
    public void reset() throws IOException {
        if (this.closed) {
            throw new IOException(sm.getString("inputBuffer.streamClosed"));
        }
        if (this.state == 1) {
            if (this.markPos < 0) {
                this.cb.recycle();
                this.markPos = -1;
                throw new IOException();
            }
            this.cb.setOffset(this.markPos);
        } else {
            this.bb.recycle();
        }
    }

    public void checkConverter() throws IOException {
        if (this.conv == null) {
            this.setConverter();
        }
    }

    private void setConverter() throws IOException {
        Charset charset;
        SynchronizedStack<B2CConverter> stack;
        if (this.coyoteRequest != null) {
            this.enc = this.coyoteRequest.getCharacterEncoding();
        }
        if (this.enc == null) {
            this.enc = "ISO-8859-1";
        }
        if ((stack = encoders.get(charset = B2CConverter.getCharset((String)this.enc))) == null) {
            stack = new SynchronizedStack<B2CConverter>();
            encoders.putIfAbsent(charset, stack);
            stack = encoders.get(charset);
        }
        this.conv = (B2CConverter)stack.pop();
        if (this.conv == null) {
            this.conv = InputBuffer.createConverter(charset);
        }
    }

    private static B2CConverter createConverter(final Charset charset) throws IOException {
        if (SecurityUtil.isPackageProtectionEnabled()) {
            try {
                return AccessController.doPrivileged(new PrivilegedExceptionAction<B2CConverter>(){

                    @Override
                    public B2CConverter run() throws IOException {
                        return new B2CConverter(charset);
                    }
                });
            }
            catch (PrivilegedActionException ex) {
                Exception e = ex.getException();
                if (e instanceof IOException) {
                    throw (IOException)e;
                }
                throw new IOException(e);
            }
        }
        return new B2CConverter(charset);
    }

    public void setByteBuffer(ByteBuffer buffer) {
        this.tempRead = buffer;
    }

    public ByteBuffer getByteBuffer() {
        return this.tempRead;
    }

    public void expand(int size) {
    }
}

