/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import javax.servlet.http.Mapping;
import javax.servlet.http.MappingMatch;
import org.apache.catalina.mapper.MappingData;

public class ApplicationMapping {
    private final MappingData mappingData;
    private volatile Mapping mapping = null;

    public ApplicationMapping(MappingData mappingData) {
        this.mappingData = mappingData;
    }

    public Mapping getMapping() {
        if (this.mapping == null) {
            switch (this.mappingData.matchType) {
                case CONTEXT_ROOT: {
                    this.mapping = new MappingImpl("", "", this.mappingData.matchType);
                    break;
                }
                case DEFAULT: {
                    this.mapping = new MappingImpl("/", "/", this.mappingData.matchType);
                    break;
                }
                case EXACT: {
                    this.mapping = new MappingImpl(this.mappingData.wrapperPath.toString(), this.mappingData.wrapperPath.toString(), this.mappingData.matchType);
                    break;
                }
                case EXTENSION: {
                    String path = this.mappingData.wrapperPath.toString();
                    int extIndex = path.lastIndexOf(46);
                    this.mapping = new MappingImpl(path.substring(0, extIndex), "*" + path.substring(extIndex), this.mappingData.matchType);
                    break;
                }
                case PATH: {
                    this.mapping = new MappingImpl(this.mappingData.pathInfo.toString(), this.mappingData.wrapperPath.toString() + "/*", this.mappingData.matchType);
                    break;
                }
                case IMPLICIT: 
                case UNKNOWN: {
                    this.mapping = new MappingImpl("", "", this.mappingData.matchType);
                }
            }
        }
        return this.mapping;
    }

    public void recycle() {
        this.mapping = null;
    }

    private static class MappingImpl
    implements Mapping {
        private final String matchValue;
        private final String pattern;
        private final MappingMatch mappingType;

        public MappingImpl(String matchValue, String pattern, MappingMatch mappingType) {
            this.matchValue = matchValue;
            this.pattern = pattern;
            this.mappingType = mappingType;
        }

        public String getMatchValue() {
            return this.matchValue;
        }

        public String getPattern() {
            return this.pattern;
        }

        public MappingMatch getMatchType() {
            return this.mappingType;
        }
    }
}

