/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.net;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.RejectedExecutionException;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.jni.Address;
import org.apache.tomcat.jni.Error;
import org.apache.tomcat.jni.File;
import org.apache.tomcat.jni.Library;
import org.apache.tomcat.jni.OS;
import org.apache.tomcat.jni.Poll;
import org.apache.tomcat.jni.Pool;
import org.apache.tomcat.jni.SSL;
import org.apache.tomcat.jni.SSLContext;
import org.apache.tomcat.jni.SSLSocket;
import org.apache.tomcat.jni.Socket;
import org.apache.tomcat.jni.Status;
import org.apache.tomcat.util.ExceptionUtils;
import org.apache.tomcat.util.net.AbstractEndpoint;
import org.apache.tomcat.util.net.SocketStatus;
import org.apache.tomcat.util.net.SocketWrapper;

public class AprEndpoint
extends AbstractEndpoint {
    private static final Log log = LogFactory.getLog(AprEndpoint.class);
    private static final boolean IS_SECURITY_ENABLED = System.getSecurityManager() != null;
    protected long rootPool = 0L;
    protected long serverSock = 0L;
    protected long serverSockPool = 0L;
    protected long sslContext = 0L;
    private Acceptor[] acceptors = null;
    protected ConcurrentLinkedQueue<SocketWrapper<Long>> waitingRequests = new ConcurrentLinkedQueue();
    protected boolean deferAccept = true;
    protected int sendfileSize = 1024;
    protected Handler handler = null;
    protected int pollTime = 2000;
    protected boolean useSendfile = Library.APR_HAS_SENDFILE;
    protected boolean useComet = true;
    protected int acceptorThreadCount = 0;
    protected int sendfileThreadCount = 0;
    protected int pollerThreadCount = 0;
    protected Poller[] pollers = null;
    protected int pollerRoundRobin = 0;
    protected Poller[] cometPollers = null;
    protected int cometPollerRoundRobin = 0;
    protected Sendfile[] sendfiles = null;
    protected int sendfileRoundRobin = 0;
    protected String SSLProtocol = "all";
    protected String SSLPassword = null;
    protected String SSLCipherSuite = "ALL";
    protected String SSLCertificateFile = null;
    protected String SSLCertificateKeyFile = null;
    protected String SSLCertificateChainFile = null;
    protected String SSLCACertificatePath = null;
    protected String SSLCACertificateFile = null;
    protected String SSLCARevocationPath = null;
    protected String SSLCARevocationFile = null;
    protected String SSLVerifyClient = "none";
    protected int SSLVerifyDepth = 10;
    protected boolean SSLInsecureRenegotiation = false;

    public AprEndpoint() {
        this.setMaxConnections(8192);
    }

    public void setDeferAccept(boolean deferAccept) {
        this.deferAccept = deferAccept;
    }

    @Override
    public boolean getDeferAccept() {
        return this.deferAccept;
    }

    public void setSendfileSize(int sendfileSize) {
        this.sendfileSize = sendfileSize;
    }

    public int getSendfileSize() {
        return this.sendfileSize;
    }

    public void setHandler(Handler handler) {
        this.handler = handler;
    }

    public Handler getHandler() {
        return this.handler;
    }

    public int getPollTime() {
        return this.pollTime;
    }

    public void setPollTime(int pollTime) {
        if (pollTime > 0) {
            this.pollTime = pollTime;
        }
    }

    public void setUseSendfile(boolean useSendfile) {
        this.useSendfile = useSendfile;
    }

    @Override
    public boolean getUseSendfile() {
        return this.useSendfile;
    }

    public void setUseComet(boolean useComet) {
        this.useComet = useComet;
    }

    public boolean getUseComet() {
        return this.useComet;
    }

    public void setAcceptorThreadCount(int acceptorThreadCount) {
        this.acceptorThreadCount = acceptorThreadCount;
    }

    public int getAcceptorThreadCount() {
        return this.acceptorThreadCount;
    }

    public void setSendfileThreadCount(int sendfileThreadCount) {
        this.sendfileThreadCount = sendfileThreadCount;
    }

    public int getSendfileThreadCount() {
        return this.sendfileThreadCount;
    }

    public void setPollerThreadCount(int pollerThreadCount) {
        this.pollerThreadCount = pollerThreadCount;
    }

    public int getPollerThreadCount() {
        return this.pollerThreadCount;
    }

    public Poller getPoller() {
        this.pollerRoundRobin = (this.pollerRoundRobin + 1) % this.pollers.length;
        return this.pollers[this.pollerRoundRobin];
    }

    public Poller getCometPoller() {
        this.cometPollerRoundRobin = (this.cometPollerRoundRobin + 1) % this.cometPollers.length;
        return this.cometPollers[this.cometPollerRoundRobin];
    }

    public Sendfile getSendfile() {
        this.sendfileRoundRobin = (this.sendfileRoundRobin + 1) % this.sendfiles.length;
        return this.sendfiles[this.sendfileRoundRobin];
    }

    public String getSSLProtocol() {
        return this.SSLProtocol;
    }

    public void setSSLProtocol(String SSLProtocol) {
        this.SSLProtocol = SSLProtocol;
    }

    public String getSSLPassword() {
        return this.SSLPassword;
    }

    public void setSSLPassword(String SSLPassword) {
        this.SSLPassword = SSLPassword;
    }

    public String getSSLCipherSuite() {
        return this.SSLCipherSuite;
    }

    public void setSSLCipherSuite(String SSLCipherSuite) {
        this.SSLCipherSuite = SSLCipherSuite;
    }

    public String getSSLCertificateFile() {
        return this.SSLCertificateFile;
    }

    public void setSSLCertificateFile(String SSLCertificateFile) {
        this.SSLCertificateFile = SSLCertificateFile;
    }

    public String getSSLCertificateKeyFile() {
        return this.SSLCertificateKeyFile;
    }

    public void setSSLCertificateKeyFile(String SSLCertificateKeyFile) {
        this.SSLCertificateKeyFile = SSLCertificateKeyFile;
    }

    public String getSSLCertificateChainFile() {
        return this.SSLCertificateChainFile;
    }

    public void setSSLCertificateChainFile(String SSLCertificateChainFile) {
        this.SSLCertificateChainFile = SSLCertificateChainFile;
    }

    public String getSSLCACertificatePath() {
        return this.SSLCACertificatePath;
    }

    public void setSSLCACertificatePath(String SSLCACertificatePath) {
        this.SSLCACertificatePath = SSLCACertificatePath;
    }

    public String getSSLCACertificateFile() {
        return this.SSLCACertificateFile;
    }

    public void setSSLCACertificateFile(String SSLCACertificateFile) {
        this.SSLCACertificateFile = SSLCACertificateFile;
    }

    public String getSSLCARevocationPath() {
        return this.SSLCARevocationPath;
    }

    public void setSSLCARevocationPath(String SSLCARevocationPath) {
        this.SSLCARevocationPath = SSLCARevocationPath;
    }

    public String getSSLCARevocationFile() {
        return this.SSLCARevocationFile;
    }

    public void setSSLCARevocationFile(String SSLCARevocationFile) {
        this.SSLCARevocationFile = SSLCARevocationFile;
    }

    public String getSSLVerifyClient() {
        return this.SSLVerifyClient;
    }

    public void setSSLVerifyClient(String SSLVerifyClient) {
        this.SSLVerifyClient = SSLVerifyClient;
    }

    public int getSSLVerifyDepth() {
        return this.SSLVerifyDepth;
    }

    public void setSSLVerifyDepth(int SSLVerifyDepth) {
        this.SSLVerifyDepth = SSLVerifyDepth;
    }

    public void setSSLInsecureRenegotiation(boolean SSLInsecureRenegotiation) {
        this.SSLInsecureRenegotiation = SSLInsecureRenegotiation;
    }

    public boolean getSSLInsecureRenegotiation() {
        return this.SSLInsecureRenegotiation;
    }

    public int getKeepAliveCount() {
        if (this.pollers == null) {
            return 0;
        }
        int keepAliveCount = 0;
        for (int i = 0; i < this.pollers.length; ++i) {
            keepAliveCount += this.pollers[i].getKeepAliveCount();
        }
        return keepAliveCount;
    }

    public int getSendfileCount() {
        if (this.sendfiles == null) {
            return 0;
        }
        int sendfileCount = 0;
        for (int i = 0; i < this.sendfiles.length; ++i) {
            sendfileCount += this.sendfiles[i].getSendfileCount();
        }
        return sendfileCount;
    }

    @Override
    public void bind() throws Exception {
        try {
            this.rootPool = Pool.create(0L);
        }
        catch (UnsatisfiedLinkError e) {
            throw new Exception(sm.getString("endpoint.init.notavail"));
        }
        this.serverSockPool = Pool.create(this.rootPool);
        String addressStr = null;
        if (this.getAddress() != null) {
            addressStr = this.getAddress().getHostAddress();
        }
        int family = 1;
        if (Library.APR_HAVE_IPV6) {
            if (addressStr == null) {
                if (!(OS.IS_BSD || OS.IS_WIN32 || OS.IS_WIN64)) {
                    family = 0;
                }
            } else if (addressStr.indexOf(58) >= 0) {
                family = 0;
            }
        }
        long inetAddress = Address.info(addressStr, family, this.getPort(), 0, this.rootPool);
        this.serverSock = Socket.create(Address.getInfo((long)inetAddress).family, 0, 6, this.rootPool);
        if (OS.IS_UNIX) {
            Socket.optSet(this.serverSock, 16, 1);
        }
        Socket.optSet(this.serverSock, 2, 1);
        int ret = Socket.bind(this.serverSock, inetAddress);
        if (ret != 0) {
            throw new Exception(sm.getString("endpoint.init.bind", new Object[]{"" + ret, Error.strerror(ret)}));
        }
        ret = Socket.listen(this.serverSock, this.getBacklog());
        if (ret != 0) {
            throw new Exception(sm.getString("endpoint.init.listen", new Object[]{"" + ret, Error.strerror(ret)}));
        }
        if (OS.IS_WIN32 || OS.IS_WIN64) {
            Socket.optSet(this.serverSock, 16, 1);
        }
        if (this.useSendfile && !Library.APR_HAS_SENDFILE) {
            this.useSendfile = false;
        }
        if (this.acceptorThreadCount == 0) {
            this.acceptorThreadCount = 1;
        }
        if (this.pollerThreadCount == 0) {
            if ((OS.IS_WIN32 || OS.IS_WIN64) && this.getMaxConnections() > 1024) {
                this.pollerThreadCount = this.getMaxConnections() / 1024;
                this.setMaxConnections(this.getMaxConnections() - this.getMaxConnections() % 1024);
            } else {
                this.pollerThreadCount = 1;
            }
        }
        if (this.sendfileThreadCount == 0) {
            if ((OS.IS_WIN32 || OS.IS_WIN64) && this.sendfileSize > 1024) {
                this.sendfileThreadCount = this.sendfileSize / 1024;
                this.sendfileSize -= this.sendfileSize % 1024;
            } else {
                this.sendfileThreadCount = 1;
            }
        }
        if (this.deferAccept && Socket.optSet(this.serverSock, 32768, 1) == 70023) {
            this.deferAccept = false;
        }
        if (this.isSSLEnabled()) {
            if (this.SSLCertificateFile == null) {
                throw new Exception(sm.getString("endpoint.apr.noSslCertFile"));
            }
            int value = 7;
            if ("SSLv2".equalsIgnoreCase(this.SSLProtocol)) {
                value = 1;
            } else if ("SSLv3".equalsIgnoreCase(this.SSLProtocol)) {
                value = 2;
            } else if ("TLSv1".equalsIgnoreCase(this.SSLProtocol)) {
                value = 4;
            } else if ("SSLv2+SSLv3".equalsIgnoreCase(this.SSLProtocol)) {
                value = 3;
            } else if (!"all".equalsIgnoreCase(this.SSLProtocol) && this.SSLProtocol != null && this.SSLProtocol.length() != 0) {
                throw new Exception(sm.getString("endpoint.apr.invalidSslProtocol", new Object[]{this.SSLProtocol}));
            }
            this.sslContext = SSLContext.make(this.rootPool, value, 1);
            if (this.SSLInsecureRenegotiation) {
                boolean legacyRenegSupported = false;
                try {
                    legacyRenegSupported = SSL.hasOp(262144);
                    if (legacyRenegSupported) {
                        SSLContext.setOptions(this.sslContext, 262144);
                    }
                }
                catch (UnsatisfiedLinkError e) {
                    // empty catch block
                }
                if (!legacyRenegSupported) {
                    log.warn((Object)sm.getString("endpoint.warn.noInsecureReneg", new Object[]{SSL.versionString()}));
                }
            }
            SSLContext.setCipherSuite(this.sslContext, this.SSLCipherSuite);
            SSLContext.setCertificate(this.sslContext, this.SSLCertificateFile, this.SSLCertificateKeyFile, this.SSLPassword, 0);
            SSLContext.setCertificateChainFile(this.sslContext, this.SSLCertificateChainFile, false);
            SSLContext.setCACertificate(this.sslContext, this.SSLCACertificateFile, this.SSLCACertificatePath);
            SSLContext.setCARevocation(this.sslContext, this.SSLCARevocationFile, this.SSLCARevocationPath);
            value = 0;
            if ("optional".equalsIgnoreCase(this.SSLVerifyClient)) {
                value = 1;
            } else if ("require".equalsIgnoreCase(this.SSLVerifyClient)) {
                value = 2;
            } else if ("optionalNoCA".equalsIgnoreCase(this.SSLVerifyClient)) {
                value = 3;
            }
            SSLContext.setVerify(this.sslContext, value, this.SSLVerifyDepth);
            this.useSendfile = false;
        }
    }

    @Override
    public void startInternal() throws Exception {
        if (!this.running) {
            int i;
            this.running = true;
            this.paused = false;
            if (this.getExecutor() == null) {
                this.createExecutor();
            }
            this.initializeConnectionLatch();
            this.pollers = new Poller[this.pollerThreadCount];
            for (i = 0; i < this.pollerThreadCount; ++i) {
                this.pollers[i] = new Poller(false);
                this.pollers[i].init();
                this.pollers[i].setName(this.getName() + "-Poller-" + i);
                this.pollers[i].setPriority(this.threadPriority);
                this.pollers[i].setDaemon(true);
                this.pollers[i].start();
            }
            this.cometPollers = new Poller[this.pollerThreadCount];
            for (i = 0; i < this.pollerThreadCount; ++i) {
                this.cometPollers[i] = new Poller(true);
                this.cometPollers[i].init();
                this.cometPollers[i].setName(this.getName() + "-CometPoller-" + i);
                this.cometPollers[i].setPriority(this.threadPriority);
                this.cometPollers[i].setDaemon(true);
                this.cometPollers[i].start();
            }
            if (this.useSendfile) {
                this.sendfiles = new Sendfile[this.sendfileThreadCount];
                for (i = 0; i < this.sendfileThreadCount; ++i) {
                    this.sendfiles[i] = new Sendfile();
                    this.sendfiles[i].init();
                    this.sendfiles[i].setName(this.getName() + "-Sendfile-" + i);
                    this.sendfiles[i].setPriority(this.threadPriority);
                    this.sendfiles[i].setDaemon(true);
                    this.sendfiles[i].start();
                }
            }
            this.acceptors = new Acceptor[this.acceptorThreadCount];
            for (i = 0; i < this.acceptorThreadCount; ++i) {
                this.acceptors[i] = new Acceptor();
                this.acceptors[i].setName(this.getName() + "-Acceptor-" + i);
                this.acceptors[i].setPriority(this.threadPriority);
                this.acceptors[i].setDaemon(this.getDaemon());
                this.acceptors[i].start();
            }
            Thread timeoutThread = new Thread((Runnable)new AsyncTimeout(), this.getName() + "-AsyncTimeout");
            timeoutThread.setPriority(this.threadPriority);
            timeoutThread.setDaemon(true);
            timeoutThread.start();
        }
    }

    @Override
    public void stopInternal() {
        this.releaseConnectionLatch();
        if (!this.paused) {
            this.pause();
        }
        if (this.running) {
            int i;
            this.running = false;
            this.unlockAccept();
            for (i = 0; i < this.acceptors.length; ++i) {
                long s = System.currentTimeMillis() + 30000L;
                while (this.acceptors[i].isAlive()) {
                    try {
                        this.acceptors[i].interrupt();
                        this.acceptors[i].join(1000L);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                    if (System.currentTimeMillis() < s) continue;
                    log.warn((Object)sm.getString("endpoint.warn.unlockAcceptorFailed", new Object[]{this.acceptors[i].getName()}));
                    if (this.serverSock == 0L) continue;
                    Socket.shutdown(this.serverSock, 0);
                    this.serverSock = 0L;
                }
            }
            for (i = 0; i < this.pollers.length; ++i) {
                try {
                    this.pollers[i].destroy();
                    continue;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            this.pollers = null;
            for (i = 0; i < this.cometPollers.length; ++i) {
                try {
                    this.cometPollers[i].destroy();
                    continue;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            this.cometPollers = null;
            if (this.useSendfile) {
                for (i = 0; i < this.sendfiles.length; ++i) {
                    try {
                        this.sendfiles[i].destroy();
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                this.sendfiles = null;
            }
        }
        this.shutdownExecutor();
    }

    @Override
    public void unbind() throws Exception {
        if (this.running) {
            this.stop();
        }
        if (this.serverSockPool != 0L) {
            Pool.destroy(this.serverSockPool);
            this.serverSockPool = 0L;
        }
        if (this.serverSock != 0L) {
            Socket.close(this.serverSock);
            this.serverSock = 0L;
        }
        this.sslContext = 0L;
        if (this.rootPool != 0L) {
            Pool.destroy(this.rootPool);
            this.rootPool = 0L;
        }
        this.handler.recycle();
    }

    protected boolean setSocketOptions(long socket) {
        int step = 1;
        try {
            if (this.socketProperties.getSoLingerOn() && this.socketProperties.getSoLingerTime() >= 0) {
                Socket.optSet(socket, 1, this.socketProperties.getSoLingerTime());
            }
            if (this.socketProperties.getTcpNoDelay()) {
                Socket.optSet(socket, 512, this.socketProperties.getTcpNoDelay() ? 1 : 0);
            }
            if (this.socketProperties.getSoTimeout() > 0) {
                Socket.timeoutSet(socket, this.socketProperties.getSoTimeout() * 1000);
            }
            step = 2;
            if (this.sslContext != 0L) {
                SSLSocket.attach(this.sslContext, socket);
                if (SSLSocket.handshake(socket) != 0) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)(sm.getString("endpoint.err.handshake") + ": " + SSL.getLastError()));
                    }
                    return false;
                }
            }
        }
        catch (Throwable t) {
            ExceptionUtils.handleThrowable(t);
            if (log.isDebugEnabled()) {
                if (step == 2) {
                    log.debug((Object)sm.getString("endpoint.err.handshake"), t);
                } else {
                    log.debug((Object)sm.getString("endpoint.err.unexpected"), t);
                }
            }
            return false;
        }
        return true;
    }

    protected long allocatePoller(int size, long pool, int timeout) {
        try {
            return Poll.create(size, pool, 0, timeout * 1000);
        }
        catch (Error e) {
            if (Status.APR_STATUS_IS_EINVAL(e.getError())) {
                log.info((Object)sm.getString("endpoint.poll.limitedpollsize", new Object[]{"" + size}));
                return 0L;
            }
            log.error((Object)sm.getString("endpoint.poll.initfail"), (Throwable)e);
            return -1L;
        }
    }

    protected boolean processSocketWithOptions(long socket) {
        try {
            if (this.running) {
                SocketWrapper<Long> wrapper = new SocketWrapper<Long>(socket);
                this.getExecutor().execute(new SocketWithOptionsProcessor(wrapper));
            }
        }
        catch (RejectedExecutionException x) {
            log.warn((Object)("Socket processing request was rejected for:" + socket), (Throwable)x);
            return false;
        }
        catch (Throwable t) {
            ExceptionUtils.handleThrowable(t);
            log.error((Object)sm.getString("endpoint.process.fail"), t);
            return false;
        }
        return true;
    }

    protected boolean processSocket(long socket) {
        try {
            SocketWrapper<Long> wrapper = new SocketWrapper<Long>(socket);
            this.getExecutor().execute(new SocketProcessor(wrapper, null));
        }
        catch (RejectedExecutionException x) {
            log.warn((Object)("Socket processing request was rejected for:" + socket), (Throwable)x);
            return false;
        }
        catch (Throwable t) {
            ExceptionUtils.handleThrowable(t);
            log.error((Object)sm.getString("endpoint.process.fail"), t);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean processSocket(long socket, SocketStatus status) {
        block10: {
            try {
                PrivilegedSetTccl pa;
                if (status != SocketStatus.OPEN && status != SocketStatus.STOP && status != SocketStatus.TIMEOUT) break block10;
                SocketWrapper<Long> wrapper = new SocketWrapper<Long>(socket);
                SocketEventProcessor proc = new SocketEventProcessor(wrapper, status);
                ClassLoader loader = Thread.currentThread().getContextClassLoader();
                try {
                    if (IS_SECURITY_ENABLED) {
                        pa = new PrivilegedSetTccl(this.getClass().getClassLoader());
                        AccessController.doPrivileged(pa);
                    } else {
                        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
                    }
                    this.getExecutor().execute(proc);
                }
                finally {
                    if (IS_SECURITY_ENABLED) {
                        pa = new PrivilegedSetTccl(loader);
                        AccessController.doPrivileged(pa);
                    } else {
                        Thread.currentThread().setContextClassLoader(loader);
                    }
                }
            }
            catch (RejectedExecutionException x) {
                log.warn((Object)("Socket processing request was rejected for:" + socket), (Throwable)x);
                return false;
            }
            catch (Throwable t) {
                ExceptionUtils.handleThrowable(t);
                log.error((Object)sm.getString("endpoint.process.fail"), t);
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean processSocketAsync(SocketWrapper<Long> socket, SocketStatus status) {
        try {
            SocketWrapper<Long> socketWrapper = socket;
            synchronized (socketWrapper) {
                if (this.waitingRequests.remove(socket)) {
                    PrivilegedSetTccl pa;
                    SocketProcessor proc = new SocketProcessor(socket, status);
                    ClassLoader loader = Thread.currentThread().getContextClassLoader();
                    try {
                        if (IS_SECURITY_ENABLED) {
                            pa = new PrivilegedSetTccl(this.getClass().getClassLoader());
                            AccessController.doPrivileged(pa);
                        } else {
                            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
                        }
                        this.getExecutor().execute(proc);
                    }
                    finally {
                        if (IS_SECURITY_ENABLED) {
                            pa = new PrivilegedSetTccl(loader);
                            AccessController.doPrivileged(pa);
                        } else {
                            Thread.currentThread().setContextClassLoader(loader);
                        }
                    }
                }
            }
        }
        catch (RejectedExecutionException x) {
            log.warn((Object)("Socket processing request was rejected for:" + socket), (Throwable)x);
            return false;
        }
        catch (Throwable t) {
            ExceptionUtils.handleThrowable(t);
            log.error((Object)sm.getString("endpoint.process.fail"), t);
            return false;
        }
        return true;
    }

    private void destroySocket(long socket) {
        if (this.running && socket != 0L) {
            Socket.destroy(socket);
            this.countDownConnection();
        }
    }

    @Override
    protected Log getLog() {
        return log;
    }

    private static class PrivilegedSetTccl
    implements PrivilegedAction<Void> {
        private ClassLoader cl;

        PrivilegedSetTccl(ClassLoader cl) {
            this.cl = cl;
        }

        @Override
        public Void run() {
            Thread.currentThread().setContextClassLoader(this.cl);
            return null;
        }
    }

    protected class SocketEventProcessor
    implements Runnable {
        protected SocketWrapper<Long> socket = null;
        protected SocketStatus status = null;

        public SocketEventProcessor(SocketWrapper<Long> socket, SocketStatus status) {
            this.socket = socket;
            this.status = status;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            SocketWrapper<Long> socketWrapper = this.socket;
            synchronized (socketWrapper) {
                AbstractEndpoint.Handler.SocketState state = AprEndpoint.this.handler.event(this.socket, this.status);
                if (state == AbstractEndpoint.Handler.SocketState.CLOSED) {
                    AprEndpoint.this.destroySocket(this.socket.getSocket());
                    this.socket = null;
                }
            }
        }
    }

    protected class SocketProcessor
    implements Runnable {
        protected SocketWrapper<Long> socket = null;
        protected SocketStatus status = null;

        public SocketProcessor(SocketWrapper<Long> socket, SocketStatus status) {
            this.socket = socket;
            this.status = status;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            SocketWrapper<Long> socketWrapper = this.socket;
            synchronized (socketWrapper) {
                AbstractEndpoint.Handler.SocketState state;
                AbstractEndpoint.Handler.SocketState socketState = state = this.status == null ? AprEndpoint.this.handler.process(this.socket) : AprEndpoint.this.handler.asyncDispatch(this.socket, this.status);
                if (state == AbstractEndpoint.Handler.SocketState.CLOSED) {
                    AprEndpoint.this.destroySocket(this.socket.getSocket());
                    this.socket = null;
                } else if (state == AbstractEndpoint.Handler.SocketState.LONG) {
                    this.socket.access();
                    if (this.socket.async) {
                        AprEndpoint.this.waitingRequests.add(this.socket);
                    }
                } else if (state == AbstractEndpoint.Handler.SocketState.ASYNC_END) {
                    this.socket.access();
                    SocketProcessor proc = new SocketProcessor(this.socket, SocketStatus.OPEN);
                    AprEndpoint.this.getExecutor().execute(proc);
                }
            }
        }
    }

    protected class SocketWithOptionsProcessor
    implements Runnable {
        protected SocketWrapper<Long> socket = null;

        public SocketWithOptionsProcessor(SocketWrapper<Long> socket) {
            this.socket = socket;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            SocketWrapper<Long> socketWrapper = this.socket;
            synchronized (socketWrapper) {
                if (!AprEndpoint.this.deferAccept) {
                    if (AprEndpoint.this.setSocketOptions(this.socket.getSocket())) {
                        AprEndpoint.this.getPoller().add(this.socket.getSocket());
                    } else {
                        AprEndpoint.this.destroySocket(this.socket.getSocket());
                        this.socket = null;
                    }
                } else {
                    if (!AprEndpoint.this.setSocketOptions(this.socket.getSocket())) {
                        AprEndpoint.this.destroySocket(this.socket.getSocket());
                        this.socket = null;
                        return;
                    }
                    AbstractEndpoint.Handler.SocketState state = AprEndpoint.this.handler.process(this.socket);
                    if (state == AbstractEndpoint.Handler.SocketState.CLOSED) {
                        AprEndpoint.this.destroySocket(this.socket.getSocket());
                        this.socket = null;
                    } else if (state == AbstractEndpoint.Handler.SocketState.LONG) {
                        this.socket.access();
                        if (this.socket.async) {
                            AprEndpoint.this.waitingRequests.add(this.socket);
                        }
                    } else if (state == AbstractEndpoint.Handler.SocketState.ASYNC_END) {
                        this.socket.access();
                        SocketProcessor proc = new SocketProcessor(this.socket, SocketStatus.OPEN);
                        AprEndpoint.this.getExecutor().execute(proc);
                    }
                }
            }
        }
    }

    public static interface Handler
    extends AbstractEndpoint.Handler {
        public AbstractEndpoint.Handler.SocketState process(SocketWrapper<Long> var1);

        public AbstractEndpoint.Handler.SocketState event(SocketWrapper<Long> var1, SocketStatus var2);

        public AbstractEndpoint.Handler.SocketState asyncDispatch(SocketWrapper<Long> var1, SocketStatus var2);
    }

    public class Sendfile
    extends Thread {
        protected long sendfilePollset = 0L;
        protected long pool = 0L;
        protected long[] desc;
        protected HashMap<Long, SendfileData> sendfileData;
        protected volatile int sendfileCount;
        protected ArrayList<SendfileData> addS;
        protected volatile int addCount;

        public int getSendfileCount() {
            return this.sendfileCount;
        }

        protected void init() {
            this.pool = Pool.create(AprEndpoint.this.serverSockPool);
            int size = AprEndpoint.this.sendfileSize / AprEndpoint.this.sendfileThreadCount;
            this.sendfilePollset = AprEndpoint.this.allocatePoller(size, this.pool, AprEndpoint.this.socketProperties.getSoTimeout());
            if (this.sendfilePollset == 0L && size > 1024) {
                size = 1024;
                this.sendfilePollset = AprEndpoint.this.allocatePoller(size, this.pool, AprEndpoint.this.socketProperties.getSoTimeout());
            }
            if (this.sendfilePollset == 0L) {
                size = 62;
                this.sendfilePollset = AprEndpoint.this.allocatePoller(size, this.pool, AprEndpoint.this.socketProperties.getSoTimeout());
            }
            this.desc = new long[size * 2];
            this.sendfileData = new HashMap(size);
            this.addS = new ArrayList();
            this.addCount = 0;
        }

        public void destroy() {
            this.addCount = 0;
            for (int i = this.addS.size() - 1; i >= 0; --i) {
                SendfileData data = this.addS.get(i);
                AprEndpoint.this.destroySocket(data.socket);
            }
            this.addS.clear();
            int rv = Poll.pollset(this.sendfilePollset, this.desc);
            if (rv > 0) {
                for (int n = 0; n < rv; ++n) {
                    AprEndpoint.this.destroySocket(this.desc[n * 2 + 1]);
                }
            }
            Pool.destroy(this.pool);
            this.sendfileData.clear();
            try {
                while (this.isAlive()) {
                    this.interrupt();
                    this.join(1000L);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean add(SendfileData data) {
            block8: {
                try {
                    data.fdpool = Socket.pool(data.socket);
                    data.fd = File.open(data.fileName, 4129, 0, data.fdpool);
                    data.pos = data.start;
                    Socket.timeoutSet(data.socket, 0L);
                    do {
                        long nw;
                        if ((nw = Socket.sendfilen(data.socket, data.fd, data.pos, data.end - data.pos, 0)) < 0L) {
                            if (-nw != 120002L) {
                                AprEndpoint.this.destroySocket(data.socket);
                                data.socket = 0L;
                                return false;
                            }
                            break block8;
                        }
                        data.pos += nw;
                    } while (data.pos < data.end);
                    Pool.destroy(data.fdpool);
                    Socket.timeoutSet(data.socket, AprEndpoint.this.socketProperties.getSoTimeout() * 1000);
                    return true;
                }
                catch (Exception e) {
                    log.error((Object)AbstractEndpoint.sm.getString("endpoint.sendfile.error"), (Throwable)e);
                    return false;
                }
            }
            Sendfile sendfile = this;
            synchronized (sendfile) {
                this.addS.add(data);
                ++this.addCount;
                this.notify();
            }
            return false;
        }

        protected void remove(SendfileData data) {
            int rv = Poll.remove(this.sendfilePollset, data.socket);
            if (rv == 0) {
                --this.sendfileCount;
            }
            this.sendfileData.remove(data.socket);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            long maintainTime = 0L;
            while (AprEndpoint.this.running) {
                Sendfile e2;
                while (AprEndpoint.this.paused && AprEndpoint.this.running) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e2) {}
                }
                if (!AprEndpoint.this.running) break;
                if (this.sendfileCount < 1 && this.addCount < 1) {
                    e2 = this;
                    synchronized (e2) {
                        while (this.sendfileCount < 1 && this.addS.size() < 1 && AprEndpoint.this.running) {
                            maintainTime = 0L;
                            try {
                                this.wait();
                            }
                            catch (InterruptedException e3) {}
                        }
                    }
                }
                if (!AprEndpoint.this.running) break;
                try {
                    int errn;
                    if (this.addCount > 0) {
                        e2 = this;
                        synchronized (e2) {
                            int successCount = 0;
                            try {
                                for (int i = this.addS.size() - 1; i >= 0; --i) {
                                    SendfileData data = this.addS.get(i);
                                    int rv = Poll.add(this.sendfilePollset, data.socket, 4);
                                    if (rv == 0) {
                                        this.sendfileData.put(data.socket, data);
                                        ++successCount;
                                        continue;
                                    }
                                    log.warn((Object)AbstractEndpoint.sm.getString("endpoint.sendfile.addfail", new Object[]{"" + rv, Error.strerror(rv)}));
                                    AprEndpoint.this.destroySocket(data.socket);
                                }
                            }
                            finally {
                                this.sendfileCount += successCount;
                                this.addS.clear();
                                this.addCount = 0;
                            }
                        }
                    }
                    maintainTime += (long)AprEndpoint.this.pollTime;
                    int rv = Poll.poll(this.sendfilePollset, AprEndpoint.this.pollTime, this.desc, false);
                    if (rv > 0) {
                        for (int n = 0; n < rv; ++n) {
                            SendfileData state = this.sendfileData.get(this.desc[n * 2 + 1]);
                            if ((this.desc[n * 2] & 0x20L) == 32L || (this.desc[n * 2] & 0x10L) == 16L) {
                                this.remove(state);
                                AprEndpoint.this.destroySocket(state.socket);
                                continue;
                            }
                            long nw = Socket.sendfilen(state.socket, state.fd, state.pos, state.end - state.pos, 0);
                            if (nw < 0L) {
                                this.remove(state);
                                AprEndpoint.this.destroySocket(state.socket);
                                continue;
                            }
                            state.pos += nw;
                            if (state.pos < state.end) continue;
                            this.remove(state);
                            if (state.keepAlive) {
                                Pool.destroy(state.fdpool);
                                Socket.timeoutSet(state.socket, AprEndpoint.this.socketProperties.getSoTimeout() * 1000);
                                AprEndpoint.this.getPoller().add(state.socket);
                                continue;
                            }
                            AprEndpoint.this.destroySocket(state.socket);
                        }
                    } else if (rv < 0 && (errn = -rv) != 120001 && errn != 120003) {
                        if (errn > 120000) {
                            errn -= 120000;
                        }
                        log.error((Object)AbstractEndpoint.sm.getString("endpoint.poll.fail", new Object[]{"" + errn, Error.strerror(errn)}));
                        Sendfile state = this;
                        synchronized (state) {
                            this.destroy();
                            this.init();
                            continue;
                        }
                    }
                    if (AprEndpoint.this.socketProperties.getSoTimeout() <= 0 || maintainTime <= 1000000L || !AprEndpoint.this.running) continue;
                    rv = Poll.maintain(this.sendfilePollset, this.desc, true);
                    maintainTime = 0L;
                    if (rv <= 0) continue;
                    for (int n = 0; n < rv; ++n) {
                        SendfileData state = this.sendfileData.get(this.desc[n]);
                        this.remove(state);
                        AprEndpoint.this.destroySocket(state.socket);
                    }
                }
                catch (Throwable t) {
                    ExceptionUtils.handleThrowable(t);
                    log.error((Object)AbstractEndpoint.sm.getString("endpoint.poll.error"), t);
                }
            }
            Sendfile sendfile = this;
            synchronized (sendfile) {
                this.notifyAll();
            }
        }
    }

    public static class SendfileData {
        public String fileName;
        public long fd;
        public long fdpool;
        public long start;
        public long end;
        public long socket;
        public long pos;
        public boolean keepAlive;
    }

    public class Poller
    extends Thread {
        protected long serverPollset = 0L;
        protected long pool = 0L;
        protected long[] desc;
        protected long[] addS;
        protected volatile int addCount = 0;
        protected boolean comet = true;
        protected volatile int keepAliveCount = 0;

        public int getKeepAliveCount() {
            return this.keepAliveCount;
        }

        public Poller(boolean comet) {
            this.comet = comet;
        }

        protected void init() {
            this.pool = Pool.create(AprEndpoint.this.serverSockPool);
            int size = AprEndpoint.this.getMaxConnections() / AprEndpoint.this.pollerThreadCount;
            int timeout = AprEndpoint.this.getKeepAliveTimeout();
            if (timeout <= 0) {
                timeout = AprEndpoint.this.socketProperties.getSoTimeout();
            }
            this.serverPollset = AprEndpoint.this.allocatePoller(size, this.pool, timeout);
            if (this.serverPollset == 0L && size > 1024) {
                size = 1024;
                this.serverPollset = AprEndpoint.this.allocatePoller(size, this.pool, timeout);
            }
            if (this.serverPollset == 0L) {
                size = 62;
                this.serverPollset = AprEndpoint.this.allocatePoller(size, this.pool, timeout);
            }
            this.desc = new long[size * 2];
            this.keepAliveCount = 0;
            this.addS = new long[size];
            this.addCount = 0;
        }

        public void destroy() {
            for (int i = 0; i < this.addCount; ++i) {
                if (this.comet) {
                    AprEndpoint.this.processSocket(this.addS[i], SocketStatus.STOP);
                    continue;
                }
                AprEndpoint.this.destroySocket(this.addS[i]);
            }
            int rv = Poll.pollset(this.serverPollset, this.desc);
            if (rv > 0) {
                for (int n = 0; n < rv; ++n) {
                    if (this.comet) {
                        AprEndpoint.this.processSocket(this.desc[n * 2 + 1], SocketStatus.STOP);
                        continue;
                    }
                    AprEndpoint.this.destroySocket(this.desc[n * 2 + 1]);
                }
            }
            Pool.destroy(this.pool);
            this.keepAliveCount = 0;
            this.addCount = 0;
            try {
                while (this.isAlive()) {
                    this.interrupt();
                    this.join(1000L);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void add(long socket) {
            Poller poller = this;
            synchronized (poller) {
                if (this.addCount >= this.addS.length) {
                    if (this.comet) {
                        AprEndpoint.this.processSocket(socket, SocketStatus.ERROR);
                    } else {
                        AprEndpoint.this.destroySocket(socket);
                    }
                    return;
                }
                this.addS[this.addCount] = socket;
                ++this.addCount;
                this.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            long maintainTime = 0L;
            while (AprEndpoint.this.running) {
                Poller e2;
                while (AprEndpoint.this.paused && AprEndpoint.this.running) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e2) {}
                }
                if (!AprEndpoint.this.running) break;
                if (this.keepAliveCount < 1 && this.addCount < 1) {
                    e2 = this;
                    synchronized (e2) {
                        while (this.keepAliveCount < 1 && this.addCount < 1 && AprEndpoint.this.running) {
                            maintainTime = 0L;
                            try {
                                this.wait();
                            }
                            catch (InterruptedException e3) {}
                        }
                    }
                }
                if (!AprEndpoint.this.running) break;
                try {
                    int errn;
                    if (this.addCount > 0) {
                        e2 = this;
                        synchronized (e2) {
                            int successCount = 0;
                            try {
                                for (int i = this.addCount - 1; i >= 0; --i) {
                                    int rv = Poll.add(this.serverPollset, this.addS[i], 1);
                                    if (rv == 0) {
                                        ++successCount;
                                        continue;
                                    }
                                    if (this.comet) {
                                        AprEndpoint.this.processSocket(this.addS[i], SocketStatus.ERROR);
                                        continue;
                                    }
                                    AprEndpoint.this.destroySocket(this.addS[i]);
                                }
                            }
                            finally {
                                this.keepAliveCount += successCount;
                                this.addCount = 0;
                            }
                        }
                    }
                    maintainTime += (long)AprEndpoint.this.pollTime;
                    int rv = Poll.poll(this.serverPollset, AprEndpoint.this.pollTime, this.desc, true);
                    if (rv > 0) {
                        this.keepAliveCount -= rv;
                        for (int n = 0; n < rv; ++n) {
                            if ((this.desc[n * 2] & 0x20L) != 32L && (this.desc[n * 2] & 0x10L) != 16L && (!this.comet || AprEndpoint.this.processSocket(this.desc[n * 2 + 1], SocketStatus.OPEN)) && (this.comet || AprEndpoint.this.processSocket(this.desc[n * 2 + 1]))) continue;
                            if (this.comet) {
                                AprEndpoint.this.processSocket(this.desc[n * 2 + 1], SocketStatus.DISCONNECT);
                                continue;
                            }
                            AprEndpoint.this.destroySocket(this.desc[n * 2 + 1]);
                        }
                    } else if (rv < 0 && (errn = -rv) != 120001 && errn != 120003) {
                        if (errn > 120000) {
                            errn -= 120000;
                        }
                        log.error((Object)AbstractEndpoint.sm.getString("endpoint.poll.fail", new Object[]{"" + errn, Error.strerror(errn)}));
                        Poller poller = this;
                        synchronized (poller) {
                            this.destroy();
                            this.init();
                            continue;
                        }
                    }
                    if (AprEndpoint.this.socketProperties.getSoTimeout() <= 0 || maintainTime <= 1000000L || !AprEndpoint.this.running) continue;
                    rv = Poll.maintain(this.serverPollset, this.desc, true);
                    maintainTime = 0L;
                    if (rv <= 0) continue;
                    this.keepAliveCount -= rv;
                    for (int n = 0; n < rv; ++n) {
                        if (this.comet) {
                            AprEndpoint.this.processSocket(this.desc[n], SocketStatus.TIMEOUT);
                            continue;
                        }
                        AprEndpoint.this.destroySocket(this.desc[n]);
                    }
                }
                catch (Throwable t) {
                    ExceptionUtils.handleThrowable(t);
                    log.error((Object)AbstractEndpoint.sm.getString("endpoint.poll.error"), t);
                }
            }
            Poller poller = this;
            synchronized (poller) {
                this.notifyAll();
            }
        }
    }

    protected class AsyncTimeout
    implements Runnable {
        protected AsyncTimeout() {
        }

        @Override
        public void run() {
            while (AprEndpoint.this.running) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                long now = System.currentTimeMillis();
                for (SocketWrapper<Long> socket : AprEndpoint.this.waitingRequests) {
                    if (!socket.async) continue;
                    long access = socket.getLastAccess();
                    if (socket.getTimeout() <= 0L || now - access <= socket.getTimeout()) continue;
                    AprEndpoint.this.processSocketAsync(socket, SocketStatus.TIMEOUT);
                }
                while (AprEndpoint.this.paused && AprEndpoint.this.running) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {}
                }
            }
        }
    }

    protected class Acceptor
    extends Thread {
        private final Log log = LogFactory.getLog(Acceptor.class);

        protected Acceptor() {
        }

        @Override
        public void run() {
            int errorDelay = 0;
            while (AprEndpoint.this.running) {
                while (AprEndpoint.this.paused && AprEndpoint.this.running) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {}
                }
                if (!AprEndpoint.this.running) break;
                try {
                    AprEndpoint.this.awaitConnection();
                    long socket = 0L;
                    try {
                        socket = Socket.accept(AprEndpoint.this.serverSock);
                    }
                    catch (Exception e) {
                        errorDelay = AprEndpoint.this.handleExceptionWithDelay(errorDelay);
                        throw e;
                    }
                    errorDelay = 0;
                    AprEndpoint.this.countUpConnection();
                    if (AprEndpoint.this.deferAccept && (AprEndpoint.this.paused || !AprEndpoint.this.running)) {
                        AprEndpoint.this.destroySocket(socket);
                        continue;
                    }
                    if (AprEndpoint.this.processSocketWithOptions(socket)) continue;
                    AprEndpoint.this.destroySocket(socket);
                }
                catch (Throwable t) {
                    ExceptionUtils.handleThrowable(t);
                    if (!AprEndpoint.this.running) continue;
                    String msg = AbstractEndpoint.sm.getString("endpoint.accept.fail");
                    if (t instanceof Error) {
                        Error e = (Error)t;
                        if (e.getError() == 233) {
                            this.log.warn((Object)msg, t);
                            continue;
                        }
                        this.log.error((Object)msg, t);
                        continue;
                    }
                    this.log.error((Object)msg, t);
                }
            }
        }
    }
}

