/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.http.parser;

import org.apache.tomcat.util.http.parser.AstParameter;
import org.apache.tomcat.util.http.parser.HttpParser;
import org.apache.tomcat.util.http.parser.SimpleNode;

public class AstMediaType
extends SimpleNode {
    private static final String CHARSET = "charset";

    public AstMediaType(int id) {
        super(id);
    }

    public AstMediaType(HttpParser p, int id) {
        super(p, id);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.children[0].toString());
        sb.append('/');
        sb.append(this.children[1].toString());
        for (int i = 2; i < this.children.length; ++i) {
            sb.append(';');
            sb.append(this.children[i].toString());
        }
        return sb.toString();
    }

    public String toStringNoCharset() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.children[0].toString());
        sb.append('/');
        sb.append(this.children[1].toString());
        for (int i = 2; i < this.children.length; ++i) {
            AstParameter p = (AstParameter)this.children[i];
            if (CHARSET.equalsIgnoreCase(p.children[0].jjtGetValue().toString())) continue;
            sb.append(';');
            sb.append(p.toString());
        }
        return sb.toString();
    }

    public String getCharset() {
        for (int i = 2; i < this.children.length; ++i) {
            AstParameter p = (AstParameter)this.children[i];
            if (!CHARSET.equalsIgnoreCase(p.children[0].jjtGetValue().toString())) continue;
            return p.children[1].jjtGetValue().toString();
        }
        return null;
    }
}

