/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.http2;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.cert.X509Certificate;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.coyote.AbstractProcessor;
import org.apache.coyote.ActionCode;
import org.apache.coyote.Adapter;
import org.apache.coyote.AsyncContextCallback;
import org.apache.coyote.ContainerThreadMarker;
import org.apache.coyote.ErrorState;
import org.apache.coyote.PushToken;
import org.apache.coyote.UpgradeToken;
import org.apache.coyote.http2.ConnectionException;
import org.apache.coyote.http2.Http2Error;
import org.apache.coyote.http2.Stream;
import org.apache.coyote.http2.StreamException;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.buf.ByteChunk;
import org.apache.tomcat.util.net.AbstractEndpoint;
import org.apache.tomcat.util.net.DispatchType;
import org.apache.tomcat.util.net.SSLSupport;
import org.apache.tomcat.util.net.SocketEvent;
import org.apache.tomcat.util.net.SocketWrapperBase;
import org.apache.tomcat.util.res.StringManager;

public class StreamProcessor
extends AbstractProcessor
implements Runnable {
    private static final Log log = LogFactory.getLog(StreamProcessor.class);
    private static final StringManager sm = StringManager.getManager(StreamProcessor.class);
    private final Stream stream;
    private volatile SSLSupport sslSupport;

    public StreamProcessor(Stream stream, Adapter adapter, SocketWrapperBase<?> socketWrapper) {
        super(stream.getCoyoteRequest(), stream.getCoyoteResponse());
        this.stream = stream;
        this.setAdapter(adapter);
        this.setSocketWrapper(socketWrapper);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void run() {
        ContainerThreadMarker.set();
        AbstractEndpoint.Handler.SocketState state = AbstractEndpoint.Handler.SocketState.CLOSED;
        try {
            state = this.process(this.socketWrapper, SocketEvent.OPEN_READ);
            if (state == AbstractEndpoint.Handler.SocketState.CLOSED) {
                if (!this.getErrorState().isConnectionIoAllowed()) {
                    ConnectionException ce = new ConnectionException(sm.getString("streamProcessor.error.connection", new Object[]{this.stream.getConnectionId(), this.stream.getIdentifier()}), Http2Error.INTERNAL_ERROR);
                    this.stream.close(ce);
                } else if (!this.getErrorState().isIoAllowed()) {
                    StreamException se = new StreamException(sm.getString("streamProcessor.error.stream", new Object[]{this.stream.getConnectionId(), this.stream.getIdentifier()}), Http2Error.INTERNAL_ERROR, this.stream.getIdentifier());
                    this.stream.close(se);
                }
            }
        }
        catch (Exception e) {
            ConnectionException ce = new ConnectionException(sm.getString("streamProcessor.error.connection", new Object[]{this.stream.getConnectionId(), this.stream.getIdentifier()}), Http2Error.INTERNAL_ERROR);
            ce.initCause(e);
            this.stream.close(ce);
        }
        finally {
            ContainerThreadMarker.clear();
        }
    }

    @Override
    public void action(ActionCode actionCode, Object param) {
        switch (actionCode) {
            case COMMIT: {
                if (this.response.isCommitted()) break;
                try {
                    this.response.setCommitted(true);
                    this.stream.writeHeaders();
                }
                catch (IOException ioe) {
                    this.setErrorState(ErrorState.CLOSE_CONNECTION_NOW, ioe);
                }
                break;
            }
            case CLOSE: {
                this.action(ActionCode.COMMIT, null);
                try {
                    this.stream.getOutputBuffer().close();
                }
                catch (IOException ioe) {
                    this.setErrorState(ErrorState.CLOSE_CONNECTION_NOW, ioe);
                }
                break;
            }
            case ACK: {
                if (this.response.isCommitted() || !this.request.hasExpectation()) break;
                try {
                    this.stream.writeAck();
                }
                catch (IOException ioe) {
                    this.setErrorState(ErrorState.CLOSE_CONNECTION_NOW, ioe);
                }
                break;
            }
            case CLIENT_FLUSH: {
                this.action(ActionCode.COMMIT, null);
                try {
                    this.stream.flushData();
                }
                catch (IOException ioe) {
                    this.response.setErrorException(ioe);
                    this.setErrorState(ErrorState.CLOSE_CONNECTION_NOW, ioe);
                }
                break;
            }
            case AVAILABLE: {
                this.request.setAvailable(this.stream.getInputBuffer().available());
                break;
            }
            case REQ_SET_BODY_REPLAY: {
                ByteChunk body = (ByteChunk)param;
                this.stream.getInputBuffer().insertReplayedBody(body);
                this.stream.receivedEndOfStream();
                break;
            }
            case RESET: {
                this.stream.getOutputBuffer().reset();
                break;
            }
            case IS_ERROR: {
                ((AtomicBoolean)param).set(this.getErrorState().isError());
                break;
            }
            case CLOSE_NOW: {
                this.setErrorState(ErrorState.CLOSE_NOW, null);
                break;
            }
            case DISABLE_SWALLOW_INPUT: {
                break;
            }
            case END_REQUEST: {
                break;
            }
            case REQ_HOST_ADDR_ATTRIBUTE: {
                this.request.remoteAddr().setString(this.socketWrapper.getRemoteAddr());
                break;
            }
            case REQ_HOST_ATTRIBUTE: {
                this.request.remoteHost().setString(this.socketWrapper.getRemoteHost());
                break;
            }
            case REQ_LOCALPORT_ATTRIBUTE: {
                this.request.setLocalPort(this.socketWrapper.getLocalPort());
                break;
            }
            case REQ_LOCAL_ADDR_ATTRIBUTE: {
                this.request.localAddr().setString(this.socketWrapper.getLocalAddr());
                break;
            }
            case REQ_LOCAL_NAME_ATTRIBUTE: {
                this.request.localName().setString(this.socketWrapper.getLocalName());
                break;
            }
            case REQ_REMOTEPORT_ATTRIBUTE: {
                this.request.setRemotePort(this.socketWrapper.getRemotePort());
                break;
            }
            case REQ_SSL_ATTRIBUTE: {
                try {
                    if (this.sslSupport == null) break;
                    Object sslO = this.sslSupport.getCipherSuite();
                    if (sslO != null) {
                        this.request.setAttribute("javax.servlet.request.cipher_suite", sslO);
                    }
                    if ((sslO = this.sslSupport.getPeerCertificateChain()) != null) {
                        this.request.setAttribute("javax.servlet.request.X509Certificate", sslO);
                    }
                    if ((sslO = this.sslSupport.getKeySize()) != null) {
                        this.request.setAttribute("javax.servlet.request.key_size", sslO);
                    }
                    if ((sslO = this.sslSupport.getSessionId()) != null) {
                        this.request.setAttribute("javax.servlet.request.ssl_session_id", sslO);
                    }
                    if ((sslO = this.sslSupport.getProtocol()) != null) {
                        this.request.setAttribute("org.apache.tomcat.util.net.secure_protocol_version", sslO);
                    }
                    this.request.setAttribute("javax.servlet.request.ssl_session_mgr", this.sslSupport);
                }
                catch (Exception e) {
                    log.warn((Object)sm.getString("streamProcessor.ssl.error"), (Throwable)e);
                }
                break;
            }
            case REQ_SSL_CERTIFICATE: {
                try {
                    if (this.sslSupport == null) break;
                    X509Certificate[] sslO = this.sslSupport.getCipherSuite();
                    sslO = this.sslSupport.getPeerCertificateChain();
                    if (sslO == null) break;
                    this.request.setAttribute("javax.servlet.request.X509Certificate", sslO);
                }
                catch (Exception e) {
                    log.warn((Object)sm.getString("streamProcessor.ssl.error"), (Throwable)e);
                }
                break;
            }
            case ASYNC_START: {
                this.asyncStateMachine.asyncStart((AsyncContextCallback)param);
                break;
            }
            case ASYNC_COMPLETE: {
                if (!this.asyncStateMachine.asyncComplete()) break;
                this.socketWrapper.getEndpoint().getExecutor().execute(this);
                break;
            }
            case ASYNC_DISPATCH: {
                if (!this.asyncStateMachine.asyncDispatch()) break;
                this.socketWrapper.getEndpoint().getExecutor().execute(this);
                break;
            }
            case ASYNC_DISPATCHED: {
                this.asyncStateMachine.asyncDispatched();
                break;
            }
            case ASYNC_ERROR: {
                this.asyncStateMachine.asyncError();
                break;
            }
            case ASYNC_IS_ASYNC: {
                ((AtomicBoolean)param).set(this.asyncStateMachine.isAsync());
                break;
            }
            case ASYNC_IS_COMPLETING: {
                ((AtomicBoolean)param).set(this.asyncStateMachine.isCompleting());
                break;
            }
            case ASYNC_IS_DISPATCHING: {
                ((AtomicBoolean)param).set(this.asyncStateMachine.isAsyncDispatching());
                break;
            }
            case ASYNC_IS_ERROR: {
                ((AtomicBoolean)param).set(this.asyncStateMachine.isAsyncError());
                break;
            }
            case ASYNC_IS_STARTED: {
                ((AtomicBoolean)param).set(this.asyncStateMachine.isAsyncStarted());
                break;
            }
            case ASYNC_IS_TIMINGOUT: {
                ((AtomicBoolean)param).set(this.asyncStateMachine.isAsyncTimingOut());
                break;
            }
            case ASYNC_RUN: {
                this.asyncStateMachine.asyncRun((Runnable)param);
                break;
            }
            case ASYNC_SETTIMEOUT: {
                if (param == null) {
                    return;
                }
                long timeout = (Long)param;
                this.setAsyncTimeout(timeout);
                break;
            }
            case ASYNC_TIMEOUT: {
                AtomicBoolean result = (AtomicBoolean)param;
                result.set(this.asyncStateMachine.asyncTimeout());
                break;
            }
            case REQUEST_BODY_FULLY_READ: {
                AtomicBoolean result = (AtomicBoolean)param;
                result.set(this.stream.getInputBuffer().isRequestBodyFullyRead());
                break;
            }
            case NB_READ_INTEREST: {
                this.stream.getInputBuffer().registerReadInterest();
                break;
            }
            case NB_WRITE_INTEREST: {
                AtomicBoolean result = (AtomicBoolean)param;
                result.set(this.stream.getOutputBuffer().isReady());
                break;
            }
            case DISPATCH_READ: {
                this.addDispatch(DispatchType.NON_BLOCKING_READ);
                break;
            }
            case DISPATCH_WRITE: {
                this.addDispatch(DispatchType.NON_BLOCKING_WRITE);
                break;
            }
            case DISPATCH_EXECUTE: {
                this.socketWrapper.getEndpoint().getExecutor().execute(this);
                break;
            }
            case UPGRADE: {
                throw new UnsupportedOperationException(sm.getString("streamProcessor.httpupgrade.notsupported"));
            }
            case IS_PUSH_SUPPORTED: {
                AtomicBoolean result = (AtomicBoolean)param;
                result.set(this.stream.isPushSupported());
                break;
            }
            case PUSH_REQUEST: {
                try {
                    PushToken pushToken = (PushToken)param;
                    pushToken.setResult(this.stream.push(pushToken.getPushTarget()));
                    break;
                }
                catch (IOException ioe) {
                    this.response.setErrorException(ioe);
                    this.setErrorState(ErrorState.CLOSE_CONNECTION_NOW, ioe);
                }
            }
        }
    }

    @Override
    public void recycle() {
        this.setSocketWrapper(null);
        this.setAdapter(null);
    }

    @Override
    public boolean isUpgrade() {
        return false;
    }

    @Override
    protected Log getLog() {
        return log;
    }

    @Override
    public void pause() {
    }

    @Override
    public AbstractEndpoint.Handler.SocketState service(SocketWrapperBase<?> socket) throws IOException {
        try {
            this.adapter.service(this.request, this.response);
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)sm.getString("streamProcessor.service.error"), (Throwable)e);
            }
            this.setErrorState(ErrorState.CLOSE_NOW, e);
        }
        if (this.getErrorState().isError()) {
            this.action(ActionCode.CLOSE, null);
            this.request.updateCounters();
            return AbstractEndpoint.Handler.SocketState.CLOSED;
        }
        if (this.isAsync()) {
            return AbstractEndpoint.Handler.SocketState.LONG;
        }
        this.action(ActionCode.CLOSE, null);
        this.request.updateCounters();
        return AbstractEndpoint.Handler.SocketState.CLOSED;
    }

    @Override
    protected boolean flushBufferedWrite() throws IOException {
        if (this.stream.getOutputBuffer().flush(false)) {
            if (this.stream.getOutputBuffer().isReady()) {
                throw new IllegalStateException();
            }
            return true;
        }
        return false;
    }

    @Override
    protected AbstractEndpoint.Handler.SocketState dispatchEndRequest() {
        return AbstractEndpoint.Handler.SocketState.CLOSED;
    }

    @Override
    public UpgradeToken getUpgradeToken() {
        throw new IllegalStateException(sm.getString("streamProcessor.httpupgrade.notsupported"));
    }

    @Override
    public ByteBuffer getLeftoverInput() {
        throw new IllegalStateException(sm.getString("streamProcessor.httpupgrade.notsupported"));
    }
}

