/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.net;

import java.io.OutputStreamWriter;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.juli.logging.Log;
import org.apache.tomcat.util.IntrospectionUtils;
import org.apache.tomcat.util.net.SSLHostConfig;
import org.apache.tomcat.util.net.SocketEvent;
import org.apache.tomcat.util.net.SocketProperties;
import org.apache.tomcat.util.net.SocketWrapperBase;
import org.apache.tomcat.util.res.StringManager;
import org.apache.tomcat.util.threads.LimitLatch;
import org.apache.tomcat.util.threads.ResizableExecutor;
import org.apache.tomcat.util.threads.TaskQueue;
import org.apache.tomcat.util.threads.TaskThreadFactory;
import org.apache.tomcat.util.threads.ThreadPoolExecutor;

public abstract class AbstractEndpoint<S> {
    protected static final StringManager sm = StringManager.getManager(AbstractEndpoint.class);
    private static final int INITIAL_ERROR_DELAY = 50;
    private static final int MAX_ERROR_DELAY = 1600;
    protected volatile boolean running = false;
    protected volatile boolean paused = false;
    protected volatile boolean internalExecutor = false;
    private volatile LimitLatch connectionLimitLatch = null;
    protected SocketProperties socketProperties = new SocketProperties();
    protected Acceptor[] acceptors;
    private String defaultSSLHostConfigName = "_default_";
    protected Map<String, SSLHostConfig> sslHostConfigs = new ConcurrentHashMap<String, SSLHostConfig>();
    private boolean useSendfile = true;
    private long executorTerminationTimeoutMillis = 5000L;
    protected int acceptorThreadCount = 1;
    protected int acceptorThreadPriority = 5;
    private int maxConnections = 10000;
    private Executor executor = null;
    private int port;
    private InetAddress address;
    private int backlog = 100;
    private boolean bindOnInit = true;
    private BindState bindState = BindState.UNBOUND;
    private Integer keepAliveTimeout = null;
    private boolean SSLEnabled = false;
    private int minSpareThreads = 10;
    private int maxThreads = 200;
    private int maxKeepAliveRequests = 100;
    private int maxHeaderCount = 100;
    private String name = "TP";
    private boolean daemon = true;
    protected int threadPriority = 5;
    protected final List<String> negotiableProtocols = new ArrayList<String>();
    private Handler<S> handler = null;
    protected HashMap<String, Object> attributes = new HashMap();

    public SocketProperties getSocketProperties() {
        return this.socketProperties;
    }

    public String getDefaultSSLHostConfigName() {
        return this.defaultSSLHostConfigName;
    }

    public void setDefaultSSLHostConfigName(String defaultSSLHostConfigName) {
        this.defaultSSLHostConfigName = defaultSSLHostConfigName;
    }

    public void addSslHostConfig(SSLHostConfig sslHostConfig) {
        String key = sslHostConfig.getHostName();
        if (key == null || key.length() == 0) {
            throw new IllegalArgumentException(sm.getString("endpoint.noSslHostName"));
        }
        SSLHostConfig duplicate = this.sslHostConfigs.put(key, sslHostConfig);
        if (duplicate != null) {
            throw new IllegalArgumentException(sm.getString("endpoint.duplicateSslHostName", new Object[]{key}));
        }
        sslHostConfig.setConfigType(this.getSslConfigType());
    }

    public SSLHostConfig[] findSslHostConfigs() {
        return this.sslHostConfigs.values().toArray(new SSLHostConfig[0]);
    }

    protected abstract SSLHostConfig.Type getSslConfigType();

    protected SSLHostConfig getSSLHostConfig(String sniHostName) {
        SSLHostConfig result = null;
        if (sniHostName != null) {
            result = this.sslHostConfigs.get(sniHostName);
            if (result != null) {
                return result;
            }
            int indexOfDot = sniHostName.indexOf(46);
            if (indexOfDot > -1) {
                result = this.sslHostConfigs.get("*" + sniHostName.substring(indexOfDot));
            }
        }
        if (result == null) {
            result = this.sslHostConfigs.get(this.getDefaultSSLHostConfigName());
        }
        if (result == null) {
            throw new IllegalStateException();
        }
        return result;
    }

    public boolean getUseSendfile() {
        return this.useSendfile;
    }

    public void setUseSendfile(boolean useSendfile) {
        this.useSendfile = useSendfile;
    }

    public long getExecutorTerminationTimeoutMillis() {
        return this.executorTerminationTimeoutMillis;
    }

    public void setExecutorTerminationTimeoutMillis(long executorTerminationTimeoutMillis) {
        this.executorTerminationTimeoutMillis = executorTerminationTimeoutMillis;
    }

    public void setAcceptorThreadCount(int acceptorThreadCount) {
        this.acceptorThreadCount = acceptorThreadCount;
    }

    public int getAcceptorThreadCount() {
        return this.acceptorThreadCount;
    }

    public void setAcceptorThreadPriority(int acceptorThreadPriority) {
        this.acceptorThreadPriority = acceptorThreadPriority;
    }

    public int getAcceptorThreadPriority() {
        return this.acceptorThreadPriority;
    }

    public void setMaxConnections(int maxCon) {
        this.maxConnections = maxCon;
        LimitLatch latch = this.connectionLimitLatch;
        if (latch != null) {
            if (maxCon == -1) {
                this.releaseConnectionLatch();
            } else {
                latch.setLimit((long)maxCon);
            }
        } else if (maxCon > 0) {
            this.initializeConnectionLatch();
        }
    }

    public int getMaxConnections() {
        return this.maxConnections;
    }

    public long getConnectionCount() {
        LimitLatch latch = this.connectionLimitLatch;
        if (latch != null) {
            return latch.getCount();
        }
        return -1L;
    }

    public void setExecutor(Executor executor) {
        this.executor = executor;
        this.internalExecutor = executor == null;
    }

    public Executor getExecutor() {
        return this.executor;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public abstract int getLocalPort();

    public InetAddress getAddress() {
        return this.address;
    }

    public void setAddress(InetAddress address) {
        this.address = address;
    }

    public void setBacklog(int backlog) {
        if (backlog > 0) {
            this.backlog = backlog;
        }
    }

    public int getBacklog() {
        return this.backlog;
    }

    public boolean getBindOnInit() {
        return this.bindOnInit;
    }

    public void setBindOnInit(boolean b) {
        this.bindOnInit = b;
    }

    public int getKeepAliveTimeout() {
        if (this.keepAliveTimeout == null) {
            return this.getSoTimeout();
        }
        return this.keepAliveTimeout;
    }

    public void setKeepAliveTimeout(int keepAliveTimeout) {
        this.keepAliveTimeout = keepAliveTimeout;
    }

    public boolean getTcpNoDelay() {
        return this.socketProperties.getTcpNoDelay();
    }

    public void setTcpNoDelay(boolean tcpNoDelay) {
        this.socketProperties.setTcpNoDelay(tcpNoDelay);
    }

    public int getSoLinger() {
        return this.socketProperties.getSoLingerTime();
    }

    public void setSoLinger(int soLinger) {
        this.socketProperties.setSoLingerTime(soLinger);
        this.socketProperties.setSoLingerOn(soLinger >= 0);
    }

    public int getSoTimeout() {
        return this.socketProperties.getSoTimeout();
    }

    public void setSoTimeout(int soTimeout) {
        this.socketProperties.setSoTimeout(soTimeout);
    }

    public boolean isSSLEnabled() {
        return this.SSLEnabled;
    }

    public void setSSLEnabled(boolean SSLEnabled) {
        this.SSLEnabled = SSLEnabled;
    }

    public int getMinSpareThreads() {
        return Math.min(this.minSpareThreads, this.getMaxThreads());
    }

    public void setMinSpareThreads(int minSpareThreads) {
        this.minSpareThreads = minSpareThreads;
        Executor executor = this.executor;
        if (this.running && executor != null) {
            if (executor instanceof java.util.concurrent.ThreadPoolExecutor) {
                ((java.util.concurrent.ThreadPoolExecutor)executor).setCorePoolSize(minSpareThreads);
            } else if (executor instanceof ResizableExecutor) {
                ((ResizableExecutor)executor).resizePool(minSpareThreads, this.maxThreads);
            }
        }
    }

    public void setMaxThreads(int maxThreads) {
        this.maxThreads = maxThreads;
        Executor executor = this.executor;
        if (this.running && executor != null) {
            if (executor instanceof java.util.concurrent.ThreadPoolExecutor) {
                ((java.util.concurrent.ThreadPoolExecutor)executor).setMaximumPoolSize(maxThreads);
            } else if (executor instanceof ResizableExecutor) {
                ((ResizableExecutor)executor).resizePool(this.minSpareThreads, maxThreads);
            }
        }
    }

    public int getMaxThreads() {
        return this.getMaxThreadsExecutor(this.running);
    }

    protected int getMaxThreadsExecutor(boolean useExecutor) {
        Executor executor = this.executor;
        if (useExecutor && executor != null) {
            if (executor instanceof java.util.concurrent.ThreadPoolExecutor) {
                return ((java.util.concurrent.ThreadPoolExecutor)executor).getMaximumPoolSize();
            }
            if (executor instanceof ResizableExecutor) {
                return ((ResizableExecutor)executor).getMaxThreads();
            }
            return -1;
        }
        return this.maxThreads;
    }

    public int getMaxKeepAliveRequests() {
        return this.maxKeepAliveRequests;
    }

    public void setMaxKeepAliveRequests(int maxKeepAliveRequests) {
        this.maxKeepAliveRequests = maxKeepAliveRequests;
    }

    public int getMaxHeaderCount() {
        return this.maxHeaderCount;
    }

    public void setMaxHeaderCount(int maxHeaderCount) {
        this.maxHeaderCount = maxHeaderCount;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setDaemon(boolean b) {
        this.daemon = b;
    }

    public boolean getDaemon() {
        return this.daemon;
    }

    public void setThreadPriority(int threadPriority) {
        this.threadPriority = threadPriority;
    }

    public int getThreadPriority() {
        return this.threadPriority;
    }

    protected abstract boolean getDeferAccept();

    public void addNegotiatedProtocol(String negotiableProtocol) {
        this.negotiableProtocols.add(negotiableProtocol);
    }

    public boolean hasNegotiableProtocols() {
        return this.negotiableProtocols.size() > 0;
    }

    public void setHandler(Handler<S> handler) {
        this.handler = handler;
    }

    public Handler<S> getHandler() {
        return this.handler;
    }

    public void setAttribute(String name, Object value) {
        if (this.getLog().isTraceEnabled()) {
            this.getLog().trace((Object)sm.getString("endpoint.setAttribute", new Object[]{name, value}));
        }
        this.attributes.put(name, value);
    }

    public Object getAttribute(String key) {
        Object value = this.attributes.get(key);
        if (this.getLog().isTraceEnabled()) {
            this.getLog().trace((Object)sm.getString("endpoint.getAttribute", new Object[]{key, value}));
        }
        return value;
    }

    public boolean setProperty(String name, String value) {
        this.setAttribute(name, value);
        String socketName = "socket.";
        try {
            if (name.startsWith("socket.")) {
                return IntrospectionUtils.setProperty((Object)this.socketProperties, (String)name.substring("socket.".length()), (String)value);
            }
            return IntrospectionUtils.setProperty((Object)this, (String)name, (String)value, (boolean)false);
        }
        catch (Exception x) {
            this.getLog().error((Object)("Unable to set attribute \"" + name + "\" to \"" + value + "\""), (Throwable)x);
            return false;
        }
    }

    public String getProperty(String name) {
        Object result;
        String value = (String)this.getAttribute(name);
        String socketName = "socket.";
        if (value == null && name.startsWith("socket.") && (result = IntrospectionUtils.getProperty((Object)this.socketProperties, (String)name.substring("socket.".length()))) != null) {
            value = result.toString();
        }
        return value;
    }

    public int getCurrentThreadCount() {
        Executor executor = this.executor;
        if (executor != null) {
            if (executor instanceof ThreadPoolExecutor) {
                return ((ThreadPoolExecutor)executor).getPoolSize();
            }
            if (executor instanceof ResizableExecutor) {
                return ((ResizableExecutor)executor).getPoolSize();
            }
            return -1;
        }
        return -2;
    }

    public int getCurrentThreadsBusy() {
        Executor executor = this.executor;
        if (executor != null) {
            if (executor instanceof ThreadPoolExecutor) {
                return ((ThreadPoolExecutor)executor).getActiveCount();
            }
            if (executor instanceof ResizableExecutor) {
                return ((ResizableExecutor)executor).getActiveCount();
            }
            return -1;
        }
        return -2;
    }

    public boolean isRunning() {
        return this.running;
    }

    public boolean isPaused() {
        return this.paused;
    }

    public void createExecutor() {
        this.internalExecutor = true;
        TaskQueue taskqueue = new TaskQueue();
        TaskThreadFactory tf = new TaskThreadFactory(this.getName() + "-exec-", this.daemon, this.getThreadPriority());
        this.executor = new ThreadPoolExecutor(this.getMinSpareThreads(), this.getMaxThreads(), 60L, TimeUnit.SECONDS, (BlockingQueue)taskqueue, (ThreadFactory)tf);
        taskqueue.setParent((ThreadPoolExecutor)this.executor);
    }

    public void shutdownExecutor() {
        Executor executor = this.executor;
        if (executor != null && this.internalExecutor) {
            this.executor = null;
            if (executor instanceof ThreadPoolExecutor) {
                ThreadPoolExecutor tpe = (ThreadPoolExecutor)executor;
                tpe.shutdownNow();
                long timeout = this.getExecutorTerminationTimeoutMillis();
                if (timeout > 0L) {
                    try {
                        tpe.awaitTermination(timeout, TimeUnit.MILLISECONDS);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (tpe.isTerminating()) {
                        this.getLog().warn((Object)sm.getString("endpoint.warn.executorShutdown", new Object[]{this.getName()}));
                    }
                }
                TaskQueue queue = (TaskQueue)tpe.getQueue();
                queue.setParent(null);
            }
        }
    }

    protected void unlockAccept() {
        block23: {
            boolean unlockRequired = false;
            for (Acceptor acceptor : this.acceptors) {
                if (acceptor.getState() != Acceptor.AcceptorState.RUNNING) continue;
                unlockRequired = true;
                break;
            }
            if (!unlockRequired) {
                return;
            }
            InetSocketAddress saddr = null;
            try {
                saddr = this.address == null ? new InetSocketAddress("localhost", this.getLocalPort()) : new InetSocketAddress(this.address, this.getLocalPort());
                try (Socket s = new Socket();){
                    int stmo = 2000;
                    int utmo = 2000;
                    if (this.getSocketProperties().getSoTimeout() > stmo) {
                        stmo = this.getSocketProperties().getSoTimeout();
                    }
                    if (this.getSocketProperties().getUnlockTimeout() > utmo) {
                        utmo = this.getSocketProperties().getUnlockTimeout();
                    }
                    s.setSoTimeout(stmo);
                    s.setSoLinger(this.getSocketProperties().getSoLingerOn(), this.getSocketProperties().getSoLingerTime());
                    if (this.getLog().isDebugEnabled()) {
                        this.getLog().debug((Object)("About to unlock socket for:" + saddr));
                    }
                    s.connect(saddr, utmo);
                    if (this.getDeferAccept()) {
                        OutputStreamWriter sw = new OutputStreamWriter(s.getOutputStream(), "ISO-8859-1");
                        sw.write("OPTIONS * HTTP/1.0\r\nUser-Agent: Tomcat wakeup connection\r\n\r\n");
                        sw.flush();
                    }
                    if (this.getLog().isDebugEnabled()) {
                        this.getLog().debug((Object)("Socket unlock completed for:" + saddr));
                    }
                    long waitLeft = 1000L;
                    for (Acceptor acceptor : this.acceptors) {
                        while (waitLeft > 0L && acceptor.getState() == Acceptor.AcceptorState.RUNNING) {
                            Thread.sleep(50L);
                            waitLeft -= 50L;
                        }
                    }
                }
            }
            catch (Exception e) {
                if (!this.getLog().isDebugEnabled()) break block23;
                this.getLog().debug((Object)sm.getString("endpoint.debug.unlock", new Object[]{"" + this.getPort()}), (Throwable)e);
            }
        }
    }

    public abstract void processSocket(SocketWrapperBase<S> var1, SocketEvent var2, boolean var3);

    public abstract void bind() throws Exception;

    public abstract void unbind() throws Exception;

    public abstract void startInternal() throws Exception;

    public abstract void stopInternal() throws Exception;

    public final void init() throws Exception {
        if (this.bindOnInit) {
            this.bind();
            this.bindState = BindState.BOUND_ON_INIT;
        }
    }

    public final void start() throws Exception {
        if (this.bindState == BindState.UNBOUND) {
            this.bind();
            this.bindState = BindState.BOUND_ON_START;
        }
        this.startInternal();
    }

    protected final void startAcceptorThreads() {
        int count = this.getAcceptorThreadCount();
        this.acceptors = new Acceptor[count];
        for (int i = 0; i < count; ++i) {
            this.acceptors[i] = this.createAcceptor();
            String threadName = this.getName() + "-Acceptor-" + i;
            this.acceptors[i].setThreadName(threadName);
            Thread t = new Thread((Runnable)this.acceptors[i], threadName);
            t.setPriority(this.getAcceptorThreadPriority());
            t.setDaemon(this.getDaemon());
            t.start();
        }
    }

    protected abstract Acceptor createAcceptor();

    public void pause() {
        if (this.running && !this.paused) {
            this.paused = true;
            this.unlockAccept();
            this.getHandler().pause();
        }
    }

    public void resume() {
        if (this.running) {
            this.paused = false;
        }
    }

    public final void stop() throws Exception {
        this.stopInternal();
        if (this.bindState == BindState.BOUND_ON_START) {
            this.unbind();
            this.bindState = BindState.UNBOUND;
        }
    }

    public final void destroy() throws Exception {
        if (this.bindState == BindState.BOUND_ON_INIT) {
            this.unbind();
            this.bindState = BindState.UNBOUND;
        }
    }

    protected abstract Log getLog();

    protected LimitLatch initializeConnectionLatch() {
        if (this.maxConnections == -1) {
            return null;
        }
        if (this.connectionLimitLatch == null) {
            this.connectionLimitLatch = new LimitLatch((long)this.getMaxConnections());
        }
        return this.connectionLimitLatch;
    }

    protected void releaseConnectionLatch() {
        LimitLatch latch = this.connectionLimitLatch;
        if (latch != null) {
            latch.releaseAll();
        }
        this.connectionLimitLatch = null;
    }

    protected void countUpOrAwaitConnection() throws InterruptedException {
        if (this.maxConnections == -1) {
            return;
        }
        LimitLatch latch = this.connectionLimitLatch;
        if (latch != null) {
            latch.countUpOrAwait();
        }
    }

    protected long countDownConnection() {
        if (this.maxConnections == -1) {
            return -1L;
        }
        LimitLatch latch = this.connectionLimitLatch;
        if (latch != null) {
            long result = latch.countDown();
            if (result < 0L) {
                this.getLog().warn((Object)sm.getString("endpoint.warn.incorrectConnectionCount"));
            }
            return result;
        }
        return -1L;
    }

    protected int handleExceptionWithDelay(int currentErrorDelay) {
        if (currentErrorDelay > 0) {
            try {
                Thread.sleep(currentErrorDelay);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (currentErrorDelay == 0) {
            return 50;
        }
        if (currentErrorDelay < 1600) {
            return currentErrorDelay * 2;
        }
        return 1600;
    }

    public static abstract class Acceptor
    implements Runnable {
        protected volatile AcceptorState state = AcceptorState.NEW;
        private String threadName;

        public final AcceptorState getState() {
            return this.state;
        }

        protected final void setThreadName(String threadName) {
            this.threadName = threadName;
        }

        protected final String getThreadName() {
            return this.threadName;
        }

        public static enum AcceptorState {
            NEW,
            RUNNING,
            PAUSED,
            ENDED;

        }
    }

    protected static enum BindState {
        UNBOUND,
        BOUND_ON_INIT,
        BOUND_ON_START;

    }

    public static interface Handler<S> {
        public SocketState process(SocketWrapperBase<S> var1, SocketEvent var2);

        public Object getGlobal();

        public Set<S> getOpenSockets();

        public void release(SocketWrapperBase<S> var1);

        public void pause();

        public void recycle();

        public static enum SocketState {
            OPEN,
            CLOSED,
            LONG,
            ASYNC_END,
            SENDFILE,
            UPGRADING,
            UPGRADED;

        }
    }
}

