/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.net;

import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import java.nio.channels.ByteChannel;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.FileChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLSession;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.ExceptionUtils;
import org.apache.tomcat.util.IntrospectionUtils;
import org.apache.tomcat.util.collections.SynchronizedQueue;
import org.apache.tomcat.util.collections.SynchronizedStack;
import org.apache.tomcat.util.net.AbstractEndpoint;
import org.apache.tomcat.util.net.AbstractJsseEndpoint;
import org.apache.tomcat.util.net.NioChannel;
import org.apache.tomcat.util.net.NioSelectorPool;
import org.apache.tomcat.util.net.SSLSupport;
import org.apache.tomcat.util.net.SecureNioChannel;
import org.apache.tomcat.util.net.SendfileDataBase;
import org.apache.tomcat.util.net.SendfileState;
import org.apache.tomcat.util.net.SocketBufferHandler;
import org.apache.tomcat.util.net.SocketEvent;
import org.apache.tomcat.util.net.SocketProperties;
import org.apache.tomcat.util.net.SocketWrapperBase;
import org.apache.tomcat.util.net.jsse.JSSESupport;

public class NioEndpoint
extends AbstractJsseEndpoint<NioChannel> {
    private static final Log log = LogFactory.getLog(NioEndpoint.class);
    public static final int OP_REGISTER = 256;
    private NioSelectorPool selectorPool = new NioSelectorPool();
    private ServerSocketChannel serverSock = null;
    private volatile CountDownLatch stopLatch = null;
    private SynchronizedStack<SocketProcessor> processorCache;
    private SynchronizedStack<PollerEvent> eventCache;
    private SynchronizedStack<NioChannel> nioChannels;
    private int pollerThreadPriority = 5;
    private int pollerThreadCount = Math.min(2, Runtime.getRuntime().availableProcessors());
    private long selectorTimeout = 1000L;
    private Poller[] pollers = null;
    private AtomicInteger pollerRotater = new AtomicInteger(0);

    @Override
    public boolean setProperty(String name, String value) {
        String selectorPoolName = "selectorPool.";
        try {
            if (name.startsWith("selectorPool.")) {
                return IntrospectionUtils.setProperty((Object)this.selectorPool, (String)name.substring("selectorPool.".length()), (String)value);
            }
            return super.setProperty(name, value);
        }
        catch (Exception x) {
            log.error((Object)("Unable to set attribute \"" + name + "\" to \"" + value + "\""), (Throwable)x);
            return false;
        }
    }

    public void setPollerThreadPriority(int pollerThreadPriority) {
        this.pollerThreadPriority = pollerThreadPriority;
    }

    public int getPollerThreadPriority() {
        return this.pollerThreadPriority;
    }

    public void setPollerThreadCount(int pollerThreadCount) {
        this.pollerThreadCount = pollerThreadCount;
    }

    public int getPollerThreadCount() {
        return this.pollerThreadCount;
    }

    public void setSelectorTimeout(long timeout) {
        this.selectorTimeout = timeout;
    }

    public long getSelectorTimeout() {
        return this.selectorTimeout;
    }

    public Poller getPoller0() {
        int idx = Math.abs(this.pollerRotater.incrementAndGet()) % this.pollers.length;
        return this.pollers[idx];
    }

    public void setSelectorPool(NioSelectorPool selectorPool) {
        this.selectorPool = selectorPool;
    }

    public void setSocketProperties(SocketProperties socketProperties) {
        this.socketProperties = socketProperties;
    }

    @Override
    public boolean getDeferAccept() {
        return false;
    }

    @Override
    public int getLocalPort() {
        ServerSocketChannel ssc = this.serverSock;
        if (ssc == null) {
            return -1;
        }
        ServerSocket s = ssc.socket();
        if (s == null) {
            return -1;
        }
        return s.getLocalPort();
    }

    protected void releaseCaches() {
        this.nioChannels.clear();
        this.processorCache.clear();
        if (this.getHandler() != null) {
            this.getHandler().recycle();
        }
    }

    public int getKeepAliveCount() {
        if (this.pollers == null) {
            return 0;
        }
        int sum = 0;
        for (int i = 0; i < this.pollers.length; ++i) {
            sum += this.pollers[i].getKeyCount();
        }
        return sum;
    }

    @Override
    public void bind() throws Exception {
        this.serverSock = ServerSocketChannel.open();
        this.socketProperties.setProperties(this.serverSock.socket());
        InetSocketAddress addr = this.getAddress() != null ? new InetSocketAddress(this.getAddress(), this.getPort()) : new InetSocketAddress(this.getPort());
        this.serverSock.socket().bind(addr, this.getBacklog());
        this.serverSock.configureBlocking(true);
        this.serverSock.socket().setSoTimeout(this.getSocketProperties().getSoTimeout());
        if (this.acceptorThreadCount == 0) {
            this.acceptorThreadCount = 1;
        }
        if (this.pollerThreadCount <= 0) {
            this.pollerThreadCount = 1;
        }
        this.stopLatch = new CountDownLatch(this.pollerThreadCount);
        this.initialiseSsl();
        this.selectorPool.open();
    }

    @Override
    public void startInternal() throws Exception {
        if (!this.running) {
            this.running = true;
            this.paused = false;
            this.processorCache = new SynchronizedStack(128, this.socketProperties.getProcessorCache());
            this.eventCache = new SynchronizedStack(128, this.socketProperties.getEventCache());
            this.nioChannels = new SynchronizedStack(128, this.socketProperties.getBufferPool());
            if (this.getExecutor() == null) {
                this.createExecutor();
            }
            this.initializeConnectionLatch();
            this.pollers = new Poller[this.getPollerThreadCount()];
            for (int i = 0; i < this.pollers.length; ++i) {
                this.pollers[i] = new Poller();
                Thread pollerThread = new Thread((Runnable)this.pollers[i], this.getName() + "-ClientPoller-" + i);
                pollerThread.setPriority(this.threadPriority);
                pollerThread.setDaemon(true);
                pollerThread.start();
            }
            this.startAcceptorThreads();
        }
    }

    @Override
    public void stopInternal() {
        this.releaseConnectionLatch();
        if (!this.paused) {
            this.pause();
        }
        if (this.running) {
            this.running = false;
            this.unlockAccept();
            for (int i = 0; this.pollers != null && i < this.pollers.length; ++i) {
                if (this.pollers[i] == null) continue;
                this.pollers[i].destroy();
                this.pollers[i] = null;
            }
            try {
                this.stopLatch.await(this.selectorTimeout + 100L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.shutdownExecutor();
            this.eventCache.clear();
            this.nioChannels.clear();
            this.processorCache.clear();
        }
    }

    @Override
    public void unbind() throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Destroy initiated for " + new InetSocketAddress(this.getAddress(), this.getPort())));
        }
        if (this.running) {
            this.stop();
        }
        this.serverSock.socket().close();
        this.serverSock.close();
        this.serverSock = null;
        this.destroySsl();
        super.unbind();
        this.releaseCaches();
        this.selectorPool.close();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Destroy completed for " + new InetSocketAddress(this.getAddress(), this.getPort())));
        }
    }

    public int getWriteBufSize() {
        return this.socketProperties.getTxBufSize();
    }

    public int getReadBufSize() {
        return this.socketProperties.getRxBufSize();
    }

    public NioSelectorPool getSelectorPool() {
        return this.selectorPool;
    }

    @Override
    protected AbstractEndpoint.Acceptor createAcceptor() {
        return new Acceptor();
    }

    protected boolean setSocketOptions(SocketChannel socket) {
        try {
            socket.configureBlocking(false);
            Socket sock = socket.socket();
            this.socketProperties.setProperties(sock);
            NioChannel channel = (NioChannel)this.nioChannels.pop();
            if (channel == null) {
                SocketBufferHandler bufhandler = new SocketBufferHandler(this.socketProperties.getAppReadBufSize(), this.socketProperties.getAppWriteBufSize(), this.socketProperties.getDirectBuffer());
                channel = this.isSSLEnabled() ? new SecureNioChannel(socket, bufhandler, this.selectorPool, this) : new NioChannel(socket, bufhandler);
            } else {
                channel.setIOChannel(socket);
                channel.reset();
            }
            this.getPoller0().register(channel);
        }
        catch (Throwable t) {
            ExceptionUtils.handleThrowable((Throwable)t);
            try {
                log.error((Object)"", t);
            }
            catch (Throwable tt) {
                ExceptionUtils.handleThrowable((Throwable)t);
            }
            return false;
        }
        return true;
    }

    protected boolean isWorkerAvailable() {
        return true;
    }

    @Override
    public void processSocket(SocketWrapperBase<NioChannel> socketWrapper, SocketEvent socketStatus, boolean dispatch) {
        this.processSocket((NioSocketWrapper)socketWrapper, socketStatus, dispatch);
    }

    protected boolean processSocket(NioSocketWrapper attachment, SocketEvent status, boolean dispatch) {
        try {
            if (attachment == null) {
                return false;
            }
            SocketProcessor sc = (SocketProcessor)this.processorCache.pop();
            if (sc == null) {
                sc = new SocketProcessor(attachment, status);
            } else {
                sc.reset(attachment, status);
            }
            Executor executor = this.getExecutor();
            if (dispatch && executor != null) {
                executor.execute(sc);
            } else {
                sc.run();
            }
        }
        catch (RejectedExecutionException ree) {
            log.warn((Object)sm.getString("endpoint.executor.fail", new Object[]{attachment.getSocket()}), (Throwable)ree);
            return false;
        }
        catch (Throwable t) {
            ExceptionUtils.handleThrowable((Throwable)t);
            log.error((Object)sm.getString("endpoint.process.fail"), t);
            return false;
        }
        return true;
    }

    @Override
    protected Log getLog() {
        return log;
    }

    private void close(NioChannel socket, SelectionKey key) {
        try {
            if (socket.getPoller().cancelledKey(key) != null && this.running && !this.paused && !this.nioChannels.push((Object)socket)) {
                socket.free();
            }
        }
        catch (Exception x) {
            log.error((Object)"", (Throwable)x);
        }
    }

    private void closeSocket(SocketChannel socket) {
        block5: {
            block4: {
                try {
                    socket.socket().close();
                }
                catch (IOException ioe) {
                    if (!log.isDebugEnabled()) break block4;
                    log.debug((Object)"", (Throwable)ioe);
                }
            }
            try {
                socket.close();
            }
            catch (IOException ioe) {
                if (!log.isDebugEnabled()) break block5;
                log.debug((Object)"", (Throwable)ioe);
            }
        }
    }

    public static class SendfileData
    extends SendfileDataBase {
        protected volatile FileChannel fchannel;

        public SendfileData(String filename, long pos, long length) {
            super(filename, pos, length);
        }
    }

    protected class SocketProcessor
    implements Runnable {
        private NioSocketWrapper ka = null;
        private SocketEvent status = null;

        public SocketProcessor(NioSocketWrapper ka, SocketEvent status) {
            this.reset(ka, status);
        }

        public void reset(NioSocketWrapper ka, SocketEvent status) {
            this.ka = ka;
            this.status = status;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            NioChannel socket = (NioChannel)this.ka.getSocket();
            if (socket == null) {
                return;
            }
            SelectionKey key = socket.getIOChannel().keyFor(socket.getPoller().getSelector());
            NioChannel nioChannel = socket;
            synchronized (nioChannel) {
                try {
                    int handshake = -1;
                    try {
                        if (key != null) {
                            if (socket.isHandshakeComplete() || this.status == SocketEvent.STOP) {
                                handshake = 0;
                            } else {
                                handshake = socket.handshake(key.isReadable(), key.isWritable());
                                this.status = SocketEvent.OPEN_READ;
                            }
                        }
                    }
                    catch (IOException x) {
                        handshake = -1;
                        if (log.isDebugEnabled()) {
                            log.debug((Object)"Error during SSL handshake", (Throwable)x);
                        }
                    }
                    catch (CancelledKeyException ckx) {
                        handshake = -1;
                    }
                    if (handshake == 0) {
                        AbstractEndpoint.Handler.SocketState state = AbstractEndpoint.Handler.SocketState.OPEN;
                        state = this.status == null ? NioEndpoint.this.getHandler().process(this.ka, SocketEvent.OPEN_READ) : NioEndpoint.this.getHandler().process(this.ka, this.status);
                        if (state == AbstractEndpoint.Handler.SocketState.CLOSED) {
                            NioEndpoint.this.close(socket, key);
                        }
                    } else if (handshake == -1) {
                        NioEndpoint.this.close(socket, key);
                    } else {
                        this.ka.getPoller().add(socket, handshake);
                    }
                }
                catch (CancelledKeyException cx) {
                    socket.getPoller().cancelledKey(key);
                }
                catch (VirtualMachineError vme) {
                    ExceptionUtils.handleThrowable((Throwable)vme);
                }
                catch (Throwable t) {
                    log.error((Object)"", t);
                    socket.getPoller().cancelledKey(key);
                }
                finally {
                    this.ka = null;
                    this.status = null;
                    if (NioEndpoint.this.running && !NioEndpoint.this.paused) {
                        NioEndpoint.this.processorCache.push((Object)this);
                    }
                }
            }
        }
    }

    public static class NioSocketWrapper
    extends SocketWrapperBase<NioChannel> {
        private final NioSelectorPool pool;
        private Poller poller = null;
        private int interestOps = 0;
        private CountDownLatch readLatch = null;
        private CountDownLatch writeLatch = null;
        private volatile SendfileData sendfileData = null;
        private volatile long lastRead;
        private volatile long lastWrite = this.lastRead = System.currentTimeMillis();

        public NioSocketWrapper(NioChannel channel, NioEndpoint endpoint) {
            super(channel, endpoint);
            this.pool = endpoint.getSelectorPool();
            this.socketBufferHandler = channel.getBufHandler();
        }

        public Poller getPoller() {
            return this.poller;
        }

        public void setPoller(Poller poller) {
            this.poller = poller;
        }

        public int interestOps() {
            return this.interestOps;
        }

        public int interestOps(int ops) {
            this.interestOps = ops;
            return ops;
        }

        public CountDownLatch getReadLatch() {
            return this.readLatch;
        }

        public CountDownLatch getWriteLatch() {
            return this.writeLatch;
        }

        protected CountDownLatch resetLatch(CountDownLatch latch) {
            if (latch == null || latch.getCount() == 0L) {
                return null;
            }
            throw new IllegalStateException("Latch must be at count 0");
        }

        public void resetReadLatch() {
            this.readLatch = this.resetLatch(this.readLatch);
        }

        public void resetWriteLatch() {
            this.writeLatch = this.resetLatch(this.writeLatch);
        }

        protected CountDownLatch startLatch(CountDownLatch latch, int cnt) {
            if (latch == null || latch.getCount() == 0L) {
                return new CountDownLatch(cnt);
            }
            throw new IllegalStateException("Latch must be at count 0 or null.");
        }

        public void startReadLatch(int cnt) {
            this.readLatch = this.startLatch(this.readLatch, cnt);
        }

        public void startWriteLatch(int cnt) {
            this.writeLatch = this.startLatch(this.writeLatch, cnt);
        }

        protected void awaitLatch(CountDownLatch latch, long timeout, TimeUnit unit) throws InterruptedException {
            if (latch == null) {
                throw new IllegalStateException("Latch cannot be null");
            }
            latch.await(timeout, unit);
        }

        public void awaitReadLatch(long timeout, TimeUnit unit) throws InterruptedException {
            this.awaitLatch(this.readLatch, timeout, unit);
        }

        public void awaitWriteLatch(long timeout, TimeUnit unit) throws InterruptedException {
            this.awaitLatch(this.writeLatch, timeout, unit);
        }

        public void setSendfileData(SendfileData sf) {
            this.sendfileData = sf;
        }

        public SendfileData getSendfileData() {
            return this.sendfileData;
        }

        public void updateLastWrite() {
            this.lastWrite = System.currentTimeMillis();
        }

        public long getLastWrite() {
            return this.lastWrite;
        }

        public void updateLastRead() {
            this.lastRead = System.currentTimeMillis();
        }

        public long getLastRead() {
            return this.lastRead;
        }

        @Override
        public boolean isReadyForRead() throws IOException {
            this.socketBufferHandler.configureReadBufferForRead();
            if (this.socketBufferHandler.getReadBuffer().remaining() > 0) {
                return true;
            }
            this.fillReadBuffer(false);
            boolean isReady = this.socketBufferHandler.getReadBuffer().position() > 0;
            return isReady;
        }

        @Override
        public int read(boolean block, byte[] b, int off, int len) throws IOException {
            this.socketBufferHandler.configureReadBufferForRead();
            ByteBuffer readBuffer = this.socketBufferHandler.getReadBuffer();
            int remaining = readBuffer.remaining();
            if (remaining >= len) {
                readBuffer.get(b, off, len);
                return len;
            }
            if (remaining > 0) {
                readBuffer.get(b, off, remaining);
                return remaining;
            }
            int nRead = this.fillReadBuffer(block);
            this.lastRead = System.currentTimeMillis();
            if (nRead > 0) {
                this.socketBufferHandler.configureReadBufferForRead();
                if (nRead > len) {
                    readBuffer.get(b, off, len);
                    return len;
                }
                readBuffer.get(b, off, nRead);
                return nRead;
            }
            return nRead;
        }

        @Override
        public void close() throws IOException {
            NioChannel socket = (NioChannel)this.getSocket();
            if (socket != null) {
                socket.close();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int fillReadBuffer(boolean block) throws IOException {
            int nRead;
            NioChannel channel = (NioChannel)this.getSocket();
            this.socketBufferHandler.configureReadBufferForWrite();
            if (block) {
                Selector selector = null;
                try {
                    selector = this.pool.get();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                try {
                    NioSocketWrapper att = (NioSocketWrapper)channel.getAttachment();
                    if (att == null) {
                        throw new IOException("Key must be cancelled.");
                    }
                    nRead = this.pool.read(this.socketBufferHandler.getReadBuffer(), channel, selector, att.getReadTimeout());
                }
                finally {
                    if (selector != null) {
                        this.pool.put(selector);
                    }
                }
            }
            nRead = channel.read(this.socketBufferHandler.getReadBuffer());
            if (nRead == -1) {
                throw new EOFException();
            }
            return nRead;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected synchronized void doWriteInternal(boolean block) throws IOException {
            this.socketBufferHandler.configureWriteBufferForRead();
            long writeTimeout = this.getWriteTimeout();
            Selector selector = null;
            try {
                selector = this.pool.get();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                this.pool.write(this.socketBufferHandler.getWriteBuffer(), (NioChannel)this.getSocket(), selector, writeTimeout, block);
                if (block) {
                    while (!((NioChannel)this.getSocket()).flush(true, selector, writeTimeout)) {
                    }
                }
                this.lastWrite = System.currentTimeMillis();
            }
            finally {
                if (selector != null) {
                    this.pool.put(selector);
                }
            }
        }

        @Override
        public void registerReadInterest() {
            this.getPoller().add((NioChannel)this.getSocket(), 1);
        }

        @Override
        public void registerWriteInterest() {
            this.getPoller().add((NioChannel)this.getSocket(), 4);
        }

        @Override
        public SendfileDataBase createSendfileData(String filename, long pos, long length) {
            return new SendfileData(filename, pos, length);
        }

        @Override
        public SendfileState processSendfile(SendfileDataBase sendfileData) {
            this.setSendfileData((SendfileData)sendfileData);
            SelectionKey key = ((NioChannel)this.getSocket()).getIOChannel().keyFor(((NioChannel)this.getSocket()).getPoller().getSelector());
            return ((NioChannel)this.getSocket()).getPoller().processSendfile(key, this, true);
        }

        @Override
        protected void populateRemoteAddr() {
            InetAddress inetAddr = ((NioChannel)this.getSocket()).getIOChannel().socket().getInetAddress();
            if (inetAddr != null) {
                this.remoteAddr = inetAddr.getHostAddress();
            }
        }

        @Override
        protected void populateRemoteHost() {
            InetAddress inetAddr = ((NioChannel)this.getSocket()).getIOChannel().socket().getInetAddress();
            if (inetAddr != null) {
                this.remoteHost = inetAddr.getHostName();
                if (this.remoteAddr == null) {
                    this.remoteAddr = inetAddr.getHostAddress();
                }
            }
        }

        @Override
        protected void populateRemotePort() {
            this.remotePort = ((NioChannel)this.getSocket()).getIOChannel().socket().getPort();
        }

        @Override
        protected void populateLocalName() {
            InetAddress inetAddr = ((NioChannel)this.getSocket()).getIOChannel().socket().getLocalAddress();
            if (inetAddr != null) {
                this.localName = inetAddr.getHostName();
            }
        }

        @Override
        protected void populateLocalAddr() {
            InetAddress inetAddr = ((NioChannel)this.getSocket()).getIOChannel().socket().getLocalAddress();
            if (inetAddr != null) {
                this.localAddr = inetAddr.getHostAddress();
            }
        }

        @Override
        protected void populateLocalPort() {
            this.localPort = ((NioChannel)this.getSocket()).getIOChannel().socket().getLocalPort();
        }

        @Override
        public SSLSupport getSslSupport(String clientCertProvider) {
            if (this.getSocket() instanceof SecureNioChannel) {
                SecureNioChannel ch = (SecureNioChannel)this.getSocket();
                SSLSession session = ch.getSslEngine().getSession();
                return ((NioEndpoint)this.getEndpoint()).getSslImplementation().getSSLSupport(session);
            }
            return null;
        }

        @Override
        public void doClientAuth(SSLSupport sslSupport) {
            SecureNioChannel sslChannel = (SecureNioChannel)this.getSocket();
            SSLEngine engine = sslChannel.getSslEngine();
            if (!engine.getNeedClientAuth()) {
                engine.setNeedClientAuth(true);
                try {
                    sslChannel.rehandshake(this.getEndpoint().getSoTimeout());
                    ((JSSESupport)sslSupport).setSession(engine.getSession());
                }
                catch (IOException ioe) {
                    log.warn((Object)sm.getString("socket.sslreneg", new Object[]{ioe}));
                }
            }
        }
    }

    public class Poller
    implements Runnable {
        private Selector selector;
        private final SynchronizedQueue<PollerEvent> events = new SynchronizedQueue();
        private volatile boolean close = false;
        private long nextExpiration = 0L;
        private AtomicLong wakeupCounter = new AtomicLong(0L);
        private volatile int keyCount = 0;

        public Poller() throws IOException {
            this.selector = Selector.open();
        }

        public int getKeyCount() {
            return this.keyCount;
        }

        public Selector getSelector() {
            return this.selector;
        }

        protected void destroy() {
            this.close = true;
            this.selector.wakeup();
        }

        private void addEvent(PollerEvent event) {
            this.events.offer((Object)event);
            if (this.wakeupCounter.incrementAndGet() == 0L) {
                this.selector.wakeup();
            }
        }

        public void add(NioChannel socket, int interestOps) {
            PollerEvent r = (PollerEvent)NioEndpoint.this.eventCache.pop();
            if (r == null) {
                r = new PollerEvent(socket, null, interestOps);
            } else {
                r.reset(socket, null, interestOps);
            }
            this.addEvent(r);
            if (this.close) {
                NioSocketWrapper ka = (NioSocketWrapper)socket.getAttachment();
                NioEndpoint.this.processSocket(ka, SocketEvent.STOP, false);
            }
        }

        public boolean events() {
            boolean result = false;
            PollerEvent pe = null;
            while ((pe = (PollerEvent)this.events.poll()) != null) {
                result = true;
                try {
                    pe.run();
                    pe.reset();
                    if (!NioEndpoint.this.running || NioEndpoint.this.paused) continue;
                    NioEndpoint.this.eventCache.push((Object)pe);
                }
                catch (Throwable x) {
                    log.error((Object)"", x);
                }
            }
            return result;
        }

        public void register(NioChannel socket) {
            socket.setPoller(this);
            NioSocketWrapper ka = new NioSocketWrapper(socket, NioEndpoint.this);
            socket.setSocketWrapper(ka);
            ka.setPoller(this);
            ka.setReadTimeout(NioEndpoint.this.getSocketProperties().getSoTimeout());
            ka.setWriteTimeout(NioEndpoint.this.getSocketProperties().getSoTimeout());
            ka.setKeepAliveLeft(NioEndpoint.this.getMaxKeepAliveRequests());
            ka.setSecure(NioEndpoint.this.isSSLEnabled());
            ka.setReadTimeout(NioEndpoint.this.getSoTimeout());
            ka.setWriteTimeout(NioEndpoint.this.getSoTimeout());
            PollerEvent r = (PollerEvent)NioEndpoint.this.eventCache.pop();
            ka.interestOps(1);
            if (r == null) {
                r = new PollerEvent(socket, ka, 256);
            } else {
                r.reset(socket, ka, 256);
            }
            this.addEvent(r);
        }

        public NioSocketWrapper cancelledKey(SelectionKey key) {
            NioSocketWrapper ka;
            block17: {
                ka = null;
                try {
                    block16: {
                        block15: {
                            if (key == null) {
                                return null;
                            }
                            ka = (NioSocketWrapper)key.attach(null);
                            if (ka != null) {
                                NioEndpoint.this.getHandler().release(ka);
                            }
                            if (key.isValid()) {
                                key.cancel();
                            }
                            if (key.channel().isOpen()) {
                                try {
                                    key.channel().close();
                                }
                                catch (Exception e) {
                                    if (!log.isDebugEnabled()) break block15;
                                    log.debug((Object)AbstractEndpoint.sm.getString("endpoint.debug.channelCloseFail"), (Throwable)e);
                                }
                            }
                        }
                        try {
                            if (ka != null) {
                                ((NioChannel)ka.getSocket()).close(true);
                            }
                        }
                        catch (Exception e) {
                            if (!log.isDebugEnabled()) break block16;
                            log.debug((Object)AbstractEndpoint.sm.getString("endpoint.debug.socketCloseFail"), (Throwable)e);
                        }
                    }
                    try {
                        if (ka != null && ka.getSendfileData() != null && ka.getSendfileData().fchannel != null && ka.getSendfileData().fchannel.isOpen()) {
                            ka.getSendfileData().fchannel.close();
                        }
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    if (ka != null) {
                        NioEndpoint.this.countDownConnection();
                    }
                }
                catch (Throwable e) {
                    ExceptionUtils.handleThrowable((Throwable)e);
                    if (!log.isDebugEnabled()) break block17;
                    log.error((Object)"", e);
                }
            }
            return ka;
        }

        @Override
        public void run() {
            while (true) {
                Iterator<SelectionKey> iterator;
                boolean hasEvents = false;
                try {
                    if (!this.close) {
                        hasEvents = this.events();
                        this.keyCount = this.wakeupCounter.getAndSet(-1L) > 0L ? this.selector.selectNow() : this.selector.select(NioEndpoint.this.selectorTimeout);
                        this.wakeupCounter.set(0L);
                    }
                    if (this.close) {
                        this.events();
                        this.timeout(0, false);
                        try {
                            this.selector.close();
                        }
                        catch (IOException ioe) {
                            log.error((Object)AbstractEndpoint.sm.getString("endpoint.nio.selectorCloseFail"), (Throwable)ioe);
                        }
                        break;
                    }
                }
                catch (Throwable x) {
                    ExceptionUtils.handleThrowable((Throwable)x);
                    log.error((Object)"", x);
                    continue;
                }
                if (this.keyCount == 0) {
                    hasEvents |= this.events();
                }
                Iterator<SelectionKey> iterator2 = iterator = this.keyCount > 0 ? this.selector.selectedKeys().iterator() : null;
                while (iterator != null && iterator.hasNext()) {
                    SelectionKey sk = iterator.next();
                    NioSocketWrapper attachment = (NioSocketWrapper)sk.attachment();
                    if (attachment == null) {
                        iterator.remove();
                        continue;
                    }
                    iterator.remove();
                    this.processKey(sk, attachment);
                }
                this.timeout(this.keyCount, hasEvents);
            }
            NioEndpoint.this.stopLatch.countDown();
        }

        protected void processKey(SelectionKey sk, NioSocketWrapper attachment) {
            try {
                if (this.close) {
                    this.cancelledKey(sk);
                } else if (sk.isValid() && attachment != null) {
                    if (sk.isReadable() || sk.isWritable()) {
                        if (attachment.getSendfileData() != null) {
                            this.processSendfile(sk, attachment, false);
                        } else if (NioEndpoint.this.isWorkerAvailable()) {
                            this.unreg(sk, attachment, sk.readyOps());
                            boolean closeSocket = false;
                            if (sk.isReadable() && !NioEndpoint.this.processSocket(attachment, SocketEvent.OPEN_READ, true)) {
                                closeSocket = true;
                            }
                            if (!closeSocket && sk.isWritable() && !NioEndpoint.this.processSocket(attachment, SocketEvent.OPEN_WRITE, true)) {
                                closeSocket = true;
                            }
                            if (closeSocket) {
                                this.cancelledKey(sk);
                            }
                        }
                    }
                } else {
                    this.cancelledKey(sk);
                }
            }
            catch (CancelledKeyException ckx) {
                this.cancelledKey(sk);
            }
            catch (Throwable t) {
                ExceptionUtils.handleThrowable((Throwable)t);
                log.error((Object)"", t);
            }
        }

        public SendfileState processSendfile(SelectionKey sk, NioSocketWrapper socketWrapper, boolean calledByProcessor) {
            NioChannel sc = null;
            try {
                ByteChannel wc;
                this.unreg(sk, socketWrapper, sk.readyOps());
                SendfileData sd = socketWrapper.getSendfileData();
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Processing send file for: " + sd.fileName));
                }
                if (sd.fchannel == null) {
                    File f = new File(sd.fileName);
                    if (!f.exists()) {
                        this.cancelledKey(sk);
                        return SendfileState.ERROR;
                    }
                    FileInputStream fis = new FileInputStream(f);
                    sd.fchannel = fis.getChannel();
                }
                ByteChannel byteChannel = wc = (sc = (NioChannel)socketWrapper.getSocket()) instanceof SecureNioChannel ? sc : sc.getIOChannel();
                if (sc.getOutboundRemaining() > 0) {
                    if (sc.flushOutbound()) {
                        socketWrapper.updateLastWrite();
                    }
                } else {
                    long written = sd.fchannel.transferTo(sd.pos, sd.length, wc);
                    if (written > 0L) {
                        sd.pos += written;
                        sd.length -= written;
                        socketWrapper.updateLastWrite();
                    } else if (sd.fchannel.size() <= sd.pos) {
                        throw new IOException("Sendfile configured to send more data than was available");
                    }
                }
                if (sd.length <= 0L && sc.getOutboundRemaining() <= 0) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Send file complete for: " + sd.fileName));
                    }
                    socketWrapper.setSendfileData(null);
                    try {
                        sd.fchannel.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (!calledByProcessor) {
                        if (sd.keepAlive) {
                            if (log.isDebugEnabled()) {
                                log.debug((Object)"Connection is keep alive, registering back for OP_READ");
                            }
                            this.reg(sk, socketWrapper, 1);
                        } else {
                            if (log.isDebugEnabled()) {
                                log.debug((Object)"Send file connection is being closed");
                            }
                            NioEndpoint.this.close(sc, sk);
                        }
                    }
                    return SendfileState.DONE;
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("OP_WRITE for sendfile: " + sd.fileName));
                }
                if (calledByProcessor) {
                    this.add((NioChannel)socketWrapper.getSocket(), 4);
                } else {
                    this.reg(sk, socketWrapper, 4);
                }
                return SendfileState.PENDING;
            }
            catch (IOException x) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Unable to complete sendfile request:", (Throwable)x);
                }
                if (!calledByProcessor && sc != null) {
                    NioEndpoint.this.close(sc, sk);
                } else {
                    this.cancelledKey(sk);
                }
                return SendfileState.ERROR;
            }
            catch (Throwable t) {
                log.error((Object)"", t);
                if (!calledByProcessor && sc != null) {
                    NioEndpoint.this.close(sc, sk);
                } else {
                    this.cancelledKey(sk);
                }
                return SendfileState.ERROR;
            }
        }

        protected void unreg(SelectionKey sk, NioSocketWrapper attachment, int readyOps) {
            this.reg(sk, attachment, sk.interestOps() & ~readyOps);
        }

        protected void reg(SelectionKey sk, NioSocketWrapper attachment, int intops) {
            sk.interestOps(intops);
            attachment.interestOps(intops);
        }

        protected void timeout(int keyCount, boolean hasEvents) {
            long now = System.currentTimeMillis();
            if (this.nextExpiration > 0L && (keyCount > 0 || hasEvents) && now < this.nextExpiration && !this.close) {
                return;
            }
            int keycount = 0;
            try {
                for (SelectionKey key : this.selector.keys()) {
                    ++keycount;
                    try {
                        long timeout;
                        long delta;
                        NioSocketWrapper ka = (NioSocketWrapper)key.attachment();
                        if (ka == null) {
                            this.cancelledKey(key);
                            continue;
                        }
                        if (this.close) {
                            key.interestOps(0);
                            ka.interestOps(0);
                            this.processKey(key, ka);
                            continue;
                        }
                        if ((ka.interestOps() & 1) != 1 && (ka.interestOps() & 4) != 4) continue;
                        boolean isTimedOut = false;
                        if ((ka.interestOps() & 1) == 1) {
                            delta = now - ka.getLastRead();
                            timeout = ka.getReadTimeout();
                            boolean bl = isTimedOut = timeout > 0L && delta > timeout;
                        }
                        if (!isTimedOut && (ka.interestOps() & 4) == 4) {
                            delta = now - ka.getLastWrite();
                            timeout = ka.getWriteTimeout();
                            boolean bl = isTimedOut = timeout > 0L && delta > timeout;
                        }
                        if (!isTimedOut) continue;
                        key.interestOps(0);
                        ka.interestOps(0);
                        this.cancelledKey(key);
                    }
                    catch (CancelledKeyException ckx) {
                        this.cancelledKey(key);
                    }
                }
            }
            catch (ConcurrentModificationException cme) {
                log.warn((Object)AbstractEndpoint.sm.getString("endpoint.nio.timeoutCme"), (Throwable)cme);
            }
            long prevExp = this.nextExpiration;
            this.nextExpiration = System.currentTimeMillis() + NioEndpoint.this.socketProperties.getTimeoutInterval();
            if (log.isTraceEnabled()) {
                log.trace((Object)("timeout completed: keys processed=" + keycount + "; now=" + now + "; nextExpiration=" + prevExp + "; keyCount=" + keyCount + "; hasEvents=" + hasEvents + "; eval=" + (now < prevExp && (keyCount > 0 || hasEvents) && !this.close)));
            }
        }
    }

    public static class PollerEvent
    implements Runnable {
        private NioChannel socket;
        private int interestOps;
        private NioSocketWrapper key;

        public PollerEvent(NioChannel ch, NioSocketWrapper k, int intOps) {
            this.reset(ch, k, intOps);
        }

        public void reset(NioChannel ch, NioSocketWrapper k, int intOps) {
            this.socket = ch;
            this.interestOps = intOps;
            this.key = k;
        }

        public void reset() {
            this.reset(null, null, 0);
        }

        @Override
        public void run() {
            if (this.interestOps == 256) {
                try {
                    this.socket.getIOChannel().register(this.socket.getPoller().getSelector(), 1, this.key);
                }
                catch (Exception x) {
                    log.error((Object)"", (Throwable)x);
                }
            } else {
                SelectionKey key = this.socket.getIOChannel().keyFor(this.socket.getPoller().getSelector());
                try {
                    boolean cancel = false;
                    if (key != null) {
                        NioSocketWrapper att = (NioSocketWrapper)key.attachment();
                        if (att != null) {
                            int ops = key.interestOps() | this.interestOps;
                            att.interestOps(ops);
                            key.interestOps(ops);
                        } else {
                            cancel = true;
                        }
                    } else {
                        cancel = true;
                    }
                    if (cancel) {
                        this.socket.getPoller().cancelledKey(key);
                    }
                }
                catch (CancelledKeyException ckx) {
                    try {
                        this.socket.getPoller().cancelledKey(key);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }

        public String toString() {
            return super.toString() + "[intOps=" + this.interestOps + "]";
        }
    }

    protected class Acceptor
    extends AbstractEndpoint.Acceptor {
        protected Acceptor() {
        }

        @Override
        public void run() {
            int errorDelay = 0;
            while (NioEndpoint.this.running) {
                while (NioEndpoint.this.paused && NioEndpoint.this.running) {
                    this.state = AbstractEndpoint.Acceptor.AcceptorState.PAUSED;
                    try {
                        Thread.sleep(50L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                if (!NioEndpoint.this.running) break;
                this.state = AbstractEndpoint.Acceptor.AcceptorState.RUNNING;
                try {
                    NioEndpoint.this.countUpOrAwaitConnection();
                    SocketChannel socket = null;
                    try {
                        socket = NioEndpoint.this.serverSock.accept();
                    }
                    catch (IOException ioe) {
                        NioEndpoint.this.countDownConnection();
                        errorDelay = NioEndpoint.this.handleExceptionWithDelay(errorDelay);
                        throw ioe;
                    }
                    errorDelay = 0;
                    if (NioEndpoint.this.running && !NioEndpoint.this.paused) {
                        if (NioEndpoint.this.setSocketOptions(socket)) continue;
                        NioEndpoint.this.countDownConnection();
                        NioEndpoint.this.closeSocket(socket);
                        continue;
                    }
                    NioEndpoint.this.countDownConnection();
                    NioEndpoint.this.closeSocket(socket);
                }
                catch (SocketTimeoutException socket) {
                }
                catch (IOException x) {
                    if (!NioEndpoint.this.running) continue;
                    log.error((Object)AbstractEndpoint.sm.getString("endpoint.accept.fail"), (Throwable)x);
                }
                catch (Throwable t) {
                    ExceptionUtils.handleThrowable((Throwable)t);
                    log.error((Object)AbstractEndpoint.sm.getString("endpoint.accept.fail"), t);
                }
            }
            this.state = AbstractEndpoint.Acceptor.AcceptorState.ENDED;
        }
    }
}

