/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.net;

import java.util.HashSet;
import java.util.Set;
import org.apache.tomcat.util.net.SSLContext;
import org.apache.tomcat.util.net.SSLHostConfig;
import org.apache.tomcat.util.net.openssl.ciphers.Authentication;

public class SSLHostConfigCertificate {
    public static final Type DEFAULT_TYPE = Type.UNDEFINED;
    static final String DEFAULT_KEYSTORE_PROVIDER = System.getProperty("javax.net.ssl.keyStoreProvider");
    static final String DEFAULT_KEYSTORE_TYPE = System.getProperty("javax.net.ssl.keyStoreType", "JKS");
    private SSLContext sslContext;
    private final SSLHostConfig sslHostConfig;
    private final Type type;
    private String certificateKeyPassword = null;
    private String certificateKeyAlias = "tomcat";
    private String certificateKeystorePassword = "changeit";
    private String certificateKeystoreFile = System.getProperty("user.home") + "/.keystore";
    private String certificateKeystoreProvider = DEFAULT_KEYSTORE_PROVIDER;
    private String certificateKeystoreType = DEFAULT_KEYSTORE_TYPE;
    private String certificateChainFile;
    private String certificateFile;
    private String certificateKeyFile;

    public SSLHostConfigCertificate() {
        this(null, Type.UNDEFINED);
    }

    public SSLHostConfigCertificate(SSLHostConfig sslHostConfig, Type type) {
        this.sslHostConfig = sslHostConfig;
        this.type = type;
    }

    public SSLContext getSslContext() {
        return this.sslContext;
    }

    public void setSslContext(SSLContext sslContext) {
        this.sslContext = sslContext;
    }

    public SSLHostConfig getSSLHostConfig() {
        return this.sslHostConfig;
    }

    public Type getType() {
        return this.type;
    }

    public String getCertificateKeyPassword() {
        return this.certificateKeyPassword;
    }

    public void setCertificateKeyPassword(String certificateKeyPassword) {
        this.certificateKeyPassword = certificateKeyPassword;
    }

    public void setCertificateKeyAlias(String certificateKeyAlias) {
        this.sslHostConfig.setProperty("Certificate.certificateKeyAlias", SSLHostConfig.Type.JSSE);
        this.certificateKeyAlias = certificateKeyAlias;
    }

    public String getCertificateKeyAlias() {
        return this.certificateKeyAlias;
    }

    public void setCertificateKeystoreFile(String certificateKeystoreFile) {
        this.sslHostConfig.setProperty("Certificate.certificateKeystoreFile", SSLHostConfig.Type.JSSE);
        this.certificateKeystoreFile = certificateKeystoreFile;
    }

    public String getCertificateKeystoreFile() {
        return this.certificateKeystoreFile;
    }

    public void setCertificateKeystorePassword(String certificateKeystorePassword) {
        this.sslHostConfig.setProperty("Certificate.certificateKeystorePassword", SSLHostConfig.Type.JSSE);
        this.certificateKeystorePassword = certificateKeystorePassword;
    }

    public String getCertificateKeystorePassword() {
        return this.certificateKeystorePassword;
    }

    public void setCertificateKeystoreProvider(String certificateKeystoreProvider) {
        this.sslHostConfig.setProperty("Certificate.certificateKeystoreProvider", SSLHostConfig.Type.JSSE);
        this.certificateKeystoreProvider = certificateKeystoreProvider;
    }

    public String getCertificateKeystoreProvider() {
        return this.certificateKeystoreProvider;
    }

    public void setCertificateKeystoreType(String certificateKeystoreType) {
        this.sslHostConfig.setProperty("Certificate.certificateKeystoreType", SSLHostConfig.Type.JSSE);
        this.certificateKeystoreType = certificateKeystoreType;
    }

    public String getCertificateKeystoreType() {
        return this.certificateKeystoreType;
    }

    public void setCertificateChainFile(String certificateChainFile) {
        this.sslHostConfig.setProperty("Certificate.certificateChainFile", SSLHostConfig.Type.OPENSSL);
        this.certificateChainFile = certificateChainFile;
    }

    public String getCertificateChainFile() {
        return this.certificateChainFile;
    }

    public void setCertificateFile(String certificateFile) {
        this.sslHostConfig.setProperty("Certificate.certificateFile", SSLHostConfig.Type.OPENSSL);
        this.certificateFile = certificateFile;
    }

    public String getCertificateFile() {
        return this.certificateFile;
    }

    public void setCertificateKeyFile(String certificateKeyFile) {
        this.sslHostConfig.setProperty("Certificate.certificateKeyFile", SSLHostConfig.Type.OPENSSL);
        this.certificateKeyFile = certificateKeyFile;
    }

    public String getCertificateKeyFile() {
        return this.certificateKeyFile;
    }

    public static enum Type {
        UNDEFINED(new Authentication[0]),
        RSA(Authentication.RSA),
        DSA(Authentication.DSS),
        EC(Authentication.ECDH, Authentication.ECDSA);

        private final Set<Authentication> compatibleAuthentications = new HashSet<Authentication>();

        private Type(Authentication ... authentications) {
            if (authentications != null) {
                for (Authentication authentication : authentications) {
                    this.compatibleAuthentications.add(authentication);
                }
            }
        }

        public boolean isCompatibleWith(Authentication au) {
            return this.compatibleAuthentications.contains((Object)au);
        }
    }
}

