/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.http11;

import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import org.apache.coyote.InputBuffer;
import org.apache.coyote.Request;
import org.apache.coyote.http11.InputFilter;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.buf.ByteChunk;
import org.apache.tomcat.util.buf.MessageBytes;
import org.apache.tomcat.util.http.MimeHeaders;
import org.apache.tomcat.util.net.SocketWrapperBase;
import org.apache.tomcat.util.res.StringManager;

public class Http11InputBuffer
implements InputBuffer {
    private static final Log log = LogFactory.getLog(Http11InputBuffer.class);
    private static final StringManager sm = StringManager.getManager(Http11InputBuffer.class);
    private static final boolean[] HTTP_TOKEN_CHAR = new boolean[128];
    private static final byte[] CLIENT_PREFACE_START;
    private final Request request;
    private final MimeHeaders headers;
    private boolean parsingHeader;
    private boolean swallowInput;
    private byte[] buf;
    private int lastValid;
    private int pos;
    private int end;
    private SocketWrapperBase<?> wrapper;
    private InputBuffer inputStreamInputBuffer;
    private InputFilter[] filterLibrary;
    private InputFilter[] activeFilters;
    private int lastActiveFilter;
    private boolean parsingRequestLine;
    private int parsingRequestLinePhase = 0;
    private boolean parsingRequestLineEol = false;
    private int parsingRequestLineStart = 0;
    private int parsingRequestLineQPos = -1;
    private HeaderParsePosition headerParsePos;
    private final HeaderParseData headerData = new HeaderParseData();
    private final int headerBufferSize;
    private int socketReadBufferSize;

    public Http11InputBuffer(Request request, int headerBufferSize) {
        this.request = request;
        this.headers = request.getMimeHeaders();
        this.headerBufferSize = headerBufferSize;
        this.filterLibrary = new InputFilter[0];
        this.activeFilters = new InputFilter[0];
        this.lastActiveFilter = -1;
        this.parsingHeader = true;
        this.parsingRequestLine = true;
        this.parsingRequestLinePhase = 0;
        this.parsingRequestLineEol = false;
        this.parsingRequestLineStart = 0;
        this.parsingRequestLineQPos = -1;
        this.headerParsePos = HeaderParsePosition.HEADER_START;
        this.swallowInput = true;
        this.inputStreamInputBuffer = new SocketInputBuffer();
    }

    void addFilter(InputFilter filter) {
        if (filter == null) {
            throw new NullPointerException(sm.getString("iib.filter.npe"));
        }
        InputFilter[] newFilterLibrary = new InputFilter[this.filterLibrary.length + 1];
        for (int i = 0; i < this.filterLibrary.length; ++i) {
            newFilterLibrary[i] = this.filterLibrary[i];
        }
        newFilterLibrary[this.filterLibrary.length] = filter;
        this.filterLibrary = newFilterLibrary;
        this.activeFilters = new InputFilter[this.filterLibrary.length];
    }

    InputFilter[] getFilters() {
        return this.filterLibrary;
    }

    void addActiveFilter(InputFilter filter) {
        if (this.lastActiveFilter == -1) {
            filter.setBuffer(this.inputStreamInputBuffer);
        } else {
            for (int i = 0; i <= this.lastActiveFilter; ++i) {
                if (this.activeFilters[i] != filter) continue;
                return;
            }
            filter.setBuffer(this.activeFilters[this.lastActiveFilter]);
        }
        this.activeFilters[++this.lastActiveFilter] = filter;
        filter.setRequest(this.request);
    }

    void setSwallowInput(boolean swallowInput) {
        this.swallowInput = swallowInput;
    }

    @Override
    public int doRead(ByteChunk chunk) throws IOException {
        if (this.lastActiveFilter == -1) {
            return this.inputStreamInputBuffer.doRead(chunk);
        }
        return this.activeFilters[this.lastActiveFilter].doRead(chunk);
    }

    void recycle() {
        this.wrapper = null;
        this.request.recycle();
        for (int i = 0; i <= this.lastActiveFilter; ++i) {
            this.activeFilters[i].recycle();
        }
        this.lastValid = 0;
        this.pos = 0;
        this.lastActiveFilter = -1;
        this.parsingHeader = true;
        this.swallowInput = true;
        this.headerParsePos = HeaderParsePosition.HEADER_START;
        this.parsingRequestLine = true;
        this.parsingRequestLinePhase = 0;
        this.parsingRequestLineEol = false;
        this.parsingRequestLineStart = 0;
        this.parsingRequestLineQPos = -1;
        this.headerData.recycle();
    }

    void nextRequest() {
        this.request.recycle();
        if (this.lastValid - this.pos > 0 && this.pos > 0) {
            System.arraycopy(this.buf, this.pos, this.buf, 0, this.lastValid - this.pos);
        }
        this.lastValid -= this.pos;
        this.pos = 0;
        for (int i = 0; i <= this.lastActiveFilter; ++i) {
            this.activeFilters[i].recycle();
        }
        this.lastActiveFilter = -1;
        this.parsingHeader = true;
        this.swallowInput = true;
        this.headerParsePos = HeaderParsePosition.HEADER_START;
        this.parsingRequestLine = true;
        this.parsingRequestLinePhase = 0;
        this.parsingRequestLineEol = false;
        this.parsingRequestLineStart = 0;
        this.parsingRequestLineQPos = -1;
        this.headerData.recycle();
    }

    boolean parseRequestLine(boolean keptAlive) throws IOException {
        boolean space;
        if (!this.parsingRequestLine) {
            return true;
        }
        if (this.parsingRequestLinePhase < 2) {
            byte chr = 0;
            do {
                if (this.pos >= this.lastValid) {
                    if (keptAlive) {
                        this.wrapper.setReadTimeout(this.wrapper.getEndpoint().getKeepAliveTimeout());
                    }
                    if (!this.fill(false)) {
                        this.parsingRequestLinePhase = 1;
                        return false;
                    }
                    this.wrapper.setReadTimeout(this.wrapper.getEndpoint().getSoTimeout());
                }
                if (!keptAlive && this.pos == 0 && this.lastValid >= CLIENT_PREFACE_START.length - 1) {
                    boolean prefaceMatch = true;
                    for (int i = 0; i < CLIENT_PREFACE_START.length; ++i) {
                        if (CLIENT_PREFACE_START[i] == this.buf[i]) continue;
                        prefaceMatch = false;
                    }
                    if (prefaceMatch) {
                        this.parsingRequestLinePhase = -1;
                        return false;
                    }
                }
                if (this.request.getStartTime() >= 0L) continue;
                this.request.setStartTime(System.currentTimeMillis());
            } while ((chr = this.buf[this.pos++]) == 13 || chr == 10);
            --this.pos;
            this.parsingRequestLineStart = this.pos;
            this.parsingRequestLinePhase = 2;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Received [" + new String(this.buf, this.pos, this.lastValid - this.pos, StandardCharsets.ISO_8859_1) + "]"));
            }
        }
        if (this.parsingRequestLinePhase == 2) {
            space = false;
            while (!space) {
                if (this.pos >= this.lastValid && !this.fill(false)) {
                    return false;
                }
                if (this.buf[this.pos] == 13 || this.buf[this.pos] == 10) {
                    throw new IllegalArgumentException(sm.getString("iib.invalidmethod"));
                }
                if (this.buf[this.pos] == 32 || this.buf[this.pos] == 9) {
                    space = true;
                    this.request.method().setBytes(this.buf, this.parsingRequestLineStart, this.pos - this.parsingRequestLineStart);
                }
                ++this.pos;
            }
            this.parsingRequestLinePhase = 3;
        }
        if (this.parsingRequestLinePhase == 3) {
            space = true;
            while (space) {
                if (this.pos >= this.lastValid && !this.fill(false)) {
                    return false;
                }
                if (this.buf[this.pos] == 32 || this.buf[this.pos] == 9) {
                    ++this.pos;
                    continue;
                }
                space = false;
            }
            this.parsingRequestLineStart = this.pos;
            this.parsingRequestLinePhase = 4;
        }
        if (this.parsingRequestLinePhase == 4) {
            int end = 0;
            boolean space2 = false;
            while (!space2) {
                if (this.pos >= this.lastValid && !this.fill(false)) {
                    return false;
                }
                if (this.buf[this.pos] == 32 || this.buf[this.pos] == 9) {
                    space2 = true;
                    end = this.pos;
                } else if (this.buf[this.pos] == 13 || this.buf[this.pos] == 10) {
                    this.parsingRequestLineEol = true;
                    space2 = true;
                    end = this.pos;
                } else if (this.buf[this.pos] == 63 && this.parsingRequestLineQPos == -1) {
                    this.parsingRequestLineQPos = this.pos;
                }
                ++this.pos;
            }
            if (this.parsingRequestLineQPos >= 0) {
                this.request.queryString().setBytes(this.buf, this.parsingRequestLineQPos + 1, end - this.parsingRequestLineQPos - 1);
                this.request.requestURI().setBytes(this.buf, this.parsingRequestLineStart, this.parsingRequestLineQPos - this.parsingRequestLineStart);
            } else {
                this.request.requestURI().setBytes(this.buf, this.parsingRequestLineStart, end - this.parsingRequestLineStart);
            }
            this.parsingRequestLinePhase = 5;
        }
        if (this.parsingRequestLinePhase == 5) {
            space = true;
            while (space) {
                if (this.pos >= this.lastValid && !this.fill(false)) {
                    return false;
                }
                if (this.buf[this.pos] == 32 || this.buf[this.pos] == 9) {
                    ++this.pos;
                    continue;
                }
                space = false;
            }
            this.parsingRequestLineStart = this.pos;
            this.parsingRequestLinePhase = 6;
            this.end = 0;
        }
        if (this.parsingRequestLinePhase == 6) {
            while (!this.parsingRequestLineEol) {
                if (this.pos >= this.lastValid && !this.fill(false)) {
                    return false;
                }
                if (this.buf[this.pos] == 13) {
                    this.end = this.pos;
                } else if (this.buf[this.pos] == 10) {
                    if (this.end == 0) {
                        this.end = this.pos;
                    }
                    this.parsingRequestLineEol = true;
                }
                ++this.pos;
            }
            if (this.end - this.parsingRequestLineStart > 0) {
                this.request.protocol().setBytes(this.buf, this.parsingRequestLineStart, this.end - this.parsingRequestLineStart);
            } else {
                this.request.protocol().setString("");
            }
            this.parsingRequestLine = false;
            this.parsingRequestLinePhase = 0;
            this.parsingRequestLineEol = false;
            this.parsingRequestLineStart = 0;
            return true;
        }
        throw new IllegalStateException("Invalid request line parse phase:" + this.parsingRequestLinePhase);
    }

    boolean parseHeaders() throws IOException {
        if (!this.parsingHeader) {
            throw new IllegalStateException(sm.getString("iib.parseheaders.ise.error"));
        }
        HeaderParseStatus status = HeaderParseStatus.HAVE_MORE_HEADERS;
        do {
            status = this.parseHeader();
            if (this.pos <= this.headerBufferSize && this.buf.length - this.pos >= this.socketReadBufferSize) continue;
            throw new IllegalArgumentException(sm.getString("iib.requestheadertoolarge.error"));
        } while (status == HeaderParseStatus.HAVE_MORE_HEADERS);
        if (status == HeaderParseStatus.DONE) {
            this.parsingHeader = false;
            this.end = this.pos;
            return true;
        }
        return false;
    }

    int getParsingRequestLinePhase() {
        return this.parsingRequestLinePhase;
    }

    void endRequest() throws IOException {
        if (this.swallowInput && this.lastActiveFilter != -1) {
            int extraBytes = (int)this.activeFilters[this.lastActiveFilter].end();
            this.pos -= extraBytes;
        }
    }

    int available(boolean read) {
        int available = this.lastValid - this.pos;
        if (available == 0 && this.lastActiveFilter >= 0) {
            for (int i = 0; available == 0 && i <= this.lastActiveFilter; ++i) {
                available = this.activeFilters[i].available();
            }
        }
        if (available > 0 || !read) {
            return available;
        }
        try {
            this.fill(false);
            available = this.lastValid - this.pos;
        }
        catch (IOException ioe) {
            if (log.isDebugEnabled()) {
                log.debug((Object)sm.getString("iib.available.readFail"), (Throwable)ioe);
            }
            available = 1;
        }
        return available;
    }

    boolean isFinished() {
        if (this.lastValid > this.pos) {
            return false;
        }
        if (this.lastActiveFilter >= 0) {
            return this.activeFilters[this.lastActiveFilter].isFinished();
        }
        return false;
    }

    ByteBuffer getLeftover() {
        int available = this.lastValid - this.pos;
        if (available > 0) {
            return ByteBuffer.wrap(this.buf, this.pos, available);
        }
        return null;
    }

    void init(SocketWrapperBase<?> socketWrapper) {
        this.wrapper = socketWrapper;
        int bufLength = this.headerBufferSize + this.wrapper.getSocketBufferHandler().getReadBuffer().capacity();
        if (this.buf == null || this.buf.length < bufLength) {
            this.buf = new byte[bufLength];
        }
    }

    private boolean fill(boolean block) throws IOException {
        int nRead;
        if (this.parsingHeader) {
            if (this.lastValid >= this.headerBufferSize) {
                throw new IllegalArgumentException(sm.getString("iib.requestheadertoolarge.error"));
            }
        } else {
            this.lastValid = this.pos = this.end;
        }
        if ((nRead = this.wrapper.read(block, this.buf, this.pos, this.buf.length - this.pos)) > 0) {
            this.lastValid = this.pos + nRead;
            return true;
        }
        if (nRead == -1) {
            throw new EOFException(sm.getString("iib.eof.error"));
        }
        return false;
    }

    private HeaderParseStatus parseHeader() throws IOException {
        byte chr = 0;
        while (this.headerParsePos == HeaderParsePosition.HEADER_START) {
            if (this.pos >= this.lastValid && !this.fill(false)) {
                this.headerParsePos = HeaderParsePosition.HEADER_START;
                return HeaderParseStatus.NEED_MORE_DATA;
            }
            chr = this.buf[this.pos];
            if (chr != 13) {
                if (chr != 10) break;
                ++this.pos;
                return HeaderParseStatus.DONE;
            }
            ++this.pos;
        }
        if (this.headerParsePos == HeaderParsePosition.HEADER_START) {
            this.headerData.start = this.pos;
            this.headerParsePos = HeaderParsePosition.HEADER_NAME;
        }
        while (this.headerParsePos == HeaderParsePosition.HEADER_NAME) {
            if (this.pos >= this.lastValid && !this.fill(false)) {
                return HeaderParseStatus.NEED_MORE_DATA;
            }
            chr = this.buf[this.pos];
            if (chr == 58) {
                this.headerParsePos = HeaderParsePosition.HEADER_VALUE_START;
                this.headerData.headerValue = this.headers.addValue(this.buf, this.headerData.start, this.pos - this.headerData.start);
                ++this.pos;
                this.headerData.start = this.pos;
                this.headerData.realPos = this.pos;
                this.headerData.lastSignificantChar = this.pos;
                break;
            }
            if (chr < 0 || !HTTP_TOKEN_CHAR[chr]) {
                this.headerData.lastSignificantChar = this.pos;
                return this.skipLine();
            }
            if (chr >= 65 && chr <= 90) {
                this.buf[this.pos] = (byte)(chr - -32);
            }
            ++this.pos;
        }
        if (this.headerParsePos == HeaderParsePosition.HEADER_SKIPLINE) {
            return this.skipLine();
        }
        while (this.headerParsePos == HeaderParsePosition.HEADER_VALUE_START || this.headerParsePos == HeaderParsePosition.HEADER_VALUE || this.headerParsePos == HeaderParsePosition.HEADER_MULTI_LINE) {
            if (this.headerParsePos == HeaderParsePosition.HEADER_VALUE_START) {
                while (true) {
                    if (this.pos >= this.lastValid && !this.fill(false)) {
                        return HeaderParseStatus.NEED_MORE_DATA;
                    }
                    chr = this.buf[this.pos];
                    if (chr != 32 && chr != 9) break;
                    ++this.pos;
                }
                this.headerParsePos = HeaderParsePosition.HEADER_VALUE;
            }
            if (this.headerParsePos == HeaderParsePosition.HEADER_VALUE) {
                boolean eol = false;
                while (!eol) {
                    if (this.pos >= this.lastValid && !this.fill(false)) {
                        return HeaderParseStatus.NEED_MORE_DATA;
                    }
                    chr = this.buf[this.pos];
                    if (chr != 13) {
                        if (chr == 10) {
                            eol = true;
                        } else if (chr == 32 || chr == 9) {
                            this.buf[this.headerData.realPos] = chr;
                            ++this.headerData.realPos;
                        } else {
                            this.buf[this.headerData.realPos] = chr;
                            this.headerData.lastSignificantChar = ++this.headerData.realPos;
                        }
                    }
                    ++this.pos;
                }
                this.headerData.realPos = this.headerData.lastSignificantChar;
                this.headerParsePos = HeaderParsePosition.HEADER_MULTI_LINE;
            }
            if (this.pos >= this.lastValid && !this.fill(false)) {
                return HeaderParseStatus.NEED_MORE_DATA;
            }
            chr = this.buf[this.pos];
            if (this.headerParsePos != HeaderParsePosition.HEADER_MULTI_LINE) continue;
            if (chr != 32 && chr != 9) {
                this.headerParsePos = HeaderParsePosition.HEADER_START;
                break;
            }
            this.buf[this.headerData.realPos] = chr;
            ++this.headerData.realPos;
            this.headerParsePos = HeaderParsePosition.HEADER_VALUE_START;
        }
        this.headerData.headerValue.setBytes(this.buf, this.headerData.start, this.headerData.lastSignificantChar - this.headerData.start);
        this.headerData.recycle();
        return HeaderParseStatus.HAVE_MORE_HEADERS;
    }

    private HeaderParseStatus skipLine() throws IOException {
        this.headerParsePos = HeaderParsePosition.HEADER_SKIPLINE;
        boolean eol = false;
        while (!eol) {
            if (this.pos >= this.lastValid && !this.fill(false)) {
                return HeaderParseStatus.NEED_MORE_DATA;
            }
            if (this.buf[this.pos] != 13) {
                if (this.buf[this.pos] == 10) {
                    eol = true;
                } else {
                    this.headerData.lastSignificantChar = this.pos;
                }
            }
            ++this.pos;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)sm.getString("iib.invalidheader", new Object[]{new String(this.buf, this.headerData.start, this.headerData.lastSignificantChar - this.headerData.start + 1, StandardCharsets.ISO_8859_1)}));
        }
        this.headerParsePos = HeaderParsePosition.HEADER_START;
        return HeaderParseStatus.HAVE_MORE_HEADERS;
    }

    static {
        for (int i = 0; i < 128; ++i) {
            Http11InputBuffer.HTTP_TOKEN_CHAR[i] = i < 32 ? false : (i == 127 ? false : (i == 40 ? false : (i == 41 ? false : (i == 60 ? false : (i == 62 ? false : (i == 64 ? false : (i == 44 ? false : (i == 59 ? false : (i == 58 ? false : (i == 92 ? false : (i == 34 ? false : (i == 47 ? false : (i == 91 ? false : (i == 93 ? false : (i == 63 ? false : (i == 61 ? false : (i == 123 ? false : (i == 125 ? false : i != 32))))))))))))))))));
        }
        CLIENT_PREFACE_START = "PRI * HTTP/2.0\r\n\r\nSM\r\n\r\n".getBytes(StandardCharsets.ISO_8859_1);
    }

    private class SocketInputBuffer
    implements InputBuffer {
        private SocketInputBuffer() {
        }

        @Override
        public int doRead(ByteChunk chunk) throws IOException {
            if (Http11InputBuffer.this.pos >= Http11InputBuffer.this.lastValid && !Http11InputBuffer.this.fill(true)) {
                return -1;
            }
            int length = Http11InputBuffer.this.lastValid - Http11InputBuffer.this.pos;
            chunk.setBytes(Http11InputBuffer.this.buf, Http11InputBuffer.this.pos, length);
            Http11InputBuffer.this.pos = Http11InputBuffer.this.lastValid;
            return length;
        }
    }

    private static class HeaderParseData {
        int start = 0;
        int realPos = 0;
        int lastSignificantChar = 0;
        MessageBytes headerValue = null;

        private HeaderParseData() {
        }

        public void recycle() {
            this.start = 0;
            this.realPos = 0;
            this.lastSignificantChar = 0;
            this.headerValue = null;
        }
    }

    private static enum HeaderParsePosition {
        HEADER_START,
        HEADER_NAME,
        HEADER_VALUE_START,
        HEADER_VALUE,
        HEADER_MULTI_LINE,
        HEADER_SKIPLINE;

    }

    private static enum HeaderParseStatus {
        DONE,
        HAVE_MORE_HEADERS,
        NEED_MORE_DATA;

    }
}

