/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.concurrent.Executor;
import org.apache.coyote.AbstractProcessorLight;
import org.apache.coyote.ActionHook;
import org.apache.coyote.Adapter;
import org.apache.coyote.AsyncStateMachine;
import org.apache.coyote.ContainerThreadMarker;
import org.apache.coyote.ErrorState;
import org.apache.coyote.Request;
import org.apache.coyote.RequestInfo;
import org.apache.coyote.Response;
import org.apache.tomcat.util.ExceptionUtils;
import org.apache.tomcat.util.net.AbstractEndpoint;
import org.apache.tomcat.util.net.SSLSupport;
import org.apache.tomcat.util.net.SocketStatus;
import org.apache.tomcat.util.net.SocketWrapperBase;
import org.apache.tomcat.util.res.StringManager;

public abstract class AbstractProcessor
extends AbstractProcessorLight
implements ActionHook {
    private static final StringManager sm = StringManager.getManager(AbstractProcessor.class);
    protected Adapter adapter;
    protected final AsyncStateMachine asyncStateMachine;
    private volatile long asyncTimeout = -1L;
    protected final AbstractEndpoint<?> endpoint;
    protected final Request request;
    protected final Response response;
    protected volatile SocketWrapperBase<?> socketWrapper = null;
    protected volatile SSLSupport sslSupport;
    private ErrorState errorState = ErrorState.NONE;

    protected AbstractProcessor(Request coyoteRequest, Response coyoteResponse) {
        this(null, coyoteRequest, coyoteResponse);
    }

    public AbstractProcessor(AbstractEndpoint<?> endpoint) {
        this(endpoint, new Request(), new Response());
    }

    private AbstractProcessor(AbstractEndpoint<?> endpoint, Request coyoteRequest, Response coyoteResponse) {
        this.endpoint = endpoint;
        this.asyncStateMachine = new AsyncStateMachine(this);
        this.request = coyoteRequest;
        this.response = coyoteResponse;
        this.response.setHook(this);
        this.request.setResponse(this.response);
        this.request.setHook(this);
    }

    protected void setErrorState(ErrorState errorState, Throwable t) {
        boolean blockIo = this.errorState.isIoAllowed() && !errorState.isIoAllowed();
        this.errorState = this.errorState.getMostSevere(errorState);
        if (blockIo && !ContainerThreadMarker.isContainerThread() && this.isAsync()) {
            if (this.response.getStatus() < 400) {
                this.response.setStatus(500);
            }
            this.getLog().info((Object)sm.getString("abstractProcessor.nonContainerThreadError"), t);
            this.socketWrapper.processSocket(SocketStatus.CLOSE_NOW, true);
        }
    }

    protected ErrorState getErrorState() {
        return this.errorState;
    }

    @Override
    public Request getRequest() {
        return this.request;
    }

    public void setAdapter(Adapter adapter) {
        this.adapter = adapter;
    }

    public Adapter getAdapter() {
        return this.adapter;
    }

    protected final void setSocketWrapper(SocketWrapperBase<?> socketWrapper) {
        this.socketWrapper = socketWrapper;
    }

    protected final SocketWrapperBase<?> getSocketWrapper() {
        return this.socketWrapper;
    }

    @Override
    public final void setSslSupport(SSLSupport sslSupport) {
        this.sslSupport = sslSupport;
    }

    protected Executor getExecutor() {
        return this.endpoint.getExecutor();
    }

    @Override
    public boolean isAsync() {
        return this.asyncStateMachine.isAsync();
    }

    @Override
    public AbstractEndpoint.Handler.SocketState asyncPostProcess() {
        return this.asyncStateMachine.asyncPostProcess();
    }

    @Override
    public void errorDispatch() {
        this.getAdapter().errorDispatch(this.request, this.response);
    }

    @Override
    public final AbstractEndpoint.Handler.SocketState dispatch(SocketStatus status) {
        if (status == SocketStatus.OPEN_WRITE && this.response.getWriteListener() != null) {
            this.asyncStateMachine.asyncOperation();
            try {
                if (this.flushBufferedWrite()) {
                    return AbstractEndpoint.Handler.SocketState.LONG;
                }
            }
            catch (IOException ioe) {
                if (this.getLog().isDebugEnabled()) {
                    this.getLog().debug((Object)"Unable to write async data.", (Throwable)ioe);
                }
                status = SocketStatus.ASYNC_WRITE_ERROR;
                this.request.setAttribute("javax.servlet.error.exception", ioe);
            }
        } else if (status == SocketStatus.OPEN_READ && this.request.getReadListener() != null) {
            this.dispatchNonBlockingRead();
        }
        RequestInfo rp = this.request.getRequestProcessor();
        try {
            rp.setStage(3);
            if (!this.getAdapter().asyncDispatch(this.request, this.response, status)) {
                this.setErrorState(ErrorState.CLOSE_NOW, null);
            }
        }
        catch (InterruptedIOException e) {
            this.setErrorState(ErrorState.CLOSE_CONNECTION_NOW, e);
        }
        catch (Throwable t) {
            ExceptionUtils.handleThrowable((Throwable)t);
            this.setErrorState(ErrorState.CLOSE_NOW, t);
            this.getLog().error((Object)sm.getString("http11processor.request.process"), t);
        }
        rp.setStage(7);
        if (this.getErrorState().isError()) {
            this.request.updateCounters();
            return AbstractEndpoint.Handler.SocketState.CLOSED;
        }
        if (this.isAsync()) {
            return AbstractEndpoint.Handler.SocketState.LONG;
        }
        this.request.updateCounters();
        return this.dispatchEndRequest();
    }

    protected void dispatchNonBlockingRead() {
        this.asyncStateMachine.asyncOperation();
    }

    @Override
    public void timeoutAsync(long now) {
        if (now < 0L) {
            this.doTimeoutAsync();
        } else {
            long asyncStart;
            long asyncTimeout = this.getAsyncTimeout();
            if (asyncTimeout > 0L && now - (asyncStart = this.asyncStateMachine.getLastAsyncStart()) > asyncTimeout) {
                this.doTimeoutAsync();
            }
        }
    }

    private void doTimeoutAsync() {
        this.setAsyncTimeout(-1L);
        this.socketWrapper.processSocket(SocketStatus.TIMEOUT, true);
    }

    public void setAsyncTimeout(long timeout) {
        this.asyncTimeout = timeout;
    }

    public long getAsyncTimeout() {
        return this.asyncTimeout;
    }

    @Override
    public void recycle() {
        this.errorState = ErrorState.NONE;
        this.asyncStateMachine.recycle();
    }

    protected abstract boolean flushBufferedWrite() throws IOException;

    protected abstract AbstractEndpoint.Handler.SocketState dispatchEndRequest();
}

