/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.http2;

import java.nio.charset.StandardCharsets;
import java.util.Enumeration;
import org.apache.coyote.Adapter;
import org.apache.coyote.Processor;
import org.apache.coyote.Request;
import org.apache.coyote.UpgradeProtocol;
import org.apache.coyote.UpgradeToken;
import org.apache.coyote.http11.upgrade.InternalHttpUpgradeHandler;
import org.apache.coyote.http11.upgrade.UpgradeProcessorInternal;
import org.apache.coyote.http2.Http2UpgradeHandler;
import org.apache.tomcat.util.net.SocketWrapperBase;

public class Http2Protocol
implements UpgradeProtocol {
    static final long DEFAULT_READ_TIMEOUT = 10000L;
    static final long DEFAULT_KEEP_ALIVE_TIMEOUT = -1L;
    static final long DEFAULT_WRITE_TIMEOUT = 10000L;
    static final long DEFAULT_MAX_CONCURRENT_STREAMS = 200L;
    static final int DEFAULT_INITIAL_WINDOW_SIZE = 65535;
    private static final String HTTP_UPGRADE_NAME = "h2c";
    private static final String ALPN_NAME = "h2";
    private static final byte[] ALPN_IDENTIFIER = "h2".getBytes(StandardCharsets.UTF_8);
    private long readTimeout = 10000L;
    private long keepAliveTimeout = -1L;
    private long writeTimeout = 10000L;
    private long maxConcurrentStreams = 200L;
    private int initialWindowSize = 65535;

    @Override
    public String getHttpUpgradeName(boolean isSecure) {
        if (isSecure) {
            return null;
        }
        return HTTP_UPGRADE_NAME;
    }

    @Override
    public byte[] getAlpnIdentifier() {
        return ALPN_IDENTIFIER;
    }

    @Override
    public String getAlpnName() {
        return ALPN_NAME;
    }

    @Override
    public Processor getProcessor(SocketWrapperBase<?> socketWrapper, Adapter adapter) {
        UpgradeProcessorInternal processor = new UpgradeProcessorInternal(socketWrapper, null, new UpgradeToken(this.getInternalUpgradeHandler(adapter, null), Http2Protocol.class.getClassLoader(), null));
        return processor;
    }

    @Override
    public InternalHttpUpgradeHandler getInternalUpgradeHandler(Adapter adapter, Request coyoteRequest) {
        Http2UpgradeHandler result = new Http2UpgradeHandler(adapter, coyoteRequest);
        result.setReadTimeout(this.getReadTimeout());
        result.setKeepAliveTimeout(this.getKeepAliveTimeout());
        result.setWriteTimeout(this.getWriteTimeout());
        result.setMaxConcurrentStreams(this.getMaxConcurrentStreams());
        result.setInitialWindowSize(this.getInitialWindowSize());
        return result;
    }

    @Override
    public boolean accept(Request request) {
        Enumeration<String> settings = request.getMimeHeaders().values("HTTP2-Settings");
        int count = 0;
        while (settings.hasMoreElements()) {
            ++count;
            settings.nextElement();
        }
        if (count != 1) {
            return false;
        }
        Enumeration<String> connection = request.getMimeHeaders().values("Connection");
        boolean found = false;
        while (connection.hasMoreElements() && !found) {
            found = connection.nextElement().contains("HTTP2-Settings");
        }
        return found;
    }

    public long getReadTimeout() {
        return this.readTimeout;
    }

    public void setReadTimeout(long readTimeout) {
        this.readTimeout = readTimeout;
    }

    public long getKeepAliveTimeout() {
        return this.keepAliveTimeout;
    }

    public void setKeepAliveTimeout(long keepAliveTimeout) {
        this.keepAliveTimeout = keepAliveTimeout;
    }

    public long getWriteTimeout() {
        return this.writeTimeout;
    }

    public void setWriteTimeout(long writeTimeout) {
        this.writeTimeout = writeTimeout;
    }

    public long getMaxConcurrentStreams() {
        return this.maxConcurrentStreams;
    }

    public void setMaxConcurrentStreams(long maxConcurrentStreams) {
        this.maxConcurrentStreams = maxConcurrentStreams;
    }

    public int getInitialWindowSize() {
        return this.initialWindowSize;
    }

    public void setInitialWindowSize(int initialWindowSize) {
        this.initialWindowSize = initialWindowSize;
    }
}

