/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.net;

import java.io.EOFException;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.Iterator;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.ExceptionUtils;
import org.apache.tomcat.util.collections.SynchronizedQueue;
import org.apache.tomcat.util.collections.SynchronizedStack;
import org.apache.tomcat.util.net.NioChannel;
import org.apache.tomcat.util.net.NioEndpoint;

public class NioBlockingSelector {
    private static final Log log = LogFactory.getLog(NioBlockingSelector.class);
    private static int threadCounter = 0;
    private final SynchronizedStack<KeyReference> keyReferenceStack = new SynchronizedStack();
    protected Selector sharedSelector;
    protected BlockPoller poller;

    public void open(Selector selector) {
        this.sharedSelector = selector;
        this.poller = new BlockPoller();
        this.poller.selector = this.sharedSelector;
        this.poller.setDaemon(true);
        this.poller.setName("NioBlockingSelector.BlockPoller-" + ++threadCounter);
        this.poller.start();
    }

    public void close() {
        if (this.poller != null) {
            this.poller.disable();
            this.poller.interrupt();
            this.poller = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int write(ByteBuffer buf, NioChannel socket, long writeTimeout) throws IOException {
        SelectionKey key = socket.getIOChannel().keyFor(socket.getPoller().getSelector());
        if (key == null) {
            throw new IOException("Key no longer registered");
        }
        KeyReference reference = (KeyReference)this.keyReferenceStack.pop();
        if (reference == null) {
            reference = new KeyReference();
        }
        NioEndpoint.NioSocketWrapper att = (NioEndpoint.NioSocketWrapper)key.attachment();
        int written = 0;
        boolean timedout = false;
        int keycount = 1;
        long time = System.currentTimeMillis();
        try {
            while (!timedout && buf.hasRemaining()) {
                if (keycount > 0) {
                    int cnt = socket.write(buf);
                    if (cnt == -1) {
                        throw new EOFException();
                    }
                    written += cnt;
                    if (cnt > 0) {
                        time = System.currentTimeMillis();
                        continue;
                    }
                }
                try {
                    if (att.getWriteLatch() == null || att.getWriteLatch().getCount() == 0L) {
                        att.startWriteLatch(1);
                    }
                    this.poller.add(att, 4, reference);
                    if (writeTimeout < 0L) {
                        att.awaitWriteLatch(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
                    } else {
                        att.awaitWriteLatch(writeTimeout, TimeUnit.MILLISECONDS);
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (att.getWriteLatch() != null && att.getWriteLatch().getCount() > 0L) {
                    keycount = 0;
                } else {
                    keycount = 1;
                    att.resetWriteLatch();
                }
                if (writeTimeout <= 0L || keycount != 0) continue;
                timedout = System.currentTimeMillis() - time >= writeTimeout;
            }
            if (timedout) {
                throw new SocketTimeoutException();
            }
        }
        finally {
            this.poller.remove(att, 4);
            if (timedout && reference.key != null) {
                this.poller.cancelKey(reference.key);
            }
            reference.key = null;
            this.keyReferenceStack.push((Object)reference);
        }
        return written;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(ByteBuffer buf, NioChannel socket, long readTimeout) throws IOException {
        SelectionKey key = socket.getIOChannel().keyFor(socket.getPoller().getSelector());
        if (key == null) {
            throw new IOException("Key no longer registered");
        }
        KeyReference reference = (KeyReference)this.keyReferenceStack.pop();
        if (reference == null) {
            reference = new KeyReference();
        }
        NioEndpoint.NioSocketWrapper att = (NioEndpoint.NioSocketWrapper)key.attachment();
        int read = 0;
        boolean timedout = false;
        int keycount = 1;
        long time = System.currentTimeMillis();
        try {
            while (!(timedout || keycount > 0 && (read = socket.read(buf)) != 0)) {
                try {
                    if (att.getReadLatch() == null || att.getReadLatch().getCount() == 0L) {
                        att.startReadLatch(1);
                    }
                    this.poller.add(att, 1, reference);
                    if (readTimeout < 0L) {
                        att.awaitReadLatch(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
                    } else {
                        att.awaitReadLatch(readTimeout, TimeUnit.MILLISECONDS);
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (att.getReadLatch() != null && att.getReadLatch().getCount() > 0L) {
                    keycount = 0;
                } else {
                    keycount = 1;
                    att.resetReadLatch();
                }
                if (readTimeout < 0L || keycount != 0) continue;
                timedout = System.currentTimeMillis() - time >= readTimeout;
            }
            if (timedout) {
                throw new SocketTimeoutException();
            }
        }
        finally {
            this.poller.remove(att, 1);
            if (timedout && reference.key != null) {
                this.poller.cancelKey(reference.key);
            }
            reference.key = null;
            this.keyReferenceStack.push((Object)reference);
        }
        return read;
    }

    public static class KeyReference {
        SelectionKey key = null;

        public void finalize() {
            if (this.key != null && this.key.isValid()) {
                log.warn((Object)"Possible key leak, cancelling key in the finalizer.");
                try {
                    this.key.cancel();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.key = null;
        }
    }

    protected static class BlockPoller
    extends Thread {
        protected volatile boolean run = true;
        protected Selector selector = null;
        protected final SynchronizedQueue<Runnable> events = new SynchronizedQueue();
        protected final AtomicInteger wakeupCounter = new AtomicInteger(0);

        protected BlockPoller() {
        }

        public void disable() {
            this.run = false;
            this.selector.wakeup();
        }

        public void cancelKey(final SelectionKey key) {
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    key.cancel();
                }
            };
            this.events.offer((Object)r);
            this.wakeup();
        }

        public void wakeup() {
            if (this.wakeupCounter.addAndGet(1) == 0) {
                this.selector.wakeup();
            }
        }

        public void cancel(SelectionKey sk, NioEndpoint.NioSocketWrapper key, int ops) {
            if (sk != null) {
                sk.cancel();
                sk.attach(null);
                if (4 == (ops & 4)) {
                    this.countDown(key.getWriteLatch());
                }
                if (1 == (ops & 1)) {
                    this.countDown(key.getReadLatch());
                }
            }
        }

        public void add(final NioEndpoint.NioSocketWrapper key, final int ops, final KeyReference ref) {
            if (key == null) {
                return;
            }
            NioChannel nch = (NioChannel)key.getSocket();
            if (nch == null) {
                return;
            }
            final SocketChannel ch = nch.getIOChannel();
            if (ch == null) {
                return;
            }
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    SelectionKey sk = ch.keyFor(selector);
                    try {
                        if (sk == null) {
                            ref.key = sk = ch.register(selector, ops, key);
                        } else if (!sk.isValid()) {
                            this.cancel(sk, key, ops);
                        } else {
                            sk.interestOps(sk.interestOps() | ops);
                        }
                    }
                    catch (CancelledKeyException cx) {
                        this.cancel(sk, key, ops);
                    }
                    catch (ClosedChannelException cx) {
                        this.cancel(sk, key, ops);
                    }
                }
            };
            this.events.offer((Object)r);
            this.wakeup();
        }

        public void remove(final NioEndpoint.NioSocketWrapper key, final int ops) {
            if (key == null) {
                return;
            }
            NioChannel nch = (NioChannel)key.getSocket();
            if (nch == null) {
                return;
            }
            final SocketChannel ch = nch.getIOChannel();
            if (ch == null) {
                return;
            }
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    block11: {
                        SelectionKey sk = ch.keyFor(selector);
                        try {
                            if (sk == null) {
                                if (4 == (ops & 4)) {
                                    this.countDown(key.getWriteLatch());
                                }
                                if (1 == (ops & 1)) {
                                    this.countDown(key.getReadLatch());
                                }
                            } else if (sk.isValid()) {
                                sk.interestOps(sk.interestOps() & ~ops);
                                if (4 == (ops & 4)) {
                                    this.countDown(key.getWriteLatch());
                                }
                                if (1 == (ops & 1)) {
                                    this.countDown(key.getReadLatch());
                                }
                                if (sk.interestOps() == 0) {
                                    sk.cancel();
                                    sk.attach(null);
                                }
                            } else {
                                sk.cancel();
                                sk.attach(null);
                            }
                        }
                        catch (CancelledKeyException cx) {
                            if (sk == null) break block11;
                            sk.cancel();
                            sk.attach(null);
                        }
                    }
                }
            };
            this.events.offer((Object)r);
            this.wakeup();
        }

        public boolean events() {
            boolean result = false;
            Runnable r = null;
            boolean bl = result = this.events.size() > 0;
            while ((r = (Runnable)this.events.poll()) != null) {
                r.run();
                result = true;
            }
            return result;
        }

        @Override
        public void run() {
            block20: {
                block19: {
                    while (this.run) {
                        try {
                            Iterator<SelectionKey> iterator;
                            this.events();
                            int keyCount = 0;
                            try {
                                int i = this.wakeupCounter.get();
                                if (i > 0) {
                                    keyCount = this.selector.selectNow();
                                } else {
                                    this.wakeupCounter.set(-1);
                                    keyCount = this.selector.select(1000L);
                                }
                                this.wakeupCounter.set(0);
                                if (!this.run) {
                                    break;
                                }
                            }
                            catch (NullPointerException x) {
                                if (this.selector == null) {
                                    throw x;
                                }
                                if (!log.isDebugEnabled()) continue;
                                log.debug((Object)"Possibly encountered sun bug 5076772 on windows JDK 1.5", (Throwable)x);
                                continue;
                            }
                            catch (CancelledKeyException x) {
                                if (!log.isDebugEnabled()) continue;
                                log.debug((Object)"Possibly encountered sun bug 5076772 on windows JDK 1.5", (Throwable)x);
                                continue;
                            }
                            catch (Throwable x) {
                                ExceptionUtils.handleThrowable((Throwable)x);
                                log.error((Object)"", x);
                                continue;
                            }
                            Iterator<SelectionKey> iterator2 = iterator = keyCount > 0 ? this.selector.selectedKeys().iterator() : null;
                            while (this.run && iterator != null && iterator.hasNext()) {
                                SelectionKey sk = iterator.next();
                                NioEndpoint.NioSocketWrapper attachment = (NioEndpoint.NioSocketWrapper)sk.attachment();
                                try {
                                    iterator.remove();
                                    sk.interestOps(sk.interestOps() & ~sk.readyOps());
                                    if (sk.isReadable()) {
                                        this.countDown(attachment.getReadLatch());
                                    }
                                    if (!sk.isWritable()) continue;
                                    this.countDown(attachment.getWriteLatch());
                                }
                                catch (CancelledKeyException ckx) {
                                    sk.cancel();
                                    this.countDown(attachment.getReadLatch());
                                    this.countDown(attachment.getWriteLatch());
                                }
                            }
                        }
                        catch (Throwable t) {
                            log.error((Object)"", t);
                        }
                    }
                    this.events.clear();
                    try {
                        this.selector.selectNow();
                    }
                    catch (Exception ignore) {
                        if (!log.isDebugEnabled()) break block19;
                        log.debug((Object)"", (Throwable)ignore);
                    }
                }
                try {
                    this.selector.close();
                }
                catch (Exception ignore) {
                    if (!log.isDebugEnabled()) break block20;
                    log.debug((Object)"", (Throwable)ignore);
                }
            }
        }

        public void countDown(CountDownLatch latch) {
            if (latch == null) {
                return;
            }
            latch.countDown();
        }
    }
}

