/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.net;

import javax.net.ssl.SSLSession;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.net.SSLHostConfig;
import org.apache.tomcat.util.net.SSLHostConfigCertificate;
import org.apache.tomcat.util.net.SSLSupport;
import org.apache.tomcat.util.net.SSLUtil;

public abstract class SSLImplementation {
    private static final Log logger = LogFactory.getLog(SSLImplementation.class);
    private static final String JSSEImplementationClass = "org.apache.tomcat.util.net.jsse.JSSEImplementation";
    private static final String[] implementations = new String[]{"org.apache.tomcat.util.net.jsse.JSSEImplementation"};

    public static SSLImplementation getInstance() throws ClassNotFoundException {
        for (int i = 0; i < implementations.length; ++i) {
            try {
                SSLImplementation impl = SSLImplementation.getInstance(implementations[i]);
                return impl;
            }
            catch (Exception e) {
                if (!logger.isTraceEnabled()) continue;
                logger.trace((Object)("Error creating " + implementations[i]), (Throwable)e);
                continue;
            }
        }
        throw new ClassNotFoundException("Can't find any SSL implementation");
    }

    public static SSLImplementation getInstance(String className) throws ClassNotFoundException {
        if (className == null) {
            return SSLImplementation.getInstance();
        }
        try {
            Class<?> clazz = Class.forName(className);
            return (SSLImplementation)clazz.newInstance();
        }
        catch (Exception e) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Error loading SSL Implementation " + className), (Throwable)e);
            }
            throw new ClassNotFoundException("Error loading SSL Implementation " + className, e);
        }
    }

    public abstract String getImplementationName();

    public abstract SSLSupport getSSLSupport(SSLSession var1);

    public abstract SSLUtil getSSLUtil(SSLHostConfig var1, SSLHostConfigCertificate var2);
}

