/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.net.openssl;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.StringTokenizer;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import javax.crypto.Cipher;
import javax.crypto.EncryptedPrivateKeyInfo;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSessionContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.jni.CertificateVerifier;
import org.apache.tomcat.jni.Pool;
import org.apache.tomcat.jni.SSL;
import org.apache.tomcat.util.file.ConfigFileLoader;
import org.apache.tomcat.util.net.AbstractEndpoint;
import org.apache.tomcat.util.net.SSLContext;
import org.apache.tomcat.util.net.SSLHostConfig;
import org.apache.tomcat.util.net.SSLHostConfigCertificate;
import org.apache.tomcat.util.net.openssl.CipherSuiteConverter;
import org.apache.tomcat.util.net.openssl.OpenSSLEngine;
import org.apache.tomcat.util.net.openssl.OpenSSLKeyManager;
import org.apache.tomcat.util.net.openssl.OpenSSLServerSessionContext;
import org.apache.tomcat.util.net.openssl.OpenSslX509Certificate;
import org.apache.tomcat.util.net.openssl.ciphers.OpenSSLCipherConfigurationParser;
import org.apache.tomcat.util.res.StringManager;

public class OpenSSLContext
implements SSLContext {
    private static final Log log = LogFactory.getLog(OpenSSLContext.class);
    private static final StringManager netSm = StringManager.getManager(AbstractEndpoint.class);
    private static final StringManager sm = StringManager.getManager(OpenSSLContext.class);
    private static final String defaultProtocol = "TLS";
    private final SSLHostConfig sslHostConfig;
    private final SSLHostConfigCertificate certificate;
    private OpenSSLServerSessionContext sessionContext;
    private final List<String> negotiableProtocols;
    private List<String> ciphers = new ArrayList<String>();
    private String enabledProtocol;
    private final long aprPool;
    protected final long ctx;
    private volatile int aprPoolDestroyed;
    private static final AtomicIntegerFieldUpdater<OpenSSLContext> DESTROY_UPDATER = AtomicIntegerFieldUpdater.newUpdater(OpenSSLContext.class, "aprPoolDestroyed");
    static final CertificateFactory X509_CERT_FACTORY;
    private static final String BEGIN_KEY = "-----BEGIN RSA PRIVATE KEY-----\n";
    private static final Object END_KEY;
    private boolean initialized = false;

    public List<String> getCiphers() {
        return this.ciphers;
    }

    public String getEnabledProtocol() {
        return this.enabledProtocol;
    }

    public void setEnabledProtocol(String protocol) {
        this.enabledProtocol = protocol == null ? defaultProtocol : protocol;
    }

    public OpenSSLContext(SSLHostConfig sslHostConfig, SSLHostConfigCertificate certificate, List<String> negotiableProtocols) throws SSLException {
        this.sslHostConfig = sslHostConfig;
        this.certificate = certificate;
        this.aprPool = Pool.create((long)0L);
        boolean success = false;
        try {
            if (SSLHostConfig.adjustRelativePath(certificate.getCertificateFile()) == null) {
                // empty if block
            }
            int value = 0;
            if (sslHostConfig.getProtocols().size() == 0) {
                value = 28;
            } else {
                for (String protocol : sslHostConfig.getProtocols()) {
                    if ("SSLv2Hello".equalsIgnoreCase(protocol)) continue;
                    if ("SSLv2".equalsIgnoreCase(protocol)) {
                        value |= 1;
                        continue;
                    }
                    if ("SSLv3".equalsIgnoreCase(protocol)) {
                        value |= 2;
                        continue;
                    }
                    if ("TLSv1".equalsIgnoreCase(protocol)) {
                        value |= 4;
                        continue;
                    }
                    if ("TLSv1.1".equalsIgnoreCase(protocol)) {
                        value |= 8;
                        continue;
                    }
                    if ("TLSv1.2".equalsIgnoreCase(protocol)) {
                        value |= 0x10;
                        continue;
                    }
                    if ("all".equalsIgnoreCase(protocol)) {
                        value |= 0x1C;
                        continue;
                    }
                    throw new Exception(netSm.getString("endpoint.apr.invalidSslProtocol", new Object[]{protocol}));
                }
            }
            try {
                this.ctx = org.apache.tomcat.jni.SSLContext.make((long)this.aprPool, (int)value, (int)1);
            }
            catch (Exception e) {
                throw new Exception(netSm.getString("endpoint.apr.failSslContextMake"), e);
            }
            this.negotiableProtocols = negotiableProtocols;
            success = true;
        }
        catch (Exception e) {
            throw new SSLException(sm.getString("openssl.errorSSLCtxInit"), e);
        }
        finally {
            if (!success) {
                this.destroyPools();
            }
        }
    }

    private void destroyPools() {
        if (this.aprPool != 0L && DESTROY_UPDATER.compareAndSet(this, 0, 1)) {
            Pool.destroy((long)this.aprPool);
        }
    }

    @Override
    public synchronized void init(KeyManager[] kms, TrustManager[] tms, SecureRandom sr) {
        if (this.initialized) {
            log.warn((Object)sm.getString("openssl.doubleInit"));
            return;
        }
        try {
            boolean legacyRenegSupported = false;
            try {
                legacyRenegSupported = SSL.hasOp((int)262144);
                if (legacyRenegSupported) {
                    if (this.sslHostConfig.getInsecureRenegotiation()) {
                        org.apache.tomcat.jni.SSLContext.setOptions((long)this.ctx, (int)262144);
                    } else {
                        org.apache.tomcat.jni.SSLContext.clearOptions((long)this.ctx, (int)262144);
                    }
                }
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                // empty catch block
            }
            if (!legacyRenegSupported) {
                log.warn((Object)netSm.getString("endpoint.warn.noInsecureReneg", new Object[]{SSL.versionString()}));
            }
            boolean orderCiphersSupported = false;
            try {
                orderCiphersSupported = SSL.hasOp((int)0x400000);
                if (orderCiphersSupported) {
                    if (this.sslHostConfig.getHonorCipherOrder()) {
                        org.apache.tomcat.jni.SSLContext.setOptions((long)this.ctx, (int)0x400000);
                    } else {
                        org.apache.tomcat.jni.SSLContext.clearOptions((long)this.ctx, (int)0x400000);
                    }
                }
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                // empty catch block
            }
            if (!orderCiphersSupported) {
                log.warn((Object)netSm.getString("endpoint.warn.noHonorCipherOrder", new Object[]{SSL.versionString()}));
            }
            boolean disableCompressionSupported = false;
            try {
                disableCompressionSupported = SSL.hasOp((int)131072);
                if (disableCompressionSupported) {
                    if (this.sslHostConfig.getDisableCompression()) {
                        org.apache.tomcat.jni.SSLContext.setOptions((long)this.ctx, (int)131072);
                    } else {
                        org.apache.tomcat.jni.SSLContext.clearOptions((long)this.ctx, (int)131072);
                    }
                }
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                // empty catch block
            }
            if (!disableCompressionSupported) {
                log.warn((Object)netSm.getString("endpoint.warn.noDisableCompression", new Object[]{SSL.versionString()}));
            }
            boolean disableSessionTicketsSupported = false;
            try {
                disableSessionTicketsSupported = SSL.hasOp((int)16384);
                if (disableSessionTicketsSupported) {
                    if (this.sslHostConfig.getDisableSessionTickets()) {
                        org.apache.tomcat.jni.SSLContext.setOptions((long)this.ctx, (int)16384);
                    } else {
                        org.apache.tomcat.jni.SSLContext.clearOptions((long)this.ctx, (int)16384);
                    }
                }
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                // empty catch block
            }
            if (!disableSessionTicketsSupported) {
                log.warn((Object)netSm.getString("endpoint.warn.noDisableSessionTickets", new Object[]{SSL.versionString()}));
            }
            if (this.sslHostConfig.getSessionCacheSize() > 0) {
                org.apache.tomcat.jni.SSLContext.setSessionCacheSize((long)this.ctx, (long)this.sslHostConfig.getSessionCacheSize());
            } else {
                long sessionCacheSize = org.apache.tomcat.jni.SSLContext.setSessionCacheSize((long)this.ctx, (long)20480L);
                org.apache.tomcat.jni.SSLContext.setSessionCacheSize((long)this.ctx, (long)sessionCacheSize);
            }
            if (this.sslHostConfig.getSessionTimeout() > 0) {
                org.apache.tomcat.jni.SSLContext.setSessionCacheTimeout((long)this.ctx, (long)this.sslHostConfig.getSessionTimeout());
            } else {
                long sessionTimeout = org.apache.tomcat.jni.SSLContext.setSessionCacheTimeout((long)this.ctx, (long)300L);
                org.apache.tomcat.jni.SSLContext.setSessionCacheTimeout((long)this.ctx, (long)sessionTimeout);
            }
            String ciphers = this.sslHostConfig.getCiphers();
            if (!"ALL".equals(ciphers) && ciphers.indexOf(58) == -1) {
                StringTokenizer tok = new StringTokenizer(ciphers, ",");
                this.ciphers = new ArrayList<String>();
                while (tok.hasMoreTokens()) {
                    String token = tok.nextToken().trim();
                    if ("".equals(token)) continue;
                    this.ciphers.add(token);
                }
                ciphers = CipherSuiteConverter.toOpenSsl(ciphers);
            } else {
                this.ciphers = OpenSSLCipherConfigurationParser.parseExpression(ciphers);
            }
            org.apache.tomcat.jni.SSLContext.setCipherSuite((long)this.ctx, (String)ciphers);
            if (this.certificate.getCertificateFile() != null) {
                org.apache.tomcat.jni.SSLContext.setCertificate((long)this.ctx, (String)SSLHostConfig.adjustRelativePath(this.certificate.getCertificateFile()), (String)SSLHostConfig.adjustRelativePath(this.certificate.getCertificateKeyFile()), (String)this.certificate.getCertificateKeyPassword(), (int)0);
                org.apache.tomcat.jni.SSLContext.setCACertificate((long)this.ctx, (String)SSLHostConfig.adjustRelativePath(this.sslHostConfig.getCaCertificateFile()), (String)SSLHostConfig.adjustRelativePath(this.sslHostConfig.getCaCertificatePath()));
                org.apache.tomcat.jni.SSLContext.setCARevocation((long)this.ctx, (String)SSLHostConfig.adjustRelativePath(this.sslHostConfig.getCertificateRevocationListFile()), (String)SSLHostConfig.adjustRelativePath(this.sslHostConfig.getCertificateRevocationListPath()));
            } else {
                X509KeyManager keyManager = OpenSSLContext.getJSSEKeyManager(this.sslHostConfig);
                String alias = this.getJSSEAlias(this.sslHostConfig, keyManager);
                X509Certificate certificate = keyManager.getCertificateChain(alias)[0];
                PrivateKey key = keyManager.getPrivateKey(alias);
                StringBuilder sb = new StringBuilder(BEGIN_KEY);
                sb.append(Base64.getMimeEncoder(64, new byte[]{10}).encodeToString(key.getEncoded()));
                sb.append(END_KEY);
                org.apache.tomcat.jni.SSLContext.setCertificateRaw((long)this.ctx, (byte[])certificate.getEncoded(), (byte[])sb.toString().getBytes(StandardCharsets.US_ASCII), (int)0);
            }
            int value = 0;
            switch (this.sslHostConfig.getCertificateVerification()) {
                case NONE: {
                    value = 0;
                    break;
                }
                case OPTIONAL: {
                    value = 1;
                    break;
                }
                case OPTIONAL_NO_CA: {
                    value = 3;
                    break;
                }
                case REQUIRED: {
                    value = 2;
                }
            }
            org.apache.tomcat.jni.SSLContext.setVerify((long)this.ctx, (int)value, (int)this.sslHostConfig.getCertificateVerificationDepth());
            if (tms != null) {
                final X509TrustManager manager = OpenSSLContext.chooseTrustManager(tms);
                org.apache.tomcat.jni.SSLContext.setCertVerifyCallback((long)this.ctx, (CertificateVerifier)new CertificateVerifier(){

                    public boolean verify(long ssl, byte[][] chain, String auth) {
                        X509Certificate[] peerCerts = OpenSSLContext.certificates(chain);
                        try {
                            manager.checkClientTrusted(peerCerts, auth);
                            return true;
                        }
                        catch (Exception e) {
                            log.debug((Object)sm.getString("openssl.certificateVerificationFailed"), (Throwable)e);
                            return false;
                        }
                    }
                });
            }
            if (this.negotiableProtocols != null && this.negotiableProtocols.size() > 0) {
                ArrayList<String> protocols = new ArrayList<String>();
                protocols.addAll(this.negotiableProtocols);
                protocols.add("http/1.1");
                String[] protocolsArray = protocols.toArray(new String[0]);
                org.apache.tomcat.jni.SSLContext.setAlpnProtos((long)this.ctx, (String[])protocolsArray, (int)0);
                org.apache.tomcat.jni.SSLContext.setNpnProtos((long)this.ctx, (String[])protocolsArray, (int)0);
            }
            this.sessionContext = new OpenSSLServerSessionContext(this.ctx);
            this.sslHostConfig.setOpenSslContext(this.ctx);
            this.initialized = true;
        }
        catch (Exception e) {
            log.warn((Object)sm.getString("openssl.errorSSLCtxInit"), (Throwable)e);
            this.destroyPools();
        }
    }

    String getJSSEAlias(SSLHostConfig sslHostConfig, X509KeyManager keyManager) {
        String alias = null;
        if (this.certificate.getCertificateKeyAlias() != null) {
            alias = this.certificate.getCertificateKeyAlias();
        }
        return alias;
    }

    static X509KeyManager getJSSEKeyManager(SSLHostConfig sslHostConfig) throws KeyStoreException, UnrecoverableKeyException, NoSuchAlgorithmException, CertificateException, IOException {
        String keystoretype = null;
        String keystoreprovider = null;
        String keystorefile = null;
        String password = null;
        for (SSLHostConfigCertificate certificate : sslHostConfig.getCertificates(true)) {
            if (certificate.getCertificateKeystoreFile() != null) {
                keystorefile = certificate.getCertificateKeystoreFile();
            }
            if (certificate.getCertificateKeystorePassword() != null) {
                password = certificate.getCertificateKeystorePassword();
            }
            if (certificate.getCertificateKeystoreType() != null) {
                keystoretype = certificate.getCertificateKeystoreType();
            }
            if (certificate.getCertificateKeystoreProvider() == null) continue;
            keystoreprovider = certificate.getCertificateKeystoreProvider();
        }
        KeyStore ks = KeyStore.getInstance(keystoretype);
        InputStream stream = ConfigFileLoader.getInputStream(keystorefile);
        ks.load(stream, password.toCharArray());
        KeyManagerFactory kmf = keystoreprovider != null ? KeyManagerFactory.getInstance(keystoreprovider) : KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        kmf.init(ks, password.toCharArray());
        KeyManager[] kms = kmf.getKeyManagers();
        if (kms == null) {
            return null;
        }
        return (X509KeyManager)kms[0];
    }

    static OpenSSLKeyManager chooseKeyManager(KeyManager[] managers) throws Exception {
        for (KeyManager manager : managers) {
            if (!(manager instanceof OpenSSLKeyManager)) continue;
            return (OpenSSLKeyManager)manager;
        }
        throw new IllegalStateException(sm.getString("openssl.keyManagerMissing"));
    }

    static X509TrustManager chooseTrustManager(TrustManager[] managers) {
        for (TrustManager m : managers) {
            if (!(m instanceof X509TrustManager)) continue;
            return (X509TrustManager)m;
        }
        throw new IllegalStateException(sm.getString("openssl.trustManagerMissing"));
    }

    private static X509Certificate[] certificates(byte[][] chain) {
        X509Certificate[] peerCerts = new X509Certificate[chain.length];
        for (int i = 0; i < peerCerts.length; ++i) {
            peerCerts[i] = new OpenSslX509Certificate(chain[i]);
        }
        return peerCerts;
    }

    @Override
    public SSLSessionContext getServerSessionContext() {
        return this.sessionContext;
    }

    @Override
    public SSLEngine createSSLEngine() {
        return new OpenSSLEngine(this.ctx, defaultProtocol, false, this.sessionContext, this.negotiableProtocols != null && this.negotiableProtocols.size() > 0);
    }

    @Override
    public SSLServerSocketFactory getServerSocketFactory() {
        throw new UnsupportedOperationException();
    }

    @Override
    public SSLParameters getSupportedSSLParameters() {
        throw new UnsupportedOperationException();
    }

    protected static PKCS8EncodedKeySpec generateKeySpec(char[] password, byte[] key) throws IOException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeySpecException, InvalidKeyException, InvalidAlgorithmParameterException {
        if (password == null || password.length == 0) {
            return new PKCS8EncodedKeySpec(key);
        }
        EncryptedPrivateKeyInfo encryptedPrivateKeyInfo = new EncryptedPrivateKeyInfo(key);
        SecretKeyFactory keyFactory = SecretKeyFactory.getInstance(encryptedPrivateKeyInfo.getAlgName());
        PBEKeySpec pbeKeySpec = new PBEKeySpec(password);
        SecretKey pbeKey = keyFactory.generateSecret(pbeKeySpec);
        Cipher cipher = Cipher.getInstance(encryptedPrivateKeyInfo.getAlgName());
        cipher.init(2, (Key)pbeKey, encryptedPrivateKeyInfo.getAlgParameters());
        return encryptedPrivateKeyInfo.getKeySpec(cipher);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void finalize() throws Throwable {
        super.finalize();
        Class<OpenSSLContext> clazz = OpenSSLContext.class;
        synchronized (OpenSSLContext.class) {
            if (this.ctx != 0L) {
                org.apache.tomcat.jni.SSLContext.free((long)this.ctx);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            this.destroyPools();
            return;
        }
    }

    static {
        END_KEY = "\n-----END RSA PRIVATE KEY-----";
        try {
            X509_CERT_FACTORY = CertificateFactory.getInstance("X.509");
        }
        catch (CertificateException e) {
            throw new IllegalStateException(sm.getString("openssl.X509FactoryError"), e);
        }
    }
}

