/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.net.openssl;

import java.nio.ByteBuffer;
import java.nio.ReadOnlyBufferException;
import java.security.Principal;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSessionBindingEvent;
import javax.net.ssl.SSLSessionBindingListener;
import javax.net.ssl.SSLSessionContext;
import javax.security.cert.CertificateException;
import javax.security.cert.X509Certificate;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.jni.Buffer;
import org.apache.tomcat.jni.Pool;
import org.apache.tomcat.jni.SSL;
import org.apache.tomcat.jni.SSLContext;
import org.apache.tomcat.util.buf.ByteBufferUtils;
import org.apache.tomcat.util.net.SSLUtil;
import org.apache.tomcat.util.net.openssl.CipherSuiteConverter;
import org.apache.tomcat.util.net.openssl.OpenSSLSessionContext;
import org.apache.tomcat.util.net.openssl.OpenSslX509Certificate;
import org.apache.tomcat.util.res.StringManager;

public final class OpenSSLEngine
extends SSLEngine
implements SSLUtil.ProtocolInfo {
    private static final Log logger = LogFactory.getLog(OpenSSLEngine.class);
    private static final StringManager sm = StringManager.getManager(OpenSSLEngine.class);
    private static final Certificate[] EMPTY_CERTIFICATES = new Certificate[0];
    private static final SSLException ENGINE_CLOSED = new SSLException(sm.getString("engine.engineClosed"));
    private static final SSLException RENEGOTIATION_UNSUPPORTED = new SSLException(sm.getString("engine.renegociationUnsupported"));
    private static final SSLException ENCRYPTED_PACKET_OVERSIZED = new SSLException(sm.getString("engine.oversizedPacket"));
    private static final Set<String> AVAILABLE_CIPHER_SUITES;
    private static final int MAX_PLAINTEXT_LENGTH = 16384;
    private static final int MAX_COMPRESSED_LENGTH = 17408;
    private static final int MAX_CIPHERTEXT_LENGTH = 18432;
    protected static final int VERIFY_DEPTH = 10;
    private static final String[] SUPPORTED_PROTOCOLS;
    private static final Set<String> SUPPORTED_PROTOCOLS_SET;
    static final int MAX_ENCRYPTED_PACKET_LENGTH = 18713;
    static final int MAX_ENCRYPTION_OVERHEAD_LENGTH = 2329;
    private static final AtomicIntegerFieldUpdater<OpenSSLEngine> DESTROYED_UPDATER;
    private static final String INVALID_CIPHER = "SSL_NULL_WITH_NULL_NULL";
    private static final long EMPTY_ADDR;
    private long ssl;
    private long networkBIO;
    private int accepted;
    private boolean handshakeFinished;
    private boolean receivedShutdown;
    private volatile int destroyed;
    private volatile String cipher;
    private volatile String applicationProtocol;
    private volatile Certificate[] peerCerts;
    private volatile ClientAuthMode clientAuth = ClientAuthMode.NONE;
    private boolean isInboundDone;
    private boolean isOutboundDone;
    private boolean engineClosed;
    private final boolean clientMode;
    private final String fallbackApplicationProtocol;
    private final OpenSSLSessionContext sessionContext;
    private final boolean alpn;
    private String selectedProtocol = null;
    private final OpenSSLSession session;

    OpenSSLEngine(long sslCtx, String fallbackApplicationProtocol, boolean clientMode, OpenSSLSessionContext sessionContext, boolean alpn) {
        if (sslCtx == 0L) {
            throw new IllegalArgumentException(sm.getString("engine.noSSLContext"));
        }
        this.session = new OpenSSLSession();
        this.ssl = SSL.newSSL((long)sslCtx, (!clientMode ? 1 : 0) != 0);
        this.networkBIO = SSL.makeNetworkBIO((long)this.ssl);
        this.fallbackApplicationProtocol = fallbackApplicationProtocol;
        this.clientMode = clientMode;
        this.sessionContext = sessionContext;
        this.alpn = alpn;
    }

    @Override
    public String getNegotiatedProtocol() {
        return this.selectedProtocol;
    }

    public synchronized void shutdown() {
        if (DESTROYED_UPDATER.compareAndSet(this, 0, 1)) {
            SSL.freeSSL((long)this.ssl);
            SSL.freeBIO((long)this.networkBIO);
            this.networkBIO = 0L;
            this.ssl = 0L;
            this.engineClosed = true;
            this.isOutboundDone = true;
            this.isInboundDone = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int writePlaintextData(ByteBuffer src) {
        int sslWrote;
        int pos = src.position();
        int limit = src.limit();
        int len = Math.min(limit - pos, 16384);
        if (src.isDirect()) {
            long addr = Buffer.address((ByteBuffer)src) + (long)pos;
            sslWrote = SSL.writeToSSL((long)this.ssl, (long)addr, (int)len);
            if (sslWrote >= 0) {
                src.position(pos + sslWrote);
                return sslWrote;
            }
        } else {
            ByteBuffer buf = ByteBuffer.allocateDirect(len);
            try {
                long addr = OpenSSLEngine.memoryAddress(buf);
                src.limit(pos + len);
                buf.put(src);
                src.limit(limit);
                sslWrote = SSL.writeToSSL((long)this.ssl, (long)addr, (int)len);
                if (sslWrote >= 0) {
                    src.position(pos + sslWrote);
                    int n = sslWrote;
                    return n;
                }
                src.position(pos);
            }
            finally {
                buf.clear();
                ByteBufferUtils.cleanDirectBuffer((ByteBuffer)buf);
            }
        }
        throw new IllegalStateException(sm.getString("engine.writeToSSLFailed", new Object[]{Integer.toString(sslWrote)}));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int writeEncryptedData(ByteBuffer src) {
        int pos = src.position();
        int len = src.remaining();
        if (src.isDirect()) {
            long addr = Buffer.address((ByteBuffer)src) + (long)pos;
            int netWrote = SSL.writeToBIO((long)this.networkBIO, (long)addr, (int)len);
            if (netWrote >= 0) {
                src.position(pos + netWrote);
                return netWrote;
            }
        } else {
            ByteBuffer buf = ByteBuffer.allocateDirect(len);
            try {
                long addr = OpenSSLEngine.memoryAddress(buf);
                buf.put(src);
                int netWrote = SSL.writeToBIO((long)this.networkBIO, (long)addr, (int)len);
                if (netWrote >= 0) {
                    src.position(pos + netWrote);
                    int n = netWrote;
                    return n;
                }
                src.position(pos);
            }
            finally {
                buf.clear();
                ByteBufferUtils.cleanDirectBuffer((ByteBuffer)buf);
            }
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int readPlaintextData(ByteBuffer dst) {
        if (dst.isDirect()) {
            int len;
            int pos = dst.position();
            long addr = Buffer.address((ByteBuffer)dst) + (long)pos;
            int sslRead = SSL.readFromSSL((long)this.ssl, (long)addr, (int)(len = dst.limit() - pos));
            if (sslRead > 0) {
                dst.position(pos + sslRead);
                return sslRead;
            }
        } else {
            int pos = dst.position();
            int limit = dst.limit();
            int len = Math.min(18713, limit - pos);
            ByteBuffer buf = ByteBuffer.allocateDirect(len);
            try {
                long addr = OpenSSLEngine.memoryAddress(buf);
                int sslRead = SSL.readFromSSL((long)this.ssl, (long)addr, (int)len);
                if (sslRead > 0) {
                    buf.limit(sslRead);
                    dst.limit(pos + sslRead);
                    dst.put(buf);
                    dst.limit(limit);
                    int n = sslRead;
                    return n;
                }
            }
            finally {
                buf.clear();
                ByteBufferUtils.cleanDirectBuffer((ByteBuffer)buf);
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int readEncryptedData(ByteBuffer dst, int pending) {
        if (dst.isDirect() && dst.remaining() >= pending) {
            int pos = dst.position();
            long addr = Buffer.address((ByteBuffer)dst) + (long)pos;
            int bioRead = SSL.readFromBIO((long)this.networkBIO, (long)addr, (int)pending);
            if (bioRead > 0) {
                dst.position(pos + bioRead);
                return bioRead;
            }
        } else {
            ByteBuffer buf = ByteBuffer.allocateDirect(pending);
            try {
                long addr = OpenSSLEngine.memoryAddress(buf);
                int bioRead = SSL.readFromBIO((long)this.networkBIO, (long)addr, (int)pending);
                if (bioRead > 0) {
                    buf.limit(bioRead);
                    int oldLimit = dst.limit();
                    dst.limit(dst.position() + bioRead);
                    dst.put(buf);
                    dst.limit(oldLimit);
                    int n = bioRead;
                    return n;
                }
            }
            finally {
                buf.clear();
                ByteBufferUtils.cleanDirectBuffer((ByteBuffer)buf);
            }
        }
        return 0;
    }

    @Override
    public synchronized SSLEngineResult wrap(ByteBuffer[] srcs, int offset, int length, ByteBuffer dst) throws SSLException {
        if (this.destroyed != 0) {
            return new SSLEngineResult(SSLEngineResult.Status.CLOSED, SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING, 0, 0);
        }
        if (srcs == null) {
            throw new IllegalArgumentException(sm.getString("engine.nullBuffer"));
        }
        if (dst == null) {
            throw new IllegalArgumentException(sm.getString("engine.nullBuffer"));
        }
        if (offset >= srcs.length || offset + length > srcs.length) {
            throw new IndexOutOfBoundsException(sm.getString("engine.invalidBufferArray", new Object[]{Integer.toString(offset), Integer.toString(length), Integer.toString(srcs.length)}));
        }
        if (dst.isReadOnly()) {
            throw new ReadOnlyBufferException();
        }
        if (this.accepted == 0) {
            this.beginHandshakeImplicitly();
        }
        SSLEngineResult.HandshakeStatus handshakeStatus = this.getHandshakeStatus();
        if ((!this.handshakeFinished || this.engineClosed) && handshakeStatus == SSLEngineResult.HandshakeStatus.NEED_UNWRAP) {
            return new SSLEngineResult(this.getEngineStatus(), SSLEngineResult.HandshakeStatus.NEED_UNWRAP, 0, 0);
        }
        int bytesProduced = 0;
        int pendingNet = SSL.pendingWrittenBytesInBIO((long)this.networkBIO);
        if (pendingNet > 0) {
            int capacity = dst.remaining();
            if (capacity < pendingNet) {
                return new SSLEngineResult(SSLEngineResult.Status.BUFFER_OVERFLOW, handshakeStatus, 0, 0);
            }
            try {
                bytesProduced = this.readEncryptedData(dst, pendingNet);
            }
            catch (Exception e) {
                throw new SSLException(e);
            }
            if (this.isOutboundDone) {
                this.shutdown();
            }
            return new SSLEngineResult(this.getEngineStatus(), this.getHandshakeStatus(), 0, bytesProduced);
        }
        int bytesConsumed = 0;
        int endOffset = offset + length;
        for (int i = offset; i < endOffset; ++i) {
            ByteBuffer src = srcs[i];
            if (src == null) {
                throw new IllegalArgumentException(sm.getString("engine.nullBufferInArray"));
            }
            while (src.hasRemaining()) {
                try {
                    bytesConsumed += this.writePlaintextData(src);
                }
                catch (Exception e) {
                    throw new SSLException(e);
                }
                pendingNet = SSL.pendingWrittenBytesInBIO((long)this.networkBIO);
                if (pendingNet <= 0) continue;
                int capacity = dst.remaining();
                if (capacity < pendingNet) {
                    return new SSLEngineResult(SSLEngineResult.Status.BUFFER_OVERFLOW, this.getHandshakeStatus(), bytesConsumed, bytesProduced);
                }
                try {
                }
                catch (Exception e) {
                    throw new SSLException(e);
                }
                return new SSLEngineResult(this.getEngineStatus(), this.getHandshakeStatus(), bytesConsumed, bytesProduced += this.readEncryptedData(dst, pendingNet));
            }
        }
        return new SSLEngineResult(this.getEngineStatus(), this.getHandshakeStatus(), bytesConsumed, bytesProduced);
    }

    @Override
    public synchronized SSLEngineResult unwrap(ByteBuffer src, ByteBuffer[] dsts, int offset, int length) throws SSLException {
        if (this.destroyed != 0) {
            return new SSLEngineResult(SSLEngineResult.Status.CLOSED, SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING, 0, 0);
        }
        if (src == null) {
            throw new IllegalArgumentException(sm.getString("engine.nullBuffer"));
        }
        if (dsts == null) {
            throw new IllegalArgumentException(sm.getString("engine.nullBuffer"));
        }
        if (offset >= dsts.length || offset + length > dsts.length) {
            throw new IndexOutOfBoundsException(sm.getString("engine.invalidBufferArray", new Object[]{Integer.toString(offset), Integer.toString(length), Integer.toString(dsts.length)}));
        }
        int capacity = 0;
        int endOffset = offset + length;
        for (int i = offset; i < endOffset; ++i) {
            ByteBuffer dst = dsts[i];
            if (dst == null) {
                throw new IllegalArgumentException(sm.getString("engine.nullBufferInArray"));
            }
            if (dst.isReadOnly()) {
                throw new ReadOnlyBufferException();
            }
            capacity += dst.remaining();
        }
        if (this.accepted == 0) {
            this.beginHandshakeImplicitly();
        }
        SSLEngineResult.HandshakeStatus handshakeStatus = this.getHandshakeStatus();
        if ((!this.handshakeFinished || this.engineClosed) && handshakeStatus == SSLEngineResult.HandshakeStatus.NEED_WRAP) {
            return new SSLEngineResult(this.getEngineStatus(), SSLEngineResult.HandshakeStatus.NEED_WRAP, 0, 0);
        }
        int len = src.remaining();
        if (len > 18713) {
            this.isInboundDone = true;
            this.isOutboundDone = true;
            this.engineClosed = true;
            this.shutdown();
            throw ENCRYPTED_PACKET_OVERSIZED;
        }
        int written = -1;
        try {
            written = this.writeEncryptedData(src);
        }
        catch (Exception e) {
            throw new SSLException(e);
        }
        if (written < 0) {
            written = 0;
        }
        int pendingApp = this.pendingReadableBytesInSSL();
        if (!this.handshakeFinished) {
            pendingApp = 0;
        }
        int bytesProduced = 0;
        int idx = offset;
        if (capacity < pendingApp) {
            return new SSLEngineResult(SSLEngineResult.Status.BUFFER_OVERFLOW, this.getHandshakeStatus(), written, 0);
        }
        while (pendingApp > 0) {
            while (idx < endOffset) {
                int bytesRead;
                ByteBuffer dst = dsts[idx];
                if (!dst.hasRemaining()) {
                    ++idx;
                    continue;
                }
                if (pendingApp <= 0) break;
                try {
                    bytesRead = this.readPlaintextData(dst);
                }
                catch (Exception e) {
                    throw new SSLException(e);
                }
                if (bytesRead == 0) break;
                bytesProduced += bytesRead;
                pendingApp -= bytesRead;
                capacity -= bytesRead;
                if (dst.hasRemaining()) continue;
                ++idx;
            }
            if (capacity == 0) break;
            if (pendingApp != 0) continue;
            pendingApp = this.pendingReadableBytesInSSL();
        }
        if (!this.receivedShutdown && (SSL.getShutdown((long)this.ssl) & 2) == 2) {
            this.receivedShutdown = true;
            this.closeOutbound();
            this.closeInbound();
        }
        if (bytesProduced == 0 && written == 0) {
            return new SSLEngineResult(SSLEngineResult.Status.BUFFER_UNDERFLOW, this.getHandshakeStatus(), 0, 0);
        }
        return new SSLEngineResult(this.getEngineStatus(), this.getHandshakeStatus(), written, bytesProduced);
    }

    private int pendingReadableBytesInSSL() throws SSLException {
        long error;
        int lastPrimingReadResult = SSL.readFromSSL((long)this.ssl, (long)EMPTY_ADDR, (int)0);
        if (lastPrimingReadResult <= 0 && (error = (long)SSL.getLastErrorNumber()) != 0L) {
            String err = SSL.getErrorString((long)error);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)sm.getString("engine.readFromSSLFailed", new Object[]{Long.toString(error), Integer.toString(lastPrimingReadResult), err}));
            }
            this.shutdown();
            throw new SSLException(err);
        }
        return SSL.pendingReadableBytesInSSL((long)this.ssl);
    }

    @Override
    public Runnable getDelegatedTask() {
        return null;
    }

    @Override
    public synchronized void closeInbound() throws SSLException {
        if (this.isInboundDone) {
            return;
        }
        this.isInboundDone = true;
        this.engineClosed = true;
        this.shutdown();
        if (this.accepted != 0 && !this.receivedShutdown) {
            throw new SSLException(sm.getString("engine.inboundClose"));
        }
    }

    @Override
    public synchronized boolean isInboundDone() {
        return this.isInboundDone || this.engineClosed;
    }

    @Override
    public synchronized void closeOutbound() {
        if (this.isOutboundDone) {
            return;
        }
        this.isOutboundDone = true;
        this.engineClosed = true;
        if (this.accepted != 0 && this.destroyed == 0) {
            int mode = SSL.getShutdown((long)this.ssl);
            if ((mode & 1) != 1) {
                SSL.shutdownSSL((long)this.ssl);
            }
        } else {
            this.shutdown();
        }
    }

    @Override
    public synchronized boolean isOutboundDone() {
        return this.isOutboundDone;
    }

    @Override
    public String[] getSupportedCipherSuites() {
        Set<String> availableCipherSuites = AVAILABLE_CIPHER_SUITES;
        return availableCipherSuites.toArray(new String[availableCipherSuites.size()]);
    }

    @Override
    public String[] getEnabledCipherSuites() {
        String[] enabled = SSL.getCiphers((long)this.ssl);
        if (enabled == null) {
            return new String[0];
        }
        for (int i = 0; i < enabled.length; ++i) {
            String mapped = this.toJavaCipherSuite(enabled[i]);
            if (mapped == null) continue;
            enabled[i] = mapped;
        }
        return enabled;
    }

    @Override
    public void setEnabledCipherSuites(String[] cipherSuites) {
        if (cipherSuites == null) {
            throw new IllegalArgumentException(sm.getString("engine.nullCipherSuite"));
        }
        StringBuilder buf = new StringBuilder();
        for (String cipherSuite : cipherSuites) {
            if (cipherSuite == null) break;
            String converted = CipherSuiteConverter.toOpenSsl(cipherSuite);
            if (converted != null) {
                cipherSuite = converted;
            }
            if (!AVAILABLE_CIPHER_SUITES.contains(cipherSuite)) {
                logger.debug((Object)sm.getString("engine.unsupportedCipher", new Object[]{cipherSuite, converted}));
            }
            buf.append(cipherSuite);
            buf.append(':');
        }
        if (buf.length() == 0) {
            throw new IllegalArgumentException(sm.getString("engine.emptyCipherSuite"));
        }
        buf.setLength(buf.length() - 1);
        String cipherSuiteSpec = buf.toString();
        try {
            SSL.setCipherSuites((long)this.ssl, (String)cipherSuiteSpec);
        }
        catch (Exception e) {
            throw new IllegalStateException(sm.getString("engine.failedCipherSuite", new Object[]{cipherSuiteSpec}), e);
        }
    }

    @Override
    public String[] getSupportedProtocols() {
        return (String[])SUPPORTED_PROTOCOLS.clone();
    }

    @Override
    public String[] getEnabledProtocols() {
        int size;
        ArrayList<String> enabled = new ArrayList<String>();
        enabled.add("SSLv2Hello");
        int opts = SSL.getOptions((long)this.ssl);
        if ((opts & 0x4000000) == 0) {
            enabled.add("TLSv1");
        }
        if ((opts & 0x10000000) == 0) {
            enabled.add("TLSv1.1");
        }
        if ((opts & 0x8000000) == 0) {
            enabled.add("TLSv1.2");
        }
        if ((opts & 0x1000000) == 0) {
            enabled.add("SSLv2");
        }
        if ((opts & 0x2000000) == 0) {
            enabled.add("SSLv3");
        }
        if ((size = enabled.size()) == 0) {
            return new String[0];
        }
        return enabled.toArray(new String[size]);
    }

    @Override
    public void setEnabledProtocols(String[] protocols) {
        if (protocols == null) {
            throw new IllegalArgumentException();
        }
        boolean sslv2 = false;
        boolean sslv3 = false;
        boolean tlsv1 = false;
        boolean tlsv1_1 = false;
        boolean tlsv1_2 = false;
        for (String p : protocols) {
            if (!SUPPORTED_PROTOCOLS_SET.contains(p)) {
                throw new IllegalArgumentException(sm.getString("engine.unsupportedProtocol", new Object[]{p}));
            }
            if (p.equals("SSLv2")) {
                sslv2 = true;
                continue;
            }
            if (p.equals("SSLv3")) {
                sslv3 = true;
                continue;
            }
            if (p.equals("TLSv1")) {
                tlsv1 = true;
                continue;
            }
            if (p.equals("TLSv1.1")) {
                tlsv1_1 = true;
                continue;
            }
            if (!p.equals("TLSv1.2")) continue;
            tlsv1_2 = true;
        }
        SSL.setOptions((long)this.ssl, (int)4095);
        if (!sslv2) {
            SSL.setOptions((long)this.ssl, (int)0x1000000);
        }
        if (!sslv3) {
            SSL.setOptions((long)this.ssl, (int)0x2000000);
        }
        if (!tlsv1) {
            SSL.setOptions((long)this.ssl, (int)0x4000000);
        }
        if (!tlsv1_1) {
            SSL.setOptions((long)this.ssl, (int)0x10000000);
        }
        if (!tlsv1_2) {
            SSL.setOptions((long)this.ssl, (int)0x8000000);
        }
    }

    private Certificate[] initPeerCertChain() throws SSLPeerUnverifiedException {
        Certificate[] peerCerts;
        byte[][] chain = SSL.getPeerCertChain((long)this.ssl);
        byte[] clientCert = !this.clientMode ? SSL.getPeerCertificate((long)this.ssl) : null;
        if (chain == null && clientCert == null) {
            throw new SSLPeerUnverifiedException(sm.getString("engine.unverifiedPeer"));
        }
        int len = 0;
        if (chain != null) {
            len += chain.length;
        }
        int i = 0;
        if (clientCert != null) {
            peerCerts = new Certificate[++len];
            peerCerts[i++] = new OpenSslX509Certificate(clientCert);
        } else {
            peerCerts = new Certificate[len];
        }
        if (chain != null) {
            int a = 0;
            while (i < peerCerts.length) {
                peerCerts[i] = new OpenSslX509Certificate(chain[a++]);
                ++i;
            }
        }
        return peerCerts;
    }

    @Override
    public SSLSession getSession() {
        return this.session;
    }

    @Override
    public synchronized void beginHandshake() throws SSLException {
        if (this.engineClosed || this.destroyed != 0) {
            throw ENGINE_CLOSED;
        }
        switch (this.accepted) {
            case 0: {
                this.handshake();
                this.accepted = 2;
                break;
            }
            case 1: {
                this.accepted = 2;
                break;
            }
            case 2: {
                throw RENEGOTIATION_UNSUPPORTED;
            }
            default: {
                throw new Error();
            }
        }
    }

    private void beginHandshakeImplicitly() throws SSLException {
        if (this.engineClosed || this.destroyed != 0) {
            throw ENGINE_CLOSED;
        }
        if (this.accepted == 0) {
            this.handshake();
            this.accepted = 1;
        }
    }

    private void handshake() throws SSLException {
        int code = SSL.doHandshake((long)this.ssl);
        if (code <= 0) {
            long error = SSL.getLastErrorNumber();
            if (error != 0L) {
                String err = SSL.getErrorString((long)error);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)sm.getString("engine.handshakeFailure", new Object[]{err}));
                }
                this.shutdown();
                throw new SSLException(err);
            }
        } else {
            if (this.alpn) {
                this.selectedProtocol = SSL.getAlpnSelected((long)this.ssl);
                if (this.selectedProtocol == null) {
                    this.selectedProtocol = SSL.getNextProtoNegotiated((long)this.ssl);
                }
            }
            this.session.lastAccessedTime = System.currentTimeMillis();
            this.handshakeFinished = true;
        }
    }

    private static long memoryAddress(ByteBuffer buf) {
        return Buffer.address((ByteBuffer)buf);
    }

    private SSLEngineResult.Status getEngineStatus() {
        return this.engineClosed ? SSLEngineResult.Status.CLOSED : SSLEngineResult.Status.OK;
    }

    @Override
    public synchronized SSLEngineResult.HandshakeStatus getHandshakeStatus() {
        if (this.accepted == 0 || this.destroyed != 0) {
            return SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING;
        }
        if (!this.handshakeFinished) {
            if (SSL.pendingWrittenBytesInBIO((long)this.networkBIO) != 0) {
                return SSLEngineResult.HandshakeStatus.NEED_WRAP;
            }
            if (SSL.isInInit((long)this.ssl) == 0) {
                if (this.alpn) {
                    this.selectedProtocol = SSL.getAlpnSelected((long)this.ssl);
                    if (this.selectedProtocol == null) {
                        this.selectedProtocol = SSL.getNextProtoNegotiated((long)this.ssl);
                    }
                }
                this.session.lastAccessedTime = System.currentTimeMillis();
                this.handshakeFinished = true;
                return SSLEngineResult.HandshakeStatus.FINISHED;
            }
            return SSLEngineResult.HandshakeStatus.NEED_UNWRAP;
        }
        if (this.engineClosed) {
            if (SSL.pendingWrittenBytesInBIO((long)this.networkBIO) != 0) {
                return SSLEngineResult.HandshakeStatus.NEED_WRAP;
            }
            return SSLEngineResult.HandshakeStatus.NEED_UNWRAP;
        }
        return SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING;
    }

    private String toJavaCipherSuite(String openSslCipherSuite) {
        if (openSslCipherSuite == null) {
            return null;
        }
        String prefix = OpenSSLEngine.toJavaCipherSuitePrefix(SSL.getVersion((long)this.ssl));
        return CipherSuiteConverter.toJava(openSslCipherSuite, prefix);
    }

    private static String toJavaCipherSuitePrefix(String protocolVersion) {
        int c = protocolVersion == null || protocolVersion.length() == 0 ? 0 : (int)protocolVersion.charAt(0);
        switch (c) {
            case 84: {
                return "TLS";
            }
            case 83: {
                return "SSL";
            }
        }
        return "UNKNOWN";
    }

    @Override
    public void setUseClientMode(boolean clientMode) {
        if (clientMode != this.clientMode) {
            throw new UnsupportedOperationException();
        }
    }

    @Override
    public boolean getUseClientMode() {
        return this.clientMode;
    }

    @Override
    public void setNeedClientAuth(boolean b) {
        this.setClientAuth(b ? ClientAuthMode.REQUIRE : ClientAuthMode.NONE);
    }

    @Override
    public boolean getNeedClientAuth() {
        return this.clientAuth == ClientAuthMode.REQUIRE;
    }

    @Override
    public void setWantClientAuth(boolean b) {
        this.setClientAuth(b ? ClientAuthMode.OPTIONAL : ClientAuthMode.NONE);
    }

    @Override
    public boolean getWantClientAuth() {
        return this.clientAuth == ClientAuthMode.OPTIONAL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setClientAuth(ClientAuthMode mode) {
        if (this.clientMode) {
            return;
        }
        OpenSSLEngine openSSLEngine = this;
        synchronized (openSSLEngine) {
            if (this.clientAuth == mode) {
                return;
            }
            switch (mode) {
                case NONE: {
                    SSL.setVerify((long)this.ssl, (int)0, (int)10);
                    break;
                }
                case REQUIRE: {
                    SSL.setVerify((long)this.ssl, (int)2, (int)10);
                    break;
                }
                case OPTIONAL: {
                    SSL.setVerify((long)this.ssl, (int)1, (int)10);
                }
            }
            this.clientAuth = mode;
        }
    }

    @Override
    public void setEnableSessionCreation(boolean b) {
        if (b) {
            throw new UnsupportedOperationException();
        }
    }

    @Override
    public boolean getEnableSessionCreation() {
        return false;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.shutdown();
    }

    static /* synthetic */ Certificate[] access$502(OpenSSLEngine x0, Certificate[] x1) {
        x0.peerCerts = x1;
        return x1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        LinkedHashSet<String> availableCipherSuites = new LinkedHashSet<String>(128);
        long aprPool = Pool.create((long)0L);
        try {
            long sslCtx = SSLContext.make((long)aprPool, (int)28, (int)1);
            try {
                SSLContext.setOptions((long)sslCtx, (int)4095);
                SSLContext.setCipherSuite((long)sslCtx, (String)"ALL");
                long ssl = SSL.newSSL((long)sslCtx, (boolean)true);
                try {
                    for (String c : SSL.getCiphers((long)ssl)) {
                        if (c == null || c.length() == 0 || availableCipherSuites.contains(c)) continue;
                        availableCipherSuites.add(CipherSuiteConverter.toJava(c, "ALL"));
                    }
                }
                finally {
                    SSL.freeSSL((long)ssl);
                }
            }
            finally {
                SSLContext.free((long)sslCtx);
            }
        }
        catch (Exception e) {
            logger.warn((Object)sm.getString("engine.ciphersFailure"), (Throwable)e);
        }
        finally {
            Pool.destroy((long)aprPool);
        }
        AVAILABLE_CIPHER_SUITES = Collections.unmodifiableSet(availableCipherSuites);
        ENGINE_CLOSED.setStackTrace(new StackTraceElement[0]);
        RENEGOTIATION_UNSUPPORTED.setStackTrace(new StackTraceElement[0]);
        ENCRYPTED_PACKET_OVERSIZED.setStackTrace(new StackTraceElement[0]);
        DESTROYED_UPDATER = AtomicIntegerFieldUpdater.newUpdater(OpenSSLEngine.class, "destroyed");
        SUPPORTED_PROTOCOLS = new String[]{"SSLv2Hello", "SSLv2", "SSLv3", "TLSv1", "TLSv1.1", "TLSv1.2"};
        SUPPORTED_PROTOCOLS_SET = new HashSet<String>(Arrays.asList(SUPPORTED_PROTOCOLS));
        EMPTY_ADDR = Buffer.address((ByteBuffer)ByteBuffer.allocate(0));
    }

    private class OpenSSLSession
    implements SSLSession {
        private X509Certificate[] x509PeerCerts;
        private Map<String, Object> values;
        private long lastAccessedTime = -1L;

        private OpenSSLSession() {
        }

        @Override
        public byte[] getId() {
            byte[] id = SSL.getSessionId((long)OpenSSLEngine.this.ssl);
            if (id == null) {
                throw new IllegalStateException(sm.getString("engine.noSession"));
            }
            return id;
        }

        @Override
        public SSLSessionContext getSessionContext() {
            return OpenSSLEngine.this.sessionContext;
        }

        @Override
        public long getCreationTime() {
            return SSL.getTime((long)OpenSSLEngine.this.ssl) * 1000L;
        }

        @Override
        public long getLastAccessedTime() {
            return this.lastAccessedTime > 0L ? this.lastAccessedTime : this.getCreationTime();
        }

        @Override
        public void invalidate() {
        }

        @Override
        public boolean isValid() {
            return false;
        }

        @Override
        public void putValue(String name, Object value) {
            if (name == null) {
                throw new IllegalArgumentException(sm.getString("engine.nullName"));
            }
            if (value == null) {
                throw new IllegalArgumentException(sm.getString("engine.nullValue"));
            }
            Map<String, Object> values = this.values;
            if (values == null) {
                values = this.values = new HashMap<String, Object>(2);
            }
            Object old = values.put(name, value);
            if (value instanceof SSLSessionBindingListener) {
                ((SSLSessionBindingListener)value).valueBound(new SSLSessionBindingEvent(this, name));
            }
            this.notifyUnbound(old, name);
        }

        @Override
        public Object getValue(String name) {
            if (name == null) {
                throw new IllegalArgumentException(sm.getString("engine.nullName"));
            }
            if (this.values == null) {
                return null;
            }
            return this.values.get(name);
        }

        @Override
        public void removeValue(String name) {
            if (name == null) {
                throw new IllegalArgumentException(sm.getString("engine.nullName"));
            }
            Map<String, Object> values = this.values;
            if (values == null) {
                return;
            }
            Object old = values.remove(name);
            this.notifyUnbound(old, name);
        }

        @Override
        public String[] getValueNames() {
            Map<String, Object> values = this.values;
            if (values == null || values.isEmpty()) {
                return new String[0];
            }
            return values.keySet().toArray(new String[values.size()]);
        }

        private void notifyUnbound(Object value, String name) {
            if (value instanceof SSLSessionBindingListener) {
                ((SSLSessionBindingListener)value).valueUnbound(new SSLSessionBindingEvent(this, name));
            }
        }

        @Override
        public Certificate[] getPeerCertificates() throws SSLPeerUnverifiedException {
            Certificate[] c = OpenSSLEngine.this.peerCerts;
            if (c == null) {
                if (SSL.isInInit((long)OpenSSLEngine.this.ssl) != 0) {
                    throw new SSLPeerUnverifiedException(sm.getString("engine.unverifiedPeer"));
                }
                c = OpenSSLEngine.access$502(OpenSSLEngine.this, OpenSSLEngine.this.initPeerCertChain());
            }
            return c;
        }

        @Override
        public Certificate[] getLocalCertificates() {
            return EMPTY_CERTIFICATES;
        }

        @Override
        public X509Certificate[] getPeerCertificateChain() throws SSLPeerUnverifiedException {
            X509Certificate[] c = this.x509PeerCerts;
            if (c == null) {
                if (SSL.isInInit((long)OpenSSLEngine.this.ssl) != 0) {
                    throw new SSLPeerUnverifiedException(sm.getString("engine.unverifiedPeer"));
                }
                byte[][] chain = SSL.getPeerCertChain((long)OpenSSLEngine.this.ssl);
                if (chain == null) {
                    throw new SSLPeerUnverifiedException(sm.getString("engine.unverifiedPeer"));
                }
                X509Certificate[] peerCerts = new X509Certificate[chain.length];
                for (int i = 0; i < peerCerts.length; ++i) {
                    try {
                        peerCerts[i] = X509Certificate.getInstance(chain[i]);
                        continue;
                    }
                    catch (CertificateException e) {
                        throw new IllegalStateException(e);
                    }
                }
                this.x509PeerCerts = peerCerts;
                c = peerCerts;
            }
            return c;
        }

        @Override
        public Principal getPeerPrincipal() throws SSLPeerUnverifiedException {
            Certificate[] peer = this.getPeerCertificates();
            if (peer == null || peer.length == 0) {
                return null;
            }
            return this.principal(peer);
        }

        @Override
        public Principal getLocalPrincipal() {
            Certificate[] local = this.getLocalCertificates();
            if (local == null || local.length == 0) {
                return null;
            }
            return this.principal(local);
        }

        private Principal principal(Certificate[] certs) {
            return ((java.security.cert.X509Certificate)certs[0]).getIssuerX500Principal();
        }

        @Override
        public String getCipherSuite() {
            String c;
            if (!OpenSSLEngine.this.handshakeFinished) {
                return OpenSSLEngine.INVALID_CIPHER;
            }
            if (OpenSSLEngine.this.cipher == null && (c = OpenSSLEngine.this.toJavaCipherSuite(SSL.getCipherForSSL((long)OpenSSLEngine.this.ssl))) != null) {
                OpenSSLEngine.this.cipher = c;
            }
            return OpenSSLEngine.this.cipher;
        }

        @Override
        public String getProtocol() {
            String applicationProtocol = OpenSSLEngine.this.applicationProtocol;
            if (applicationProtocol == null) {
                applicationProtocol = SSL.getNextProtoNegotiated((long)OpenSSLEngine.this.ssl);
                if (applicationProtocol == null) {
                    applicationProtocol = OpenSSLEngine.this.fallbackApplicationProtocol;
                }
                if (applicationProtocol != null) {
                    OpenSSLEngine.this.applicationProtocol = applicationProtocol.replace(':', '_');
                } else {
                    applicationProtocol = "";
                    OpenSSLEngine.this.applicationProtocol = "";
                }
            }
            String version = SSL.getVersion((long)OpenSSLEngine.this.ssl);
            if (applicationProtocol.isEmpty()) {
                return version;
            }
            return version + ':' + applicationProtocol;
        }

        @Override
        public String getPeerHost() {
            return null;
        }

        @Override
        public int getPeerPort() {
            return 0;
        }

        @Override
        public int getPacketBufferSize() {
            return 18713;
        }

        @Override
        public int getApplicationBufferSize() {
            return 16384;
        }
    }

    static enum ClientAuthMode {
        NONE,
        OPTIONAL,
        REQUIRE;

    }
}

