/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.net.openssl;

import java.util.List;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLSessionContext;
import javax.net.ssl.TrustManager;
import org.apache.tomcat.util.net.SSLContext;
import org.apache.tomcat.util.net.SSLHostConfig;
import org.apache.tomcat.util.net.SSLHostConfigCertificate;
import org.apache.tomcat.util.net.SSLUtil;
import org.apache.tomcat.util.net.openssl.OpenSSLContext;
import org.apache.tomcat.util.net.openssl.OpenSSLKeyManager;
import org.apache.tomcat.util.net.openssl.OpenSSLProtocols;

public class OpenSSLUtil
implements SSLUtil {
    private final SSLHostConfig sslHostConfig;
    private final SSLHostConfigCertificate certificate;
    private String[] enabledProtocols = null;
    private String[] enabledCiphers = null;

    public OpenSSLUtil(SSLHostConfig sslHostConfig, SSLHostConfigCertificate certificate) {
        this.sslHostConfig = sslHostConfig;
        this.certificate = certificate;
    }

    @Override
    public SSLContext createSSLContext(List<String> negotiableProtocols) throws Exception {
        return new OpenSSLContext(this.sslHostConfig, this.certificate, negotiableProtocols);
    }

    @Override
    public KeyManager[] getKeyManagers() throws Exception {
        KeyManager[] managers = new KeyManager[]{new OpenSSLKeyManager(SSLHostConfig.adjustRelativePath(this.certificate.getCertificateFile()), SSLHostConfig.adjustRelativePath(this.certificate.getCertificateKeyFile()))};
        return managers;
    }

    @Override
    public TrustManager[] getTrustManagers() throws Exception {
        return null;
    }

    @Override
    public void configureSessionContext(SSLSessionContext sslSessionContext) {
    }

    @Override
    public String[] getEnableableCiphers(SSLContext context) {
        if (this.enabledCiphers == null) {
            List<String> enabledCiphersList = ((OpenSSLContext)context).getCiphers();
            this.enabledCiphers = enabledCiphersList.toArray(new String[enabledCiphersList.size()]);
        }
        return this.enabledCiphers;
    }

    @Override
    public String[] getEnableableProtocols(SSLContext context) {
        if (this.enabledProtocols == null) {
            this.enabledProtocols = new OpenSSLProtocols(((OpenSSLContext)context).getEnabledProtocol()).getProtocols();
        }
        return this.enabledProtocols;
    }
}

